<?php

class ModelAndroidCustomerPatientHistory extends Model
{

    public function getList($data)
    {
        $start = $data['start'];
        $limit = $data['limit'];
        $search_statement = '';
        if (!empty($data['filter_search'])) {
            $filter_search = $data['filter_search'];
            $search_statement .= "AND ( ";
            $search_statement .= "CONCAT(cs.diagnostic, cs.doctoradvice, cs.pulse, cs.disease, cs.treatment, cs.acupuncture, cs.symptom, cs.remark) LIKE '%" . $this->db->escape($filter_search) . "%' ";
            $search_statement .= "OR cs.invoice_prefix LIKE '%" . $this->db->escape($filter_search) . "%' ";
            $search_statement .= "OR CONCAT(u.firstname,u.lastname) LIKE '%" . $this->db->escape($filter_search) . "%' ";
            $search_statement .= ")";
        }

        $sql = "SELECT 
        cs.clinical_sale_id,
        CONCAT(u.firstname,u.lastname) AS doctor,
        (CASE WHEN s.name IS NULL THEN '" . $this->config->get('config_name') . "' ELSE s.name END) AS store,
        cs.sales_date,
        cs.invoice_prefix,
        CONCAT(cs.diagnostic, cs.doctoradvice, cs.pulse, cs.disease, cs.treatment, cs.acupuncture, cs.symptom, cs.remark) AS diagnostic
        FROM " . DB_PREFIX . "clinical_sale cs
        LEFT JOIN " . DB_PREFIX . "user u ON(cs.doctor_id = u.user_id)
        LEFT JOIN " . DB_PREFIX . "store s ON(cs.store_id = s.store_id)
        WHERE cs.customer_id ='" . (int)$data['customer_id'] . "'
        AND cs.hide = 0
        $search_statement
        ORDER BY cs.invoice_prefix DESC
        LIMIT $start,$limit";

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getClinicalSale($clinical_sale_id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "clinical_sale WHERE clinical_sale_id='" . (int)$clinical_sale_id . "'";
        $query = $this->db->query($sql);
        return $query->row;
    }

    public function getPrescriptions($clinical_sale_id)
    {
        $sql = "SELECT 
        GROUP_CONCAT(pd.name,' ',TRIM(cp.t_weight) + 0,' ',wcd.unit SEPARATOR ',') AS products,
        MAX(cp.times) AS time,
        MAX(cp.day) AS day,
        cp.cook,
        cp.taketype
        FROM " . DB_PREFIX . "clinicalsale_product cp 
        LEFT JOIN " . DB_PREFIX . "product_description pd ON(cp.product_id=pd.product_id AND pd.language_id = '" . (int)$this->session->data['language_id'] . "')
        LEFT JOIN " . DB_PREFIX . "weight_class_description wcd ON(cp.weight_class_id=wcd.weight_class_id AND wcd.language_id = '" . (int)$this->session->data['language_id'] . "')
        WHERE cp.clinical_sale_id = '" . (int)$clinical_sale_id . "'
        GROUP BY cp.prescription_id
        ";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getServices($clinical_sale_id)
    {
        $sql = "SELECT *
        FROM " . DB_PREFIX . "clinecal_service_item
        WHERE clinical_sale_id = '" . (int)$clinical_sale_id . "'
        ";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getImages($clinical_sale_id)
    {
        $sql = "SELECT CONCAT('" . HTTPS_IMAGE . "',image) as image FROM " . DB_PREFIX . "clinical_sale_image WHERE clinical_sale_id ='" . (int)$clinical_sale_id . "'
        ";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getPrescriptionsIds($clinical_sale_id)
    {
        $sql = "SELECT DISTINCT(prescription_id) AS id FROM " . DB_PREFIX . "clinecal_sales_prescription WHERE clinical_sale_id='" . (int)$clinical_sale_id . "'";
        $query = $this->db->query($sql);
        if ($query->num_rows) {
            return array_column($query->rows, 'id');
        } else {
            return null;
        }
    }

    public function getPrescription($prescription_id)
    {
        $sql = "SELECT p.prescription_id, pn.name, p.code FROM " . DB_PREFIX . "prescription p
        LEFT JOIN " . DB_PREFIX . "prescription_name pn ON(p.prescription_id=pn.prescription_id AND language_id='" . (int)$this->session->data['language_id'] . "')
        WHERE p.status='1' 
        AND p.prescription_id = '" . (int)$prescription_id . "' 
        ";
        $query = $this->db->query($sql);
        if (!empty($query->row)) {
            $info = $query->row;
            $info['items'] = $this->getPrescriptionItem($prescription_id);
            return $info;
        } else {
            return null;
        }
    }
    public function getPrescriptionItem($prescription_id)
    {
        $language_id = $this->session->data['language_id'];
        $sql = "SELECT 
        p.product_id,
        pd.name,
        p.code,
        p.price,
        pi.used_qty AS qty,
        wcd.unit AS weight_class,
        p.weight_class_id 
        FROM " . DB_PREFIX . "prescription_item pi
        RIGHT JOIN " . DB_PREFIX . "product p ON (pi.product_id = p.product_id)
        LEFT JOIN " . DB_PREFIX . "product_description pd ON(p.product_id=pd.product_id AND pd.language_id = '" . (int)$language_id . "') 
        LEFT JOIN " . DB_PREFIX . "weight_class_description wcd ON(p.weight_class_id = wcd.weight_class_id AND wcd.language_id = '" . (int)$language_id . "')
        WHERE pi.prescription_id ='" . (int)$prescription_id . "'
        ORDER BY pi.display_order, pd.name
        ";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getService($service_id)
    {
        $sql = "SELECT 
        c.*,
        cd.name
        FROM 
        " . DB_PREFIX . "clinical_service c
        LEFT JOIN " . DB_PREFIX . "clinical_service_description cd ON(c.clinicalservice_id=cd.clinicalservice_id AND cd.language_id='" . (int)$this->session->data['language_id'] . "')
        WHERE 1
        
        AND c.clinicalservice_id = '" . (int)$service_id . "'
        ";
        $query = $this->db->query($sql);
        if (!empty($query->row)) {
            $service = $query->row;
            $info = array(
                "id"             => $service["clinicalservice_id"],
                "label"          => $service["name"],
                "service_minute" => $service["cs_minute"],
                "price"          => $service["price"],
            );
            $info['doctors'] = $this->getDoctors();
            $acupunture_points = array();
            if (!empty($service['enable_acupuncture']) && $service['enable_acupuncture'] == '1') {
                $acupunture_points = $this->getAcupuncturePoints();
            }
            $info['acupuncture_points'] = $acupunture_points;
            return $info;
        } else {
            return null;
        }
    }
    public function getDoctors()
    {
        $sql = "SELECT 
        user_id AS id,
        TRIM(CONCAT(firstname,' ',lastname)) AS name
        FROM " . DB_PREFIX . "user
        WHERE position='2'
        ";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getAcupuncturePoints()
    {
        $sql = "SELECT 
        a.acupuncture_id AS id,
        an.name
        FROM " . DB_PREFIX . "acupuncture a
        LEFT JOIN " . DB_PREFIX . "acupuncture_name an ON(a.acupuncture_id = an.acupuncture_id AND language_id='" . (int)$this->session->data['language_id'] . "')
        WHERE a.parent_id > 0
        ";
        $query = $this->db->query($sql);
        return $query->rows;
    }
}
