<?php

class ModelAndroidCustomerCustomer extends Model
{
    public function getCustomers($data)
    {
        $start = $data['start'];
        $limit = $data['limit'];

        $search_statement = '';
        if (!empty($data['filter_search'])) {
            $filter_search = $data['filter_search'];
            $search_statement .= "AND ( ";
            $search_statement .= "c.customer_ic LIKE '%" . $this->db->escape($filter_search) . "%' ";
            $search_statement .= "OR TRIM(CONCAT(c.firstname,' ',c.lastname)) LIKE '%" . $this->db->escape($filter_search) . "%' ";
            // $search_statement .= "OR c.lastname LIKE '%" . $this->db->escape($filter_search) . "%' ";
            $search_statement .= "OR c.email LIKE '%" . $this->db->escape($filter_search) . "%' ";
            $search_statement .= "OR c.telephone LIKE '%" . $this->db->escape($filter_search) . "%' ";
            $search_statement .= "OR c.telephone2 LIKE '%" . $this->db->escape($filter_search) . "%' ";
            $search_statement .= "OR c.home LIKE '%" . $this->db->escape($filter_search) . "%' ";
            $search_statement .= ") ";
        }

        $sql = "SELECT c.*, a.address_1 , CASE WHEN a.address_2 ='-' THEN NULL ELSE CONCAT(',', a.address_2) END AS address_2
        FROM " . DB_PREFIX . "customer c 
        LEFT JOIN " . DB_PREFIX . "address a ON(c.address_id = a.address_id)
        WHERE 1 
        AND (TRIM(CONCAT(c.firstname,' ',c.lastname)) <> '' OR c.telephone <>'' OR c.customer_ic <> '') 
        $search_statement 
        ORDER BY TRIM(CONCAT(c.firstname,' ',c.lastname))
        LIMIT $start, $limit";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getCustomerList($data)
    {

        #region filter statement
        $filter_statement = '';

        if (!empty($data['filter_search'])) {
            $filter_search = $data['filter_search'];
            $filter_statement .= " AND ( ";
            $filter_statement .= "c.customer_ic LIKE '%" . $this->db->escape($filter_search) . "%' ";
            $filter_statement .= "OR TRIM(CONCAT(c.firstname,' ',c.lastname)) LIKE '%" . $this->db->escape($filter_search) . "%' ";
            $filter_statement .= "OR c.email LIKE '%" . $this->db->escape($filter_search) . "%' ";
            $filter_statement .= "OR c.telephone LIKE '%" . $this->db->escape($filter_search) . "%' ";
            $filter_statement .= "OR c.telephone2 LIKE '%" . $this->db->escape($filter_search) . "%' ";
            $filter_statement .= "OR c.home LIKE '%" . $this->db->escape($filter_search) . "%' ";
            $filter_statement .= ") ";
        }

        if (!empty($data['customer_card'])) {
            $filter_statement .= " AND c.customer_card LIKE '%" . $this->db->escape($data['customer_card']) . "%'";
        }

        if (!empty($data['customer_group_id'])) {
            $filter_statement .= " AND c.customer_group_id = '" . (int)$data['customer_group_id'] . "'";
        }

        if (!empty($data['gender'])) {
            $filter_statement .= " AND c.gender = '" . (int)$data['gender'] . "'";
        }

        if (!empty($data['min_age'])) {
            $filter_statement .= " AND (YEAR(CURRENT_DATE) - YEAR(c.dob)) >= '" . (int)$data['min_age'] . "'";
        }

        if (!empty($data['max_age'])) {
            $filter_statement .= " AND (YEAR(CURRENT_DATE) - YEAR(c.dob)) <= '" . (int)$data['max_age'] . "'";
        }

        if (!empty($data['max_age']) || !empty($data['min_age'])) {
            $filter_statement .= " AND (YEAR(CURRENT_DATE) - YEAR(c.dob)) <>'0' AND c.dob<>'0000-00-00'";
        }

        if (!empty($data['zone_id'])) {
            $filter_statement .= " AND a.zone_id = '" . (int)$data['zone_id'] . "'";
        }

        if (!empty($data['email'])) {
            $filter_statement .= " AND c.email LIKE '%" . $this->db->escape($data['email']) . "%'";
        }

        #endregion

        #region sorting & pagination

        //default sort by name desc
        $order_column = "TRIM(CONCAT(c.firstname,' ',c.lastname))";
        $direction = "ASC";

        if (!empty($data['sort_by'])) {
            if (in_array($data['sort_by'], ['date_added'])) {
                $order_column = "c.date_added";
            }
        }

        if (!empty($data['sort_direction'])) {
            if (in_array($data['sort_direction'], ['ASC', 'DESC'])) {
                $direction = $data['sort_direction'];
            }
        }

        $start = $data['start'];
        $limit = $data['limit'];
        #endregion

        $sql = "SELECT c.*,
        YEAR(CURRENT_DATE) - YEAR(c.dob) AS age_year,
        z.name AS state_name,
        cgd.name AS customer_group
        FROM " . DB_PREFIX . "customer c
        LEFT JOIN " . DB_PREFIX . "customer_group_description cgd ON(c.customer_group_id = cgd.customer_group_id AND cgd.language_id = '" . (int)$this->session->data['language_id'] . "')
        LEFT JOIN " . DB_PREFIX . "address a ON(c.address_id = a.address_id)
        LEFT JOIN " . DB_PREFIX . "zone z ON(a.zone_id = z.zone_id)
        WHERE 1
        AND (TRIM(CONCAT(c.firstname,' ',c.lastname)) <> '' OR c.telephone <>'' OR c.customer_ic <> '')
        $filter_statement
        ORDER BY $order_column $direction
        LIMIT $start, $limit";

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getCustomer($customer_id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "customer WHERE customer_id = '" . (int)$customer_id . "'";
        $query = $this->db->query($sql);
        return $query->row;
    }

    public function getAddressesByCustomerId($customer_id)
    {
        $sql = "SELECT a.*, z.name as zone, c.name as country FROM " . DB_PREFIX . "address a 
        LEFT JOIN " . DB_PREFIX . "zone z ON(a.zone_id=z.zone_id)
        LEFT JOIN " . DB_PREFIX . "country c ON(a.country_id=c.country_id)
        WHERE a.customer_id = '" . (int)$customer_id . "'";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getAddress($address_id)
    {
        $sql = "SELECT a.*, z.name as zone, c.name as country FROM " . DB_PREFIX . "address a 
        LEFT JOIN " . DB_PREFIX . "zone z ON(a.zone_id=z.zone_id)
        LEFT JOIN " . DB_PREFIX . "country c ON(a.country_id=c.country_id)
        WHERE a.address_id = '" . (int)$address_id . "'";
        $query = $this->db->query($sql);
        return $query->row;
    }

    public function updateCustomer($data)
    {
        $customer_id = $data['customer_id'];
        if (empty($customer_id)) {
            $customer_id = $this->addCustomer($data);
        } else {
            $this->editCustomer($data);
        }
        return $customer_id;
    }

    public function addCustomer($data)
    {
        do {
            $insert_customer = false;
            $unique_id = md5(rand() . $data['customer_ic'] . time());
            $customer_row = $this->check_unique_id($unique_id);
            $this->load->model('setting/setting');

            $customer_card_no = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'sale/customer', 'store' => $this->session->data['store_id']));

            if (empty($data['customer_card'])) {
                $customer_card = $customer_card_no;
                $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'sale/customer', 'store' => $this->session->data['store_id']));
            } else {
                $customer_card = $data['customer_card'];
            }

            if (empty($customer_row)) {
                $insert_customer = true;
                $this->db->query("
					INSERT INTO " . DB_PREFIX . "customer SET
						unique_customer_id = '" . $this->db->escape($unique_id) . "',
						customer_group_id = '" . (int) $data['customer_group_id'] . "',
						customer_card = '" . $this->db->escape($customer_card) . "',
						customer_ic = '" . $this->db->escape($data['customer_ic']) . "',
						firstname = '" . $this->db->escape($data['firstname']) . "',
						lastname = '" . $this->db->escape($data['lastname']) . "',
						gender = '" . $this->db->escape($data['gender_id']) . "',
						dob = '" . $this->db->escape($data['dob']) . "',
						email = '" . $this->db->escape($data['email']) . "',
						telephone = '" . $this->db->escape($data['telephone1']) . "',
						telephone2 = '" . $this->db->escape($data['telephone2']) . "',
						home = '" . $this->db->escape($data['home']) . "',
						occupation = '" . $this->db->escape($data['occupation']) . "',
						nationality = '" . $this->db->escape($data['nationality']) . "',
						marital_status = '" . (int) $data['marital_status_id'] . "',
						religion = '" . (int) $data['religion_id'] . "',
						race = '" . (int) $data['race_id'] . "',
						allergic = '" . $this->db->escape($data['allergic']) . "',
						diagnostic_history = '" . $this->db->escape($data['diagnostic_history']) . "',
						salt = '" . $this->db->escape($salt = substr(md5(uniqid(rand(), true)), 0, 9)) . "',
						password = '" . $this->db->escape(sha1($salt . sha1($salt . sha1('')))) . "',
						status = '1',
						approved = '1',
						safe = '1',
						date_added = NOW()
				");
            }
        } while ($insert_customer == false);
        $customer_id = $this->db->getLastId();
        return $customer_id;
    }

    public function editCustomer($data)
    {
        $customer_id = $data['customer_id'];

        $this->db->query("
        UPDATE " . DB_PREFIX . "customer SET
            customer_group_id = '" . (int) $data['customer_group_id'] . "',
            customer_card = '" . $this->db->escape($data['customer_card']) . "',
            customer_ic = '" . $this->db->escape($data['customer_ic']) . "',
            firstname = '" . $this->db->escape($data['firstname']) . "',
            lastname = '" . $this->db->escape($data['lastname']) . "',
            gender = '" . $this->db->escape($data['gender_id']) . "',
            dob = '" . $this->db->escape($data['dob']) . "',
            email = '" . $this->db->escape($data['email']) . "',
            telephone = '" . $this->db->escape($data['telephone1']) . "',
            telephone2 = '" . $this->db->escape($data['telephone2']) . "',
            home = '" . $this->db->escape($data['home']) . "',
            occupation = '" . $this->db->escape($data['occupation']) . "',
            nationality = '" . $this->db->escape($data['nationality']) . "',
            marital_status = '" . (int) $data['marital_status_id'] . "',
            religion = '" . (int) $data['religion_id'] . "',
            race = '" . (int) $data['race_id'] . "',
            allergic = '" . $this->db->escape($data['allergic']) . "',
            diagnostic_history = '" . $this->db->escape($data['diagnostic_history']) . "'
            WHERE customer_id = '" . (int)$customer_id . "'
        ");
    }

    public function updateAddress($data)
    {
        $address_id = $data['address_id'];
        $customer_id = $data['customer_id'];
        if (empty($address_id)) {
            $address_id = $this->addAddress($data);
        } else {
            $this->editAddress($data);
        }

        if (!empty($data['default'])) {
            $this->db->query("UPDATE " . DB_PREFIX . "customer SET address_id = '" . (int) $address_id . "' WHERE customer_id = '" . (int) $customer_id . "'");
        }
        return $address_id;
    }

    public function addAddress($data)
    {
        $this->db->query("
        INSERT INTO " . DB_PREFIX . "address SET
        customer_id = '" . (int) $data['customer_id'] . "',
        firstname = '" . $this->db->escape($data['firstname']) . "',
        lastname = '" . $this->db->escape($data['lastname']) . "',
        address_1 = '" . $this->db->escape($data['address_1']) . "',
        address_2 = '" . $this->db->escape($data['address_2']) . "',
        address_3 = '" . $this->db->escape($data['address_3']) . "',
        city = '" . $this->db->escape($data['city']) . "',
        postcode = '" . $this->db->escape($data['postcode']) . "',
        country_id = '" . (int) $data['country_id'] . "',
        zone_id = '" . (int) $data['zone_id'] . "'
        ");
        return $this->db->getLastId();
    }

    public function editAddress($data)
    {
        $this->db->query("
        UPDATE " . DB_PREFIX . "address SET
        customer_id = '" . (int) $data['customer_id'] . "',
        firstname = '" . $this->db->escape($data['firstname']) . "',
        lastname = '" . $this->db->escape($data['lastname']) . "',
        address_1 = '" . $this->db->escape($data['address_1']) . "',
        address_2 = '" . $this->db->escape($data['address_2']) . "',
        address_3 = '" . $this->db->escape($data['address_3']) . "',
        city = '" . $this->db->escape($data['city']) . "',
        postcode = '" . $this->db->escape($data['postcode']) . "',
        country_id = '" . (int) $data['country_id'] . "',
        zone_id = '" . (int) $data['zone_id'] . "'
        WHERE address_id = '" . (int)$data['address_id'] . "'
        ");
    }

    public function deleteAddresses($customer_id)
    {
        $this->db->query("DELETE FROM " . DB_PREFIX . "address WHERE customer_id='" . (int)$customer_id . "'");
    }

    public function deleteAddress($address_id)
    {
        $this->db->query("DELETE FROM " . DB_PREFIX . "address WHERE address_id='" . (int)$address_id . "'");
    }

    public function getCustomerGroups()
    {
        $sql = "SELECT customer_group_id as id, name FROM " . DB_PREFIX . "customer_group_description WHERE language_id = '" . (int)$this->session->data['language_id'] . "' ORDER BY name";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getZones($country_id)
    {
        $sql = "SELECT zone_id AS id, name FROM " . DB_PREFIX . "zone WHERE country_id='" . (int)$country_id . "' ORDER BY name";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getReligions()
    {
        $sql = "SELECT religion_id AS id, name FROM " . DB_PREFIX . "religion_description WHERE language_id ='" . (int)$this->session->data['language_id'] . "'";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getRaces()
    {
        $sql = "SELECT race_id AS id, name FROM " . DB_PREFIX . "race_description WHERE language_id ='" . (int)$this->session->data['language_id'] . "'";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getMaritalStatuses()
    {
        $sql = "SELECT marital_status_id AS id, name FROM " . DB_PREFIX . "marital_status_description WHERE language_id ='" . (int)$this->session->data['language_id'] . "'";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getCustomerDefaultAddress($customer_id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "address WHERE address_id = (SELECT address_id FROM " . DB_PREFIX . "customer WHERE customer_id='" . (int)$customer_id . "')";
        $query = $this->db->query($sql);
        return $query->row;
    }


    private function check_unique_id($unique_id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "customer WHERE unique_customer_id = '" . $this->db->escape($unique_id) . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }
}
