<?php

class ModelAndroidCommonNotification extends Model
{
    private $notification_module = [
        "appointment" => [
            "new" => [
                'label' => "New Appointments",
                "desc" => "These are notification when new appointment created"
            ],
            "confirm" => [
                'label' => "Appointments Confirmed",
                "desc" => "These are notification when your appointment status changed to confirmed"
            ],
            "cancel" => [
                'label' => "Appointments Cancelled",
                "desc" => "These are notification when your appointment have been cancelled"
            ],
            "attend" => [
                'label' => "Appointments Attended",
                "desc" => "These are notification when patient attend your appointment"
            ],
        ],
        "medical_record" => [
            "new" => [
                'label' => "New Medical Records",
                "desc" => "These are notification when new Medical Records created"
            ],
        ],
        "service" => [
            "new" => [
                'label' => "New Services",
                "desc" => "These are notification when new services created"
            ],
        ],
    ];

    public function getNotificationModule()
    {
        return $this->notification_module;
    }

    public function getUserNotificationSetting($user_id = 0)
    {
        $this->updateNotificationSettingTable();
        $sql = "SELECT * FROM " . DB_PREFIX . "doctorapp_notification_setting WHERE 1";
        if (!empty($user_id)) {
            $sql .= " AND user_id='" . (int)$user_id . "'";
        }
        $sql .= " ORDER BY user_id, module, action";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getUserSetting($user_id, $module, $action)
    {
        $this->updateNotificationSettingTable();
        $sql = "SELECT * FROM " . DB_PREFIX . "doctorapp_notification_setting 
        WHERE 
        user_id = '" . (int)$user_id . "' 
        AND module = '" . $this->db->escape($module) . "' 
        AND action = '" . $this->db->escape($action) . "'";
        $query = $this->db->query($sql);
        return $query->row;
    }

    public function updateNotificationSetting($user_id, $data)
    {
        list($module, $action) = explode("__", $data['code']);
        $exist = $this->db->query("SELECT * FROM " . DB_PREFIX . "doctorapp_notification_setting WHERE user_id = '" . (int)$user_id . "' AND module = '" . $this->db->escape($module) . "' AND action = '" . $this->db->escape($action) . "'")->row;

        if ($exist) {
            //update
            $sql = "UPDATE " . DB_PREFIX . "doctorapp_notification_setting 
            SET 
            app = '" . (int)$data['push'] . "', 
            email = '" . (int)$data['email'] . "', 
            sms = '" . (int)$data['sms'] . "'
            WHERE id = '" . (int)$exist['id'] . "'";
        } else {
            //add new
            $sql = "INSERT INTO " . DB_PREFIX . "doctorapp_notification_setting 
            SET 
            user_id = '" . (int)$user_id . "', 
            module = '" . $this->db->escape($module) . "', 
            action = '" . $this->db->escape($action) . "', 
            app = '" . (int)$data['push'] . "', 
            email = '" . (int)$data['email'] . "', 
            sms = '" . (int)$data['sms'] . "'";
        }
        $this->db->query($sql);
    }

    public function getUsers()
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "user WHERE hide_user='0'";
        return $this->db->query($sql)->rows;
    }

    public function getUser($id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "user WHERE user_id = '" . (int)$id . "'";
        return $this->db->query($sql)->row;
    }

    public function getTokens($user_id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "user_device 
        WHERE fcm_token <> '' AND user_id = '" . (int)$user_id . "'";
        $query = $this->db->query($sql);
        $result = $query->rows;
        return array_column($result, 'fcm_token');
    }

    public function getDeviceIdByToken($token)
    {
        $device_id = '';
        $query = $this->db->query("SELECT device_id FROM " . DB_PREFIX . "user_device WHERE fcm_token = '" . $this->db->escape($token) . "'");
        if ($query->num_rows) {
            $device_id = $query->row['device_id'];
        }
        return $device_id;
    }

    public function addFirebaseLog($data)
    {
        $sql = "INSERT INTO " . DB_PREFIX . "firebase_notification_log
            SET user_id = '" . (int)$data['user_id'] . "',
            device_id = '" . $this->db->escape($data['device_id']) . "',
            notification = '" . $this->db->escape($data['notification']) . "',
            data = '" . $this->db->escape($data['fcm_data']) . "',
            request = '" . $this->db->escape($data['request']) . "',
            response = '" . $this->db->escape($data['response']) . "',
            error = '" . $this->db->escape($data['error']) . "',
            date_added = NOW()";

        $this->db->query($sql);

        return $this->db->getLastId();
    }

    public function addNotificationHistory($data)
    {
        $sql = "INSERT INTO " . DB_PREFIX . "doctorapp_notification_history 
            SET user_id='" . (int)$data['user_id'] . "',
            firebase_notification_log_id='" . (int)$data['log_id'] . "',
            notification_type='" . $this->db->escape($data['notification_type']) . "',
            notification='" . $this->db->escape($data['notification']) . "',
            data='" . $this->db->escape($data['fcm_data']) . "',
            date_added= NOW(),
            date_modified= NOW()";

        $this->db->query($sql);
        return $this->db->getLastId();
    }

    public function getNotificationDataUrl($app, $type)
    {
        $app_url = '';
        $query = $this->db->query("SELECT app_url FROM " . DB_PREFIX . "notification_type WHERE app='" . $this->db->escape($app) . "'
        AND type='" . $this->db->escape($type) . "'");
        if ($query->num_rows) {
            $app_url = $query->row['app_url'];
        }
        return $app_url;
    }

    public function getUserLanguageId($user_id)
    {
        $language_id = 2; //default chinese

        $query = $this->db->query("SELECT device_id FROM " . DB_PREFIX . "user_device WHERE user_id = '" . (int)$user_id . "' ORDER BY date_added DESC");
        if ($query->num_rows) {
            $device_id = $query->row['device_id'];
            $sql = "SELECT * FROM " . DB_PREFIX . "doctorapp_tracking WHERE device_id ='" . $this->db->escape($device_id) . "' order by id desc limit 1";
            $query = $this->db->query($sql);
            if (!empty($query->row['request'])) {
                $request_arr = json_decode($query->row['request'], true);
                if (!empty($request_arr['server']['HTTP_ACCEPT_LANGUAGE'])) {
                    $language_id = strtolower($request_arr['server']['HTTP_ACCEPT_LANGUAGE']) == 'en' ? 1 : 2;
                }
            }
        }
        return $language_id;
    }

    public function updateNotificationSettingTable()
    {
        $table_exist = $this->db->query("SHOW TABLES LIKE '" . DB_PREFIX . "doctorapp_notification_setting'")->num_rows;
        if (!$table_exist) {
            $this->db->query("CREATE TABLE `" . DB_PREFIX . "doctorapp_notification_setting` (`id` INT NOT NULL AUTO_INCREMENT , `user_id` INT NOT NULL , `module` VARCHAR(255) NOT NULL , `action` VARCHAR(255) NOT NULL , `app` INT(1) NOT NULL , `email` INT(1) NOT NULL , `sms` INT(1) NOT NULL , PRIMARY KEY (`id`)) ENGINE = InnoDB");
        }
    }
}
