<?php
class ModelAndroidBrewingQuotationApi extends Model {
	private $is_ver20;
	private $opencart_version;
	/*----------------------- New ----------------------------------*/
	/*-- Customer Start --*/
	public function getBrewingRequestTotals($brewing_id) {
		$sql = "
			SELECT
					htt.*
				FROM
					`oc_herbal_transfer_total` htt
				WHERE
					1
					AND htt.herbal_transfer_id = '" . (int)$brewing_id . "'
					AND htt.htt_id = 1
		";
		$query = $this->db->query($sql);
		return $query->rows;
	}

	public function getBrewingRequestDetails($brewing_id){
		$own_hosting = HTTP_SERVER;
		$sql = "
			SELECT 
					ht.herbal_transfer_id,
					ht.invoice_prefix,
					ht.tranfer_invoice,
					ht.to_hosting,
					ht.herbal,
					ht.prescription,
					ht.product,
					ht.status,
					ht.to_store_name,
					ht.image,
					DATE(date_added) AS date
				FROM 
					`oc_herbal_transfer` ht
				WHERE 
					1
					AND ht.herbal_transfer_id = '" . (int)$brewing_id . "'
					AND ht.from_hosting = '" . $this->db->escape($own_hosting) . "'
		";
		$query = $this->db->query($sql);
		return $query->row;
	}

	public function getBrewingRequestList($data) {
		$own_hosting = HTTP_SERVER;
		$sql = "
			SELECT
					ht.herbal_transfer_id,
					ht.tranfer_invoice,
					ht.to_store_name,
					ht.total,
					ht.status,
					ht.herbal,
					DATE(date_added) AS date
				FROM
					`oc_herbal_transfer` ht
				WHERE
					1
					AND ht.from_hosting = '" . $this->db->escape($own_hosting) . "'
		";
		/*if (!empty($data->status_name)) {
			$sql . = "
				AND ht.status = '" .  . "'
			";
		}*/
		if (!empty($data->search)) {
			$sql .= "
				    	AND (ht.to_store_name LIKE '%" . $this->db->escape($data->search) . "%' 
						OR ht.tranfer_invoice LIKE '%" . $this->db->escape($data->search) . "%' 
						OR DATE(date_added) LIKE '%" . $this->db->escape($data->search) . "%')
					";
		}
		$sql .= " GROUP BY ht.herbal_transfer_id 
					ORDER BY ht.herbal_transfer_id DESC";
		$sql .= " LIMIT " . $data->pagination_offset . "," . $data->pagination_entry;
		$query = $this->db->query($sql);
		return $query->rows;
	}

	public function checkExistsBrewingRequest($brewing_id) {
		$own_hosting = HTTP_SERVER;
		$sql = "
			SELECT
					COUNT(*) AS total
				FROM
					`oc_herbal_transfer` ht
				WHERE
					1
					AND ht.herbal_transfer_id = '" . (int)$brewing_id . "'
					AND ht.from_hosting = '" . $this->db->escape($own_hosting) . "'
				LIMIT 1
		";
		$query = $this->db->query($sql);
		return $query->row['total'];
	}

	public function getBrewingOrderList($data) {
		$own_hosting = HTTP_SERVER;
		$sql = "
			SELECT
					ht.herbal_transfer_id,
					ht.tranfer_invoice,
					ht.from_store_name,
					ht.total,
					ht.status,
					DATE(date_added) AS date
				FROM
					`oc_herbal_transfer` ht
				WHERE
					1
					AND ht.status = '" . (int)$data->status . "'
					AND ht.to_hosting = '" . $this->db->escape($own_hosting) . "'
		";
		if (!empty($data->search)) {
			$sql .= "
				    	AND (ht.from_store_name LIKE '%" . $this->db->escape($data->search) . "%' 
						OR ht.tranfer_invoice LIKE '%" . $this->db->escape($data->search) . "%' 
						OR DATE(date_added) LIKE '%" . $this->db->escape($data->search) . "%')
					";
		}
		$sql .= " GROUP BY ht.herbal_transfer_id 
					ORDER BY ht.herbal_transfer_id DESC";
		if (!empty($data->pagination_entry)) {
			$sql .= " LIMIT " . $data->pagination_entry;
		} else { 
			$sql .= " LIMIT 30 ";
		}
		$query = $this->db->query($sql);
		return $query->rows;
	}

	public function getBrewingStatus($brewing_id) {
		$sql = "
			SELECT
					ht.status AS status
				FROM
					`oc_herbal_transfer` ht
				WHERE
					1
					AND herbal_transfer_id = '" . (int)$brewing_id . "'
		";
		$query = $this->db->query($sql);
		return !empty($query->row['status']) ? $query->row['status'] : '';
	}

	public function setBrewingStatus($data) {
		$sql = "
			UPDATE
				`oc_herbal_transfer`
					SET
						status = '" . (int)$data['status'] . "',
						modifi_by = '" . (int)$data['user_id'] . "', 
						date_modified = NOW()";
	
		if ($data['status'] == 1) {
			$sql .=",accepted_by ='".(int)$data['user_id'] . "',
					accepted_date = NOW() ";  
		}

		if ($data['status'] == 2) {
			$sql .=",delivered_by ='".(int)$data['user_id'] . "',
			delivered_date = NOW() ";  
		}

		if ( $data['status'] == 3) {
			$sql .=",received_by ='".(int)$data['user_id'] . "',
				received_date = NOW() ";  
		}

		if ($data['status'] ==4) {
			$sql .=",canceled_by ='".(int)$data['user_id'] . "',
			canceled_date = NOW() ";  
		}
				  
		if ($data['status'] == 5) {
			$sql .=",dispensing_by ='".(int)$data['user_id'] . "',
				dispensing_date = NOW() ";
		}
				  
		if ($data['status'] == 6) {
			$sql .=",brewing_by ='".(int)$data['user_id'] . "',
				brewing_date = NOW() ";
		}

		$sql .= "	
				WHERE
					1
					AND herbal_transfer_id = '" . (int)$data['brewing_id'] . "'
					AND tranfer_invoice = '" . $this->db->escape($data['tranfer_invoice']) . "' 
					AND invoice_prefix = '" . $this->db->escape($data['invoice_prefix']) ."' 
					AND from_hosting = '" . $this->db->escape($data['from_hosting']) . "'
		";
		return $this->db->query($sql);
	}

	public function saveBrewingRequest($data) {
		$this->db->query("INSERT INTO " . DB_PREFIX . "herbal_transfer SET 
	    invoice_prefix = '" . $this->db->escape($data['invoice_prefix']) . "', 
		tranfer_invoice = '" . $this->db->escape($data['tranfer_invoice']) . "', 
		from_hosting = '" . $this->db->escape($data['from_hosting']) . "', 
		from_store_name = '" . $this->db->escape($data['from_store_name']) . "', 
		to_hosting = '" . $this->db->escape($data['to_hosting']) . "', 
		to_store_name = '" . $this->db->escape($data['to_store_name']) . "', 
		sales_date = '" . $this->db->escape($data['sales_date']) . "', 
		currency_id = '" . (int)$data['currency_id'] . "', 
		currency_code = '" . $this->db->escape($data['currency_code']) . "',
		currency_value = '" . $this->db->escape($data['currency_value']) . "',
		status = '0', 
		doctor_id = '" . (int)$data['doctor_id'] . "',
		customer_id = '".(int)$data['herbal']['customer_id']."', 
		doctor_name = '" . $this->db->escape($data['doctor_name']) . "', 
		shipping_method = '" . $this->db->escape($data['shipping_method']) . "',
		shipping_address_id = '" . (int)$data['shipping_address_id'] . "',
		shipping_firstname = '" . $this->db->escape($data['shipping_firstname']) . "',
		shipping_lastname = '" . $this->db->escape($data['shipping_lastname']) . "',
		shipping_company = '" . $this->db->escape($data['shipping_company']) . "',
		shipping_address_1 = '" . $this->db->escape($data['shipping_address_1']) . "',
		shipping_address_2 = '" . $this->db->escape($data['shipping_address_2']) . "',
		shipping_address_3 = '" . $this->db->escape($data['shipping_address_3']) . "',
		shipping_city = '" . $this->db->escape($data['shipping_city']) . "',
		shipping_postcode = '" . $this->db->escape($data['shipping_postcode']) . "',
		shipping_country = '" . $this->db->escape($data['shipping_country']) . "',
		shipping_country_id = '" . $this->db->escape($data['shipping_country_id']) . "',
		shipping_zone = '" . $this->db->escape($data['shipping_zone']) . "',
		shipping_zone_id = '" . $this->db->escape($data['shipping_zone_id']) . "',
		transfer_by = '" . (int)$data['transfer_by'] . "', 
		transfer_date = NOW(), 
		image = '" . $data['brewing_image'] . "',
		store_info = '" . $this->db->escape(serialize($data['store_info'])) . "', 
		herbal = '" . $this->db->escape(serialize($data['herbal'])) . "', 
		prescription = '" . $this->db->escape(serialize($data['prescription'])) . "', 
		product = '" . $this->db->escape(serialize($data['product'])) . "', 
		add_by = '" .(int)$data['transfer_by'] . "', 
		date_added = NOW(), 
		modifi_by = '" .(int)$data['transfer_by'] . "', 
		date_modified = NOW(),
		payment_status = '17',
		from_type = '2',
		store_type = '1', brew_type = '1'");
		$herbal_transfer_id = $this->db->getLastId();
		$total_weight = 0;
		if (!empty($data['prescription']) && $herbal_transfer_id) {
			$pst = array();
			foreach ($data['prescription'] as $prescription_id => $prescription) {
				$pst[$prescription_id]['net_amount'] = 0 ;
				$pst[$prescription_id]['weight'] = 0 ;
				$pst[$prescription_id]['tax'] = 0 ;
				$pst[$prescription_id]['total'] = 0 ;
				$this->db->query("
					INSERT INTO 
						`".DB_PREFIX."herbal_transfer_prescription` 
							SET 
								herbal_transfer_id = '".(int)$herbal_transfer_id."', 
								prescription_id = '".(int)$prescription_id."', 
								prescription_id2 = '".$prescription['id']."', 
								discount = '0', 
								markup = '0', 
								markup_type = '1', 
								name = '".$this->db->escape($prescription['name'])."'");
					$herbal_transfer_prescription_id = $this->db->getLastId(); 
					if (!empty($data['product']) && $herbal_transfer_prescription_id) {
						foreach ($data['product'][$prescription_id] as $product_id => $product) {
							$this->db->query("
							INSERT INTO 
								`".DB_PREFIX."herbal_transfer_product` 
									SET 
										herbal_transfer_id = '".(int)$herbal_transfer_id."', 
										product_id = '".(int)$product['product_id']."', 
										prescription_id = '".(int)$herbal_transfer_prescription_id."', 
										prescription_id2 = '".(int)$prescription_id."', 
										name = '".$this->db->escape($product['name'])."',
										code = '".$this->db->escape($product['code'])."',
										cook = 'Boiled Medicine',
										taketype = 'After Meal',
										quantity = '".$product['quantity']."',
										t_qty = '".$product['quantity']*$product['times']."',
										times = '".(int)$product['times']."',
										day = '1', 
										discount = '0',
										price  = '".$product['price']."',
										net_amount = '".$product['product_subtotal']."',
										total_net_amount = '".$product['subtotal']."',
										tax = '".$product['product_tax']."',
										total_tax = '".$product['tax']."',
										total = '".$product['total']."',
										tax_class_id = '".$product['tax_class_id']."',
										tax_code  = '".$product['tax_code']."',
										tax_format  = '".$product['tax_format']."',
										weight_class_id = '".$product['weight_class_id']."',
										weight = '".$product['product_weight']."', 
										t_weight = '".$product['weight']."',
										discount2 = '0.00',
										markup_type = '1',
										markup = '0.00',
										total_markup = '0.00',
										final_total = '".$product['total']."'");
								$pst[$prescription_id]['net_amount'] += $product['subtotal'] ;
								$pst[$prescription_id]['tax'] += $product['tax'];
								$pst[$prescription_id]['total'] += $product['total'];
								$pst[$prescription_id]['weight'] += $product['weight'];
						}
						$total_weight += $pst[$prescription_id]['weight'];
						$this->db->query("UPDATE `".DB_PREFIX."herbal_transfer_prescription` SET t_weight = '".(float)$pst[$prescription_id]['weight']."', t_net = '".(float)$pst[$prescription_id]['net_amount']."', t_tax = '".(float)$pst[$prescription_id]['tax']."', t_total = '".(float)$pst[$prescription_id]['total']."' WHERE herbal_transfer_prescription_id = '".(int)$herbal_transfer_prescription_id."'");
					}
			}
		}
		$total_weight2 = $total_weight;
		$total = 0;
		if(isset($data['totalData']) && $herbal_transfer_id){
			$sort_order = 0;
            foreach ($data['totalData'] as $order_total) {
               $this->db->query("INSERT INTO " . DB_PREFIX . "herbal_transfer_total SET herbal_transfer_id = '" . (int) $herbal_transfer_id . "', code = '" . $this->db->escape($order_total['code']). "',tax_key ='".(int) $order_total['key']."', tax_code = '" . $this->db->escape($order_total['tax_code']) . "', title = '" . $this->db->escape($order_total['title']) . "',  `value` = '" . (float) $order_total['value'] . "', sort_order = '" . (int) $order_total['sort_order'] . "', htt_id = '1'");
            }
            $total += $order_total['value'];
            //Total Weight
            $sort_order = (int)$order_total['sort_order'] + 1;
            $this->db->query("INSERT INTO `".DB_PREFIX."herbal_transfer_total` SET herbal_transfer_id = '".(int)$herbal_transfer_id."', code = 'weight', tax_key = '0', tax_code = '', title = 'Total Weight', value = '".(float)$total_weight2."', sort_order = '".(int)$sort_order."', htt_id = '2'");
            //Total Discount
            $sort_order += 1 ;
            $this->db->query("INSERT INTO `".DB_PREFIX."herbal_transfer_total` SET herbal_transfer_id = '".(int)$herbal_transfer_id."', code = 'discount', tax_key = '0', tax_code = '', title = 'Total Discount', value = '0.00', sort_order = '".(int)$sort_order."', htt_id = '2'");
            //Total Markup
            $sort_order += 1;
            $this->db->query("INSERT INTO `".DB_PREFIX."herbal_transfer_total` SET herbal_transfer_id = '".(int)$herbal_transfer_id."', code = 'markup', tax_key = '0', tax_code = '', title = 'Total Markup', value = '0.00', sort_order = '".(int)$sort_order."', htt_id = '2'");
            //Total Incl(Markup) 
            $sort_order += 1;
            $this->db->query("INSERT INTO `".DB_PREFIX."herbal_transfer_total` SET herbal_transfer_id = '".(int)$herbal_transfer_id."', code = 'total', tax_key = '0', tax_code = '', title = 'Total Incl(Markup)', value = '".(float)$total."', sort_order = '".(int)$sort_order."', htt_id = '2'");
            //Final Discount
            $sort_order += 1;
            $this->db->query("INSERT INTO `".DB_PREFIX."herbal_transfer_total` SET herbal_transfer_id = '".(int)$herbal_transfer_id."', code = 'discount', tax_key = '0', tax_code = '', title = 'Extra Discount', value = '0.00', sort_order = '".(int)$sort_order."', htt_id = '3'");
            //Final Total
            $sort_order += 1;
            $this->db->query("INSERT INTO `".DB_PREFIX."herbal_transfer_total` SET herbal_transfer_id = '".(int)$herbal_transfer_id."', code = 'total', tax_key = '0', tax_code = '', title = 'Final Total', value = '".(float)$total."', sort_order = '".(int)$sort_order."', htt_id = '3'");
            //Brew Total
            //$order_total = 0;
            $this->load->library('tax');
            $this->load->library('brew_cart');
            $this->load->library('currency');
            $this->currency = new Currency($this->registry);
            $this->tax = new Tax($this->registry);
            $this->cart = new Cart($this->registry);
            //$this->load->model('user/user');
            $rate_value 	= array();
            $user_info 		= [];//$this->model_user_user->getUser((int)$data['doctor_id']);
            if (!empty($user_info['consultationprice'])) {
            	$doctor_consultation_price = $user_info['consultationprice'];
            } else {
            	$doctor_consultation_price = 0;
            }
            if (!empty($user_info['enable_consultation_price'])) {
            	$enable_consultation_status = $user_info['enable_consultation_price'];
            } else {
            	$enable_consultation_status = 0;
            }
            $brewing_final_total = 0;
            if (!empty($enable_consultation_status)) {
            	$brewing_final_total = $total + $doctor_consultation_price;
            	//$doctor_consultation_price2 = $doctor_consultation_price;
            } else {
            	$brewing_final_total = $total;
            	//$doctor_consultation_price2 = $total;
            }
            if (!empty($user_info['tax_class_id'])) {
             	$tax_class_id 	= $user_info['tax_class_id'];
        	} else {
        		$tax_class_id 	= 13;
        	}
            $tax_code 	  	= $this->tax->getClassCode($tax_class_id);
            $final_taxes 	= $this->tax->calculateTax($brewing_final_total,$tax_class_id);
            $getRates 		= $this->tax->getRates($brewing_final_total,$tax_class_id); 
            if (!empty($getRates)) {
           		foreach ($getRates as $r_id => $rates) {
           			$rate_value = array(
           				'code'			=> $rates['code'],
           				'tax_rate_id'	=> $rates['tax_rate_id'],
           			);
           		}
           	}
           //Final Subtotal 
            $sort_order += 1;
           	$this->db->query("INSERT INTO `".DB_PREFIX."herbal_transfer_total` SET herbal_transfer_id = '".(int)$herbal_transfer_id."', code = 'sub_total', tax_key = '0', tax_code = '".$rate_value['code']."', title = 'Subtotal', value = '".(float)$final_taxes['net_amount']."', sort_order = '".(int)$sort_order."', htt_id = '4'");
           	//Final Tax
           	$sort_order += 1;
            $this->db->query("INSERT INTO `".DB_PREFIX."herbal_transfer_total` SET herbal_transfer_id = '".(int)$herbal_transfer_id."', code = 'tax', tax_key = '".$rate_value['tax_rate_id']."', tax_code = '".$rate_value['code']."', title = 'Tax', value = '".(float)$final_taxes['tax']."', sort_order = '".(int)$sort_order."', htt_id = '4'");
            //Final Brew Total
			$sort_order += 1;
            $this->db->query("INSERT INTO `".DB_PREFIX."herbal_transfer_total` SET herbal_transfer_id = '".(int)$herbal_transfer_id."', code = 'total', tax_key = '0', tax_code = '', title = 'Total', value = '".(float)$final_taxes['total']."', sort_order = '".(int)$sort_order."', htt_id = '4'");
		   	$this->db->query("update " . DB_PREFIX . "herbal_transfer SET 
	        price = '".(float)$total."', total = '".(float)$total."', tax_class_id = '".(int)$tax_class_id."', tax_code = '".$this->db->escape($tax_code)."', tax_format = '".$this->db->escape($final_taxes['format'])."', t_net = '".(float)$final_taxes['net_amount']."', t_gst = '".(float)$final_taxes['tax']."', t_total = '".(float)$final_taxes['total']."', prescription = '".serialize($data['prescription'])."', product = '".serialize($data['product'])."', brew_consultation_price = '" . (float) $doctor_consultation_price . "', brew_consultation_status = '" . (int)$enable_consultation_status . "' WHERE herbal_transfer_id = '" . (int) $herbal_transfer_id . "'");
	  
		}
		//Send Email
		$data['herbal_transfer_id'] = $herbal_transfer_id;
		/*if (is_file(DIR_IMAGE . $this->config->get('config_logo'))) {
			$data['image'] = HTTPS_IMAGE . $this->config->get('config_logo');
		} else {
			$data['image'] = '';
		}
		if(!empty($herbal_transfer_id)){
			$subject = sprintf('New Brewing Service Order #%u', $herbal_transfer_id);
			$data['text_subject'] = sprintf('You have a New Brewing Service Order #%u', $herbal_transfer_id) ;
			$data['text_subject_id'] = $herbal_transfer_id ;
		}
		$message = $this->load->view('mail/brewing.tpl',$data);
		$mail = new Mail($this->config->get('config_mail'));
		if (!empty($mail) && !empty($message)) {
			if (!empty($this->config->get('config_email'))) {
				$mail->setTo($this->config->get('config_email'));
				$mail->setFrom($this->config->get('config_email'));
				$mail->setSender($this->config->get('config_name'));
				$mail->setSubject($subject);
				$mail->setHtml($message);
				$mail->send();
			}
			if($this->config->get('config_mail_alert')) {
				$emails = explode(',',$this->config->get('config_mail_alert'));
				foreach ($emails as $email) {
					if ($email && preg_match('/^[^\@]+@.*.[a-z]{2,15}$/i', $email)) {
							$mail->setTo($email);
							$mail->setFrom($this->config->get('config_email'));
							$mail->send();
					}
				}
			}
			$admin_email = ['admin@etcm.me','support@etcm.me'];
			if (!empty($admin_email)) {
				foreach ($admin_email as $ad_mail) {
					if ($ad_mail && preg_match('/^[^\@]+@.*.[a-z]{2,15}$/i', $ad_mail)) {
							$mail->setTo($ad_mail);
							$mail->setFrom($this->config->get('config_email'));
							$mail->send();
					}
				}
			}
		}*/
		return $herbal_transfer_id;
	}

	public function updateBrewingRequestID($brewing_request_id,$brewing_quotation_id) {
		$this->db->query("UPDATE `" . DB_PREFIX . "brewing_request_quotation` SET brewing_request_id = '" . (int)$brewing_request_id . "', brewing_request_check = '1' WHERE 1 AND brewing_quotation_id = '" . (int)$brewing_quotation_id . "'");
	}

	public function getBrewingQuotationDetails($temp_id) {
		$sql = "
			SELECT
					brq.*,
					DATE(brq.date_added) AS sales_date,
					u.user_id   AS doctor_id,
					u.firstname AS doctor_firstname,
					u.lastname  AS doctor_lastname,
					u.email     AS doctor_email,
					c.firstname AS customer_firstname,
					c.lastname  AS customer_lastname,
					c.email     AS customer_email,
					c.telephone AS customer_telephone
				FROM
					`oc_brewing_request_quotation` brq
					LEFT JOIN
						`oc_user` u
							ON brq.added_by = u.user_id
					LEFT JOIN
						`oc_customer` c
							ON brq.customer_id = c.customer_id
				WHERE
					1
					AND brq.brewing_quotation_id = '" . (int)$temp_id . "'
		";
		$query = $this->db->query($sql);
		return $query->row;
	}

	public function getBrewingQuotationPrescriptions($temp_id) {
		$query = $this->db->query("
			SELECT 	
					bqps.* 
				FROM 
					`oc_brewing_request_quotation_prescription` bqps 
				WHERE 
					1 
					AND bqps.brewing_quotation_id = '" . (int)$temp_id . "' 
					AND status = '1' 
					LIMIT 1
		");
		return $query->rows;
	}

	public function getBrewingQuotationProducts($temp_id) {
		$query = $this->db->query("
			SELECT 
					bqp.*, 
					p.code 
				FROM 
					`oc_brewing_request_quotation_product` bqp 
						LEFT JOIN  
							`oc_product` p 
								ON bqp.product_id = p.product_id 
				WHERE 
					1 
					AND bqp.brewing_quotation_id = '" . (int)$temp_id . "' 
					AND bqp.status = '1'
		");
		return $query->rows;
	}

	public function getBrewingCheck($temp_id) {
		$sql = "
			SELECT 
					brq.brewing_request_check AS checked
				FROM
					`oc_brewing_request_quotation` brq
				WHERE
					1
					AND brewing_quotation_id = '" . (int)$temp_id . "'
		";
		$query = $this->db->query($sql);
		return $query->row['checked'];
	}

	public function getCSId($clinical_sale_prefix) {
		$sql = "
			SELECT 
					cs.clinical_sale_id
				FROM
					`oc_clinical_sale` cs
				WHERE
					1
					AND cs.invoice_prefix = '" . $this->db->escape($clinical_sale_prefix) . "'
				LIMIT 
					1
		";
		$query = $this->db->query($sql);
		return !empty($query->row['clinical_sale_id']) ? $query->row['clinical_sale_id'] : 0;
	} 

	public function getCSDetails($csid) {
		$sql = "
			SELECT
					cs.customer_id,
					cs.doctor_id,
					cs.store_id,
					cs.shipping_address_id
				FROM
					`oc_clinical_sale` cs
				WHERE
					1
					AND  clinical_sale_id = '" . (int)$csid . "'
		";
		$query = $this->db->query($sql);
		return $query->row;
	}

	public function getCSPrescriptions($csid) {
		$sql = "
			SELECT
					csp.prescription_id AS prescription_id,
					csp.name AS prescription_name
				FROM
					`oc_clinecal_sales_prescription` csp
				WHERE
					1
					AND clinical_sale_id = '" . (int)$csid . "'
		";
		$query = $this->db->query($sql);
		return $query->rows;
	}

	public function getCSProducts($csid) {
		$sql = "
		SELECT
				csp.product_id AS product_id,
				csp.quantity AS product_quantity,
				csp.times AS product_times
			FROM
				`oc_clinicalsale_product` csp
			WHERE
				1
				AND clinical_sale_id = '" . (int)$csid . "'
		";
		$query = $this->db->query($sql);
		return $query->rows;
	}

	public function getCSCustomer($customer_id) {
		$sql = "
			SELECT
					c.customer_id,
					CONCAT(c.firstname,' ',c.lastname) AS customer_name,
					c.telephone AS customer_telephone,
					c.customer_ic AS customer_ic,
					c.email AS customer_email,
					c.gender AS customer_gender
			FROM
					`oc_customer` c
			WHERE
				1
				AND c.status = '1'
				AND c.approved = '1'
				AND c.customer_id = '" . (int)$customer_id . "'
			";
		$query = $this->db->query($sql);
		return $query->row;
	}

	public function getCSAddress($address_id) {
		$sql = "
			SELECT
					a.address_id,
					c.telephone AS customer_telephone,
					CONCAT(a.firstname,' ',a.lastname) AS customer_name,
					CONCAT(a.address_1,' ',a.address_2,' ',a.address_3,' ',a.city,' ',a.postcode,' ',zo.name,' , ',co.name) AS customer_address,
					a.city AS city,
					a.postcode AS postcode,
					a.country_id,
					co.name AS country,
					a.zone_id,
					zo.name AS zone,
					(CASE WHEN c.address_id = a.address_id THEN 1 ELSE 0 END) AS default_address
				FROM 
					`oc_address` a
						LEFT JOIN
							`oc_customer` c
								ON a.customer_id = c.customer_id
						LEFT JOIN
							`oc_zone` zo
								ON a.zone_id = zo.zone_id
						LEFT JOIN
							`oc_country` co
								ON a.country_id = co.country_id
				WHERE
					1
					AND c.status = '1'
					AND c.approved = '1'
					AND a.address_id = '" . (int)$address_id . "'
					ORDER BY (CASE WHEN c.address_id = a.address_id THEN 1 ELSE 0 END) DESC, a.address_id DESC
				LIMIT 1
		";
		$query = $this->db->query($sql);
		return $query->row;
	}

	public function addTotals($data) {
		$this->db->query("
			INSERT INTO
				`oc_brewing_request_quotation_total`
					SET
						brewing_quotation_id = '" . (int)$data['temp_id'] . "',
						id = 0,
						code = '" . $this->db->escape($data['code']) . "',
						tax_key  = '" . (int)$data['key'] . "',
						tax_code = '" . $this->db->escape($data['tax_code']) . "',
						title = '" . $this->db->escape($data['title']) . "',
						value = '" . (float)$data['value'] . "',
						sort_order = '" . (int)$data['sort_order'] . "',
						status = 1,
						added_by = '" . $data['user_id'] . "',
						date_added = NOW()
		");
	}

	public function deleteTotals($temp_id) {
		$this->db->query("
			DELETE 
				FROM
					`oc_brewing_request_quotation_total` 
				WHERE
					1
					AND brewing_quotation_id = '" . (int)$temp_id  . "'
		");
	}

	public function addPrescriptopn($data) {
		$prescription_id = 0;
		$this->db->query("
			INSERT 
				INTO
					`oc_brewing_request_quotation_prescription`
						SET
							brewing_quotation_id = '" . (int)$data['brewing_quotation_id'] . "',
							prescription_id = '" . $this->dn->escape($data['id']) . "',
							status = 1,
							name = '" . $this->db->escape($data['name']) . "'
							discount = '0.00',
							added_by = '" . (int)$data['user_id'] . "',
							date_added = NOW() 
		");
		$prescription_id = $this->db->getLastId();
		return $prescription_id;
	}

	public function deletePrescription($temp_id) {
		$this->db->query("
			DELETE FROM
				`oc_brewing_request_quotation_prescription`
					WHERE
						1
						AND brewing_quotation_id = '" . (int)$temp_id  . "'
		");
	}

	public function addProduct($data) {
		$this->db->query("
			INSERT INTO
				`oc_brewing_request_quotation_product`
					SET
						brewing_quotation_id = '" . (int)$data['temp_id'] . "',
						brewing_quotation_prescription_id = '" . (int)$data['prescription_id'] . "',
						product_id = '" . (int)$data['product_id'] . "',
						prescription_id = '" . (int)$data['product_id'] . "',
						status = 1,
						quantity = '" . (float)$data['quantity'] . "',
						times = '" . (int)$data['times'] . "',
						price = '" . (float)$data['price'] . "',
						weight = '" . (float)$data['weight'] . "',
						discount = 0.00,
						total_quantity = '" . (float)($data['quantity']) * (float)$data['times'] . "',
						total_weight = '" . (float)$data['total_weight'] . "',
						subtotal = '" . (float)$data['price'] . "',
						tax = '" . (float)0.00 . "',
						total = '" . $data['total'] . "',
						weight_class_id = '" . (int)$data['weight_class_id'] . "',
						tax_class_id = '" . (int)$data['tax_class_id'] . "', 
						tax_code = '" . $this->db->escape($data['tax_code']) . "',
						tax_format = '" . $this->db->escape($data['tax_format']) . "', 
						day = 1,
						cook = 'Boiled Medicine',
						taketype = 'After Meal',
						stock = '" . $data['stock']  . "',
						added_by = '" . (int)$data['user_id'] . "',
						date_added = NOW()
		");
	}

	public function deleteProduct($temp_id) {
		$this->db->query("
			DELETE FROM
				`oc_brewing_request_quotation_product`
					WHERE
						1
						AND brewing_quotation_id = '" . (int)$temp_id . "'
		");
	}

	public function addPrescription($data) {
		$brewing_prescription_id = 0;
		$this->db->query("
			INSERT INTO
				`oc_brewing_request_quotation_prescription` 
					SET
						brewing_quotation_id = '" . (int)$data['temp_id'] . "',
						name = '" . $this->db->escape($data['name']) . "',
						prescription_id = '" . $this->db->escape($data['id']) . "',
						added_by = '" . (int)$data['user_id'] . "',
						discount = 0,
						status = 1,
						date_added = NOW()
		");
		$brewing_prescription_id = $this->db->getLastId();
		return $brewing_prescription_id;
	}

	/*public function addProduct($data) {
		$brewing_quotation_product_id = 0;
		$this->db->query("
			INSERT INTO `oc_brewing_request_quotation_product` 
				SET 
					brewing_quotation_id = '" . (int)$data['temp_id'] . "', brewing_quotation_prescription_id = '" . (int)$data['brewing_prescription_id'] . "', 
					product_id = '" . (int)$data['product_id'] ."', prescription_id = '" . $this->db->escape($data['prescription_id']) . "', 
					status = '1', 
					quantity = '" . (float)$data['quantity'] . "', 
					times = '" . (int)$data['times'] . "', 
					price = '" . (float)0.00 . "', 
					weight = '" . (float)$data['weight'] . "', 
					discount = '" . (float)$data['discount'] . "', 
					total_quantity = '" . (float)$data['total_quantity'] . "', total_weight = '" . (float)$data['total_weight'] . "', subtotal = '" . (float)$data['subtotal'] . "', 
					tax = '" . (float)$data['tax'] . "', 
					total = '" . (float)$data['total'] . "', 
					weight_class_id = '" . (int)$data['weight_class_id'] ."', tax_class_id = '" . (int)$data['tax_class_id'] . "', 
					tax_code = '" . $this->db->escape($data['tax_code']) . "', tax_format = '" . $this->db->escape($data['tax_format']) . "',day = '" . (int)$data['day'] . "', 
					cook = '" . $this->db->escape($data['cook']) . "', 
					taketype = '" . $this->db->escape($data['taketype']) . "', stock = '" . $data['stock'] . "', 
					added_by = '" . (int)$data['user_id'] . "', 
					date_added = NOW()");
		$brewing_quotation_product_id = $this->db->getLastId();
		return $brewing_quotation_product_id;
	}*/

	public function check_country($country_id) {
		$sql = "
			SELECT
					COUNT(*) AS total
				FROM
					`oc_country` c
				WHERE 
					1
					AND c.country_id = '" . (int)$country_id . "'
				LIMIT 1
		";
		$query = $this->db->query($sql);
		return $query->row['total'];
	}

	public function check_zone($country_id,$zone_id) {
		$sql = "
			SELECT
					COUNT(*) AS total
				FROM
					`oc_zone` z
				WHERE 
					1
					AND z.country_id = '" . (int)$country_id . "'
					AND z.zone_id    = '" . (int)$zone_id . "'
				LIMIT 1
		";
		$query = $this->db->query($sql);
		return $query->row['total'];
	}

	public function get_countries_list($data) {
		$sql = "
			SELECT
					c.country_id, 
					c.name,
					(CASE WHEN c.country_id = '" . (int)$data->country_id ."' THEN 1 ELSE 0 END) AS selected
				FROM
					`oc_country` c
				WHERE
					1
		";
		if (!empty($data->search)) {
			$sql .= " 
				AND c.name LIKE '%" . $this->db->escape($data->search) . " %'
			";
		}
		$sql .= " GROUP BY c.country_id
					ORDER BY (CASE WHEN c.country_id = '" . (int)$data->country_id ."' THEN 1 ELSE 0 END) DESC, c.name ASC";
		if (!empty($data->pagination_entry)) {
			$sql .= " LIMIT " . $data->pagination_entry ;
		}
		$query = $this->db->query($sql);
		return $query->rows;
	}

	public function get_zones_list($data) {
		$sql = "
			SELECT
					z.zone_id, 
					z.name,
					(CASE WHEN z.zone_id = '" . (int)$data->zone_id ."' THEN 1 ELSE 0 END) AS selected
				FROM
					`oc_zone` c
				WHERE
					1
		";
		if (!empty($data->search)) {
			$sql .= " 
				AND z.name LIKE '%" . $this->db->escape($data->search) . " %'
			";
		}
		$sql .= " GROUP BY z.zone_id
					ORDER BY (CASE WHEN c.zone_id = '" . (int)$data->zone_id ."' THEN 1 ELSE 0 END) DESC, z.name ASC";
		if (!empty($data->pagination_entry)) {
			$sql .= " LIMIT " . $data->pagination_entry ;
		}
		$query = $this->db->query($sql);
		return $query->rows;
	}

	public function check_customer_field_exists($data) {
		$sql = "
			SELECT
					COUNT(*) AS total
				FROM
					`oc_customer` c
				WHERE
					1
					AND c.status = '1'
					AND c.approved = '1'
		";

		if (!empty($data->customer_id)) {
			$sql .= " AND c.customer_id = " . $data->customer_id;
		}

		if (!empty($data->customer_telephone)) {
			$sql .= " AND c.telephone = " . $data->customer_telephone;
		}

		if (!empty($data->customer_email)) {
			$sql .= " AND c.email = " . $data->customer_email;
		}

		if (!empty($data->customer_ic)) {
			$sql .= " AND c.customer_ic = " . $data->customer_ic;
		}

		$sql .= " LIMIT 1" ;
		$query = $this->db->query($sql);
		return $query->row['total'];
	}

	public function check_customer_exists($customer_id) {
		$sql = "
			SELECT
					COUNT(*) AS total
				FROM
					`oc_customer` c
				WHERE
					1
					AND c.status = '1'
					AND c.approved = '1'
					AND c.customer_id = '" . (int)$customer_id . "'
				LIMIT 1
		";
		$query = $this->db->query($sql);
		return $query->row['total'];
	}

	public function add_customer($data) {
		$sql = $this->db->query("
			INSERT INTO 
				`oc_customer` 
					SET 
						`customer_group_id` = 1,
						`firstname`   = '" . $this->db->escape($data->customer_name) . "',
						`telephone`   = '" . $this->db->escape($data->customer_telephone) ."',
						`email`       = '" . $this->db->escape($data->customer_email) . "',
						`customer_ic` = '" . $this->db->escape($data->customer_ic) . "',
						`gender`      = '" . (int)$data->customer_gender . "',
						`status`      = 1,
						`approved`    = 1
		");
		$customer_id = $this->db->getLastId();
		return $customer_id;
	}

	public function add_address($data) {
		$sql = $this->db->query("
			INSERT INTO
				`oc_address`
					SET
						`customer_id` = '" . (int)$data->customer_id . "',
						`firstname`   = '" . $this->db->escape($data->customer_name) . "',
						`address_1`   = '" . $this->db->escape($data->address) . "',
						`city`        = '" . $this->db->escape($data->city) . "',
						`postcode`    = '" . $this->db->escape($data->postcode) . "',
						`country_id`  = '" . (int)$data->country_id . "',
						`zone_id`     = '" . (int)$data->zone_id . "'
		");
		$address_id = $this->db->getLastId();
		return $address_id;
	}

	public function update_address_to_customer($data) {
		$sql = $this->db->query("
			UPDATE
				`oc_customer`
					SET
						`address_id` = '" . (int)$data->address_id . "'
				WHERE
					customer_id = '" . (int)$data->customer_id . "' 
		");
	}

	public function get_customer($customer_id) {
		$sql = "
			SELECT
					c.customer_id,
					CONCAT(c.firstname,' ',c.lastname) AS customer_name,
					c.telephone AS customer_telephone,
					c.customer_ic AS customer_ic,
					c.email AS customer_email,
					c.gender AS customer_gender
				FROM
					`oc_customer` c
				WHERE
					1
					AND c.status = '1'
					AND c.approved = '1'
					AND c.customer_id = '" . (int)$customer_id . "'
		";
		$query = $this->db->query($sql);
		return $query->row;
	}

	public function saveQuotationDetails($data) {
		$this->db->query("
			UPDATE	
				`oc_brewing_request_quotation`
					SET
						customer_id = '" . (int)$data['customer_id'] . "',
						customer_telephone = '" . $this->db->escape($data['customer_telephone'])  . "',
						customer_email = '" . $this->db->escape($data['customer_email']) . "',
						customer_ic = '" . $this->db->escape($data['customer_ic']) . "',
						customer_gender = '" . (int)$data['customer_gender'] . "',
						customer_name = '" . $this->db->escape($data['customer_name']) . "',
						customer_details = '" . $this->db->escape($data['customer_details']) . "',
						currency_id = '" . (int)$data['currency_id'] . "',
						currency_code = '" . $this->db->escape($data['currency_code']) . "',
						currency_value = '" . (float)$data['currency_value'] . "',
						currency_details = '" . $data['currency_details'] . "',
						shipping_address_id = '" . (int)$data['shipping']['shipping_address_id'] . "',
						shipping_address_method = '" . $this->db->escape($data['shipping']['shipping_address_method']) . "',
						shipping_customer = '" . $this->db->escape($data['shipping']['shipping_customer']) . "',
						shipping_telephone = '" . $this->db->escape($data['shipping']['shipping_telephone']) . "',
						shipping_address = '" . $this->db->escape($data['shipping']['shipping_address']) . "',
						shipping_postcode = '" . $this->db->escape($data['shipping']['shipping_postcode']) . "',
						shipping_city = '" . $this->db->escape($data['shipping']['shipping_city']) . "',
						shipping_country_id = '" . (int)$data['shipping']['shipping_country_id'] . "',
						shipping_country = '" . $this->db->escape($data['shipping']['shipping_country']) . "',
						shipping_zone_id = '" . (int)$data['shipping']['shipping_zone_id'] . "',
						shipping_zone = '" . $this->db->escape($data['shipping']['shipping_zone']) . "',
						shipping_details = '" . $this->db->escape($data['shipping']['shipping_details']) . "',
						brewing_store_id = '" . (int)$data['store']['brewing_store_id'] . "',
						brewing_store_name = '" . $this->db->escape($data['store']['brewing_store_name']) . "',
						brewing_store_url = '" . $this->db->escape($data['store']['brewing_store_url']) . "',
						brewing_store_address = '" . $this->db->escape($data['store']['brewing_store_address']) . "',
						brewing_store_city = '" . $this->db->escape($data['store']['brewing_store_city']) . "',
						brewing_store_telephone = '" . $this->db->escape($data['store']['brewing_store_telephone']) . "',
						brewing_images = '" . $this->db->escape($data['store']['brewing_images']) . "',
						brewing_store_details = '" . $data['store']['brewing_store_details'] . "',
						shipping_method_code = '" . $this->db->escape($data['shipping_method_code']). "',
						shipping_method_title = '" . $this->db->escape($data['shipping_method_title']) . "',
						subtotal = '" . (float)$data['total']['subtotal'] . "',
						tax = '" . (float)$data['total']['tax'] . "',
						shipping = '" . (float)$data['total']['shipping'] . "',
						rounding = '" . (float)$data['total']['rounding'] . "',
						total  = '" . (float)$data['total']['total'] . "',
						images = '" . $this->db->escape($data['images']) . "',
						remarks = '" . $this->db->escape($data['remarks']) . "',
						pack = '" . (int)$data['pack'] . "',
						volume = '" . $this->db->escape($data['volume']) . "',
						cook_method = '" . $this->db->escape($data['cook_method']) . "',
						modified_by = '" . (int)$data['user_id'] . "',
						date_modified = NOW(),
						date_modified_ts = NOW()
					WHERE
						1
						AND brewing_quotation_id = '" . (int)$data['temp_id'] . "'
		");
	}

	public function update_customer($customer) {
		$sql = $this->db->query("
			UPDATE
				`oc_brewing_request_quotation` 
					SET
						customer_id         = '" . (int)$customer['customer_id'] .  "',
					  	customer_telephone  = '" . $this->db->escape($customer['customer_telephone']) . "',
						customer_email      = '" . $this->db->escape($customer['customer_email']) . "',
						customer_ic         = '" . $this->db->escape($customer['customer_ic']) . "',
						customer_gender     = '" . (int)$customer['customer_gender'] . "',
						customer_name       = '" . $this->db->escape($customer['customer_name']) . "'
					WHERE
						1
						AND brewing_quotation_id = '" . (int)$customer['temp_id'] . "'
		");
	}

	public function get_customers_list($data) {
		$data = $this->unhashed($data);
		$sql = "
			SELECT
					c.customer_id,
					CONCAT(c.firstname,' ',c.lastname) AS customer_name,
					c.telephone AS customer_telephone,
					c.customer_ic AS customer_ic,
					c.email AS customer_email,
					(CASE WHEN c.gender = 1 THEN 'Male' ELSE 'Female' END)  AS customer_gender,
					(CASE WHEN c.customer_id = '" . (int)$data->customer_id . "' THEN 1 ELSE 0 END) AS selected_customer
				FROM
					`oc_customer` c
				WHERE
					1
					AND c.status = '1'
					AND c.approved = '1'
		";
		if (!empty($data->search)) {
			$sql .= "
				    	AND (CONCAT(c.firstname,' ',c.lastname) LIKE '%" . $this->db->escape($data->search) . "%' 
						OR c.telephone LIKE '%" . $this->db->escape($data->search) . "%' 
						OR c.customer_ic LIKE '%" . $this->db->escape($data->search) . "%' 
						OR c.email LIKE '%" . $this->db->escape($data->search) .  "%'
					 	OR (CASE WHEN c.gender = 1 THEN 'Male' ELSE 'Female' END) = '" . $data->search . "')
					";
		}
		$sql .= " GROUP BY c.customer_id 
					ORDER BY (CASE WHEN c.customer_id = '" . (int)$data->customer_id . "' THEN 1 ELSE 0 END) DESC, customer_name ASC";
		if (!empty($data->pagination_entry)) {
			$sql .= " LIMIT " . $data->pagination_entry;
		} else { 
			$sql .= " LIMIT 30 ";
		}
		$query = $this->db->query($sql);
		return $this->hashed($query->rows);
	}

	public function get_customer_address_list($data) {
		$data = $this->unhashed($data);
		$sql = "
			SELECT 
					a.address_id,
					c.telephone AS customer_telephone,
					CONCAT(a.firstname,' ',a.lastname) AS customer_name,
					CONCAT(a.address_1,' ',a.address_2,' ',a.address_3,' ',a.city,' ',a.postcode,' ',zo.name,' , ',co.name) AS customer_address,
					a.city AS city,
					a.postcode AS postcode,
					a.country_id,
					co.name AS country,
					a.zone_id,
					zo.name AS zone,
					(CASE WHEN c.address_id = a.address_id THEN 1 ELSE 0 END) AS default_address
				FROM 
					`oc_address` a
						LEFT JOIN
							`oc_customer` c
								ON a.customer_id = c.customer_id
						LEFT JOIN
							`oc_zone` zo
								ON a.zone_id = zo.zone_id
						LEFT JOIN
							`oc_country` co
								ON a.country_id = co.country_id
				WHERE
					1
					AND c.status = '1'
					AND c.approved = '1'
					AND c.customer_id = '" . (int)$data->customer_id . "'
				ORDER BY (CASE WHEN c.address_id = a.address_id THEN 1 ELSE 0 END) DESC, a.address_id DESC
		";
		if (!empty($data->pagination_entry)) {
			$sql .= " LIMIT " . $data->pagination_entry;
		} else { 
			$sql .= " LIMIT " . $this->config->get('config_limit_admin');
		}
		$query = $this->db->query($sql);
		return $this->hashed($query->rows);
	}

	public function get_payment_address_list($data) {
		$data = $this->unhashed($data);
		$sql = "
			SELECT 
					s.store_id,
					s.name AS store_name, 
					s.url AS store_url,
					(CASE WHEN st.code = 'config_telephone' THEN st.value ELSE '' END) AS telephone,
					(CASE WHEN st.code = 'config_zone_id' THEN st.value ELSE 0 END) AS zone_id,
					(CASE WHEN st.code = 'config_country_id' THEN st.value ELSE 0 END) AS country_id,
					(CASE WHEN st.code = 'config_email' THEN st.value ELSE '' END) AS email,
					(CASE WHEN st.code = 'config_address' THEN st.value ELSE '' END) AS address,
					(CASE WHEN st.code = 'config_owner' THEN st.value ELSE '' END) AS 
					store_owner
				FROM
					`oc_store` s
						LEFT JOIN
							`oc_setting` st
								ON s.store_id = st.store_id
				WHERE
					1
				GROUP BY s.store_id
				ORDER BY s.store_id ASC
		";
		if (!empty($data->pagination_entry)) {
			$sql .= " LIMIT " . $data->pagination_entry;
		} else { 
			$sql .= " LIMIT 30 ";
		}
		$query = $this->db->query($sql);
		return $this->hashed($query->rows);
	}

	/*-- Product Start --*/
	public function delete_prescription($temp_id) {
		$this->db->query("
			DELETE
				FROM
					`oc_brewing_request_quotation_prescription`
				WHERE
					1
					AND brewing_quotation_id = '" . (int)$temp_id . "'
		");
	}

	public function add_prescription($data,$temp_id) {
		$this->db->query("
			INSERT INTO
				`oc_brewing_request_quotation_prescription`
					SET
						brewing_quotation_id = '" . (int)$temp_id . "',
						prescription_id = '" . $this->db->escape($data['id']) . "', 
						status = 1,
						name = '" . $this->db->escape($data['name']) . "',
						added_by = '" . (int)$data['user_id'] . "',
						date_added = NOW()
		");
	}

	public function get_product($product_id) {
		$sql = "
			SELECT 
					p.product_id AS product_id,
					pd.name AS name
				FROM
					`oc_product` p
						LEFT JOIN
							`oc_product_description` pd
								ON p.product_id = pd.product_id
				WHERE
					1
					AND p.product_id = '" . (int)$product_id .  "'
					AND pd.language_id  = '" . (int)$this->config->get('config_language_id') . "'
				LIMIT 1
		";
		$query = $this->db->query($sql);
		return $query->row;
	}

	public function get_products_list($data) {
		$data = $this->unhashed($data);
		$sql = "
			SELECT 
					p.product_id AS product_id, 
					p.code AS product_code, 
					pd.name AS product_name 
				FROM 
					`oc_product` p 
						LEFT JOIN 
							`oc_product_description` pd 
								ON p.product_id = pd.product_id AND pd.language_id = " . (int)$data->language_id . " 
				WHERE 
					1 
					AND p.internal_status = 1
					AND pd.name <>'' 
			"; 
		if (!empty($data->search)) {
			$sql .= "
				    	AND (p.code LIKE '%" . $this->db->escape($data->search) . "%' 
					 	OR pd.name LIKE '%" . $this->db->escape($data->search) . "%' 
					 	OR p.model LIKE '%" . $data->search . "%')
					";
		}
		$sql .= " GROUP BY p.product_id ORDER BY product_name ASC";
		if (!empty($data->pagination_entry)) {
			$sql .= " LIMIT " . $data->pagination_entry;
		} else { 
			$sql .= " LIMIT 30 ";
		}
		$query = $this->db->query($sql);
		return $this->hashed($query->rows);
	}
	/*-- Product End --*/
	/*-- Prescription  -Start-*/
	public function get_prescriptions_list($data) {
		$data = $this->unhashed($data);
		$sql = "
			SELECT 
					p.prescription_id AS prescription_id, 
					p.code AS prescription_code, 
					pn.name AS prescription_name 
				FROM 
					`oc_prescription` p 
						LEFT JOIN 
							`oc_prescription_name` pn 
								ON p.prescription_id = pn.prescription_id AND pn.language_id = " . (int)$data->language_id . " 
				WHERE 
					1
			";
		if (!empty($data->search)) {
			$sql .= " 
						AND (p.code LIKE '%" . $this->db->escape($data->search) . "%' 
						OR pn.name LIKE '%" . $this->db->escape($data->search) . "%')";
		} 
		$sql .= " GROUP BY p.prescription_id ORDER BY prescription_name ASC";
		if (!empty($data->pagination_entry)) {$sql .= " LIMIT " . $data->pagination_entry;} else { $sql .= " LIMIT 30 "; }
		$query = $this->db->query($sql);
		return $this->hashed($query->rows);
	}

	public function get_perscription_items_json($prescription_id){
		$query = $this->db->query("
			SELECT 
					pn.name AS prescription_name,
					p.product_id,
					pd.name AS product_name,
					pi.used_qty AS quantity,
					pi.display_order 
				FROM 
					`oc_prescription_item` pi 
						LEFT JOIN
							`oc_prescription_name` pn
								ON pi.prescription_id = pn.prescription_id AND pn.language_id = '" . (int)$this->config->get('config_language_id') . "' 				
						LEFT JOIN 
							`oc_product_description` pd 
								ON (pi.product_id = pd.product_id) AND pd.language_id = '" . (int)$this->config->get('config_language_id') . "' 
						LEFT JOIN 
							`oc_product` p 
								ON (pi.product_id = p.product_id) 
				WHERE 
					1
					AND pi.prescription_id = '". $prescription_id."' 
					AND p.internal_status = '1' 
				ORDER BY pi.display_order ASC
		");
		return $query->rows;	 
	}
	/*-- Prescription End --*/

	/*-- Cart Start --*/
	public function add_activity($data) {
		$data = $this->unhashed($data);
		$this->db->query("
			INSERT INTO `oc_brewing_activity` 
				SET 
					device_type     = '" . (int)$data->device_type . "',
					method          = '" . $this->db->escape($data->method) . "',
					type            = '" . $this->db->escape($data->type) . "',
					data            = '" . $data->items .  "',
					timestamp       = '" . $this->get_time_stamp() . "'
		");
		$activity_id = $this->db->getLastId();
		return $this->hashed($activity_id);
	}

	public function add_temp($data) {
		$data = $this->unhashed($data);
		$brewing_invoice_prefix = $this->load->controller('setting/transaction_no/getTransactionNo',array('module'=>'etcm/brewing_request_quotation','store'=>$this->session->data['store_id']));
		$this->db->query("
			INSERT INTO `oc_brewing_request_quotation` 
				SET 
					invoice_prefix = '" . $this->db->escape($brewing_invoice_prefix) .  "',
					brewing_activity_id = '" . $this->db->escape($data->activity_id) . "',
					data   = '" . $data->items .  "',
					timestamp = '" . $this->get_time_stamp() . "',
					added_by  = '" . $data->user_id .  "'
		");
		$temp_id = $this->db->getLastId();
		if (!empty($temp_id)) {
			$this->load->controller('setting/transaction_no/setTransactionNo',array('module'=>'etcm/brewing_request_quotation','store'=>$this->session->data['store_id']));
		}
		return $this->hashed($temp_id);
	}

	public function add_images($data) {
		$image_folder_name = DIR_IMAGE . 'brewing_quotation/';
		//create cert dir if not exists
		if (!file_exists($image_folder_name)) {
			mkdir($image_folder_name, 0777, true);
		}
		$data_url_image = false;
		if ($data['image']['name'] && $data['temp_id']) {
			$image_query = $this->db->query("
				SELECT 
						i.image AS image
					FROM 
						`oc_brewing_request_quotation_images` i 
					WHERE 
						1
						AND brewing_quotation_id = '" . $data['temp_id'] . "'
					ORDER BY
						i.brewing_image_id DESC
					LIMIT 
						1
			");

			$this->db->query("
				DELETE FROM
						`oc_brewing_request_quotation_images`
					WHERE
						1
						AND brewing_quotation_id = '" . $data['temp_id'] . "'
			");

			if (!empty($image_query->row['image'])) {
				unlink(DIR_IMAGE . $image_query->row['image']);
			}

			$img_name = md5(rand (0, 1000) . rand (0, 1000) . rand (0, 1000)) .'.jpg';
			$upload_path_image = $image_folder_name . $img_name;
			$data_url_image = 'brewing_quotation/' . $img_name;
			move_uploaded_file($data['image']['tmp_name'], $upload_path_image);

			$this->db->query("
			INSERT INTO `oc_brewing_request_quotation_images` 
				SET 
					image = '" . $this->db->escape($data_url_image) .  "',
					brewing_quotation_id = '" . (int)$data['temp_id'] . "',
					remark = '',
					add_by = '" . (int)$data['user_id'] . "',
					timestamp = '" . $this->get_time_stamp() . "'
			");
			$images['temp_id'] = (int)$data['temp_id'];
			$images['images']  = $data_url_image;
			$this->update_images($images);
			$brewing_image  = $data_url_image;
		} else {
			$brewing_image  = '';
		}
		return $brewing_image;
	}

	public function update_images($data) {
		$this->db->query("
			UPDATE `oc_brewing_request_quotation` 
				SET 
					images = '" . $this->db->escape($data['images']) .  "'
				WHERE
					brewing_quotation_id = '" . (int)$data['temp_id'] . "'
		");
	}

	public function update_totals($totals) {
		$this->db->query("
			UPDATE `oc_brewing_request_quotation` 
				SET 
					pos_total = '" . (float)$totals['total'] . "',
					total = '" . (float)$totals['total'] . "',
					subtotal = '" . (float)$totals['subtotal'] . "',
					tax = '" . (float)$totals['tax'] . "',
					shipping = '" . (float)$totals['shipping'] . "'
				WHERE
					brewing_quotation_id = '" . (int)$totals['temp_id'] . "'
		");
	}

	public function update_temp($data) {
		$data = $this->unhashed($data);
		$this->db->query("
			UPDATE `oc_brewing_request_quotation` 
				SET 
					brewing_activity_id = '" . $this->db->escape($data->activity_id) . "',
					data   = '" . $data->items .  "',
					date   = NOW(),
					timestamp = '" . $this->get_time_stamp() . "'
				WHERE
					brewing_quotation_id = '" . (int)$data->temp_id . "'
		");
	}

	public function update_activity($activity_id,$temp_id) {
		$this->db->query("
			UPDATE `oc_brewing_activity`
				SET 
					brewing_temp_id = '" . (int)$temp_id . "'
				WHERE 
					brewing_activity_id = '" . (int)$activity_id .  "'
		");
	}

	public function get_temp_data($brewing_temp_id) {
		$sql = "
			SELECT 
				bt.data
				FROM
					`oc_brewing_request_quotation` bt
				WHERE 
					1
					AND bt.brewing_quotation_id = '" . (int)$brewing_temp_id .  "'
				ORDER BY bt.brewing_quotation_id DESC
		";
		$query = $this->db->query($sql);
		return $query->row;
	}

	/** Quotation */
	public function getQuotationDetails($quotation_id) {
		$sql = "
			SELECT
					brq.brewing_quotation_id,
					brq.brewing_request_check = 0 AS edited
				FROM
					`oc_brewing_request_quotation` brq
				WHERE
					1
					AND brq.brewing_quotation_id = '" . (int)$quotation_id . "'
		";
		$query = $this->db->query($sql);
		return $query->row;
	}

	public function get_quotations_list($data) {
		$data = $this->unhashed($data);
		$sql = "
			SELECT 
					brq.brewing_quotation_id,
					brq.invoice_prefix,
					brq.customer_name,
					brq.customer_telephone,
					brq.subtotal,
					brq.tax,
					brq.total,
					brq.brewing_request_check AS edited,
					DATE(brq.date_added) AS date
				FROM
					`oc_brewing_request_quotation` brq
				WHERE
					1
		";
		if (!empty($data->search)) {
			$sql .= "
				    	AND (brq.invoice_prefix LIKE '%" . $this->db->escape($data->search) . "%' 
						OR brq.customer_name LIKE '%" . $this->db->escape($data->search) . "%' 
						OR brq.customer_telephone LIKE '%" . $this->db->escape($data->search) . "%' 
						OR brq.subtotal LIKE '%" . $this->db->escape($data->search) .  "%'
						OR brq.tax LIKE '%" . $this->db->escape($data->search) .  "%'
						OR brq.total LIKE '%" . $this->db->escape($data->search) .  "%'
					 	OR DATE(brq.date_added) LIKE '%" . $data->search . "%')
					";
		}
		$sql .= " ORDER BY brq.brewing_quotation_id DESC ";
		$sql .= " LIMIT " . $data->pagination_offset . "," . $data->pagination_entry;
		/*if (!empty($data->pagination_entry)) {
			$sql .= " LIMIT " . $data->pagination_entry;
		} else { 
			$sql .= " LIMIT 30 ";
		}*/
		$query = $this->db->query($sql);
		return $this->hashed($query->rows);
	}

	protected function get_time_stamp() {
		$date = new DateTime();
		return $date->getTimestamp();
	}

	protected function hashed($data) {
		return base64_encode(json_encode($data));
	}

	protected function unhashed($data) {
		return json_decode(base64_decode($data));
	}
	/*----------------------- New END ----------------------------------*/

	/*----------------------- Old ----------------------------------*/
	private function check_version() {
        if(class_exists('MijoShop')) {
            $base = MijoShop::get('base');
            $installed_ms_version = (array) $base->getMijoshopVersion();
            $mijo_version = $installed_ms_version[0];
            if(version_compare($mijo_version, '3.0.0', '>=') && version_compare(VERSION, '2.0.0.0', '<')) {
                $this->opencart_version = '2.0.1.0';
            } else {
                $this->opencart_version = VERSION;
            }
        } else {
            $this->opencart_version = VERSION;
        }



        $this->is_ver20 = version_compare($this->opencart_version, '2.0.0.0', '>=');

    }

	public function getlangugeId(){
		$query = $this->db->query("SELECT l.language_id FROM `" . DB_PREFIX . "language` l  WHERE code = '" .$this->db->escape($this->config->get('config_language')). "'");
		return $query->row['language_id'];
   	}

	public function getSetting($group, $store_id = 0) {
        $this->check_version();
        $data        = [];
        $group_field = 'group';
        if(version_compare($this->opencart_version, '2.0.1.0', '>=')) {
            $group_field = 'code';
        }

        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "setting WHERE store_id = '" . (int)$store_id . "' AND `".$group_field."` = '" . $this->db->escape($group) . "'");

        foreach ($query->rows as $result) {
            if (!$result['serialized']) {
                $data[$result['key']] = $result['value'];
            } else {
                $data[$result['key']] = unserialize($result['value']);
            }
        }
        return $data;
	}
	/*----------------------- Old END ----------------------------------*/
} 
?>