<?php

class ModelAndroidBrewingSellerOrder extends Model {

    public function getBrewingOrderList($data = array()) {

        $sql = "SELECT * FROM " . DB_PREFIX . "herbal_order WHERE 1 ";

        if (!empty($data['search'])) {
            $sql .= " AND (
                        invoice_prefix LIKE '%" . $this->db->escape($data['search']) . "%'
                        OR buyer_store_name LIKE '%" . $this->db->escape($data['search']) . "%'
                        OR buyer_store_phone LIKE '%" . $this->db->escape($data['search']) . "%'
                        OR buyer_store_email LIKE '%" . $this->db->escape($data['search']) . "%'
                        OR total LIKE '%" . $this->db->escape($data['search']) . "%'
                        OR DATE(date_added) LIKE '%" . $this->db->escape($data['search']) . "%'
                )";
        }

        $sort_data = array(
            'invoice_no',
        );

        if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
            $sql .= " ORDER BY " . $data['sort'];
        } else {
            $sql .= " ORDER BY herbal_order_id";
        }

        if (isset($data['order']) && ($data['order'] == 'ASC')) {
            $sql .= " ASC";
        } else {
            $sql .= " DESC";
        }

        if (isset($data['page']) || isset($data['show'])) {
            if ($data['page'] < 0) {
                $data['page'] = 0;
            }

            if ($data['show'] < 1) {
                $data['show'] = 5;
            }

            $sql .= " LIMIT " . (int) $data['page'] . "," . (int) $data['show'];
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getOrderDetails($herbal_order_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "herbal_order WHERE 1 AND herbal_order_id = '" . (int) $herbal_order_id . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function getProducts($herbal_order_id) {
        $sql = "SELECT ho.*, wc.* , (CASE WHEN p.product_id != '' THEN 1 ELSE 0 END) AS available, (CASE WHEN pts.onhand_quantity > 0 THEN 1 ELSE 0 END) AS stock FROM " . DB_PREFIX . "herbal_order_product ho LEFT JOIN `" . DB_PREFIX . "weight_class_description` wc ON ho.weight_class_id = wc.weight_class_id AND wc.language_id = 1 LEFT JOIN `oc_product` p ON ho.product_id = p.product_id LEFT JOIN `oc_product_to_store` pts ON ho.product_id = pts.product_id AND pts.store_id = '" . (int) $this->config->get('config_store_id') . "'  WHERE 1 AND herbal_order_id = '" . (int) $herbal_order_id . "'";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getTotal($herbal_order_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "herbal_order_total WHERE 1 AND herbal_order_id = '" . (int) $herbal_order_id . "'";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function updateOrderStatus($order_status_id, $herbal_order_id, $remark, $shipped_status) {

        $this->db->query("UPDATE " . DB_PREFIX . "herbal_order SET order_status_id = '" . (int) $order_status_id . "', remark = '" . $this->db->escape($remark) . "', status = '1', shipped_status = '" . (int) $shipped_status . "' WHERE herbal_order_id = '" . (int) $herbal_order_id . "'");

        return $this->db->getLastId();
    }

    public function updateOrderStatusToShipped($order_status_id, $herbal_order_id, $remark) {
        $this->db->query("UPDATE " . DB_PREFIX . "herbal_order SET order_status_id = '" . (int) $order_status_id . "', remark = '" . $this->db->escape($remark) . "', shipped_status = '0' WHERE herbal_order_id = '" . (int) $herbal_order_id . "'");

        return $this->db->getLastId();
    }

    public function completeStatusForSeller($herbal_request_id, $buyer_store_id, $order_status_id) {
        $this->db->query("UPDATE " . DB_PREFIX . "herbal_order SET
                        order_status_id = '" . (int) $order_status_id . "',
                        shipped_status = '0'    
                        WHERE buyer_herbal_request_id = '" . (int) $herbal_request_id . "'
                        AND buyer_store_id = '" . (int) $buyer_store_id . "'");

        return $this->db->getLastId();
    }

    public function saveRemarkIntoSeller($herbal_order_id, $remark, $order_status_id) {
        $this->db->query("INSERT INTO " . DB_PREFIX . "herbal_order_remark SET
                                herbal_order_id = '" . (int) $herbal_order_id . "',
                                order_status_id = '" . (int) $order_status_id . "',    
                        	remark = '" . $this->db->escape($remark) . "',
                                date_added = NOW()");

        return $this->db->getLastId();
    }

    public function getHerbalOrderRemark($herbal_order_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "herbal_order_remark WHERE herbal_order_id = '" . (int) $herbal_order_id . "'";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getSingleHerbalOrderRemark($herbal_order_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "herbal_order_remark WHERE herbal_order_id = '" . (int) $herbal_order_id . "' ORDER BY date_added DESC LIMIT 1";

        $query = $this->db->query($sql);

        return $query->row;
    }

}
