<?php

class ModelAndroidBrewingProduct extends Model {

    private $is_ver20;
    private $opencart_version;

    public function get_products_list($data) {
        $data = $this->unhashed($data);
        $sql = "
			SELECT 
					p.product_id AS product_id, 
					pd.name AS product_name 
				FROM 
					`oc_product` p 
						LEFT JOIN 
							`oc_product_description` pd 
								ON p.product_id = pd.product_id AND pd.language_id = " . (int) $data->language_id . " 
				WHERE 
					1 
					AND pd.name <>'' 
			";
        if (!empty($data->search)) {
            $sql .= "
					 	OR pd.name LIKE '%" . $this->db->escape($data->search) . "%' 
					 	OR p.model LIKE '%" . $data->search . "%')
					";
        }
        $sql .= " GROUP BY p.product_id ORDER BY product_name ASC";
        if (!empty($data->pagination_entry)) {
            $sql .= " LIMIT " . $data->pagination_entry;
        } else {
            $sql .= " LIMIT 30 ";
        }
        $query = $this->db->query($sql);
        return $this->hashed($query->rows);
    }

    protected function hashed($data) {
        return base64_encode(json_encode($data));
    }

    protected function unhashed($data) {
        return json_decode(base64_decode($data));
    }

    public function addProductToHerbalRequest($data) {
        $this->db->query("UPDATE " . DB_PREFIX . "herbal_request set data = '" . $this->db->escape($data['customer_data']) . "' WHERE herbal_request_id = '" . $data['herbal_request_id'] . "'");

        return $this->db->getLastId();
    }

    public function updateProductCartToHerbalRequest($customer_data, $herbal_request_id) {
        $this->db->query("UPDATE " . DB_PREFIX . "herbal_request set data = '" . $this->db->escape($customer_data) . "' WHERE herbal_request_id = '" . $herbal_request_id . "'");

        return $this->db->getLastId();
    }
    
    public function updateHerbalRequestDetail($customer_data, $herbal_request_id, $total_value) {
        $this->db->query("UPDATE " . DB_PREFIX . "herbal_request set data = '" . $this->db->escape($customer_data) . "', total = '" . $this->db->escape($total_value) . "' WHERE herbal_request_id = '" . $herbal_request_id . "'");

        return $this->db->getLastId();
    }

    public function updateHerbalRequestData($customer_data, $herbal_request_id, $total_amount) {
        $this->db->query("UPDATE " . DB_PREFIX . "herbal_request set total = '" . $this->db->escape($total_amount) . "', data = '" . $this->db->escape($customer_data) . "' WHERE herbal_request_id = '" . $herbal_request_id . "'");

        return $this->db->getLastId();
    }

    public function getProductFromCart($herbal_request_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "herbal_request WHERE herbal_request_id = '" . $herbal_request_id . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function getDetails($herbal_request_id) {
        $sql = "SELECT data AS customer_data FROM " . DB_PREFIX . "herbal_request WHERE herbal_request_id = '" . $herbal_request_id . "'";

        $query = $this->db->query($sql);

        return !empty($query->row['customer_data']) ? $query->row['customer_data'] : [];
    }

    public function getCustomerDetails($herbal_request_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "herbal_request WHERE herbal_request_id = '" . $herbal_request_id . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function updateHerbalRequest($customer_data, $herbal_request_id) {
        $sql = "UPDATE " . DB_PREFIX . "herbal_request set data = '" . $this->db->escape($customer_data) . "' WHERE herbal_request_id = '" . $herbal_request_id . "'";

        $query = $this->db->query($sql);

        return $this->db->countAffected();
    }

}

?>