<?php

class Modelandroidbrewingcustomer extends Model {

    public function getCustomerList($data) {

        $sql = "SELECT DISTINCT c.customer_id, CONCAT(c.firstname, ' ',c.lastname) as customer_name, c.telephone, c.customer_ic,
                a.address_1, a.address_2, a.city, a.postcode, z.name AS zone_name, coun.name AS country_name,
                CONCAT(a.address_1, ' ', a.address_2, ' ', a.city, ' ', a.postcode, ' ', z.name, ' ', coun.name) AS full_address           
                FROM " . DB_PREFIX . "customer c
                LEFT JOIN " . DB_PREFIX . "address a
                ON a.address_id = c.address_id
                LEFT JOIN " . DB_PREFIX . "zone z 
                ON z.zone_id = a.zone_id
                LEFT JOIN " . DB_PREFIX . "country coun
                ON coun.country_id = a.country_id    
                WHERE 1";

        if (!empty($data['search'])) {
            $sql .= " AND (CONCAT(c.firstname, ' ',c.lastname) LIKE '%" . $this->db->escape($data['search']) . "%'
                     OR c.firstname LIKE '%" . $this->db->escape($data['search']) . "%'
                     OR c.lastname LIKE '%" . $this->db->escape($data['search']) . "%'    
                     OR c.customer_id LIKE '%" . $this->db->escape($data['search']) . "%'
                     OR c.customer_ic LIKE '%" . $this->db->escape($data['search']) . "%'    
                     OR c.telephone LIKE '%" . $this->db->escape($data['search']) . "%')
					";
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getCustomerbyAddressID($customer_id) {
        $sql = "SELECT a.address_id, a.firstname, a.telephone, a.lastname, a.company, a.address_1, a.address_2, a.address_3, a.zone_id, a.country_id, a.city, a.postcode, z.name AS zone_name, ct.name AS country_name
                FROM " . DB_PREFIX . "address a
                LEFT JOIN " . DB_PREFIX . "customer c
                ON c.customer_id = a.customer_id
                LEFT JOIN " . DB_PREFIX . "country ct
                ON ct.country_id = a.country_id
                LEFT JOIN " . DB_PREFIX . "zone z
                ON z.zone_id = a.zone_id    
                WHERE c.customer_id = '" . $customer_id . "'";

        $query = $this->db->query($sql);

        return !empty($query->row) ? $query->row : [];
    }

    public function getCustomerbyID($customer_id) {
        $sql = "SELECT customer_id, customer_ic, CONCAT(firstname, ' ',lastname) as customer_name, telephone, email FROM " . DB_PREFIX . "customer WHERE customer_id = '" . (int) $customer_id . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function addNewCustomer($data) {
        $this->db->query("INSERT INTO " . DB_PREFIX . "customer SET
                firstname = '" . $this->db->escape($data['customer_name']) . "',
                customer_ic = '" . $this->db->escape($data['customer_ic']) . "',
                telephone = '" . $this->db->escape($data['telephone']) . "',
                gender = '" . $this->db->escape($data['gender']) . "',
                date_added = NOW()    
                ");

        $customer_id = $this->db->getLastId();

        $this->db->query("INSERT INTO " . DB_PREFIX . "address SET
                customer_id = '" . (int) $customer_id . "',
                firstname = '" . $this->db->escape($data['customer_name']) . "',
                customer_ic = '" . $this->db->escape($data['customer_ic']) . "',   
                telephone = '" . $this->db->escape($data['telephone']) . "',    
                address_1 = '" . $this->db->escape($data['address_1']) . "',
                address_2 = '" . $this->db->escape($data['address_2']) . "',
                city = '" . $this->db->escape($data['city']) . "',
                postcode = '" . $this->db->escape($data['postcode']) . "',
                zone_id = '" . $this->db->escape($data['zone_id']) . "',
                country_id = '" . $this->db->escape($data['country_id']) . "'");

        $address_id = $this->db->getLastId();
        
        $this->db->query("UPDATE " . DB_PREFIX . "customer SET address_id = '" . (int) $address_id . "' WHERE customer_id = '" . (int) $customer_id . "'");
        
        return $customer_id;
    }

}
