<?php

class ModelAndroidBrewingBrewingOrder extends Controller {

    public function addBrewingOrderToSeller($data) {
        $payment_code = !empty($data['payment_method']['code']) ? $data['payment_method']['code'] : '';
        $payment_method = !empty($data['payment_method']['title']) ? $data['payment_method']['title'] : '';
        $shipping_code = !empty($data['shipping_method']['code']) ? $data['shipping_method']['code'] : '';
        $shipping_method = !empty($data['shipping_method']['title']) ? $data['shipping_method']['title'] : '';

        $invoice_prefix = $this->load->controller('setting/transaction_no_for_app/getTransactionNo', array('module' => 'herbal/herbal_order', 'store' => $data['store_id']));

        $prefix = $invoice_prefix['prefix'] . str_pad($invoice_prefix['lastrunningno2'] + 1, $invoice_prefix['length'], '0', STR_PAD_LEFT);
        
        $invoice_last_running_no = $invoice_prefix['lastrunningno2'] + 1;

        $sql = "INSERT INTO " . DB_PREFIX . "herbal_order SET
                    invoice_no = '" . (int) $invoice_last_running_no . "',    
                    invoice_prefix = '" . $this->db->escape($prefix) . "', 
                    buyer_herbal_request_id = '" . (int) $data['herbal_request_id'] . "',
                    buyer_store_id = '" . (int) $data['buyer_store']['store_id'] . "',
                    buyer_store_name = '" . $this->db->escape($data['buyer_store']['store_name']) . "',
                    buyer_store_phone = '" . (int) $data['buyer_store']['store_telephone'] . "',
                    buyer_store_email = '" . $this->db->escape($data['buyer_store']['store_email']) . "',  
                    payment_firstname = '" . $this->db->escape($data['payment_address']['name']) . "',
                    payment_lastname = '-',
                    payment_company = '" . $this->db->escape($data['payment_address']['company']) . "',
                    payment_address_1 = '" . $this->db->escape($data['payment_address']['address_1']) . "',
                    payment_address_2 = '" . $this->db->escape($data['payment_address']['address_2']) . "',
                    payment_city = '" . $this->db->escape($data['payment_address']['city']) . "',
                    payment_postcode = '" . $this->db->escape($data['payment_address']['postcode']) . "',
                    payment_country = '" . $this->db->escape($data['payment_address']['country_name']) . "',
                    payment_country_id = '" . (int) ($data['payment_address']['country_id']) . "',
                    payment_zone = '" . $this->db->escape($data['payment_address']['zone_name']) . "',
                    payment_zone_id = '" . (int) ($data['payment_address']['zone_id']) . "',
                    payment_method = '" . $payment_method . "',
                    payment_code = '" . $payment_code . "',
                    shipping_firstname = '" . $this->db->escape($data['shipping_address']['firstname']) . "',
                    shipping_lastname = '" . $this->db->escape($data['shipping_address']['lastname']) . "',
                    shipping_company = '" . $this->db->escape($data['shipping_address']['company']) . "',
                    shipping_address_1 = '" . $this->db->escape($data['shipping_address']['address_1']) . "',
                    shipping_address_2 = '" . $this->db->escape($data['shipping_address']['address_2']) . "',
                    shipping_address_3 = '" . $this->db->escape($data['shipping_address']['address_3']) . "',
                    shipping_city = '" . $this->db->escape($data['shipping_address']['city']) . "',
                    shipping_postcode = '" . $this->db->escape($data['shipping_address']['postcode']) . "',
                    shipping_country = '" . $this->db->escape($data['shipping_address']['country_name']) . "',
                    shipping_country_id = '" . (int) ($data['shipping_address']['country_id']) . "',
                    shipping_zone = '" . $this->db->escape($data['shipping_address']['zone_name']) . "',
                    shipping_zone_id = '" . (int) ($data['shipping_address']['zone_id']) . "',
                    shipping_method = '" . $shipping_method . "',
                    shipping_code = '" . $shipping_code . "',
                    brewing_type = '" . $this->db->escape($data['brewing_type']) . "',    
                    dosage = '" . $this->db->escape($data['prescription']['dosage']) . "',
                    daily_take = '" . $this->db->escape($data['prescription']['daily_take']) . "',
                    volume = '" . $this->db->escape($data['prescription']['volume']) . "',
                    remark = '" . $this->db->escape($data['remark']) . "',
                    total = '0',
                    order_status_id = '1',
                    date_added = NOW(),
                    date_modified = NOW()";

        $this->db->query($sql);

        $herbal_order_id = $this->db->getLastId();

        $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'herbal/herbal_order', 'store' => $data['store_id']));

        foreach ($data['product'] as $product_id => $product) {
            $this->db->query("INSERT INTO " . DB_PREFIX . "herbal_order_product SET 
                                herbal_order_id = '" . (int) $herbal_order_id . "',
                                product_id = '" . (int) $product['product_id'] . "',
                                name = '" . $this->db->escape($product['name']) . "',
                                model = '" . $this->db->escape($product['model']) . "',    
                                code = '" . $this->db->escape($product['code']) . "',
                                quantity = '" . $this->db->escape($product['quantity']) . "',
                                weight = '" . $this->db->escape($product['weight']) . "',
                                weight_class_id = '" . (int) $product['weight_class_id'] . "',
                                price = '" . $this->db->escape($product['price']) . "',
                                total = '" . $this->db->escape($product['total']) . "',
                                tax = '" . $this->db->escape($product['tax']) . "'");
        }

        foreach ($data['total'] as $total) {
            $this->db->query("INSERT INTO " . DB_PREFIX . "herbal_order_total SET
                                herbal_order_id = '" . (int) $herbal_order_id . "',
                                code = '" . $this->db->escape($total['code']) . "',
                                title = '" . $this->db->escape($total['title']) . "',
                                value = '" . $total['value'] . "',
                                sort_order = '" . (int) $total['sort_order'] . "'    
                    ");

            if ($total['code'] == 'total') {
                $this->db->query("UPDATE " . DB_PREFIX . "herbal_order SET total = '" . $total['value'] . "' WHERE herbal_order_id = '" . (int) $herbal_order_id . "'");
            }
        }

        return $herbal_order_id;
    }

    public function getZonefromID($zone_id) {
        $sql = "SELECT name AS zone_name FROM " . DB_PREFIX . "zone WHERE zone_id = '" . (int) $zone_id . "'";

        $query = $this->db->query($sql);

        return !empty($query->row) ? $query->row['zone_name'] : '';
    }

    public function getCountryfromID($country_name) {
        $sql = "SELECT name AS country_name FROM " . DB_PREFIX . "country WHERE country_id = '" . (int) $country_name . "'";

        $query = $this->db->query($sql);

        return !empty($query->row['country_name']) ? $query->row['country_name'] : '';
    }

    public function getAllDoctors() {
        $sql = "SELECT user_id FROM " . DB_PREFIX . "user WHERE position = '2'";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getHerbalOrderInfo($herbal_order_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "herbal_order WHERE herbal_order_id = '" . (int) $herbal_order_id . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function updateOrderStatusForSeller($herbal_request_id, $buyer_store_id) {
        $this->db->query("UPDATE " . DB_PREFIX . "herbal_order SET order_status_id = '7', status = '1' WHERE buyer_herbal_request_id = '" . (int) $herbal_request_id . "' AND buyer_store_id = '" . (int) $buyer_store_id . "'");

        $this->db->getLastId();
    }

    public function getHerbalOrderInfoByRequest($buyer_herbal_request_id, $customer_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "herbal_order WHERE buyer_herbal_request_id = '" . (int) $buyer_herbal_request_id . "' AND buyer_store_id = '" . (int) $customer_id . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

}
