<?php

class ModelAndroidBrewingBrewing extends Model {

    public function addHerbalRequestFromCustomer($data = array()) {

        $invoice_prefix = $this->load->controller('setting/transaction_no_for_app/getTransactionNo', array('module' => 'herbal/herbal_request', 'store' => $data['store_id']));

        $prefix = $invoice_prefix['prefix'] . str_pad($invoice_prefix['lastrunningno2'] + 1, $invoice_prefix['length'], '0', STR_PAD_LEFT);

        $invoice_last_running_no = $invoice_prefix['lastrunningno2'] + 1;

        $this->db->query("INSERT INTO " . DB_PREFIX . "herbal_request SET
                            store_id = '" . (int) $this->db->escape($data['store_id']) . "',
                            invoice_no = '" . $this->db->escape($invoice_last_running_no) . "',    
                            invoice_prefix = '" . $this->db->escape($prefix) . "', 
                            customer_id = '" . $this->db->escape($data['customer_id']) . "',
                            data = '" . $this->db->escape($data['customer_data']) . "',
                            order_status_id = '1',    
                            date_added = NOW(),
                            added_by = '" . $this->db->escape($data['user_id']) . "'
                         ");

        $brewing_request_id = $this->db->getLastId();

        $this->load->controller('setting/transaction_no_for_app/setTransactionNo', array('module' => 'herbal/herbal_request', 'store' => $data['store_id']));

        return $brewing_request_id;
    }

    public function getBrewingRequestHerbalList($data = array()) {

        $sql = "SELECT hr.*, c.firstname AS name FROM " . DB_PREFIX . "herbal_request hr
                LEFT JOIN " . DB_PREFIX . "customer c
                ON c.customer_id = hr.customer_id  
                WHERE 1";

        if (!empty($data['search'])) {
            $sql .= " AND (hr.herbal_request_id LIKE '%" . $this->db->escape($data['search']) . "%'
                     OR hr.invoice_prefix LIKE '%" . $this->db->escape($data['search']) . "%'  
                     OR CONCAT(c.firstname, ' ',c.lastname) LIKE '%" . $this->db->escape($data['search']) . "%'
                     OR hr.order_status_id LIKE '%" . $this->db->escape($data['search']) . "%'    
                     OR c.customer_id LIKE '%" . $this->db->escape($data['search']) . "%')
					";
        }

        $sort_data = array(
            'hr.herbal_request_id',
            'hr.invoice_prefix',
            'c.customer_id',
            'hr.order_status_id'
        );

        if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
            $sql .= " ORDER BY " . $data['sort'];
        } else {
            $sql .= " ORDER BY hr.herbal_request_id";
        }

        if (isset($data['order']) && ($data['order'] == 'ASC')) {
            $sql .= " ASC";
        } else {
            $sql .= " DESC";
        }

        if (isset($data['page']) || isset($data['show'])) {
            if ($data['page'] < 0) {
                $data['page'] = 0;
            }

            if ($data['show'] < 1) {
                $data['show'] = 30;
            }

            $sql .= " LIMIT " . (int) $data['page'] . "," . (int) $data['show'];
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getOrderStatus($order_status_id) {
        $sql = "SELECT name FROM " . DB_PREFIX . "order_status WHERE order_status_id = '" . $order_status_id . "' AND language_id = '" . (int) $this->config->get('config_language_id') . "'";

        $query = $this->db->query($sql);

        return !empty($query->row) ? $query->row['name'] : '';
    }

    public function getOrderStatuses() {
        $sql = "SELECT * FROM " . DB_PREFIX . "order_status WHERE language_id = '" . (int) $this->config->get('config_language_id') . "'";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function InsertRemarkIntoHerbalRequest($herbal_request_id, $data) {
        $this->db->query("UPDATE " . DB_PREFIX . "herbal_request SET data = '" . $this->db->escape($data['customer_data']) . "', date_modified = NOW(), modified_by = '" . $this->db->escape($data['user_id']) . "' WHERE herbal_request_id = '" . (int) $herbal_request_id . "'");

        return $this->db->getLastId();
    }

    public function getHerbalListById($herbal_request_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "herbal_request WHERE herbal_request_id = '" . $herbal_request_id . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function updateBrewingType($encoded_customer_data, $herbal_request_id) {
        $this->db->query("UPDATE " . DB_PREFIX . "herbal_request SET data = '" . $this->db->escape($encoded_customer_data) . "' WHERE herbal_request_id = '" . (int) $herbal_request_id . "'");

        return $this->db->getLastId();
    }

    public function updateAddressHerbalRequest($herbal_request_id, $customer_data) {
        $this->db->query("UPDATE " . DB_PREFIX . "herbal_request set data = '" . $this->db->escape($customer_data) . "' WHERE herbal_request_id = '" . (int) $herbal_request_id . "'");

        return $this->db->getLastId();
    }

    public function getStoreAddressforCustomer() {
        $sql = "SELECT * FROM " . DB_PREFIX . "setting WHERE key = 'config_address'";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getClinicalSale($clinical_sale_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "clinical_sale WHERE clinical_sale_id = '" . (int) $clinical_sale_id . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function getClinicalSaleProduct($clinical_sale_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "clinicalsale_product WHERE clinical_sale_id = '" . (int) $clinical_sale_id . "'";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getProductName($product_id) {
        $sql = "SELECT pd.name AS product_name FROM " . DB_PREFIX . "product p LEFT JOIN " . DB_PREFIX . "product_description pd ON p.product_id = pd.product_id AND pd.language_id = '2' WHERE p.product_id = '" . (int) $product_id . "'";

        $query = $this->db->query($sql);

        return !empty($query->row) ? $query->row['product_name'] : '';
    }

    public function addHerbalRequestFromClinicalSale($data = array()) {

        $invoice_prefix = $this->load->controller('setting/transaction_no_for_app/getTransactionNo', array('module' => 'herbal/herbal_request', 'store' => $data['store_id']));

        $prefix = $invoice_prefix['prefix'] . str_pad($invoice_prefix['lastrunningno2'] + 1, $invoice_prefix['length'], '0', STR_PAD_LEFT);

        $invoice_last_running_no = $invoice_prefix['lastrunningno2'] + 1;

        $this->db->query("INSERT INTO " . DB_PREFIX . "herbal_request SET
                            store_id = '" . (int) $data['store_id'] . "',
                            invoice_no = '" . $this->db->escape($invoice_last_running_no) . "',    
                            invoice_prefix = '" . $this->db->escape($prefix) . "',
                            clinical_sale_id = '" . (int) $data['clinical_sale_id'] . "',    
                            customer_id = '" . $this->db->escape($data['customer_id']) . "',
                            data = '" . $this->db->escape($data['customer_data']) . "',
                            order_status_id = '1',    
                            date_added = NOW(),
                            added_by = '" . $this->db->escape($data['user_id']) . "'
                         ");

        $brewing_request_id = $this->db->getLastId();

        $this->load->controller('setting/transaction_no_for_app/setTransactionNo', array('module' => 'herbal/herbal_request', 'store' => $data['store_id']));

        return $brewing_request_id;
    }

    public function getWeightClass($weight_class_id) {
        $sql = "SELECT wcd.unit as weight_class FROM " . DB_PREFIX . "weight_class wc LEFT JOIN " . DB_PREFIX . "weight_class_description wcd ON wc.weight_class_id = wcd.weight_class_id AND wcd.language_id = '" . (int) $this->config->get('config_language_id') . "' WHERE wc.weight_class_id = '" . (int) $weight_class_id . "'";

        $query = $this->db->query($sql);

        return !empty($query->row) ? $query->row['weight_class'] : '';
    }

    public function getClinicalSaleImage($clinical_sale_id) {
        $sql = "SELECT image FROM " . DB_PREFIX . "clinical_sale_image WHERE clinical_sale_id = '" . (int) $clinical_sale_id . "'";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function UpdateOrderStatus($data) {
        $this->db->query("UPDATE " . DB_PREFIX . "herbal_request SET order_status_id = '2', paid_time = NOW() WHERE herbal_request_id = '" . (int) $data['herbal_request_id'] . "'");

        return $this->db->getLastId;
    }

    public function editCustomerDetail($customer_data, $herbal_request_id, $customer_id) {
        $this->db->query("UPDATE " . DB_PREFIX . "herbal_request set customer_id = '" . (int) $customer_id . "', data = '" . $this->db->escape($customer_data) . "' WHERE herbal_request_id = '" . $herbal_request_id . "'");

        return $this->db->getLastId();
    }

    public function updateRequestStatusToCS($clinical_sale_id) {
        $this->db->query("UPDATE " . DB_PREFIX . "clinical_sale SET herbal_request_status = '1' WHERE clinical_sale_id = '" . (int) $clinical_sale_id . "'");

        return $this->db->getLastId();
    }

    public function getClinicalSaleData($clinical_sale_id) {
        $sql = "SELECT herbal_request_status FROM " . DB_PREFIX . "clinical_sale WHERE clinical_sale_id = '" . (int) $clinical_sale_id . "'";

        $query = $this->db->query($sql);

        return !empty($query->row) ? $query->row['herbal_request_status'] : 0;
    }

    public function updateHerbalRequestOrderStatus($herbal_request_id, $order_status_id) {
        $this->db->query("UPDATE " . DB_PREFIX . "herbal_request SET order_status_id = '" . (int) $order_status_id . "' WHERE herbal_request_id = '" . (int) $herbal_request_id . "'");

        return $this->db->getLastId();
    }

    public function getHerbalRequestInvoice($herbal_request_id) {
        $sql = "SELECT invoice_prefix FROM " . DB_PREFIX . "herbal_request WHERE herbal_request_id = '" . (int) $herbal_request_id . "'";

        $query = $this->db->query($sql);

        return !empty($query->row) ? $query->row['invoice_prefix'] : 0;
    }

    public function getDoctorDevice($doctor_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "user_device WHERE user_id = '" . (int) $doctor_id . "'";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function updateRequestOrderStatus($herbal_request_id, $order_status) {
        $this->db->query("UPDATE " . DB_PREFIX . "herbal_request SET order_status_id = '" . (int) $order_status . "' WHERE herbal_request_id = '" . (int) $herbal_request_id . "'");
    }

    public function updateReceivedRequestOrderStatus($herbal_request_id, $order_status) {
        $this->db->query("UPDATE " . DB_PREFIX . "herbal_request SET order_status_id = '" . (int) $order_status . "', accepted_status = '0' WHERE herbal_request_id = '" . (int) $herbal_request_id . "'");
    }

    public function updateRequestToShipped($herbal_request_id, $order_status) {
        $this->db->query("UPDATE " . DB_PREFIX . "herbal_request SET order_status_id = '" . (int) $order_status . "', accepted_status = '1' WHERE herbal_request_id = '" . (int) $herbal_request_id . "'");
    }

    public function insertHerbalRequestRemark($herbal_request_id, $order_status_id, $remark) {
        $this->db->query("INSERT INTO " . DB_PREFIX . "herbal_request_remark
                        SET herbal_request_id = '" . (int) $herbal_request_id . "',
                            order_status_id = '" . (int) $order_status_id . "',
                            remark = '" . $this->db->escape($remark) . "',
                            added_by = 0,
                            date_added = NOW()
                        ");
    }

    public function getHerbalRequestRemark($herbal_request_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "herbal_request_remark WHERE herbal_request_id = '" . (int) $herbal_request_id . "'";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getSingleHerbalRequestRemark($herbal_request_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "herbal_request_remark WHERE herbal_request_id = '" . (int) $herbal_request_id . "' ORDER BY date_added DESC LIMIT 1";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function getNotAvailableProducts($product_id) {
        $sql = "SELECT pd.name, p.product_id FROM " . DB_PREFIX . "product p
                LEFT JOIN " . DB_PREFIX . "product_description pd
                ON p.product_id = pd.product_id AND pd.language_id = '2' WHERE p.product_id = '" . (int) $product_id . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

}
