<?php

class ModelAndroidBrewingAddress extends Model {

    private $is_ver20;
    private $opencart_version;

    protected function hashed($data) {
        return base64_encode(json_encode($data));
    }

    protected function unhashed($data) {
        return json_decode(base64_decode($data));
    }

    private function check_version() {
        if (class_exists('MijoShop')) {
            $base = MijoShop::get('base');

            $installed_ms_version = (array) $base->getMijoshopVersion();
            $mijo_version = $installed_ms_version[0];
            if (version_compare($mijo_version, '3.0.0', '>=') && version_compare(VERSION, '2.0.0.0', '<')) {
                $this->opencart_version = '2.0.1.0';
            } else {
                $this->opencart_version = VERSION;
            }
        } else {
            $this->opencart_version = VERSION;
        }

        $this->is_ver20 = version_compare($this->opencart_version, '2.0.0.0', '>=');
    }

    public function get_address_by_id($data) {
        $sql = "
			SELECT 
					a.address_id, CONCAT(a.address_1,a.address_2) AS address , c.telephone, c.customer_id
				FROM 
					`oc_address` a
						LEFT JOIN 
							`oc_customer` c
								ON a.customer_id = c.customer_id 
				WHERE 
					1 
            ";

        $sql .= " GROUP BY c.customer_id ORDER BY address ASC";
        if (!empty($data['pagination_entry'])) {
            $sql .= " LIMIT " . $data['pagination_entry'];
        } else {
            $sql .= " LIMIT 30 ";
        }
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getAddress($customer_id) {
        $sql = "SELECT a.address_1, a.address_2, a.city, a.postcode, z.name AS zone_name, c.name AS country_name
                FROM " . DB_PREFIX . "address a 
                LEFT JOIN " . DB_PREFIX . "country c
                ON a.country_id = c.country_id
                LEFT JOIN " . DB_PREFIX . "zone z
                ON a.zone_id = z.zone_id    
                WHERE a.customer_id = '" . (int) $customer_id . "'
                ";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function getAddressByAddressID($address_id) {
        $sql = "SELECT a.*, z.name AS zone_name, c.name AS country_name FROM " . DB_PREFIX . "address a
                LEFT JOIN " . DB_PREFIX . "zone z
                ON z.zone_id = a.zone_id
                LEFT JOIN " . DB_PREFIX . "country c
                ON c.country_id = a.country_id    
                WHERE address_id = '" . (int) $address_id . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function getZoneByName($zone) {
        $sql = "SELECT zone_id FROM " . DB_PREFIX . "zone WHERE name = '" . $this->db->escape($zone) . "'";

        $query = $this->db->query($sql);

        return $query->row['zone_id'];
    }

    public function getCountryByName($country) {
        $sql = "SELECT country_id FROM " . DB_PREFIX . "country WHERE name = '" . $this->db->escape($country) . "'";

        $query = $this->db->query($sql);

        return $query->row['country_id'];
    }

    public function updateCustomerAddress($data) {
        $this->db->query("UPDATE " . DB_PREFIX . "address SET
                          firstname = '" . $this->db->escape($data['name']) . "',
                          lastname = '-',
                          telephone = '" . $this->db->escape($data['telephone']) . "',
                          customer_ic = '" . $this->db->escape($data['customer_ic']) . "',
                          company = '" . $this->db->escape($data['company']) . "',
                          address_1 = '" . $this->db->escape($data['address_1']) . "',
                          address_2 = '" . $this->db->escape($data['address_2']) . "',
                          address_3 = '" . $this->db->escape($data['address_3']) . "',
                          city = '" . $this->db->escape($data['city']) . "',
                          postcode = '" . $this->db->escape($data['postcode']) . "',
                          zone_id = '" . $this->db->escape($data['zone_id']) . "',
                          country_id = '" . $this->db->escape($data['country_id']) . "'
                          WHERE customer_id = '" . (int) $data['customer_id'] . "' AND address_id = '" . (int) $data['address_id'] . "'    
                            ");

        return $this->db->getLastId();
    }

    public function addCustomerAddress($data) {
        $this->db->query("INSERT INTO " . DB_PREFIX . "address SET
                          firstname = '" . $this->db->escape($data['name']) . "',
                          lastname = '-',
                          telephone = '" . $this->db->escape($data['telephone']) . "',
                          customer_ic = '" . $this->db->escape($data['customer_ic']) . "',    
                          company = '" . $this->db->escape($data['company']) . "',
                          address_1 = '" . $this->db->escape($data['address_1']) . "',
                          address_2 = '" . $this->db->escape($data['address_2']) . "',
                          address_3 = '" . $this->db->escape($data['address_3']) . "',
                          city = '" . $this->db->escape($data['city']) . "',
                          postcode = '" . $this->db->escape($data['postcode']) . "',
                          zone_id = '" . (int) $data['zone_id'] . "',
                          country_id = '" . (int) $data['country_id'] . "',
                          customer_id = '" . (int) $data['customer_id'] . "'");

        return $this->db->getLastId();
    }

    public function DeleteAddress($data) {
        $sql = "DELETE FROM " . DB_PREFIX . "address WHERE customer_id = '" . (int) $data['customer_id'] . "' AND address_id = '" . (int) $data['address_id'] . "'";

        $query = $this->db->query($sql);

        $delete_address = $this->db->countAffected();

        return $delete_address;
    }

    public function getAddressByCustomerIDAddressID($customer_id, $address_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "address WHERE customer_id = '" . (int) $customer_id . "' AND address_id = '" . (int) $address_id . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function getAddressByCustomerID($customer_id) {
        $sql = "SELECT a.address_id, a.customer_id, a.telephone, a.company, a.address_1, a.address_2, a.address_3, a.city, a.postcode, a.zone_id, a.country_id, z.name AS zone_name, c.name AS country_name, a.firstname as name, cus.email, a.customer_ic FROM " . DB_PREFIX . "address a
                LEFT JOIN " . DB_PREFIX . "zone z
                ON z.zone_id = a.zone_id
                LEFT JOIN " . DB_PREFIX . "country c
                ON c.country_id = a.country_id   
                LEFT JOIN " . DB_PREFIX . "customer cus
                ON cus.customer_id = a.customer_id    
                WHERE a.customer_id = '" . (int) $customer_id . "'";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getZonefromID($zone_id) {
        $sql = "SELECT name AS zone_name FROM " . DB_PREFIX . "zone WHERE zone_id = '" . (int) $zone_id . "'";

        $query = $this->db->query($sql);

        return $query->row['zone_name'];
    }

    public function getCountryfromID($country_name) {
        $sql = "SELECT name AS country_name FROM " . DB_PREFIX . "country WHERE country_id = '" . (int) $country_name . "'";

        $query = $this->db->query($sql);

        return $query->row['country_name'];
    }

}

?>