<?php

class ModelAndroidAppointmentAvailability extends Model
{
    public function getAllDoctors()
    {
        $sql = "SELECT user_id AS id, TRIM(CONCAT(firstname,' ',lastname)) AS name FROM " . DB_PREFIX . "user WHERE position = '2'";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getAvailabilities($data)
    {
        $sql = "SELECT a.*, TRIM(CONCAT(u.firstname, ' ', u.lastname)) AS doctor_name FROM " . DB_PREFIX . "appointment_availability a 
        LEFT JOIN " . DB_PREFIX . "user u ON (a.doctor_id = u.user_id)
        WHERE a.store_id = '" . $this->session->data['store_id'] . "'";

        if (!empty($data['day'])) {
            $sql .= " AND a.day = '" . $this->db->escape($data['day']) . "'";
        }

        if (!empty($data['doctor_id'])) {
            $sql .= " AND a.doctor_id = '" . (int)$data['doctor_id'] . "'";
        }

        $sql .= " ORDER BY
        CASE a.day
            WHEN 'Sunday' THEN 1
            WHEN 'Monday' THEN 2
            WHEN 'Tuesday' THEN 3
            WHEN 'Wednesday' THEN 4
            WHEN 'Thursday' THEN 5
            WHEN 'Friday' THEN 6
            WHEN 'Saturday' THEN 7
        END ASC ";

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 10;
            }

            $sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getAvailabilityTimes($availability_id)
    {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "appointment_availability_time WHERE availability_id = '" . $availability_id . "' ORDER BY availability_time_id ASC");

        return $query->rows;
    }

    public function getAvailabilityServices($availability_id)
    {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "availability_to_service WHERE availability_id = '" . (int)$availability_id . "'");
        return $query->rows;
    }

    public function getDoctorServices($doctor_id)
    {
        $query = $this->db->query("SELECT cs.clinicalservice_id AS id, csd.name FROM " . DB_PREFIX . "clinical_service cs LEFT JOIN " . DB_PREFIX . "clinical_service_description csd ON (cs.clinicalservice_id = csd.clinicalservice_id AND csd.language_id = '" . (int)$this->session->data['language_id'] . "') WHERE cs.doctor_id LIKE '%s:" . strlen($doctor_id) . ":\"$doctor_id\"%'");
        return $query->rows;
    }

    public function getAvailability($availability_id)
    {
        $query = $this->db->query("SELECT a.*, TRIM(CONCAT(u.firstname, ' ', u.lastname)) AS doctor_name FROM " . DB_PREFIX . "appointment_availability a 
        LEFT JOIN " . DB_PREFIX . "user u ON (a.doctor_id = u.user_id) WHERE a.availability_id = '" . (int)$availability_id . "'");

        return $query->row;
    }

    public function updateAppointmentAvailability($data)
    {
        if (empty($data['availability_id'])) {
            $existing = $this->checkDuplicate($data['day'], $data['doctor_id']);
            if (!empty($existing['availability_id'])) {
                $data['availability_id'] = $existing['availability_id'];
                $availability_id = $existing['availability_id'];
                $this->editAvailability($data);
            } else {
                $availability_id = $this->addAvailability($data);
            }
        } else {
            $availability_id = $data['availability_id'];
            $this->editAvailability($data);
        }
        return $availability_id;
    }

    public function addAvailability($data)
    {
        $availability_id = 0;
        if (!empty($data['schedule'])) {
            $sql = "INSERT INTO " . DB_PREFIX . "appointment_availability SET
            store_id='" . (int)$this->session->data['store_id'] . "',
            doctor_id='" . (int)$data['doctor_id'] . "',
            day='" . $this->db->escape($data['day']) . "',
            created_by='" . (int)$this->session->data['user_id'] . "',
            created_date=NOW(),
            lastmodified_by='" . (int)$this->session->data['user_id'] . "',
            lastmodified_date=NOW()
            ";
            $this->db->query($sql);
            $availability_id = $this->db->getLastId();
            if ($availability_id) {
                foreach ($data['schedule'] as $slot) {
                    $this->db->query("INSERT INTO " . DB_PREFIX . "appointment_availability_time SET
                    availability_id='" . (int)$availability_id . "',
                    start_time='" . $this->db->escape($slot['start_time']) . "',
                    end_time='" . $this->db->escape($slot['end_time']) . "',
                    num_app='" . (int)0 . "',
                    enable_num_app='" . (int)0 . "',
                    added_by='" . (int)$this->session->data['user_id'] . "',
                    date_added=NOW()
                    ");
                }

                if (!empty($data['services'])) {
                    foreach ($data['services'] as $service_id) {
                        $this->db->query("INSERT INTO " . DB_PREFIX . "availability_to_service SET availability_id='" . (int)$availability_id . "',
                        service_id='" . (int)$service_id . "'");
                    }
                }
            }
        }
        return $availability_id;
    }

    public function editAvailability($data)
    {
        $availability_id = $data['availability_id'];
        $sql = "UPDATE " . DB_PREFIX . "appointment_availability SET
        lastmodified_by='" . (int)$this->session->data['user_id'] . "',
        lastmodified_date=NOW()
        WHERE availability_id='" . (int)$availability_id . "'
        ";
        $this->db->query($sql);
        $this->db->query("DELETE FROM " . DB_PREFIX . "appointment_availability_time WHERE availability_id='" . (int)$availability_id . "'");
        if ($availability_id && !empty($data['schedule'])) {
            foreach ($data['schedule'] as $slot) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "appointment_availability_time SET
                availability_id='" . (int)$availability_id . "',
                start_time='" . $this->db->escape($slot['start_time']) . "',
                end_time='" . $this->db->escape($slot['end_time']) . "',
                num_app='" . (int)0 . "',
                enable_num_app='" . (int)0 . "',
                added_by='" . (int)$this->session->data['user_id'] . "',
                date_added=NOW()
                ");
            }

            $this->db->query("DELETE FROM " . DB_PREFIX . "availability_to_service WHERE availability_id='" . (int)$availability_id . "'");
            if (!empty($data['services'])) {
                foreach ($data['services'] as $service_id) {
                    $this->db->query("INSERT INTO " . DB_PREFIX . "availability_to_service SET availability_id='" . (int)$availability_id . "',
                    service_id='" . (int)$service_id . "'");
                }
            }
        }

        if ($availability_id && empty($data['schedule'])) {
            $this->db->query("DELETE FROM " . DB_PREFIX . "appointment_availability WHERE availability_id='" . (int)$availability_id . "'");
        }
    }

    public function deleteAvailability($id)
    {
        $this->db->query("DELETE FROM " . DB_PREFIX . "availability_to_service WHERE availability_id='" . (int)$id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "appointment_availability_time WHERE availability_id='" . (int)$id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "appointment_availability WHERE availability_id='" . (int)$id . "'");
    }

    private function checkDuplicate($day, $doctor_id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "appointment_availability
        WHERE day = '" . $this->db->escape($day) . "'
        AND doctor_id = '" . (int)$doctor_id . "'
        AND store_id = '" . (int)$this->session->data['store_id'] . "'
        ";
        $query = $this->db->query($sql);
        return $query->row;
    }

    /** Chew Yi Xuan */
    // To get the T&CM practitioner that have appointment availability
    public function getDoctorAvailability($data)
    {
        if (!empty($this->session->data['user_info']['viewalldata'])) {
            $filter_access_statement = '';
        } else {
            $filter_access_statement = " AND u.user_id = '" . (int)$this->session->data['user_id'] . "'";
        }

        if (isset($data['doctor_id'])) {
            $filter_doctor_statement = " AND u.user_id = '" . (int)$data['doctor_id'] . "'";
        }

        $sql = "SELECT u.user_id AS id, TRIM(CONCAT(u.firstname,' ',u.lastname)) AS name, u.* FROM `" . DB_PREFIX . "user` u INNER JOIN `" . DB_PREFIX . "appointment_availability` aa ON (aa.doctor_id = u.user_id) WHERE u.position = '2' AND u.status = 1 
        $filter_doctor_statement
        GROUP BY u.user_id";

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 10;
            }

            $sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
        }

        $query = $this->db->query($sql);
        return $query->rows;
    }

    // To get the T&CM practitioner availability days
    public function getDoctorAvailabilityDays($doctor_id)
    {
        $sql = "SELECT DISTINCT aa.day FROM `" . DB_PREFIX . "appointment_availability` aa WHERE aa.doctor_id = '" . (int)$doctor_id . "' 
        GROUP BY aa.day ";

        $query = $this->db->query($sql);
        return $query->rows;
    }
}
