<?php

class ModelAndroidAppointmentAppointment extends Model
{
    public function getList($data)
    {
        $start = $data['start'];
        $limit = $data['limit'];
        $filter_statement = '';
        if (!empty($data['doctor_id'])) {
            $filter_statement .= " AND a.doctor_id ='" . (int)$data['doctor_id'] . "'";
        }

        if (!empty($data['customer_id'])) {
            $filter_statement .= " AND a.customer_id ='" . (int)$data['customer_id'] . "'";
        }

        if (!empty($data['customer_name'])) {
            $customer_name = trim($data['customer_name']);
            $filter_statement .= " AND (TRIM(CONCAT_WS(' ',NULLIF(c.firstname,'-'),NULLIF(c.lastname,'-'))) LIKE '%" . $this->db->escape($customer_name) . "%' OR a.customer_name LIKE '%" . $this->db->escape($customer_name) . "%')";
        }

        if (!empty($data['service_id'])) {
            $filter_statement .= " AND a.clinicalservice_id ='" . (int)$data['service_id'] . "'";
        }

        if ($data['status_id'] !== false) {
            $filter_statement .= " AND a.status = '" . (int)$data['status_id'] . "'";
        }

        if (!empty($data['appointment_date_start'])) {
            $filter_statement .= " AND a.appointment_date >= '" . $data['appointment_date_start'] . "'";
        }

        if (!empty($data['appointment_date_end'])) {
            $filter_statement .= " AND a.appointment_date <= '" . $data['appointment_date_end'] . "'";
        }

        if (!empty($data['created_date_start'])) {
            $filter_statement .= " AND a.created_date >= '" . $data['created_date_start'] . "'";
        }

        if (!empty($data['created_date_end'])) {
            $filter_statement .= " AND a.created_date <= '" . $data['created_date_end'] . "'";
        }

        if (!empty($data['from_etcm'])) {
            if ($data['from_etcm'] == 'yes') {
                $filter_statement .= " AND a.from_etcm > '0'";
            } else {
                $filter_statement .= " AND a.from_etcm = '0'";
            }
        }

        //wildcard search
        if (!empty($data['keyword'])) {
            $keyword = trim($data['keyword']);
            $filter_statement .= " AND (";
            //doctor_name
            $filter_statement .= "TRIM(CONCAT(u.firstname,' ',u.lastname)) LIKE '%" . $this->db->escape($keyword) . "%'";
            //customer_name
            $filter_statement .= "OR TRIM(CONCAT_WS(' ',NULLIF(c.firstname,'-'),NULLIF(c.lastname,'-'))) LIKE '%" . $this->db->escape($keyword) . "%'";
            //service_name
            $filter_statement .= "OR csd.name LIKE '%" . $this->db->escape($keyword) . "%'";
            $filter_statement .= ")";
        }

        //access statement
        //check user data access
        if (!empty($this->session->data['user_info']['viewalldata'])) {
            $filter_access_statement = '';
        } else {
            //restricted by store id(currently logged)
            $filter_access_statement = " AND a.store_id='" . (int)$this->session->data['store_id'] . "'";

            //restricted by doctor file for doctor
            if ($this->session->data['user_info']['position'] == '2') {
                $filter_access_statement .= " AND 
                (
                a.doctor_id = '" . (int)$this->session->data['user_id'] . "' 
                OR 
                a.created_by = '" . (int)$this->session->data['user_id'] . "'
                )";
            }
        }

        $order_statement = "";

        if (!empty($data['sort'])) {
            if ($data['sort'] == 'recent') {
                $order_statement = "ORDER BY app_datetime ASC";
            } else {
                $order_statement = "ORDER BY app_datetime DESC";
            }
        } else {
            $order_statement = "ORDER BY app_datetime ASC";
        }

        $sql = "SELECT 
        a.appointment_id,
        a.appointment_date,
        a.appointment_time,
        STR_TO_DATE(CONCAT(a.appointment_date,' ',a.appointment_time),'%Y-%m-%d %h:%i %p') AS app_datetime,
        a.status,
        a.from_etcm,
        TRIM(CONCAT(u.firstname,' ',u.lastname)) AS doctor_name ,
        CASE WHEN a.customer_id = 0 THEN a.customer_name ELSE
        TRIM(CONCAT_WS(' ',NULLIF(c.firstname,'-'),NULLIF(c.lastname,'-'))) END AS customer_name,
        CASE WHEN a.clinicalservice_id = 0 THEN 'No Service' ELSE csd.name END AS service_name
        FROM " . DB_PREFIX . "appointment a
        LEFT JOIN " . DB_PREFIX . "user u ON(a.doctor_id=u.user_id)
        LEFT JOIN " . DB_PREFIX . "customer c ON(a.customer_id=c.customer_id)
        LEFT JOIN " . DB_PREFIX . "clinical_service_description csd ON(a.clinicalservice_id=csd.clinicalservice_id AND csd.language_id='" . (int)$this->session->data['language_id'] . "')
        WHERE 1 
        AND a.hide='0'
        AND a.store_id = '" . (int)$this->session->data['store_id'] . "'
        AND u.user_id IS NOT NULL
        /*AND csd.name IS NOT NULL*/
        $filter_access_statement
        $filter_statement
        $order_statement
        LIMIT $start,$limit";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getListTotal($data)
    {
        $filter_statement = '';
        if (!empty($data['doctor_id'])) {
            $filter_statement .= " AND a.doctor_id ='" . (int)$data['doctor_id'] . "'";
        }

        if (!empty($data['customer_id'])) {
            $filter_statement .= " AND a.customer_id ='" . (int)$data['customer_id'] . "'";
        }

        if (!empty($data['customer_name'])) {
            $customer_name = trim($data['customer_name']);
            $filter_statement .= " AND (TRIM(CONCAT_WS(' ',NULLIF(c.firstname,'-'),NULLIF(c.lastname,'-'))) LIKE '%" . $this->db->escape($customer_name) . "%' OR a.customer_name LIKE '%" . $this->db->escape($customer_name) . "%')";
        }

        if (!empty($data['service_id'])) {
            $filter_statement .= " AND a.clinicalservice_id ='" . (int)$data['service_id'] . "'";
        }

        if ($data['status_id'] !== false) {
            $filter_statement .= " AND a.status = '" . (int)$data['status_id'] . "'";
        }

        if (!empty($data['appointment_date_start'])) {
            $filter_statement .= " AND a.appointment_date >= '" . $data['appointment_date_start'] . "'";
        }

        if (!empty($data['appointment_date_end'])) {
            $filter_statement .= " AND a.appointment_date <= '" . $data['appointment_date_end'] . "'";
        }

        if (!empty($data['created_date_start'])) {
            $filter_statement .= " AND a.created_date >= '" . $data['created_date_start'] . "'";
        }

        if (!empty($data['created_date_end'])) {
            $filter_statement .= " AND a.created_date <= '" . $data['created_date_end'] . "'";
        }

        if (!empty($data['from_etcm'])) {
            if ($data['from_etcm'] == 'yes') {
                $filter_statement .= " AND a.from_etcm > '0'";
            } else {
                $filter_statement .= " AND a.from_etcm = '0'";
            }
        }

        //wildcard search
        if (!empty($data['keyword'])) {
            $keyword = trim($data['keyword']);
            $filter_statement .= " AND (";
            //doctor_name
            $filter_statement .= "TRIM(CONCAT(u.firstname,' ',u.lastname)) LIKE '%" . $this->db->escape($keyword) . "%'";
            //customer_name
            $filter_statement .= "OR TRIM(CONCAT_WS(' ',NULLIF(c.firstname,'-'),NULLIF(c.lastname,'-'))) LIKE '%" . $this->db->escape($keyword) . "%'";
            //service_name
            $filter_statement .= "OR csd.name LIKE '%" . $this->db->escape($keyword) . "%'";
            $filter_statement .= ")";
        }

        //access statement
        //check user data access
        if (!empty($this->session->data['user_info']['viewalldata'])) {
            $filter_access_statement = '';
        } else {
            //restricted by store id(currently logged)
            $filter_access_statement = " AND a.store_id='" . (int)$this->session->data['store_id'] . "'";

            //restricted by doctor file for doctor
            if ($this->session->data['user_info']['position'] == '2') {
                $filter_access_statement .= " AND 
                (
                a.doctor_id = '" . (int)$this->session->data['user_id'] . "' 
                OR 
                a.created_by = '" . (int)$this->session->data['user_id'] . "'
                )";
            }
        }

        $sql = "SELECT COUNT(*) AS total FROM (
            SELECT 
            a.appointment_id,
            a.appointment_date,
            a.appointment_time,
            a.status,
            TRIM(CONCAT(u.firstname,' ',u.lastname)) AS doctor_name ,
            TRIM(CONCAT_WS(' ',NULLIF(c.firstname,'-'),NULLIF(c.lastname,'-'))) AS customer_name,
            csd.name AS service_name
            FROM " . DB_PREFIX . "appointment a
            LEFT JOIN " . DB_PREFIX . "user u ON(a.doctor_id=u.user_id)
            LEFT JOIN " . DB_PREFIX . "customer c ON(a.customer_id=c.customer_id)
            LEFT JOIN " . DB_PREFIX . "clinical_service_description csd ON(a.clinicalservice_id=csd.clinicalservice_id AND csd.language_id='" . (int)$this->session->data['language_id'] . "')
            WHERE 1 
            AND a.hide='0'
            AND a.store_id = '" . (int)$this->session->data['store_id'] . "'
            AND u.user_id IS NOT NULL
            /*AND csd.name IS NOT NULL*/
            $filter_access_statement
            $filter_statement
            ORDER BY a.appointment_date
        )a
        ";
        $query = $this->db->query($sql);
        return $query->row['total'];
    }

    public function get_settings()
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "appointment_setting";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getServicesAvailable($data)
    {
        $filter_statement = '';

        // a:2:{i:0;s:3:"134";i:1;s:3:"137";}
        if (!empty($data['doctor_id'])) {
            $doctor_str = 's:' . strlen($data['doctor_id']) . ':"' . $data['doctor_id'] . '";';
            $filter_statement .= "AND doctor_id LIKE '%$doctor_str%'";
        }
        $sql = "SELECT cs.clinicalservice_id AS id, csd.name AS name, cs.cs_minute AS minute
        FROM " . DB_PREFIX . "clinical_service cs 
        LEFT JOIN " . DB_PREFIX . "clinical_service_description csd ON(cs.clinicalservice_id = csd.clinicalservice_id AND csd.language_id = '" . (int)$this->session->data['language_id'] . "') 
        WHERE doctor_id <> 'a:0:{}' 
        AND cs.clinicalservice_id IN (SELECT DISTINCT(service_id) as service_id FROM " . DB_PREFIX . "availability_to_service)
        $filter_statement
        ORDER BY csd.name
        ";

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getDoctorsAvailable($service_id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "clinical_service 
        WHERE doctor_id <> 'a:0:{}'
        AND clinicalservice_id='" . (int)$service_id . "'";
        $query = $this->db->query($sql);
        if (!empty($query->row['doctor_id'])) {
            $doctor_ids = unserialize($query->row['doctor_id']);
            $sql_docs = "SELECT user_id AS id, TRIM(CONCAT(firstname, ' ' ,lastname)) AS name
            FROM " . DB_PREFIX . "user WHERE user_id IN (" . implode(",", $doctor_ids) . ")";
            $query_docs = $this->db->query($sql_docs);
            return $query_docs->rows;
        } else {
            return $this->getDoctorsByServiceId($service_id);
        }
    }

    public function getDoctorsByServiceId($service_id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "service_to_doctor WHERE service_id ='" . (int)$service_id . "'";
        $query = $this->db->query($sql);
        $result = [];

        if (!empty($query->rows)) {
            $doctor_ids = array_column($query->rows, 'doctor_id');
            $sql_docs = "SELECT user_id AS id, TRIM(CONCAT(firstname, ' ' ,lastname)) AS name
            FROM " . DB_PREFIX . "user WHERE user_id IN (" . implode(",", $doctor_ids) . ")";
            $query_docs = $this->db->query($sql_docs);
            $result =  $query_docs->rows;
        }
        return $result;
    }

    public function getCalendarList($data)
    {
        $filter_statement = '';
        if (!empty($data['doctor_id'])) {

            $filter_statement .= " AND a.doctor_id IN (" . implode(',', $data['doctor_id']) . ")";
        }

        if (!empty($data['doctor_name'])) {
            $filter_statement .= " AND TRIM(CONCAT(u.firstname,' ',u.lastname)) LIKE '%" . $this->db->escape($data['doctor_name']) . "%'";
        }

        if (!empty($data['status_id'])) {
            $filter_statement .= " AND a.status IN (" . implode(",", $data['status_id']) . ")";
        }

        if (!empty($data['from_etcm'])) {
            if ($data['from_etcm'] == 'yes') {
                $filter_statement .= " AND a.from_etcm > '0'";
            } else {
                $filter_statement .= " AND a.from_etcm = '0'";
            }
        }

        //wildcard search
        if (!empty($data['keyword'])) {
            $keyword = trim($data['keyword']);
            $filter_statement .= " AND (";
            //doctor_name
            $filter_statement .= "TRIM(CONCAT(u.firstname,' ',u.lastname)) LIKE '%" . $this->db->escape($keyword) . "%'";
            //customer_name
            $filter_statement .= "OR TRIM(CONCAT_WS(' ',NULLIF(c.firstname,'-'),NULLIF(c.lastname,'-'))) LIKE '%" . $this->db->escape($keyword) . "%'";
            //service_name
            $filter_statement .= "OR sd.name LIKE '%" . $this->db->escape($keyword) . "%'";
            $filter_statement .= "OR a.customer_name LIKE '%" . $this->db->escape($keyword) . "%'";
            $filter_statement .= ")";
        }

        $filter_statement .= " AND a.appointment_date >= '" . $data['start_date'] . "' AND a.appointment_date <='" . $data['end_date'] . "'";

        //access statement
        //check user data access
        if (!empty($this->session->data['user_info']['viewalldata'])) {
            $filter_access_statement = '';
        } else {
            //restricted by store id(currently logged)
            $filter_access_statement = " AND a.store_id='" . (int)$this->session->data['store_id'] . "'";

            //restricted by doctor file for doctor
            if ($this->session->data['user_info']['position'] == '2') {
                $filter_access_statement .= " AND 
                (
                a.doctor_id = '" . (int)$this->session->data['user_id'] . "' 
                OR 
                a.created_by = '" . (int)$this->session->data['user_id'] . "'
                )";
            }
        }


        $sql = "SELECT a.*, 
        TRIM(CONCAT(c.firstname,' ',c.lastname)) AS customer_name2,
        TRIM(CONCAT(u.firstname,' ',u.lastname)) AS doctor_name,
        sd.name AS servicename
        FROM " . DB_PREFIX . "appointment a
        LEFT JOIN " . DB_PREFIX . "customer c ON(a.customer_id=c.customer_id)
        LEFT JOIN " . DB_PREFIX . "user u ON(a.doctor_id = u.user_id)
        LEFT JOIN " . DB_PREFIX . "clinical_service_description sd ON(a.clinicalservice_id = sd.clinicalservice_id AND sd.language_id='" . (int)$this->session->data['language_id'] . "')
        WHERE 1 
        AND a.hide='0'
        $filter_access_statement
        $filter_statement
        ORDER BY a.appointment_date";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getCalendarListTotal($data)
    {
        $filter_statement = '';
        if (!empty($data['doctor_id'])) {
            $filter_statement .= " AND a.doctor_id IN (" . implode(',', $data['doctor_id']) . ")";
        }

        if (!empty($data['doctor_name'])) {
            $filter_statement .= " AND TRIM(CONCAT(u.firstname,' ',u.lastname)) LIKE '%" . $this->db->escape($data['doctor_name']) . "%'";
        }

        if (!empty($data['status_id'])) {
            $filter_statement .= " AND a.status IN (" . implode(",", $data['status_id']) . ")";
        }

        if (!empty($data['from_etcm'])) {
            if ($data['from_etcm'] == 'yes') {
                $filter_statement .= " AND a.from_etcm > '0'";
            } else {
                $filter_statement .= " AND a.from_etcm = '0'";
            }
        }

        //wildcard search
        if (!empty($data['keyword'])) {
            $keyword = trim($data['keyword']);
            $filter_statement .= " AND (";
            //doctor_name
            $filter_statement .= "TRIM(CONCAT(u.firstname,' ',u.lastname)) LIKE '%" . $this->db->escape($keyword) . "%'";
            //customer_name
            $filter_statement .= "OR TRIM(CONCAT_WS(' ',NULLIF(c.firstname,'-'),NULLIF(c.lastname,'-'))) LIKE '%" . $this->db->escape($keyword) . "%'";
            //service_name
            $filter_statement .= "OR sd.name LIKE '%" . $this->db->escape($keyword) . "%'";
            $filter_statement .= "OR a.customer_name LIKE '%" . $this->db->escape($keyword) . "%'";
            $filter_statement .= ")";
        }

        $filter_statement .= " AND a.appointment_date >= '" . $data['start_date'] . "' AND a.appointment_date <='" . $data['end_date'] . "'";

        //access statement
        //check user data access
        if (!empty($this->session->data['user_info']['viewalldata'])) {
            $filter_access_statement = '';
        } else {
            //restricted by store id(currently logged)
            $filter_access_statement = " AND a.store_id='" . (int)$this->session->data['store_id'] . "'";

            //restricted by doctor file for doctor
            if ($this->session->data['user_info']['position'] == '2') {
                $filter_access_statement .= " AND 
                (
                a.doctor_id = '" . (int)$this->session->data['user_id'] . "' 
                OR 
                a.created_by = '" . (int)$this->session->data['user_id'] . "'
                )";
            }
        }

        $sql = "SELECT COUNT(*) AS total
        FROM " . DB_PREFIX . "appointment a
        LEFT JOIN " . DB_PREFIX . "customer c ON(a.customer_id=c.customer_id)
        LEFT JOIN " . DB_PREFIX . "user u ON(a.doctor_id = u.user_id)
        LEFT JOIN " . DB_PREFIX . "clinical_service_description sd ON(a.clinicalservice_id = sd.clinicalservice_id AND sd.language_id='" . (int)$this->session->data['language_id'] . "')
        WHERE 1 
        AND a.hide='0'
        $filter_access_statement
        $filter_statement
        ORDER BY a.appointment_date";
        $query = $this->db->query($sql);

        return $query->row['total'];
    }

    public function getAppointmentAvailabilityList($doctor_id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "appointment_availability
        WHERE doctor_id='" . (int)$doctor_id . "'
        ";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getAppointmentAvailabilityTimes($availability_id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "appointment_availability_time
        WHERE availability_id='" . (int)$availability_id . "'
        ";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function updateAppointmentAvailability($data)
    {
        $availability_id = $data['availability_id'];
        if (empty($availability_id)) {
            $availability_id = $this->addAvailability($data);
        } else {
            $this->editAvailability($data);
        }
        return $availability_id;
    }

    public function addAvailability($data)
    {
        $sql = "INSERT INTO " . DB_PREFIX . "appointment_availability SET
        store_id='" . (int)$this->session->data['store_id'] . "',
        doctor_id='" . (int)$data['doctor_id'] . "',
        minutes='" . (int)$data['minutes'] . "',
        day='" . $this->db->escape($data['day']) . "',
        created_by='" . (int)$this->session->data['user_id'] . "',
        created_date=NOW(),
        lastmodified_by='" . (int)$this->session->data['user_id'] . "',
        lastmodified_date=NOW()
        ";
        $this->db->query($sql);
        $availability_id = $this->db->getLastId();
        if ($availability_id && !empty($data['times'])) {
            foreach ($data['times'] as $slot) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "appointment_availability_time SET
                availability_id='" . (int)$availability_id . "',
                start_time='" . $this->db->query($slot['start_time']) . "',
                end_time='" . $this->db->query($slot['end_time']) . "',
                num_app='" . (int)$slot['num_app'] . "',
                enable_num_app='" . (int)$slot['enable_num_app'] . "',
                added_by='" . (int)$this->session->slot['user_id'] . "',
                date_added=NOW()
                ");
            }
        }
        return $availability_id;
    }

    public function editAvailability($data)
    {
        $availability_id = $data['availability_id'];
        $sql = "INSERT INTO " . DB_PREFIX . "appointment_availability SET
        minutes='" . (int)$data['minutes'] . "',
        lastmodified_by='" . (int)$this->session->data['user_id'] . "',
        lastmodified_date=NOW()
        WHERE availability_id='" . (int)$availability_id . "'
        ";
        $this->db->query($sql);
        $this->db->query("DELETE FROM " . DB_PREFIX . "appointment_availability_time WHERE availability_id='" . (int)$availability_id . "'");
        if ($availability_id && !empty($data['times'])) {
            foreach ($data['times'] as $slot) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "appointment_availability_time SET
                availability_id='" . (int)$availability_id . "',
                start_time='" . $this->db->query($slot['start_time']) . "',
                end_time='" . $this->db->query($slot['end_time']) . "',
                num_app='" . (int)$slot['num_app'] . "',
                enable_num_app='" . (int)$slot['enable_num_app'] . "',
                added_by='" . (int)$this->session->slot['user_id'] . "',
                date_added=NOW()
                ");
            }
        }
    }

    public function getAppointment($appointment_id)
    {
        $sql = "SELECT a.*,
        TRIM(CONCAT(u.firstname,' ',u.lastname)) AS doctor_name ,
        csd.name AS service_name,
        cs.cs_minute AS service_minute,
        cs.price AS service_price,
        CASE WHEN a.cancel_reason_id = 0 THEN a.cancel_reasons ELSE crd.name END AS cancel_reason
        FROM " . DB_PREFIX . "appointment a
        LEFT JOIN " . DB_PREFIX . "user u 
        ON(a.doctor_id=u.user_id)

        LEFT JOIN " . DB_PREFIX . "clinical_service cs 
        ON(a.clinicalservice_id=cs.clinicalservice_id)

        LEFT JOIN " . DB_PREFIX . "clinical_service_description csd
        ON(a.clinicalservice_id=csd.clinicalservice_id AND csd.language_id='" . (int)$this->session->data['language_id'] . "')

        LEFT JOIN " . DB_PREFIX . "cancel_reason_description crd
        ON(a.cancel_reason_id = crd.cancel_reason_id AND crd.language_id='" . (int)$this->session->data['language_id'] . "')

        WHERE a.appointment_id='" . (int)$appointment_id . "'";
        $query = $this->db->query($sql);
        return $query->row;
    }

    public function getCustomer($customer_id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "customer WHERE customer_id = '" . (int)$customer_id . "'";
        $query = $this->db->query($sql);
        return $query->row;
    }

    public function addAppointment($data)
    {
        $sql = "INSERT INTO " . DB_PREFIX . "appointment
		SET
			store_id = '" . (int)$this->session->data['store_id'] . "',
			customer_id = '" . (int)$data['customer_id'] . "',
			email = '" . $this->db->escape($data['email']) . "',
			telephone = '" . $this->db->escape($data['telephone']) . "',
			clinicalservice_id = '" . $data['clinicalservice_id'] . "',
			status = 0,
            from_etcm = 0,
            appointment_date = '" . $this->db->escape($data['appointment_date']) . "',
            appointment_time = '" . $this->db->escape($data['appointment_time']) . "', 
            doctor_id = '" . (int)$data['doctor_id'] . "',
            facility_id = '" . (int)$data['facility_id'] . "',
            remark = '" . $this->db->escape($data['remark']) . "', 
			new_customer = '" . (int)$data['new'] . "',
			created_by = '" . $this->session->data['user_id'] . "',
			created_date = NOW(),
			lastmodified_by = '" . $this->session->data['user_id'] . "',
			lastmodified_date = NOW()";
        $this->db->query($sql);
        $appointment_id = $this->db->getLastId();
        return $appointment_id;
    }

    public function getCancelReasons()
    {
        $sql = "SELECT crd.cancel_reason_id AS id, crd.name FROM 
        " . DB_PREFIX . "cancel_reason_description crd 
        INNER JOIN " . DB_PREFIX . "cancel_reason cr ON(crd.cancel_reason_id=cr.cancel_reason_id)
        WHERE
        cr.enable = '1'
        AND cr.module='appointment/appointment'
        AND crd.language_id = '" . (int)$this->session->data['language_id'] . "'";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getCancelReasonText($id)
    {
        $sql = "SELECT name FROM " . DB_PREFIX . "cancel_reason_description WHERE language_id = '" . (int)$this->session->data['language_id'] . "' AND cancel_reason_id = '" . (int)$id . "'";
        $query = $this->db->query($sql);
        return !empty($query->row['name']) ? $query->row['name'] : '';
    }

    public function cancelAppointment($appointment_id, $reason_id, $reason = '')
    {
        $cancel_reasons = !empty($reason) ? "cancel_reasons = '" . $this->db->escape($reason) . "', " : '';

        $sql = "UPDATE " . DB_PREFIX . "appointment SET 
        status = '2', 
        cancel_reason_id = '" . (int)$reason_id . "',
        $cancel_reasons
        lastmodified_by = '" . $this->session->data['user_id'] . "', 
        lastmodified_date = NOW() 
        WHERE appointment_id = '" . $appointment_id . "'";

        $this->db->query($sql);
        return $this->db->countAffected();
    }

    public function confirmAppointment($appointment_id)
    {
        $sql = "UPDATE " . DB_PREFIX . "appointment SET 
        status = '1', 
        lastmodified_by = '" . $this->session->data['user_id'] . "', 
        lastmodified_date = NOW() 
        WHERE appointment_id = '" . $appointment_id . "'";

        $this->db->query($sql);
        return $this->db->countAffected();
    }

    public function attendAppointment($appointment_id)
    {
        $sql = "UPDATE " . DB_PREFIX . "appointment SET 
        status = '3', 
        lastmodified_by = '" . $this->session->data['user_id'] . "', 
        lastmodified_date = NOW() 
        WHERE appointment_id = '" . (int)$appointment_id . "'";

        $this->db->query($sql);

        $this->insertOrUpdateCustomer($appointment_id);
        $affectedRow = $this->db->countAffected();

        $medical_record_id = 0;
        $service_form_id = 0;

        $sql = "SELECT * FROM " . DB_PREFIX . "appointment WHERE appointment_id = '" . (int)$appointment_id . "'";
        $query = $this->db->query($sql);
        $appInfo = $query->row;

        if (!empty($appInfo)) {
            $customer_id = $appInfo['customer_id'];
            $doctor_id = $appInfo['doctor_id'];
            $clinicalservice_id = $appInfo['clinicalservice_id'];
            $serviceInfo = $this->getServiceDetail($clinicalservice_id);
            if (!empty($serviceInfo['type'])) {
                if ($serviceInfo['type'] == 1) {
                    //create service form
                    $service_form_id = $this->createServiceForm($customer_id, $doctor_id, $serviceInfo);
                }
                if ($serviceInfo['type'] == 2) {
                    //create medical record
                    $medical_record_id = $this->createMedicalRecord($customer_id, $doctor_id);
                }
            }
        }
        $result = array(
            "affectedRow" => $affectedRow,
            "service_type" => !empty($serviceInfo['type']) ? $serviceInfo['type'] : null,
            "medical_record_id" => $medical_record_id,
            "service_form_id" => $service_form_id
        );
        return $result;
    }

    public function insertOrUpdateCustomer($appointment_id)
    {
        $app_info = $this->db->query("SELECT * FROM " . DB_PREFIX . "appointment WHERE appointment_id = '" . (int)$appointment_id . "'")->row;

        if ($app_info['customer_id'] == '0') {
            //match using ic
            if (!empty($app_info['customer_ic'])) {
                $ic = str_replace(['-', ' '], '', $app_info['customer_ic']);
                $match_active_customer = $this->db->query("SELECT * FROM " . DB_PREFIX . "customer WHERE REPLACE(REPLACE(customer_ic, ' ', ''), '-', '') = '" . $this->db->escape($ic) . "' AND status = '1' ORDER BY customer_id DESC")->row;
                if (!empty($match_active_customer)) {
                    //update app's customer_id
                    $this->db->query("UPDATE " . DB_PREFIX . "appointment SET customer_id = '" . (int)$match_active_customer['customer_id'] . "' WHERE appointment_id = '" . (int)$appointment_id . "'");
                } else {
                    //check for inactive customer
                    $match_inactive_customer = $this->db->query("SELECT * FROM " . DB_PREFIX . "customer WHERE REPLACE(REPLACE(customer_ic, ' ', ''), '-', '') = '" . $this->db->escape($ic) . "' AND status = '0' ORDER BY customer_id DESC")->row;

                    if (!empty($match_inactive_customer)) {
                        //switch customer to status
                        $this->db->query("UPDATE " . DB_PREFIX . "customer SET status = '1' WHERE customer_id = '" . (int)$match_inactive_customer['customer_id'] . "'");

                        //update app's customer_id
                        $this->db->query("UPDATE " . DB_PREFIX . "appointment SET customer_id = '" . (int)$match_inactive_customer['customer_id'] . "' WHERE appointment_id = '" . (int)$appointment_id . "'");
                    } else {
                        //create as new customer
                        $data = [
                            'store_id'      => $app_info['store_id'],
                            'customer_ic'   => $app_info['customer_ic'],
                            'firstname'     => $app_info['customer_name'],
                            'telephone1'    => $app_info['telephone'],
                            'email'         => $app_info['email']
                        ];
                        $customer_id = $this->addCustomer($data);
                        //update app's customer_id
                        $this->db->query("UPDATE " . DB_PREFIX . "appointment SET customer_id = '" . (int)$customer_id . "' WHERE appointment_id = '" . (int)$appointment_id . "'");
                    }
                }
            }
            //match using phone number
            elseif (!empty($app_info['telephone'])) {
                $phone = str_replace('+', '', $app_info['telephone']);
                $customer_id = 0;
                $active_customer = true;

                // 1.check for phone number without '+'
                /// 1.1check for active customer
                $match_active_customer = $this->db->query("SELECT * FROM " . DB_PREFIX . "customer WHERE REPLACE(telephone, '+', '') = '" . $this->db->escape($phone) . "' AND status = '1' ORDER BY customer_id DESC")->row;

                if (!empty($match_active_customer)) {
                    $customer_id = $match_active_customer['customer_id'];
                }

                if (empty($customer_id)) {
                    /// 1.2check for inactive customer
                    $match_inactive_customer = $this->db->query("SELECT * FROM " . DB_PREFIX . "customer WHERE REPLACE(telephone, '+', '') = '" . $this->db->escape($phone) . "' AND status = '0' ORDER BY customer_id DESC")->row;
                    if (!empty($match_inactive_customer)) {
                        $customer_id = $match_inactive_customer['customer_id'];
                        $active_customer = false;
                    }
                }

                //2.check for phone number start with zero(malaysia case) (017401XXXXX)
                if (substr($phone, 0, 2) == '60') {
                    $phone = ltrim($phone, '60');
                    $phone = "0" . $phone;
                }

                if (empty($customer_id)) {
                    /// 2.1check for active customer
                    $match_active_customer = $this->db->query("SELECT * FROM " . DB_PREFIX . "customer WHERE telephone = '" . $this->db->escape($phone) . "' AND status = '1' ORDER BY customer_id DESC")->row;
                    if (!empty($match_active_customer)) {
                        $customer_id = $match_active_customer['customer_id'];
                    }
                }
                if (empty($customer_id)) {
                    /// 2.2check for inactive customer
                    $match_inactive_customer = $this->db->query("SELECT * FROM " . DB_PREFIX . "customer WHERE telephone = '" . $this->db->escape($phone) . "' AND status = '0' ORDER BY customer_id DESC")->row;
                    if (!empty($match_inactive_customer)) {
                        $customer_id = $match_inactive_customer['customer_id'];
                        $active_customer = false;
                    }
                }

                //end matching
                if (!empty($customer_id)) {
                    //update app's customer_id
                    $this->db->query("UPDATE " . DB_PREFIX . "appointment SET customer_id = '" . (int)$customer_id . "' WHERE appointment_id = '" . (int)$appointment_id . "'");
                    if (!$active_customer) {
                        //switch customer to status
                        $this->db->query("UPDATE " . DB_PREFIX . "customer SET status = '1' WHERE customer_id = '" . (int)$customer_id . "'");
                    }
                } else {
                    $data = [
                        'store_id'      => $app_info['store_id'],
                        'customer_ic'   => $app_info['customer_ic'],
                        'firstname'     => $app_info['customer_name'],
                        'telephone1'    => $app_info['telephone'],
                        'email'         => $app_info['email']
                    ];
                    $customer_id = $this->addCustomer($data);
                    //update app's customer_id
                    $this->db->query("UPDATE " . DB_PREFIX . "appointment SET customer_id = '" . (int)$customer_id . "' WHERE appointment_id = '" . (int)$appointment_id . "'");
                }
            }
        }
    }

    public function addCustomer($data)
    {
        do {
            $insert_customer = false;
            $unique_id = md5(rand() . $data['customer_ic'] . time());
            $customer_row = $this->check_unique_id($unique_id);
            $this->load->model('setting/setting');

            $customer_card_no = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'sale/customer', 'store' => $data['store_id']));

            if (empty($data['customer_card'])) {
                $customer_card = $customer_card_no;
                $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'sale/customer', 'store' => $data['store_id']));
            } else {
                $customer_card = $data['customer_card'];
            }

            if (empty($customer_row)) {
                $insert_customer = true;
                $this->db->query("
					INSERT INTO " . DB_PREFIX . "customer SET
						unique_customer_id = '" . $this->db->escape($unique_id) . "',
						customer_card = '" . $this->db->escape($customer_card) . "',
						customer_ic = '" . $this->db->escape($data['customer_ic']) . "',
						firstname = '" . $this->db->escape($data['firstname']) . "',
						email = '" . $this->db->escape($data['email']) . "',
						telephone = '" . $this->db->escape($data['telephone1']) . "',
						salt = '" . $this->db->escape($salt = substr(md5(uniqid(rand(), true)), 0, 9)) . "',
						password = '" . $this->db->escape(sha1($salt . sha1($salt . sha1('')))) . "',
						status = '1',
						approved = '1',
						safe = '1',
						date_added = NOW()
				");
            }
        } while ($insert_customer == false);
        $customer_id = $this->db->getLastId();
        return $customer_id;
    }

    private function check_unique_id($unique_id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "customer WHERE unique_customer_id = '" . $this->db->escape($unique_id) . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function getServiceDetail($clinicalservice_id)
    {
        $sql = "SELECT 
        c.*,
        cd.name
        FROM 
        " . DB_PREFIX . "clinical_service c
        LEFT JOIN " . DB_PREFIX . "clinical_service_description cd ON(c.clinicalservice_id=cd.clinicalservice_id AND cd.language_id='" . (int)$this->session->data['language_id'] . "')
        WHERE 1
        
        AND c.clinicalservice_id = '" . (int)$clinicalservice_id . "'";
        $query = $this->db->query($sql);
        return $query->row;
    }

    public function createMedicalRecord($customer_id, $doctor_id)
    {
        $this->load->model('setting/setting');
        $invoice_prefix = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'herbal/herbal', 'store' => $this->session->data['store_id']));

        $sql_cs = "INSERT INTO " . DB_PREFIX . "clinical_sale SET
        customer_id = '" . (int) $customer_id . "',
        doctor_id = '" . (int) $doctor_id . "',
        invoice_prefix ='" . $this->db->escape($invoice_prefix) . "',
        saved = '1',
        sales_date = NOW(),
        store_id = '" . (int) $this->session->data['store_id'] . "',
        clinicalsale_action = '" . (int) 1 . "',
        order_action = '" . (int) 17 . "',
        add_by = '" . (int) $this->session->data['user_id'] . "',
        date_added = NOW(),
        modifi_by = '" . (int) $this->session->data['user_id'] . "',
        date_modified = NOW()";
        $this->db->query($sql_cs);

        $medical_record_id = $this->db->getLastId();

        if ($medical_record_id != 0) {
            $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'herbal/herbal', 'store' => $this->session->data['store_id']));
        }
        return $medical_record_id;
    }

    public function createServiceForm($customer_id, $doctor_id, $service_info)
    {
        $this->load->model('setting/setting');
        $invoice_prefix = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'service/service_form', 'store' => $this->session->data['store_id']));

        $sql = "INSERT INTO " . DB_PREFIX . "service_form SET
            customer_id ='" . (int) $customer_id . "',
            user_id ='" . (int) $doctor_id . "',
            invoice_prefix ='" . $this->db->escape($invoice_prefix) . "',
            store_id = '" . (int) $this->session->data['store_id'] . "',
            serviceform_action='" . (int) 1 . "',
            order_action = '" . (int) 17 . "',
            service_date = NOW(),
            add_by = '" . (int) $this->session->data['user_id'] . "',
            date_added = NOW(),
            modifi_by = '" . (int) $this->session->data['user_id'] . "',
            date_modified = NOW()";
        $this->db->query($sql);

        $service_form_id = $this->db->getLastId();

        if ($service_form_id != 0) {
            $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'service/service_form', 'store' => $this->session->data['store_id']));
        }

        if (!empty($service_info)) {
            $sql = "INSERT INTO " . DB_PREFIX . "service_item SET
                        service_form_id = '" . (int) $service_form_id . "',
                        clinicalservice_id = '" . (int) $service_info['clinicalservice_id'] . "',
                        servicename ='" . $this->db->escape($service_info['name']) . "',
                        serviceminutes = '" . $this->db->escape($service_info['cs_minute']) . "',
                        user_id = '" . (int)$doctor_id . "',
                        price = '" . (float)$service_info['price'] . "',
                        tax_class_id = '" . (int)$service_info['tax_class_id'] . "',
                        modifi_by = '" . (int)$this->session->data['user_id'] . "',
                        date_modified = NOW()";

            $this->db->query($sql);
        }

        return $service_form_id;
    }

    public function deleteAppointment($appointment_id)
    {
        $sql = "UPDATE " . DB_PREFIX . "appointment SET 
        hide = '1', 
        lastmodified_by = '" . $this->session->data['user_id'] . "', 
        lastmodified_date = NOW() 
        WHERE appointment_id = '" . $appointment_id . "'";

        $this->db->query($sql);
        return $this->db->countAffected();
    }

    public function editAppointment($appointment_id, $data)
    {
        $sql = "UPDATE " . DB_PREFIX . "appointment SET 
        store_id = '" . (int)$this->session->data['store_id'] . "', 
        customer_id = '" . (int)$data['customer_id'] . "', 
        email = '" . $this->db->escape($data['email']) . "', 
        telephone = '" . $this->db->escape($data['telephone']) . "', 
        clinicalservice_id = '" . $data['clinicalservice_id'] . "', 
        appointment_date = '" . $this->db->escape($data['appointment_date']) . "',
        appointment_time = '" . $this->db->escape($data['appointment_time']) . "', 
        doctor_id = '" . (int)$data['doctor_id'] . "', 
        facility_id = '" . (int)$data['facility_id'] . "', 
        remark = '" . $this->db->escape($data['remark']) . "', 
        lastmodified_by = '" . $this->session->data['user_id'] . "', 
        lastmodified_date = NOW() 
        WHERE appointment_id = '" . $appointment_id . "'";

        $this->db->query($sql);

        // $this->db->query("UPDATE " . DB_PREFIX . "appointment_emergency SET appointment_newdate = '" . $this->db->escape($data['date']) . "', appointment_newtime = '" . $this->db->escape($data['time']) . "', doctor_id = " . $doctor . ", emergency_status = 1 WHERE appointment_id = '" . $appointment_id . "' AND emergency_status != 1");

        return $this->db->countAffected();
    }

    public function getTimes($store_id, $date, $doctor_id)
    {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "appointment_availability aa LEFT JOIN " . DB_PREFIX . "appointment_availability_time aat ON aat.availability_id = aa.availability_id WHERE aa.store_id = '" . (int)$store_id . "' AND aa.day = '" . $this->db->escape($date) . "' AND aa.doctor_id = '" . (int)$doctor_id . "' ORDER BY aat.availability_time_id ASC");

        return $query->rows;
    }

    public function checkUserHoliday($doctor_id)
    {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "user_holiday WHERE store_id = '" . $this->session->data['store_id'] . "' AND user_id = '" . (int)$doctor_id . "'");

        return $query->rows;
    }

    public function checkStoreHoliday($store_id)
    {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "store_holiday WHERE store_id = '" . $store_id . "'");

        return $query->rows;
    }

    public function getDoctorAvailabilityTime($doctor_id, $service_id, $day)
    {
        $sql = "
		SELECT
			aa.doctor_id,
			aa.day,
			aa.minutes,
			aat.start_time,
			aat.end_time
		FROM " . DB_PREFIX . "appointment_availability aa
		INNER JOIN " . DB_PREFIX . "appointment_availability_time aat
		ON aat.availability_id = aa.availability_id
        INNER JOIN " . DB_PREFIX . "availability_to_service ats ON (aa.availability_id = ats.availability_id)
		WHERE 1
		AND aa.doctor_id = '" . (int)$doctor_id . "'
		AND aa.day = '" . $this->db->escape($day) . "'
        AND aa.store_id = '" . (int)$this->session->data['store_id'] . "'
        AND ats.service_id = '" . (int)$service_id . "'
		ORDER BY aat.availability_time_id ASC";

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getDoctorAvailabilityStatus($doctor_id, $service_id = 0)
    {
        $sql = "
		SELECT COUNT(*) as total
		FROM " . DB_PREFIX . "appointment_availability aa
		INNER JOIN " . DB_PREFIX . "appointment_availability_time aat
		ON aat.availability_id = aa.availability_id
		WHERE 1
		AND aa.doctor_id = '" . (int)$doctor_id . "'
        AND aa.store_id = '" . (int)$this->session->data['store_id'] . "'
		ORDER BY aat.availability_time_id ASC";
        if (!empty($service_id)) {
            $sql = "
            SELECT COUNT(*) as total
            FROM " . DB_PREFIX . "appointment_availability aa
            INNER JOIN " . DB_PREFIX . "appointment_availability_time aat
            ON aat.availability_id = aa.availability_id
            LEFT JOIN " . DB_PREFIX . "availability_to_service ats ON(aa.availability_id = ats.availability_id)
            WHERE 1
            AND aa.doctor_id = '" . (int)$doctor_id . "'
            AND aa.store_id = '" . (int)$this->session->data['store_id'] . "'
            AND ats.service_id = '" . (int)$service_id . "'
            ORDER BY aat.availability_time_id ASC";
        }

        $query = $this->db->query($sql);
        return !empty($query->row['total']) ? (int)$query->row['total'] : 0;
    }

    public function checkBooked($doctor_id, $date, $time, $appointment_id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "appointment
				WHERE doctor_id = '" . (int)$doctor_id . "'
				AND appointment_date = '" . $this->db->escape($date) . "'
				AND appointment_time = '" . $this->db->escape($time) . "'
				AND status != '2'";
        if (!empty($appointment_id)) {
            $sql .= " AND appointment_id <> '" . (int)$appointment_id . "'";
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getServiceFacilities($service_id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "service_to_facility WHERE service_id = '" . (int)$service_id . "'
        AND facility_id IN (SELECT facility_id FROM " . DB_PREFIX . "facility WHERE status = '1')";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getFacilitiesDetail($facility_id)
    {
        $facility_info = $this->db->query("SELECT * FROM " . DB_PREFIX . "facility WHERE facility_id = '" . (int)$facility_id . "'")->row;
        if (!empty($facility_info)) {
            $availabilities = $this->db->query("SELECT * FROM " . DB_PREFIX . "facility_availability WHERE facility_id = '" . (int)$facility_id . "'")->rows;
            $facility_info['availabilities'] = $availabilities;
        }
        return $facility_info;
    }
}
