<?php
class ControllerWkWhatsappWkSms extends Controller {
    public function index(&$route, &$args) {
		if (isset($args[0])) {
			$order_id = $args[0];
		} else {
			$order_id = 0;
		}

		if (isset($args[1])) {
			$order_status_id = $args[1];
		} else {
			$order_status_id = 0;
		}

		if (isset($args[2])) {
			$comment = $args[2];
		} else {
			$comment = '';
		}

		if (isset($args[3])) {
			$notify = $args[3];
		} else {
			$notify = '';
		}

		// We need to grab the old order status ID
        $this->load->model('checkout/order');
		$order_info = $this->model_checkout_order->getOrder($order_id);

		if ($order_info && $this->config->get('module_wk_whatsapp_notification_status')) {
			// If order status is 0 then becomes greater than 0 send main html email
			if (!$order_info['order_status_id'] && $order_status_id) {
				$this->orderAddSms($order_info, $order_status_id, $comment, $notify);
			}

			// If order status is not 0 then send update text email
			if ($order_info['order_status_id'] && $order_status_id && $notify) {
				$this->edit($order_info, $order_status_id, $comment, $notify);
			}
		}
	}
public function orderAddSms($order_info, $order_status_id, $comment, $notify) {
    $this->load->language('mail/order_add');
    $this->load->model('wk_whatsapp/wk_whatsapp');
    $this->load->model('checkout/order');
    $orderLoop = $this->getOrdersDetails($order_info, $order_info['order_id'],$order_status_id);
    $replace = array();
    $order_total = 0;
    $order_sub_total = 0;
    $order_totals = $this->model_checkout_order->getOrderTotals($order_info['order_id']);
	if(!empty($order_totals)) {
		foreach ($order_totals as $key) {
            if($key['code'] == 'sub_total') {
                $order_sub_total = html_entity_decode($this->currency->format($key['value'], $order_info['currency_code'], $order_info['currency_value']), ENT_NOQUOTES, 'UTF-8');
            }
			if($key['code'] == 'total') {
				$order_total =  html_entity_decode($this->currency->format($key['value'], $order_info['currency_code'], $order_info['currency_value']), ENT_NOQUOTES, 'UTF-8');
		    }
		}
	}
    $order_product_name = '';
    $order_product_model = '';
    $order_product_quantity = '';
    // $order_product_price = 0;
    $i = 0;
	if(!empty($orderLoop['products'])){
        foreach ($orderLoop['products'] as $key) {
            if($i == 0){
                $order_product_name .= $key['name'];
                $order_product_model .= $key['model'];
                $order_product_quantity .= $key['quantity'];
                // $order_product_price = $key['price']';
                $i++;
            }
            else{
                $order_product_name .= ' , '.$key['name'];
                $order_product_model .= ' , '.$key['model'];
                $order_product_quantity .= ' , '.$key['quantity'];
                // $order_product_price = ' , '.$key['price'];
            }
        }
    }
    $replace['config_name'] = $this->config->get('config_name');
    $replace['order_url'] =  $this->url->link('account/order/info', 'order_id=' . $order_info['order_id'], true);
    $replace['config_owner'] = $this->config->get('config_owner');
    $replace['config_address'] = $this->config->get('config_address');
    $replace['config_geocode'] = $this->config->get('config_geocode');
    $replace['config_currency'] = $this->config->get('config_currency');
    $replace['config_email'] = $this->config->get('config_email');
    $replace['config_telephone'] = $this->config->get('config_telephone');
    $replace['customer_name']	= $order_info['firstname'] . ' ' .$order_info['lastname'];
    $replace['order_product']	= $order_product_name;
    $replace['order_product_model']	= $order_product_model;
    $replace['order_product_quantity']	= $order_product_quantity;
    $replace['order_product_price']	= $order_sub_total;
    $replace['order_total']	= $order_total;
    
    $order_status_query = $this->model_wk_whatsapp_wk_whatsapp->getOrderStatus($order_status_id);
    
    if($comment){	
        $replace['order_status_change_comment'] = $this->language->get('wk_order_comment').' : '.$comment;	
    }	
    else{	
        $replace['order_status_change_comment'] = '';	
    }
    $replace['order_status']	= isset($order_status_query->row['name']) ?  $order_status_query->row['name'] : '';
    $replace['store_url']       = $this->url->link('account/login');

    if(isset($order_info['order_id'])) {
        $replace['order_id']	 = $order_info['order_id'];
    }
    $replace['order_link']   = $this->url->link('account/order/info','order_id='.$order_info['order_id'], true);
    $replace['order_detail'] = $this->getOrderDetail($order_info, $order_info['order_id'],$order_status_id);

    $message_language = isset($this->config->get('module_wk_whatsapp_notification_order_template')[$order_info['language_id']]) ? $this->config->get('module_wk_whatsapp_notification_order_template')[$order_info['language_id']] : $this->config->get('module_wk_whatsapp_notification_order_template')[$this->model_wk_whatsapp_wk_whatsapp->getLanguage($this->session->data['language'])];	
    if(!$message_language){	
        $message_language = $this->config->get('module_wk_whatsapp_notification_order_template')[$this->model_wk_whatsapp_wk_whatsapp->getLanguage($this->session->data['language'])];	
    }	
    if(!$message_language){	
        $message_language = $this->config->get('module_wk_whatsapp_notification_order_template')[$this->model_wk_whatsapp_wk_whatsapp->getLanguage($this->config->get('config_language'))];	
    }	
    $rec = $this->model_wk_whatsapp_wk_whatsapp->getRecord($message_language);

    if($this->config->get('module_wk_whatsapp_notification_setting') && is_array($this->config->get('module_wk_whatsapp_notification_setting')) ) {
        $allow = $this->config->get('module_wk_whatsapp_notification_setting');
    } else {
        $allow =  array();
    }

    $find = array();
    foreach ($replace as $key => $value) {
        $find[$key] = '{'.trim($key).'}';
    }
            
    if(isset($rec['message']) && $rec['message'] && in_array('order', $allow)) {
        $message = trim(str_ireplace($find, $replace,  $rec['message']));
        $this->load->model('localisation/country');
        $country =  $this->model_localisation_country->getCountry($order_info['payment_country_id']);
        
        if(file_exists(DIR_APPLICATION . '../vendor/autoload.php')) {
            $this->load->library('wkwhatsapp');
            $this->wkwhatsapp->sendMsg(strip_tags($message), $this->phone($country['iso_code_2']).$order_info['telephone']);
        }
    }
}
public function edit($order_info, $order_status_id, $comment) {
    $this->load->model('wk_whatsapp/wk_whatsapp');
    $this->load->language('mail/order_add');
    $replace = array();
    $replace['config_logo'] = '<a href="'.HTTP_SERVER.'" title="'.$this->config->get('config_name').'"><img src="'.HTTP_SERVER.'image/' . $this->config->get('config_logo').'" alt="'.$this->config->get('config_name').'" /></a>';
    $replace['config_icon'] = '<img src="'.HTTP_SERVER.'image/' . $this->config->get('config_icon').'">';
    $replace['config_image'] = '<img src="'.HTTP_SERVER.'image/' . $this->config->get('config_image').'">';
    $replace['config_name'] = $this->config->get('config_name');
    $replace['config_owner'] = $this->config->get('config_owner');
    $replace['config_address'] = $this->config->get('config_address');
    $replace['config_geocode'] = $this->config->get('config_geocode');
    $replace['config_currency'] = $this->config->get('config_currency');
    $replace['config_email'] = $this->config->get('config_email');
    $replace['config_telephone'] = $this->config->get('config_telephone');
    $replace['customer_name']	= $order_info['firstname'] . ' ' .$order_info['lastname'];
    
    $order_status_query = $this->model_wk_whatsapp_wk_whatsapp->getOrderStatus($order_status_id);
    
    if($comment){
        $replace['order_status_change_comment'] = $this->language->get('wk_order_comment').' : '.$comment;
    }
    else{
        $replace['order_status_change_comment'] = '';
    }
    $replace['order_status']	= isset($order_status_query->row['name']) ?  $order_status_query->row['name'] : '';
    $replace['order_link']   = $this->url->link('account/order/info','order_id='.$order_info['order_id'], true);

    $replace['order_url'] =  $this->url->link('account/order/info', 'order_id=' . $order_info['order_id'], true);

    if(isset($order_info['order_id'])) {
        $replace['order_id']	 = $order_info['order_id'];
    }
    $replace['store_url']       = $this->url->link('account/login');
    $replace['order_detail'] = $this->getOrderDetail($order_info, $order_info['order_id'],$order_status_id);
    $find = array();
    foreach ($replace as $key => $value) {
        $find[$key] = '{'.trim($key).'}';
    }
    $message_language = isset($this->config->get('module_wk_whatsapp_notification_order_edit_template')[$order_info['language_id']]) ? $this->config->get('module_wk_whatsapp_notification_order_edit_template')[$order_info['language_id']] : $this->config->get('module_wk_whatsapp_notification_order_edit_template')[$this->model_wk_whatsapp_wk_whatsapp->getLanguage($this->session->data['language'])];
    if(!$message_language && isset($this->session->data['language'])){
        $message_language = $this->config->get('module_wk_whatsapp_notification_order_edit_template')[$this->model_wk_whatsapp_wk_whatsapp->getLanguage($this->session->data['language'])];
    }
    if(!$message_language){
        $message_language = $this->config->get('module_wk_whatsapp_notification_order_edit_template')[$this->model_wk_whatsapp_wk_whatsapp->getLanguage($this->config->get('config_language'))];
    }
    $rec = $this->model_wk_whatsapp_wk_whatsapp->getRecord($message_language);

    if($this->config->get('module_wk_whatsapp_notification_setting') && is_array($this->config->get('module_wk_whatsapp_notification_setting')) ) {
        $allow = $this->config->get('module_wk_whatsapp_notification_setting');
    } else {
        $allow =  array();
    }
    if(isset($rec['message']) && $rec['message'] && in_array('order', $allow)) {

        $message = trim(str_ireplace($find, $replace,  $rec['message']));

        $this->load->model('localisation/country');
        $country =  $this->model_localisation_country->getCountry($order_info['payment_country_id']);
        if(file_exists(DIR_APPLICATION . '../vendor/autoload.php')) {
        $this->load->library('wkwhatsapp');
        $this->wkwhatsapp->sendMsg(strip_tags($message), $this->phone($country['iso_code_2']).$order_info['telephone']);
        }

    }
}

public function getOrdersDetails($order_info,$order_id, $order_status_id) {
    $data =  array();
    $this->load->model('wk_whatsapp/wk_whatsapp');
    
    $order_status_query = $this->model_wk_whatsapp_wk_whatsapp->getOrderStatus($order_status_id);

    if ($order_status_query->num_rows) {
        $data['order_status'] = $order_status_query->row['name'];
    } else {
        $data['order_status'] = '';
    }

    $this->load->model('tool/upload');
    $this->load->model('checkout/order');
    
    $data['products'] = array();

    $order_products = $this->model_checkout_order->getOrderProducts($order_id);

    foreach ($order_products as $order_product) {
        $option_data = array();
        
        $order_options = $this->model_checkout_order->getOrderOptions($order_info['order_id'], $order_product['order_product_id']);
        
        foreach ($order_options as $order_option) {
            if ($order_option['type'] != 'file') {
                $value = $order_option['value'];
            } else {
                $upload_info = $this->model_tool_upload->getUploadByCode($order_option['value']);

                if ($upload_info) {
                    $value = $upload_info['name'];
                } else {
                    $value = '';
                }
            }

            $option_data[] = array(
                'name'  => $order_option['name'],
                'value' => (utf8_strlen($value) > 20 ? utf8_substr($value, 0, 20) . '..' : $value)
            );					
        }
      
        $data['products'][] = array(
            'name'     => $order_product['name'],
            'model'    => $order_product['model'],
            'quantity' => $order_product['quantity'],
            'option'   => $option_data,
            'url'      => $this->url->link('product/product', 'product_id=' . $order_product['product_id'], true),
            'price'   => $this->currency->format($order_product['price'], $order_info['currency_code'], $order_info['currency_value']),
            'total'    => html_entity_decode($this->currency->format($order_product['total'] + ($this->config->get('config_tax') ? ($order_product['tax'] * $order_product['quantity']) : 0), $order_info['currency_code'], $order_info['currency_value']), ENT_NOQUOTES, 'UTF-8')
        );
    }
    
    $data['vouchers'] = array();
    
    $order_vouchers = $this->model_checkout_order->getOrderVouchers($order_id);

    foreach ($order_vouchers as $order_voucher) {
        $data['vouchers'][] = array(
            'description' => $order_voucher['description'],
            'amount'      => html_entity_decode($this->currency->format($order_voucher['amount'], $order_info['currency_code'], $order_info['currency_value']), ENT_NOQUOTES, 'UTF-8')
        );					
    }

    $data['totals'] = array();
    
    $order_totals = $this->model_checkout_order->getOrderTotals($order_id);

    foreach ($order_totals as $order_total) {
        $data['totals'][] = array(
            'title' => $order_total['title'],
            'value' => html_entity_decode($this->currency->format($order_total['value'], $order_info['currency_code'], $order_info['currency_value']), ENT_NOQUOTES, 'UTF-8')
        );
    }

    return $data;

}

public function getOrderDetail($order_info,$order_id, $order_status_id) {
    $data =  array();
    $this->load->model('wk_whatsapp/wk_whatsapp');
    
    $order_status_query = $this->model_wk_whatsapp_wk_whatsapp->getOrderStatus($order_status_id);

    if ($order_status_query->num_rows) {
        $data['order_status'] = $order_status_query->row['name'];
    } else {
        $data['order_status'] = '';
    }

    $this->load->model('tool/upload');
    $this->load->model('checkout/order');

    $data['products'] = array();

    $order_products = $this->model_checkout_order->getOrderProducts($order_id);

    foreach ($order_products as $order_product) {
        $option_data = array();

        $order_options = $this->model_checkout_order->getOrderOptions($order_info['order_id'], $order_product['order_product_id']);

        foreach ($order_options as $order_option) {
            if ($order_option['type'] != 'file') {
                $value = $order_option['value'];
            } else {
                $upload_info = $this->model_tool_upload->getUploadByCode($order_option['value']);

                if ($upload_info) {
                    $value = $upload_info['name'];
                } else {
                    $value = '';
                }
            }

            $option_data[] = array(
                'name'  => $order_option['name'],
                'value' => (utf8_strlen($value) > 20 ? utf8_substr($value, 0, 20) . '..' : $value)
            );
        }

        $data['products'][] = array(
            'name'     => $order_product['name'],
            'model'    => $order_product['model'],
            'quantity' => $order_product['quantity'],
            'option'   => $option_data,
            'url'      => $this->url->link('product/product', 'product_id=' . $order_product['product_id'], true),
            'price'   => $this->currency->format($order_product['price'], $order_info['currency_code'], $order_info['currency_value']),
            'total'    => html_entity_decode($this->currency->format($order_product['total'] + ($this->config->get('config_tax') ? ($order_product['tax'] * $order_product['quantity']) : 0), $order_info['currency_code'], $order_info['currency_value']), ENT_NOQUOTES, 'UTF-8')
        );
    }

    $data['vouchers'] = array();

    $order_vouchers = $this->model_checkout_order->getOrderVouchers($order_id);

    foreach ($order_vouchers as $order_voucher) {
        $data['vouchers'][] = array(
            'description' => $order_voucher['description'],
            'amount'      => html_entity_decode($this->currency->format($order_voucher['amount'], $order_info['currency_code'], $order_info['currency_value']), ENT_NOQUOTES, 'UTF-8')
        );
    }

    $data['totals'] = array();

    $order_totals = $this->model_checkout_order->getOrderTotals($order_id);

    foreach ($order_totals as $order_total) {
        $data['totals'][] = array(
            'title' => $order_total['title'],
            'value' => html_entity_decode($this->currency->format($order_total['value'], $order_info['currency_code'], $order_info['currency_value']), ENT_NOQUOTES, 'UTF-8')
        );
    }

    return $this->load->view('wk_whatsapp/order_detail',$data);

}

public  function register(&$route, &$args, &$output) {
    $this->load->model('wk_whatsapp/wk_whatsapp');
   if(isset($args[0]) && isset($args[0]['firstname']) && $this->config->get('module_wk_whatsapp_notification_status')) {
    $replace = array();

    $replace['config_name'] = $this->config->get('config_name');
    $replace['config_owner'] = $this->config->get('config_owner');
    $replace['config_address'] = $this->config->get('config_address');
    $replace['config_geocode'] = $this->config->get('config_geocode');
    $replace['config_currency'] = $this->config->get('config_currency');
    $replace['config_email'] = $this->config->get('config_email');
    $replace['config_telephone'] = $this->config->get('config_telephone');
    $replace['store_url']       = $this->url->link('account/login');
    $replace['customer_name']	= trim($args[0]['firstname']) . ' ' .trim($args[0]['lastname']);
    if (isset($args[0]['customer_group_id']) && is_array($this->config->get('config_customer_group_display')) && in_array($args[0]['customer_group_id'], $this->config->get('config_customer_group_display'))) {
        $customer_group_id = $args[0]['customer_group_id'];
    } else {
        $customer_group_id = $this->config->get('config_customer_group_id');
    }
    $replace['order_detail'] = '';
    $replace['order_link'] = '';
    $replace['order_status'] = '';

    $this->load->model('account/customer_group');

    $customer_group_info = $this->model_account_customer_group->getCustomerGroup($customer_group_id);

    $find = array();
    foreach ($replace as $key => $value) {
        $find[$key] = '{'.trim($key).'}';
    }
    $message_language = isset($this->config->get('module_wk_whatsapp_notification_registration_template')[$this->model_wk_whatsapp_wk_whatsapp->getLanguage($this->session->data['language'])]) ? $this->config->get('module_wk_whatsapp_notification_registration_template')[$this->model_wk_whatsapp_wk_whatsapp->getLanguage($this->session->data['language'])] : $this->config->get('module_wk_whatsapp_notification_registration_template')[$this->model_wk_whatsapp_wk_whatsapp->getLanguage($this->session->data['language'])];
    if(!$message_language){
        $message_language = $this->config->get('module_wk_whatsapp_notification_registration_template')[$this->model_wk_whatsapp_wk_whatsapp->getLanguage($this->session->data['language'])];
    }
    if(!$message_language){
        $message_language = $this->config->get('module_wk_whatsapp_notification_registration_template')[$this->model_wk_whatsapp_wk_whatsapp->getLanguage($this->config->get('config_language'))];
    }
    
    $rec = $this->model_wk_whatsapp_wk_whatsapp->getRecord($message_language);

    if($this->config->get('module_wk_whatsapp_notification_setting') && is_array($this->config->get('module_wk_whatsapp_notification_setting')) ) {
        $allow = $this->config->get('module_wk_whatsapp_notification_setting');
    } else {
        $allow =  array();
    }

    if(isset($customer_group_info['approval']) && !$customer_group_info['approval'] && isset($rec['message']) && $rec['message'] && in_array('registration', $allow)) {

        $message = trim(str_ireplace($find, $replace,  $rec['message']));

        $this->load->model('localisation/country');
        if(isset($args[0]['country_id'])) {
            $country =  $this->model_localisation_country->getCountry($args[0]['country_id']);
        } else {
            $country =  $this->model_localisation_country->getCountry($this->config->get('config_country_id'));
        }

        if(file_exists(DIR_APPLICATION . '../vendor/autoload.php')) {
        $this->load->library('wkwhatsapp');
        $this->wkwhatsapp->sendMsg(strip_tags($message), $this->phone($country['iso_code_2']). $args[0]['telephone']);
        }

    }
   }
}
public function add_return(&$route, &$args, &$output) {
    $this->load->model('wk_whatsapp/wk_whatsapp');
    $this->load->model('checkout/order');
    $this->load->language('account/return');
    if(isset($args[0]) && isset($args[0]['firstname']) && $this->config->get('module_wk_whatsapp_notification_status') && isset($output)) {
        $replace = array();

        $replace['config_name'] = $this->config->get('config_name');
        $replace['config_owner'] = $this->config->get('config_owner');
        $replace['config_address'] = $this->config->get('config_address');
        $replace['config_geocode'] = $this->config->get('config_geocode');
        $replace['config_currency'] = $this->config->get('config_currency');
        $replace['config_email'] = $this->config->get('config_email');
        $replace['config_telephone'] = $this->config->get('config_telephone');
        $replace['store_url']       = $this->url->link('account/login');
        $replace['customer_name']	= trim($args[0]['firstname']) . ' ' .trim($args[0]['lastname']);
        if (isset($args[0]['customer_group_id']) && is_array($this->config->get('config_customer_group_display')) && in_array($args[0]['customer_group_id'], $this->config->get('config_customer_group_display'))) {
            $customer_group_id = $args[0]['customer_group_id'];
        } else {
            $customer_group_id = $this->config->get('config_customer_group_id');
        }

        $replace['store_url']    = $this->url->link('account/login');
        
        $order_info = $this->model_checkout_order->getOrder($args[0]['order_id']);

        if(isset($order_info['order_status'])) {
            $replace['order_status']	 = $order_info['order_status'];
        }
        if(isset($order_info['order_id'])) {
            $replace['order_id']	 = $order_info['order_id'];
        }
        $replace['return_id'] = $output;
        $replace['order_link']   = $this->url->link('account/order/info','order_id='.$order_info['order_id'], true);
        $replace['return_link']   = $this->url->link('account/return/info','return_id='.$output, true);
        $replace['order_detail'] = $this->getOrderDetail($order_info, $order_info['order_id'],$order_info['order_status_id']);
        $replace['return_detail'] = $this->getReturnDetail($output);
        $this->load->model('account/return');
        $return_info = $this->model_account_return->getReturn($output);

        if ($return_info) {
            
            if($return_info['comment']){
                $replace['return_status_change_comment'] = $this->language->get('wk_return_comment').' : '.$return_info['comment'];
            }
            else{
                $replace['return_status_change_comment'] = '';
            }
            
            $replace['return_status']	= $return_info['status'];
            
            $replace['return_reason']	= $return_info['reason'];
            
            $replace['return_action']	= $return_info['action'];

            if(isset($return_info['opened'])){
                if($return_info['opened']){
                    $replace['return_opened_status'] = $this->language->get('text_opened');
                }
                else{
                    $replace['return_opened_status'] = $this->language->get('text_unopened');
                }
            }
            else{
                $replace['return_opened_status'] = '';
            }
        }
        $this->load->model('account/customer_group');

        $find = array();
        foreach ($replace as $key => $value) {
            $find[$key] = '{'.trim($key).'}';
        }
        $message_language = isset($this->config->get('module_wk_whatsapp_notification_return_template')[$order_info['language_id']]) ? $this->config->get('module_wk_whatsapp_notification_return_template')[$order_info['language_id']] : $this->config->get('module_wk_whatsapp_notification_return_template')[$this->model_wk_whatsapp_wk_whatsapp->getLanguage($this->config->get('config_language'))];
        $rec = $this->model_wk_whatsapp_wk_whatsapp->getRecord($message_language);

        if($this->config->get('module_wk_whatsapp_notification_setting') && is_array($this->config->get('module_wk_whatsapp_notification_setting')) ) {
            $allow = $this->config->get('module_wk_whatsapp_notification_setting');
        } else {
            $allow =  array();
        }

        if(isset($rec['message']) && $rec['message'] && in_array('return', $allow)) {

            $message = trim(str_ireplace($find, $replace,  $rec['message']));

            $this->load->model('localisation/country');
            if(isset($order_info['shipping_country_id'])) {
                $country =  $this->model_localisation_country->getCountry($order_info['shipping_country_id']);
            } else {
                $country =  $this->model_localisation_country->getCountry($this->config->get('config_country_id'));
            }

            if(file_exists(DIR_APPLICATION . '../vendor/autoload.php')) {
            $this->load->library('wkwhatsapp');
            $this->wkwhatsapp->sendMsg(strip_tags($message), $this->phone($country['iso_code_2']). $args[0]['telephone']);
            }

        }
    }
}
public function getReturnDetail($return_id = 0) {
    $this->load->language('account/return');

    if (isset($return_id)) {
        $return_id = $return_id;
    } else {
        $return_id = 0;
    }
    $data =  array();
    $data['text_product'] = $this->language->get('column_name');
    $this->load->model('account/return');
    $return_info = $this->model_account_return->getReturn($return_id);

    if ($return_info) {
        

        $data['heading_title'] = $this->language->get('text_return');

        $data['text_return_detail'] = $this->language->get('text_return_detail');
        $data['text_return_id'] = $this->language->get('text_return_id');
        $data['text_order_id'] = $this->language->get('text_order_id');
        $data['text_date_ordered'] = $this->language->get('text_date_ordered');
        $data['text_customer'] = $this->language->get('text_customer');
        $data['text_email'] = $this->language->get('text_email');
        $data['text_telephone'] = $this->language->get('text_telephone');
        $data['text_status'] = $this->language->get('text_status');
        $data['text_date_added'] = $this->language->get('text_date_added');
        $data['text_product'] = $this->language->get('text_product');
        $data['text_reason'] = $this->language->get('text_reason');
        $data['text_comment'] = $this->language->get('text_comment');
        $data['text_history'] = $this->language->get('text_history');
        $data['text_no_results'] = $this->language->get('text_no_results');

        $data['column_product'] = $this->language->get('column_product');
        $data['column_model'] = $this->language->get('column_model');
        $data['column_quantity'] = $this->language->get('column_quantity');
        $data['column_opened'] = $this->language->get('column_opened');
        $data['column_reason'] = $this->language->get('column_reason');
        $data['column_action'] = $this->language->get('column_action');
        $data['column_date_added'] = $this->language->get('column_date_added');
        $data['column_status'] = $this->language->get('column_status');
        $data['column_comment'] = $this->language->get('column_comment');

        $data['button_continue'] = $this->language->get('button_continue');

        $data['return_id'] = $return_info['return_id'];
        $data['order_id'] = $return_info['order_id'];
        $data['date_ordered'] = date($this->language->get('date_format_short'), strtotime($return_info['date_ordered']));
        $data['date_added'] = date($this->language->get('date_format_short'), strtotime($return_info['date_added']));
        $data['firstname'] = $return_info['firstname'];
        $data['lastname'] = $return_info['lastname'];
        $data['email'] = $return_info['email'];
        $data['telephone'] = $return_info['telephone'];
        $data['product'] = $return_info['product'];
        $data['model'] = $return_info['model'];
        $data['quantity'] = $return_info['quantity'];
        $data['reason'] = $return_info['reason'];
        $data['opened'] = $return_info['opened'] ? $this->language->get('text_yes') : $this->language->get('text_no');
        $data['comment'] = nl2br($return_info['comment']);
        $data['action'] = $return_info['action'];
        return $this->load->view('wk_whatsapp/return_detail',$data);
    }
    else{
        return '';
    }

}

public function phone($code) {
    $json = json_decode('{"BD": "880", "BE": "32", "BF": "226", "BG": "359", "BA": "387", "BB": "+1-246", "WF": "681", "BL": "590", "BM": "+1-441", "BN": "673", "BO": "591", "BH": "973", "BI": "257", "BJ": "229", "BT": "975", "JM": "+1-876", "BV": "", "BW": "267", "WS": "685", "BQ": "599", "BR": "55", "BS": "+1-242", "JE": "+44-1534", "BY": "375", "BZ": "501", "RU": "7", "RW": "250", "RS": "381", "TL": "670", "RE": "262", "TM": "993", "TJ": "992", "RO": "40", "TK": "690", "GW": "245", "GU": "+1-671", "GT": "502", "GS": "", "GR": "30", "GQ": "240", "GP": "590", "JP": "81", "GY": "592", "GG": "+44-1481", "GF": "594", "GE": "995", "GD": "+1-473", "GB": "44", "GA": "241", "SV": "503", "GN": "224", "GM": "220", "GL": "299", "GI": "350", "GH": "233", "OM": "968", "TN": "216", "JO": "962", "HR": "385", "HT": "509", "HU": "36", "HK": "852", "HN": "504", "HM": " ", "VE": "58", "PR": "+1-787 and 1-939", "PS": "970", "PW": "680", "PT": "351", "SJ": "47", "PY": "595", "IQ": "964", "PA": "507", "PF": "689", "PG": "675", "PE": "51", "PK": "92", "PH": "63", "PN": "870", "PL": "48", "PM": "508", "ZM": "260", "EH": "212", "EE": "372", "EG": "20", "ZA": "27", "EC": "593", "IT": "39", "VN": "84", "SB": "677", "ET": "251", "SO": "252", "ZW": "263", "SA": "966", "ES": "34", "ER": "291", "ME": "382", "MD": "373", "MG": "261", "MF": "590", "MA": "212", "MC": "377", "UZ": "998", "MM": "95", "ML": "223", "MO": "853", "MN": "976", "MH": "692", "MK": "389", "MU": "230", "MT": "356", "MW": "265", "MV": "960", "MQ": "596", "MP": "+1-670", "MS": "+1-664", "MR": "222", "IM": "+44-1624", "UG": "256", "TZ": "255", "MY": "60", "MX": "52", "IL": "972", "FR": "33", "IO": "246", "SH": "290", "FI": "358", "FJ": "679", "FK": "500", "FM": "691", "FO": "298", "NI": "505", "NL": "31", "NO": "47", "NA": "264", "VU": "678", "NC": "687", "NE": "227", "NF": "672", "NG": "234", "NZ": "64", "NP": "977", "NR": "674", "NU": "683", "CK": "682", "XK": "", "CI": "225", "CH": "41", "CO": "57", "CN": "86", "CM": "237", "CL": "56", "CC": "61", "CA": "1", "CG": "242", "CF": "236", "CD": "243", "CZ": "420", "CY": "357", "CX": "61", "CR": "506", "CW": "599", "CV": "238", "CU": "53", "SZ": "268", "SY": "963", "SX": "599", "KG": "996", "KE": "254", "SS": "211", "SR": "597", "KI": "686", "KH": "855", "KN": "+1-869", "KM": "269", "ST": "239", "SK": "421", "KR": "82", "SI": "386", "KP": "850", "KW": "965", "SN": "221", "SM": "378", "SL": "232", "SC": "248", "KZ": "7", "KY": "+1-345", "SG": "65", "SE": "46", "SD": "249", "DO": "+1-809 and 1-829", "DM": "+1-767", "DJ": "253", "DK": "45", "VG": "+1-284", "DE": "49", "YE": "967", "DZ": "213", "US": "1", "UY": "598", "YT": "262", "UM": "1", "LB": "961", "LC": "+1-758", "LA": "856", "TV": "688", "TW": "886", "TT": "+1-868", "TR": "90", "LK": "94", "LI": "423", "LV": "371", "TO": "676", "LT": "370", "LU": "352", "LR": "231", "LS": "266", "TH": "66", "TF": "", "TG": "228", "TD": "235", "TC": "+1-649", "LY": "218", "VA": "379", "VC": "+1-784", "AE": "971", "AD": "376", "AG": "+1-268", "AF": "93", "AI": "+1-264", "VI": "+1-340", "IS": "354", "IR": "98", "AM": "374", "AL": "355", "AO": "244", "AQ": "", "AS": "+1-684", "AR": "54", "AU": "61", "AT": "43", "AW": "297", "IN": "91", "AX": "+358-18", "AZ": "994", "IE": "353", "ID": "62", "UA": "380", "QA": "974", "MZ": "258"}', true);
    return isset($json[$code]) ? $json[$code] : '91';
 }


}
?>
