<?php
class ControllerMmsocialGoogle extends Controller {
	private $error = array();

	public function index() {
		
		if ($this->customer->isLogged()) {
			$this->response->redirect($this->url->link('account/account', '', true));
		}
		// Fetch Google Api Information
// 		echo "google";
		$module_info = $this->config->get('module_mmslogin_data');
// 		echo "<pre>";
// 		print_r($module_info);
		
		$status = $module_info['module_mmslogin_status'];
		$gpstatus = $module_info['gpstatus'];
		$gptitle = $module_info['gptitle'];
		$imagegp = $module_info['imagegp'];
		$client_id = $module_info['gp_client'];
		$client_secret = $module_info['gp_secret'];
		
		if ($this->request->server['HTTPS']) {
			$server = $this->config->get('config_ssl');
		} else {
			$server = $this->config->get('config_url');
		}
		
		if($gpstatus && $status):
		
		require DIR_SYSTEM.'Google/autoload.php';
		
		//Insert your client ID and secret 
		//You can get it from : https://console.developers.google.com/
		// $client_id = '161961985859-inqggltdchi2m4mmq00endi7k6mlktis.apps.googleusercontent.com'; 
		// $client_secret = 'kq5BPdCmJIPFFPDuiLjyCOPr';
		$redirect_uri = $server.'index.php?route=mmsocial/google';

		
		//incase of logout request, just unset the session var
		if (isset($_GET['logout'])) {
			unset($this->session->data['access_token']);
			$this->response->redirect($this->url->link('account/logout', '', true));
		}

		/************************************************
		Make an API request on behalf of a user. In
		this case we need to have a valid OAuth 2.0
		token for the user, so we need to send them
		through a login flow. To do this we need some
		information from our API console project.
		************************************************/
		$client = new Google_Client();
		$client->setClientId($client_id);
		$client->setClientSecret($client_secret);
		$client->setRedirectUri($redirect_uri);
		$client->addScope("email");
		$client->addScope("profile");

		/************************************************
		When we create the service here, we pass the
		client to it. The client then queries the service
		for the required scopes, and uses that when
		generating the authentication URL later.
		************************************************/
		$service = new Google_Service_Oauth2($client);

		/************************************************
		If we have a code back from the OAuth 2.0 flow,
		we need to exchange that with the authenticate()
		function. We store the resultant access token
		bundle in the session, and redirect to ourself.
		*/

		if (isset($_GET['code'])) {
			$client->authenticate($_GET['code']);
			$this->session->data['access_token'] = $client->getAccessToken();
			header('Location: ' . filter_var($redirect_uri, FILTER_SANITIZE_URL));
			exit;
		}

		/************************************************
		If we have an access token, we can make
		requests, else we generate an authentication URL.
		************************************************/
		if (isset($this->session->data['access_token']) && $this->session->data['access_token']) {
			$client->setAccessToken($this->session->data['access_token']);
		} else {
			$authUrl = $client->createAuthUrl();
		}
		
		if($client->isAccessTokenExpired()) {

			// $authUrl = $client->createAuthUrl();
			// header('Location: ' . filter_var($authUrl, FILTER_SANITIZE_URL));

		}

		//Display user info or display login url as per the info we have.
// 		echo '<div style="margin:20px">';
		if (isset($authUrl)){ 
// 		//show login url
// 			echo '<div align="center">';
// 			echo '<h3>Login with Google -- Demo</h3>';
// 			echo '<div>Please click login button to connect to Google.</div>';
// 			echo '<a class="login" href="' . $authUrl . '"><img src="images/google-login-button.png" /></a>';
// 			echo '</div>';		
		} else {		
			$user = $service->userinfo->get(); //get user info	
			
// 			//show user picture
// 			echo '<img src="'.$user->picture.'" style="float: right;margin-top: 33px;" />';
			
// 			echo 'Hi '.$user->name.', Thanks for Registering! [<a href="'.$redirect_uri.'&logout=1">Log Out</a>]';	
			
// 			//print user details
// 			echo '<pre>';
// 			print_r($user);
// 			echo '</pre>';
		}
		
// 		echo '</div>';
		
		// Module Work
		unset($this->session->data['access_token']);
		$firstname = $user->givenName;
		$lastname = $user->familyName;
		$email = $user->email;
		
		$this->load->model('account/customer');
// 		$this->load->model('mmsocial/mmsocial');
		
		if ($this->model_account_customer->getTotalCustomersByEmail($email)) {
			
			// If Account Registered Login into Store
			
			if($this->validate($email)){				
				// echo "ok";
				$customer_data = $this->model_account_customer->getCustomerByEmail($email);				
				
				if($customer_data){
					$customer_id = $customer_data['customer_id'];
				} else {
					$customer_id = 0;
				}
				
				// Clear Session
				
				$this->customer->logout();
				$this->cart->clear();

				unset($this->session->data['order_id']);
				unset($this->session->data['payment_address']);
				unset($this->session->data['payment_method']);
				unset($this->session->data['payment_methods']);
				unset($this->session->data['shipping_address']);
				unset($this->session->data['shipping_method']);
				unset($this->session->data['shipping_methods']);
				unset($this->session->data['comment']);
				unset($this->session->data['coupon']);
				unset($this->session->data['reward']);
				unset($this->session->data['voucher']);
				unset($this->session->data['vouchers']);
				
				if ($customer_data && $this->customer->login($email, '', true)) {
					// Default Addresses
					$this->load->model('account/address');

					if ($this->config->get('config_tax_customer') == 'payment') {
						$this->session->data['payment_address'] = $this->model_account_address->getAddress($this->customer->getAddressId());
					}

					if ($this->config->get('config_tax_customer') == 'shipping') {
						$this->session->data['shipping_address'] = $this->model_account_address->getAddress($this->customer->getAddressId());
					}

					$this->response->redirect($this->url->link('account/account', '', true));
				}
			
			}
			
		} else{
			
			// If Email Not Registered, Register New Account
			
			$this->load->model('account/customer');	
				
				$register_array = array(
				
					'firstname'	=>	$firstname,
					'lastname'	=>	$lastname,
					'email'	=>	$email,
					'password'	=>	token(7),
					'telephone'	=>	"",
					'fax'	=>	"",
					'company'	=>	"",
					'address_1'	=>	"",
					'address_2'	=>	"",
					'city'	=>	"",
					'postcode'	=>	"",
					'country_id'	=>	"",
					'zone_id'	=>	"",			
				);
				
				$customer_id = $this->model_account_customer->addCustomer($register_array);

				// Clear any previous login attempts for unregistered accounts.
				$this->model_account_customer->deleteLoginAttempts($email);

				
				$this->customer->login($email, '', true);

				unset($this->session->data['guest']);
				

				// Add to activity log
				if ($this->config->get('config_customer_activity')) {
					$this->load->model('account/activity');

					$activity_data = array(
						'customer_id' => $customer_id,
						'name'        => $firstname . ' ' . $lastname
					);

					$this->model_account_activity->addActivity('register', $activity_data);
				}

				$this->response->redirect($this->url->link('account/success'));
			
			
		}
		
		// Module Work
		else:
		
		echo "redirect";
		$this->response->redirect($this->url->link('account/login'));
		
		endif; // gpstatus if close
	}	
	
	// Validation used while Login
	protected function validate($email) {
		
		// Check how many login attempts have been made.
		$login_info = $this->model_account_customer->getLoginAttempts($email);

		if ($login_info && ($login_info['total'] >= $this->config->get('config_login_attempts')) && strtotime('-1 hour') < strtotime($login_info['date_modified'])) {
			$this->error['warning'] = $this->language->get('error_attempts');
		}

		// Check if customer has been approved.
		$customer_info = $this->model_account_customer->getCustomerByEmail($email);

		if ($customer_info && !$customer_info['status']) {
			$this->error['warning'] = $this->language->get('error_approved');
		}
		
		return !$this->error;
	}
	
}
