<?php
ob_start();
require DIR_SYSTEM.'facebooklogin/autoload.php';			
use Facebook\FacebookSession;
use Facebook\FacebookRedirectLoginHelper;
use Facebook\FacebookRequest;
use Facebook\FacebookResponse;
use Facebook\FacebookSDKException;
use Facebook\FacebookRequestException;
use Facebook\FacebookAuthorizationException;
use Facebook\GraphObject;
use Facebook\Entities\AccessToken;
use Facebook\HttpClients\FacebookCurlHttpClient;
use Facebook\HttpClients\FacebookHttpable;
			
class ControllerMmsocialFacebook extends Controller {	

	public function index() {
		session_start();

		if ($this->customer->isLogged()) {
			$this->response->redirect($this->url->link('account/account', '', true));
		}
				
		$module_info = $this->config->get('module_mmslogin_data');
		$status = $module_info['module_mmslogin_status'];
		$fbstatus = $module_info['fbstatus'];
		$fbtitle = $module_info['fbtitle'];
		$imagefb = $module_info['imagefb'];
		$fb_client = $module_info['fb_client'];
		$fb_secret = $module_info['fb_secret'];
		
		if ($this->request->server['HTTPS']) {
			$server = $this->config->get('config_ssl');
		} else {
			$server = $this->config->get('config_url');
		}
	 	$server = str_replace("http://","https://",$server);
		if($fbstatus && $status):
			// init app with app id and secret
			FacebookSession::setDefaultApplication($fb_client,$fb_secret);
		//	FacebookSession::setDefaultApplication('2294467987450411','4bb5a4632fc2daf6a18e8700db852d6a');
			// login helper with redirect_uri
				$helper = new FacebookRedirectLoginHelper('https://localhost/octest/oc2.3/index.php?route=mmsocial%2Ffacebook' );
				$helper = new FacebookRedirectLoginHelper($server.'index.php?route=mmsocial%2Ffacebook' );
				
			try {
			  $session = $helper->getSessionFromRedirect();
			  echo "sess";
			  
			  
			} catch( FacebookRequestException $ex ) {
			  // When Facebook returns an error
			} catch( Exception $ex ) {
			  // When validation fails or other local issues
			}
			// see if we have a session
			if ( isset( $session ) ) {
				
				// graph api request for user data			  
				$request = new FacebookRequest( $session, 'GET', '/me?locale=en_US&fields=id,name,email,first_name,last_name' );
				$response = $request->execute();
			  // get response
			 
			  $graphObject = $response->getGraphObject();
			 
					$fbid = $graphObject->getProperty('id');              // To Get Facebook ID
					$fbfullname = $graphObject->getProperty('name'); // To Get Facebook full name
					$email = $graphObject->getProperty('email');    // To Get Facebook email ID
					$firstname = $graphObject->getProperty('first_name');    // To Get Facebook email ID
					$lastname = $graphObject->getProperty('last_name');    // To Get Facebook email ID
				/* ---- Session Variables -----*/
				echo $fbid;       
				echo $fbfullname;
				echo $firstname;
				echo $lastname;
				echo $email; 
				
				
				// Module Work
				
				
				$this->load->model('account/customer');
				// $this->load->model('mmsocial/mmsocial');
				
				if ($this->model_account_customer->getTotalCustomersByEmail($email)) {
					
					// If Account Registered Login into Store
					
					if($this->validate($email)){				
						echo "ok";
						$customer_data = $this->model_account_customer->getCustomerByEmail($email);				
						
						if($customer_data){
							$customer_id = $customer_data['customer_id'];
						} else {
							$customer_id = 0;
						}
						
						// Clear Session
						
						$this->customer->logout();
						// $this->cart->clear();

						unset($this->session->data['order_id']);
						unset($this->session->data['payment_address']);
						unset($this->session->data['payment_method']);
						unset($this->session->data['payment_methods']);
						unset($this->session->data['shipping_address']);
						unset($this->session->data['shipping_method']);
						unset($this->session->data['shipping_methods']);
						unset($this->session->data['comment']);
						unset($this->session->data['coupon']);
						unset($this->session->data['reward']);
						unset($this->session->data['voucher']);
						unset($this->session->data['vouchers']);
						
						if ($customer_data && $this->customer->login($email, '', true)) {
							// Default Addresses
							$this->load->model('account/address');

							if ($this->config->get('config_tax_customer') == 'payment') {
								$this->session->data['payment_address'] = $this->model_account_address->getAddress($this->customer->getAddressId());
							}

							if ($this->config->get('config_tax_customer') == 'shipping') {
								$this->session->data['shipping_address'] = $this->model_account_address->getAddress($this->customer->getAddressId());
							}

							$this->response->redirect($this->url->link('account/account', '', true));
						}
					
					}
					
				} else{
					
					// If Email Not Registered, Register New Account
					
					$this->load->model('account/customer');	
						
						$register_array = array(
						
							'firstname'	=>	$firstname,
							'lastname'	=>	$lastname,
							'email'	=>	$email,
							'password'	=>	token(7),
							'telephone'	=>	"",
							'fax'	=>	"",
							'company'	=>	"",
							'address_1'	=>	"",
							'address_2'	=>	"",
							'city'	=>	"",
							'postcode'	=>	"",
							'country_id'	=>	"",
							'zone_id'	=>	"",			
						);
						
						$customer_id = $this->model_account_customer->addCustomer($register_array);

						// Clear any previous login attempts for unregistered accounts.
						$this->model_account_customer->deleteLoginAttempts($email);

						
						$this->customer->login($email, '', true);

						unset($this->session->data['guest']);

						// Add to activity log
						if ($this->config->get('config_customer_activity')) {
							$this->load->model('account/activity');

							$activity_data = array(
								'customer_id' => $customer_id,
								'name'        => $firstname . ' ' . $lastname
							);

							$this->model_account_activity->addActivity('register', $activity_data);
						}

						$this->response->redirect($this->url->link('account/success'));					
					
				}
				
				// Module Work
				
				/* ---- header location after session ----*/											
				
			} else {
				
					$loginUrl = $helper->getLoginUrl(array(
						'scope' => 'email'
					));

			 header("Location: ".$loginUrl);
			}
		
		else:
		
		echo "redirect";
		
		endif; // fbstatus if close
	}
	
	// Validation used while Login
	protected function validate($email) {
		
		// Check how many login attempts have been made.
		$login_info = $this->model_account_customer->getLoginAttempts($email);

		if ($login_info && ($login_info['total'] >= $this->config->get('config_login_attempts')) && strtotime('-1 hour') < strtotime($login_info['date_modified'])) {
			$this->error['warning'] = $this->language->get('error_attempts');
		}

		// Check if customer has been approved.
		$customer_info = $this->model_account_customer->getCustomerByEmail($email);

		if ($customer_info && !$customer_info['status']) {
			$this->error['warning'] = $this->language->get('error_approved');
		}
		
		return !$this->error;
	}
	
}
