<?php
/**
 * Kiple OpenCart Plugin
 * 
 * @package Payment Gateway
 * @author Kiple Support Team <support@kiplepay.comm>
 * @version 3.0
 */

class ControllerExtensionPaymentKiple extends Controller {
        public function index() {
                $data['button_confirm'] = $this->language->get('button_confirm');

                $this->load->model('checkout/order');

                $order_info = $this->model_checkout_order->getOrder($this->session->data['order_id']);

                if (isset($this->session->data['guest']))
                {
                    $email = $this->session->data['guest']['email'];
                    $telephone = $this->session->data['guest']['telephone'];
                }
                else
                {
                    $email = $this->customer->getEmail();
                    $telephone = $this->customer->getTelephone();
                }

                $data['action'] = $this->config->get('payment_kiple_type');
                $data['ord_mercID']= $this->config->get('payment_kiple_mid');
                $data['ord_mercref'] = $this->session->data['order_id'] . '-' . uniqid();
                $data['ord_totalamt'] =  $this->currency->format($order_info['total'], $order_info['currency_code'], $order_info['currency_value'], false);
                //$data['currency'] =  $order_info['currency_code'];
                $data['currency'] =  'MYR';
                $data['ord_shipname'] = $order_info['payment_firstname'] . ' ' . $order_info['payment_lastname'];
                $data['ord_email'] = $email;
                $data['ord_telephone'] = $telephone;
                $data['ord_shipcountry'] = $order_info['payment_iso_code_2'];
                $data['ord_date'] =  date("Y-m-d h:i:s");

                $amountVal = str_replace('.', '', $data['ord_totalamt']);
                $amountVal = str_replace(',', '', $amountVal);
                $data['merchant_hashvalue'] = sha1($this->config->get('payment_kiple_vkey') . $data['ord_mercID'] . $data['ord_mercref'] . $amountVal);
        //Load all channel from language file.
        //$this->load->language('extension/payment/kiple');


                $products = $this->cart->getProducts();
                $data['prod_desc']="";
                foreach ($products as $product) {
                   // $data['prod_desc'][]= $product['name']." x ".$product['quantity'];
                     $data['prod_desc'].= $product['name']." x ".$product['quantity']."\n";
                    //implode("\n",$prod_desc)
                }

           // echo $data['prod_desc2'];
           // exit;

                $data['lang'] = $this->session->data['language'];

                $data['ord_returnURL'] = $this->url->link('extension/payment/kiple/return_ipn', '', 'SSL');

                $version_oc = substr(VERSION,0,3);
         //test echo view version->     //echo $version_oc;
                                //exit;

                if($version_oc == "2.3")
                {
                    if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/extension/payment/kiple.twig')) {
                    return $this->load->view($this->config->get('config_template') . '/template/extension/payment/kiple.twig', $data);
                    } else {
                        return $this->load->view('extension/payment/kiple', $data);
                    }
                }
                else
                {
                    if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/extension/payment/kiple')) {
                    return $this->load->view($this->config->get('config_template') . '/template/extension/payment/kiple', $data);
                    } else {
                        return $this->load->view('default/template/extension/payment/kiple', $data);
                    }
                }
        }

    public function return_ipn()   {
        $this->load->model('checkout/order');

        $vkey = $this->config->get('payment_kiple_vkey');

        $key = $_REQUEST['ord_key'];
        $returncode = $_REQUEST['returncode'];

        $amountVal = str_replace('.', '', $_REQUEST['ord_totalamt']);
        $amountVal = str_replace(',', '', $amountVal);

        $chkOrdKey = sha1($vkey . $_REQUEST['ord_mercID'] . $_REQUEST['ord_mercref'] . $amountVal . $returncode);

        $invalidKey = false;
        if($key == $chkOrdKey){
            $invalidKey = true; 
        }

        $ordID = explode('-',$_REQUEST['ord_mercref']);
        $orderid = $ordID[0];

        $order_info = $this->model_checkout_order->getOrder($orderid); 
        //orderid
        $order_status_id = $this->config->get('config_order_status_id');
        $txnPayID = " RM". number_format($_REQUEST['ord_totalamt'],2) . " (Kiplebiz PaymentID: " . $_REQUEST['ord_mercref'] .")";

        if($returncode == '100' && $invalidKey == true) {
            $commentsK = "Successful Payment " . $txnPayID;
            $order_status_id = $this->config->get('payment_kiple_completed_status_id');
        } else {
            $commentsK = "Failed Payment " . $txnPayID;
            $order_status_id = $this->config->get('payment_kiple_failed_status_id');
        }

        $param = "";
        foreach( $_POST As $kP => $vP )
        {
            $param .= $kP . "=" . $vP . "<br>";
        }

        if (!$order_info['order_status_id']) {
            $this->model_checkout_order->addOrderHistory($orderid, $order_status_id, $commentsK, 1);
        } else {
            $this->model_checkout_order->addOrderHistory($orderid, $order_status_id, $commentsK, 1);
        }

        if($returncode == '100' && $invalidKey == true)
        {
                    echo '<html>' . "\n";
                    echo '<head>' . "\n";
                    echo '  <meta http-equiv="Refresh" content="0; url=' . $this->url->link('checkout/success') . '">' . "\n";
                    echo '</head>' . "\n";
                    echo '<body>' . "\n";
                    echo '  <p>Please follow <a href="' . $this->url->link('checkout/success') . '">link</a>!</p>' . "\n";
                    echo '</body>' . "\n";
                    echo '</html>' . "\n";

        } else {

                    echo '<html>' . "\n";
                    echo '<head>' . "\n";
                    echo '  <meta http-equiv="Refresh" content="0; url=' . $this->url->link('checkout/failure') . '">' . "\n";
                    echo '</head>' . "\n";
                    echo '<body>' . "\n";
                    echo '  <p>Please follow <a href="' . $this->url->link('checkout/failure') . '">link</a>!</p>' . "\n";
                    echo '</body>' . "\n";
                    echo '</html>' . "\n";

        }
        exit();
    }
}