<?php
class ControllerEtcmCommunityApp extends Controller {
    public function get_shipping_methods() {
        $json = [];

        $this->load->model('etcm/community_app');

        $shipping_address_post = isset($this->request->post['shipping_address']) ? $this->request->post['shipping_address'] : false;
        $products_post = isset($this->request->post['products']) ? $this->request->post['products'] : false;

        $this->load->library('community_cart');
        $this->cart = new Community_cart($this->registry);

        $this->load->library('tax');
        $this->tax = new Tax($this->registry);

        $products_json = base64_decode($products_post);
        $products = json_decode($products_json, true);

        $shipping_address_json = base64_decode($shipping_address_post);
        $shipping_address_arr = json_decode($shipping_address_json, true);

        if(!empty($products) && !empty($shipping_address_arr)){
            foreach($products as $product){
                $this->cart->add_to_cart($product['merchant_product_id'], $product);
            }

            $shipping_method_rows = $this->model_etcm_community_app->getExtensions('shipping');

            foreach($shipping_method_rows as $row){
                if($this->config->get($row['code'] . '_status')){
                    $this->load->model('extension/shipping/' . $row['code']);

                    $quote = $this->{'model_extension_shipping_' . $row['code']}->getQuote($shipping_address_arr);

                    if($quote){
                        $shipping_methods[] = [
                            'title'         => $quote['title'],
                            'quote'         => $quote['quote'],
                            'sort_order'    => $quote['sort_order'],
                            'error'         => $quote['error']
                        ];
                    }
                }
            }

            $sort_order_column = array_column($shipping_methods, 'sort_order');

            array_multisort($shipping_methods, SORT_NUMERIC, $sort_order_column, SORT_ASC);
        }

        if (!empty($shipping_methods)) {
            $json = [
                'error'             => '0',
                'message'           => 'get shipping methods success',
                'store_name'        => $this->config->get('config_name'),
                'shipping_methods'  => $shipping_methods
            ];
        } else {
            $json = [
                'error'             => '1',
                'message'           => 'failed to get shipping methods',
            ];
        }       

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
    }
}
?>