<?php

class ControllerAppointmentNext extends Controller
{
    private $error = array();

    public function index()
    {
        $this->load->language('appointment/view');

        $this->document->addStyle('catalog/view/theme/default/stylesheet/appointment_view.css?v='.time());

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('appointment/view');
        $this->load->model('appointment/appointment');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            $customer_data = $this->model_appointment_appointment->customerExistsByIcAndTelephone($this->request->post['customer_ic'], $this->request->post['phone_no']);

            $access_token = $customer_data['unique_customer_id'];
            $this->response->redirect($this->url->link('appointment/view', 'access_token=' . $access_token, 'SSL'));

            /*echo '<pre>';
            print_r($customer_id);
            echo '</pre>';*/
        }

        $this->getPage();
    }

    public function getPage()
    {
        $data['heading_title'] = $this->language->get('heading_title');

        $data['text_customer_ic'] = $this->language->get('text_customer_ic');
        $data['text_placeholder_ic'] = $this->language->get('text_placeholder_ic');
        $data['text_phone_no'] = $this->language->get('text_phone_no');
        $data['text_placeholder_phone_no'] = $this->language->get('text_placeholder_phone_no');

        $data['button_submit'] = $this->language->get('button_submit');

        $data['error_not_found'] = $this->language->get('error_not_found');

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->error['customer_ic'])) {
            $data['error_customer_ic'] = $this->error['customer_ic'];
        } else {
            $data['error_customer_ic'] = '';
        }

        if (isset($this->error['phone_no'])) {
            $data['error_phone_no'] = $this->error['phone_no'];
        } else {
            $data['error_phone_no'] = '';
        }

        if (isset($this->request->post['customer_ic'])) {
            $data['customer_ic'] = $this->request->post['customer_ic'];
        } else {
            $data['customer_ic'] = '';
        }

        if (isset($this->request->post['phone_no'])) {
            $data['phone_no'] = $this->request->post['phone_no'];
        } else {
            $data['phone_no'] = '';
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/home')
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('appointment/view')
        );

        if (isset($this->request->get['access_token'])) {
            $access_token = $this->request->get['access_token'];
            $customer_id = $this->get_customer_id($access_token);

            $this->load->model('account/customer');
            $data['customer_data'] = $this->model_account_customer->getCustomer($customer_id);

            if (isset($this->request->get['sort'])) {
                $sort = $this->request->get['sort'];
            } else {
                $sort = 'appointment_date';
            }

            if (isset($this->request->get['order'])) {
                $order = $this->request->get['order'];
            } else {
                $order = 'DESC';
            }

            if (isset($this->request->get['page'])) {
                $page = $this->request->get['page'];
            } else {
                $page = 1;
            }

            $filter_data = array(
                'customer_id' 	=> 	$customer_id,
                'sort' 	 		=> 	$sort,
                'order' 		=> 	$order,
                'start' 		=> 	($page - 1) * 10,
                'limit' 		=> 	10
            );

            $results = $this->model_appointment_view->getAppointments($filter_data);

            foreach ($results as $result) {
                $data['appointments'][] = array(
                    'appointment_date' 	=> $result['appointment_date'],
                    'appointment_time'	=> $result['appointment_time'],
                    'appointment_id' 	=> $result['appointment_id'],
                    'remark'			=> $result['remark'],
                    'service_name'		=> $result['service_name'],
                    'doctor_name'		=> $result['doctor_name'],
                    'status'			=> $result['status'],
                    'image'				=> $result['image'],
                    'print'				=> $this->url->link('appointment/view/appointmentA5', 'appointment_id=' . $result['appointment_id'], true),
                    'cancel'			=> $this->url->link('appointment/view/cancelAppointment', 'appointment_id=' . $result['appointment_id'], true)
                );
            }

            /*echo '<pre>';
            print_r($results);
            echo '</pre>';*/

            $url = '';

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            if ($order == 'ASC') {
                $url .= '&order=DESC';
            } else {
                $url .= '&order=ASC';
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $data['sort_date'] = $this->url->link('appointment/view', 'access_token='. $access_token . '&sort=appointment_date' . $url, 'SSL');
            $data['sort_time'] = $this->url->link('appointment/view', 'access_token='. $access_token . '&sort=appointment_time' . $url, 'SSL');

            $url = '';

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            $appointment_total = $this->model_appointment_view->getTotalAppointments($filter_data);

            $pagination = new Pagination();
            $pagination->total = $appointment_total;
            $pagination->page = $page;
            $pagination->limit = 10;
            $pagination->url = $this->url->link('appointment/view', 'access_token=' . $access_token . '&page={page}' . $url, 'SSL');

            $data['pagination'] = $pagination->render();

            $data['results'] = sprintf($this->language->get('text_pagination'), ($appointment_total) ? (($page - 1) * 10) + 1 : 0, ((($page - 1) * 10) > ($appointment_total - 10)) ? $appointment_total : ((($page - 1) * 10) + 10), $appointment_total, ceil($appointment_total / 10));

            $data['sort'] = $sort;
            $data['order'] = $order;

            $data['customer_id'] = $customer_id;
        }

        $data['action'] = $this->url->link('appointment/view');

        $data['column_left'] = $this->load->controller('common/column_left');
        $data['column_right'] = $this->load->controller('common/column_right');
        $data['content_top'] = $this->load->controller('common/content_top');
        $data['content_bottom'] = $this->load->controller('common/content_bottom');
        $data['footer'] = $this->load->controller('common/footer');
        $data['header'] = $this->load->controller('common/header');

        if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/appointment/view')) {
            $this->response->setOutput($this->load->view($this->config->get('config_template') . '/template/appointment/view', $data));
        } else {
            $this->response->setOutput($this->load->view('default/template/appointment/view', $data));
        }
    }

    public function appointmentA5()
    {
        $this->load->language('appointment/appointmentA5_pdf');

        $this->load->model('appointment/view');
        $this->load->model('setting/setting');
        $this->load->model('localisation/country');
        $this->load->model('localisation/zone');

        $data = array();

        $data['title'] = $this->language->get('heading_title');

        if ($this->request->server['HTTPS']) {
            $data['base'] = HTTPS_SERVER;
        } else {
            $data['base'] = HTTP_SERVER;
        }

        $data['direction'] = $this->language->get('direction');
        $data['lang'] = $this->language->get('code');

        $data['text_telephone'] = $this->language->get('text_telephone');
        $data['text_email'] = $this->language->get('text_email');
        $data['en_text_appointment'] = $this->language->get('en_text_appointment');
        $data['text_appointment_date'] = $this->language->get('text_appointment_date');
        $data['text_appointment_time'] = $this->language->get('text_appointment_time');
        $data['text_service'] = $this->language->get('text_service');
        $data['text_doctor'] = $this->language->get('text_doctor');
        $data['text_remark'] = $this->language->get('text_remark');
        $data['text_patient_name'] = $this->language->get('text_patient_name');
        $data['text_patient_ic'] = $this->language->get('text_patient_ic');
        $data['text_gender'] = $this->language->get('text_gender');
        $data['text_male'] = $this->language->get('text_male');
        $data['text_female'] = $this->language->get('text_female');
        $data['text_status'] = $this->language->get('text_status');
        $data['text_pending'] = $this->language->get('text_pending');
        $data['text_confirm'] = $this->language->get('text_confirm');
        $data['text_canceled'] = $this->language->get('text_canceled');
        $data['text_attended'] = $this->language->get('text_attended');
        $data['text_draft'] = $this->language->get('text_draft');

        $store_id = $this->config->get('config_store_id');
        $store_info = $this->model_setting_setting->getSetting('config', $store_id);
        $country = $this->model_localisation_country->getCountry($store_info['config_country_id']);
        $zone = $this->model_localisation_zone->getZone($store_info['config_zone_id']);

        //address
        $data['config_name'] = $store_info['config_name'];
        $data['config_address'] = nl2br($store_info['config_address']);
        $data['config_country'] = $country['name'];
        $data['config_zone'] = $zone['name'];
        $data['config_telephone'] = $store_info['config_telephone'];
        $data['config_email'] = $store_info['config_email'];

        $appointment_id = $this->request->get['appointment_id'];
        $data['appointment_data'] = $this->model_appointment_view->getAppointment($appointment_id);

        /*echo '<pre>';
        print_r($data['appointment_data']);
        echo '</pre>';*/

        //PDF INVOICE
        $data['margin_top'] = $this->config->get('pdf_invoice_margin_top');
        $data['margin_right'] = $this->config->get('pdf_invoice_margin_right');
        $data['margin_bottom'] = $this->config->get('pdf_invoice_margin_bottom');
        $data['margin_left'] = $this->config->get('pdf_invoice_margin_left');
        $data['is_pdf'] = false;

        // PDF file name
        $pdf_file_name = date('Ymd_His') .'.pdf';

        if (isset($this->request->get['pdf'])) {
            $pdf = new PDF();
            //PDF INVOICE
            $data['margin_top'] = $this->config->get('pdf_invoice_margin_top');
            $data['margin_right'] = $this->config->get('pdf_invoice_margin_right');
            $data['margin_bottom'] = $this->config->get('pdf_invoice_margin_bottom');
            $data['margin_left'] = $this->config->get('pdf_invoice_margin_left');
            $page_format = ($this->config->get('pdf_invoice_page_orientation') == "landscape") ? '-L' : '';

            $data['is_pdf'] = true;

            $show = ($this->config->get('pdf_invoice_invoice_button') != "browser") ? 'D' : 'I';
            $page_size =  $this->config->get('pdf_invoice_page_size'). $page_format;
            $data['pdf'] = true;

            $this->response->setOutput($pdf->pdf($this->load->view('default/template/appointment/appointmentA5', $data), $pdf_file_name, $page_size, $show));
        }

        if (!isset($this->request->get['pdf']) || (isset($this->request->get['pdf']) && $this->config->get('pdf_invoice_invoice_button') != "browser")) {
            $this->response->setOutput($this->load->view('default/template/appointment/appointmentA5', $data));
        }
    }

    public function cancelAppointment()
    {
        $this->load->language('appointment/view');

        $this->load->model('appointment/view');
        $this->load->model('appointment/appointment');

        if (isset($this->request->get['appointment_id'])) {
            $appointment_id = $this->request->get['appointment_id'];
            $appointment_data = $this->model_appointment_view->getAppointment($appointment_id);
            $customer_id = $appointment_data['customer_id'];
            $access_token = $appointment_data['unique_customer_id'];

            $cancelAppointment = $this->model_appointment_view->cancelAppointment($appointment_id);

            $data['url'] = HTTPS_SERVER;

            // EMAIL TO CUSTOMER
            if (is_file(DIR_IMAGE . $this->config->get('config_logo'))) {
                $data['image'] = HTTPS_IMAGE . $this->config->get('config_logo');
            } else {
                $data['image'] = '';
            }

            $data['customer_name'] = $appointment_data['firstname'];

            $data['appointment_date'] = $appointment_data['appointment_date'];
            $data['appointment_time'] = $appointment_data['appointment_time'];
            $this->load->model('setting/setting');
            $this->load->model('localisation/country');
            $this->load->model('localisation/zone');
            $store_id = $this->config->get('config_store_id');
            $store_info = $this->model_setting_setting->getSetting('config', $store_id);
            $country = $this->model_localisation_country->getCountry($store_info['config_country_id']);
            $zone = $this->model_localisation_zone->getZone($store_info['config_zone_id']);

            //address
            $data['config_name'] = $store_info['config_name'];
            $data['config_address'] = nl2br($store_info['config_address']);
            $data['config_country'] = $country['name'];
            $data['config_zone'] = $zone['name'];
            $data['config_telephone'] = $store_info['config_telephone'];
            $data['config_email'] = $store_info['config_email'];

            if ((!empty($appointment_data['email'])) && ($appointment_data['email'] != '-')) {
                $subject = sprintf($this->language->get('text_subject'), $data['appointment_date']);

                $message = $this->load->view('default/template/appointment/cancelEmailToCustomer', $data);

                $mail = new Mail($this->config->get('config_mail'));
                $mail->setTo($appointment_data['email']);
                $mail->setFrom($this->config->get('config_email'));
                $mail->setSender($data['config_name']);
                $mail->setSubject($subject);
                $mail->setHtml($message);
                //$mail->send();

                // EMAIL TO TCM@QIANGYITANG.COM
                $subjectTCM = sprintf($this->language->get('text_subject_tcm'), $data['customer_name'], $data['appointment_date']);
                $messageTCM = $this->load->view('default/template/appointment/cancelEmailToTCM', $data);
                $mailTCM = new Mail($this->config->get('config_mail'));
                $mailTCM->setTo($data['config_email']);
                $mailTCM->setFrom($appointment_data['email']);
                $mailTCM->setSender($data['customer_name']);
                $mailTCM->setSubject($subjectTCM);
                $mailTCM->setHtml($messageTCM);
                //$mailTCM->send();

                // send email to all additional alert email
                $additional_emails = $this->config->get('config_mail_alert');

                if (!empty($additional_emails)) {
                    $emails = explode(',', $additional_emails);

                    foreach ($emails as $email) {
                        $additional_mail = new Mail($this->config->get('config_mail'));
                        $additional_mail->setTo($email);
                        $additional_mail->setFrom($appointment_data['email']);
                        $additional_mail->setSender($data['customer_name']);
                        $additional_mail->setSubject($subjectTCM);
                        $additional_mail->setHtml($messageTCM);
                        //$additional_mail->send();
                    }
                }
            }

            if ($appointment_data['doctor_id'] != 0) {
                $notification_template = $this->config->get('config_gcm_customer_cancel_appointment');

                if ($notification_template['status'] == '1') {
                    $template_title = $notification_template['title'];
                    $template_message = $notification_template['message'];

                    $find_title = array(
                        '{appointment_id}'
                    );

                    $replace_title = array(
                        'appointment_id'		=> $appointment_id
                    );

                    $customer_full_name = $appointment_data['firstname'] . ' ' . $appointment_data['lastname'];

                    $find_message = array(
                        '{customer_name}',
                        '{appointment_id}',
                        '{appointment_date}',
                        '{appointment_time}',
                        '{remark}'
                    );

                    $replace_message = array(
                        'customer_name'			=> $customer_full_name,
                        'appointment_id'		=> $appointment_id,
                        'appointment_date'		=> $appointment_data['appointment_date'],
                        'appointment_time'		=> $appointment_data['appointment_time'],
                        'remark'				=> $appointment_data['remark']
                    );

                    $notification_title = str_replace($find_title, $replace_title, $template_title);
                    $notification_message = str_replace($find_message, $replace_message, $template_message);

                    $ios_notification_data = array(
                        'body'          => $notification_title,
                        'badge'         => 1,
                        'sound'         => 'ping.aiff'
                    );

                    $notification_data = array(
                        'title' => $notification_title,
                        'message' => $notification_message,
                        'user_id' => $appointment_data['doctor_id'],
                        'type' => 3 			// Customer cancel appointment type
                    );

                    $doctor_device = $this->model_appointment_appointment->getDoctorDevice($appointment_data['doctor_id']);

                    if (!empty($doctor_device)) {
                        $gcm = new GCM($this->registry);
                        $gcm 	->sendTo($gcm->get_user_token($appointment_data['doctor_id']))
                                ->setData($notification_data)
                                ->setIosNotification($ios_notification_data)
                                ->setContentAvailable(true)
                                ->send();
                    }
                }

                $notification = new Notification($this->registry);

                $notification_data = [
                    'appointment_id'		=> $appointment_id,
                    'customer_name'			=> $appointment_data['firstname'] . ' ' . $appointment_data['lastname'],
                    'appointment_date'		=> $appointment_data['appointment_date']
                ];

                if (($notification->cancel_appointment_notification_status == '1') && ($notification->notification_status == '1')) {
                    $notification->add_notification('cancel_appointment_notification', $notification_data);
                }
            }

            $this->response->redirect($this->url->link('appointment/view/successCancel', '&access_token=' . $access_token, 'SSL'));
        }
    }

    public function successCancel()
    {
        $this->load->language('appointment/view');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->getSuccessCancelPage();
    }

    public function getSuccessCancelPage()
    {
        $data['heading_title'] = $this->language->get('heading_title');

        $data['text_success_cancel'] = $this->language->get('text_success_cancel');
        $data['text_continue'] = $this->language->get('button_continue');

        $access_token = $this->request->get['access_token'];

        $data['continue'] = $this->url->link("appointment/view", '&access_token=' . $access_token, 'SSL');

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/home')
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('appointment/view/successCancel')
        );

        $data['column_left'] = $this->load->controller('common/column_left');
        $data['column_right'] = $this->load->controller('common/column_right');
        $data['content_top'] = $this->load->controller('common/content_top');
        $data['content_bottom'] = $this->load->controller('common/content_bottom');
        $data['footer'] = $this->load->controller('common/footer');
        $data['header'] = $this->load->controller('common/header');

        if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/appointment/successCancel')) {
            $this->response->setOutput($this->load->view($this->config->get('config_template') . '/template/appointment/successCancel', $data));
        } else {
            $this->response->setOutput($this->load->view('default/template/appointment/successCancel', $data));
        }
    }

    protected function validate()
    {
        $customer_data = $this->model_appointment_appointment->customerExistsByIcAndTelephone($this->request->post['customer_ic'], $this->request->post['phone_no']);

        if (empty($customer_data)) {
            $this->error['warning'] = $this->language->get('error_not_found');
        }

        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }

    public function get_customer_id($access_token)
    {
        $this->load->model('appointment/appointment');

        $customer = $this->model_appointment_appointment->check_unique_id($access_token);

        if (!empty($customer)) {
            return $customer['customer_id'];
        }
    }
}
