<?php

class ControllerAppointmentMain extends Controller
{
    private $error = array();

    public function index()
    {
        // var_dump($this->customer);
        // die();
        $this->load->model('appointment/main');

        if ($this->customer->isLogged()) {
            $customer_details = $this->model_appointment_main->getCustomerbyID($this->request->get['customer_id']);

            $unique_id = $customer_details['unique_customer_id'];

            $this->response->redirect($this->url->link('appointment/appointment/edit', 'access_token=' . $unique_id, 'SSL'));
            return;
        }

        $this->load->language('appointment/main');

        $this->document->addStyle('catalog/view/theme/default/stylesheet/appointment_main.css?v='.time());

        $this->document->setTitle($this->language->get('heading_title'));


        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            $customer_info = $this->model_appointment_main->getCustomer($this->request->post['customer_ic'], $this->request->post['telephone_no']);

            if (!empty($customer_info)) {
                $unique_customer_id = $customer_info['unique_customer_id'];

                $this->response->redirect($this->url->link('appointment/appointment/edit'));
            } else {
                $this->error['warning'] = $this->language->get('error_not_found');
            }
        }

        $this->getPage();
    }

    public function getPage()
    {
        $data['heading_title'] = $this->language->get('heading_title');

        $data['error_not_found'] = $this->language->get('error_not_found');

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }


        if (isset($this->error['customer_ic'])) {
            $data['error_customer_ic'] = $this->error['customer_ic'];
        } else {
            $data['error_customer_ic'] = '';
        }

        if (isset($this->error['telephone_no'])) {
            $data['error_telephone_no'] = $this->error['telephone_no'];
        } else {
            $data['error_telephone_no'] = '';
        }

        if (isset($this->request->post['customer_ic'])) {
            $data['customer_ic'] = $this->request->post['customer_ic'];
        } else {
            $data['customer_ic'] = '';
        }

        if (isset($this->request->post['telephone_no'])) {
            $data['telephone_no'] = $this->request->post['telephone_no'];
        } else {
            $data['telephone_no'] = '';
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/home')
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('appointment/main')
        );

        $data['action'] = $this->url->link('appointment/main');
        $data['register'] = $this->url->link('appointment/appointment');
        $data['view'] = $this->url->link('appointment/view');

        $data['column_left'] = $this->load->controller('common/column_left');
        $data['column_right'] = $this->load->controller('common/column_right');
        $data['content_top'] = $this->load->controller('common/content_top');
        $data['content_bottom'] = $this->load->controller('common/content_bottom');
        $data['footer'] = $this->load->controller('common/footer');
        $data['header'] = $this->load->controller('common/header');

        $data['config_email'] = $this->config->get('config_email');

        if (file_exists(DIR_TEMPLATE . '/default/template/appointment/main')) {
            $this->response->setOutput($this->load->view('/default/template/appointment/main', $data));
        } else {
            $this->response->setOutput($this->load->view('default/template/appointment/main', $data));
        }
    }

    protected function validate()
    {
        if (empty($this->request->post['customer_ic'])) {
            $this->error['customer_ic'] = $this->language->get('error_customer_ic');
        }

        if (empty($this->request->post['telephone_no'])) {
            $this->error['telephone_no'] = $this->language->get('error_telephone_no');
        }

        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }
}
