<?php

class ControllerAppointmentAppointment extends Controller
{
    private $error = array();

    public function index()
    {
        $this->load->language('appointment/customer');
        $this->load->language('appointment/appointment');

        $this->document->addStyle('catalog/view/theme/default/stylesheet/appointment_form.css?v='.time());

        $this->document->setTitle($this->language->get('heading_title'));

        $this->document->addStyle('catalog/view/javascript/jquery/datetimepicker/bootstrap-datetimepicker.min.css');
        $this->document->addScript('catalog/view/javascript/jquery/datetimepicker/moment.js');
        $this->document->addScript('catalog/view/javascript/jquery/datetimepicker/bootstrap-datetimepicker.min.js');

        $this->load->model('appointment/appointment');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateCustomerForm()) {
            $unique_id = $this->model_appointment_appointment->addCustomer($this->request->post);
            $this->response->redirect($this->url->link('appointment/appointment/edit', 'access_token=' . $unique_id, 'SSL'));
        }

        $this->getFormCustomer();
    }

    public function success()
    {
        $this->load->language('appointment/appointment');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->getSuccessPage();
    }

    protected function getSuccessPage()
    {
        $this->load->model('appointment/appointment');


        $data['heading_title'] = $this->language->get('heading_title');

        $data['text_success'] = $this->language->get('text_success');
        $data['text_continue'] = $this->language->get('button_continue');

        $data['continue'] = $this->url->link("common/home", '', 'SSL');

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/home')
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('appointment/appointment')
        );


        $data['column_left'] = $this->load->controller('common/column_left');
        $data['column_right'] = $this->load->controller('common/column_right');
        $data['content_top'] = $this->load->controller('common/content_top');
        $data['content_bottom'] = $this->load->controller('common/content_bottom');
        $data['footer'] = $this->load->controller('common/footer');
        $data['header'] = $this->load->controller('common/header');



        if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/appointment/success')) {
            $this->response->setOutput($this->load->view($this->config->get('config_template') . '/template/appointment/success', $data));
        } else {
            $this->response->setOutput($this->load->view('default/template/appointment/success', $data));
        }
    }

    protected function getList()
    {
        $data['button_add'] = $this->language->get('button_add');

        $data['add'] = $this->url->link('appointment/appointment/add');

        $data['heading_title'] = $this->language->get('heading_title');

        $data['column_date'] = $this->language->get('column_date');
        $data['column_time'] = $this->language->get('column_time');
        $data['column_store'] = $this->language->get('column_store');
        $data['column_action'] = $this->language->get('column_action');

        $data['text_empty'] = $this->language->get('text_empty');

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/home')
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('appointment/appointment')
        );

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $data['appointments'] = array();

        $filter_data = array(
            'sort'  => 'date_added',
            'order' => 'DESC',
            'start' => ($page - 1) * 10,
            'limit' => 10
        );



        $results = $this->model_appointment_appointment->getAppointments($filter_data);

        foreach ($results as $result) {
            $data['appointments'][] = array(
                'appointment_date'      => $result['appointment_date'],
                'appointment_time' => $result['appointment_time'],
                'store'  => $result['store'],
                'action' => '',
            );
        }

        $appointment_total = $this->model_appointment_appointment->getTotalAppointments();

        $pagination = new Pagination();
        $pagination->total = $appointment_total;
        $pagination->page = $page;
        $pagination->limit = 10;
        $pagination->url = $this->url->link('account/transaction', 'page={page}', 'SSL');

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($appointment_total) ? (($page - 1) * 10) + 1 : 0, ((($page - 1) * 10) > ($appointment_total - 10)) ? $appointment_total : ((($page - 1) * 10) + 10), $appointment_total, ceil($appointment_total / 10));

        $data['column_left'] = $this->load->controller('common/column_left');
        $data['column_right'] = $this->load->controller('common/column_right');
        $data['content_top'] = $this->load->controller('common/content_top');
        $data['content_bottom'] = $this->load->controller('common/content_bottom');
        $data['footer'] = $this->load->controller('common/footer');
        $data['header'] = $this->load->controller('common/header');

        if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/appointment/appointment_list')) {
            $this->response->setOutput($this->load->view($this->config->get('config_template') . '/template/appointment/appointment_list', $data));
        } else {
            $this->response->setOutput($this->load->view('default/template/appointment/appointment_list', $data));
        }
    }


    protected function getFormCustomer()
    {
        $data['heading_title'] = $this->language->get('heading_title');
        $data['entry_invoiceprefix'] = $this->language->get('entry_invoiceprefix');

        $data['text_form'] = !isset($this->request->get['clinical_sale_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');
        $data['text_enabled'] = $this->language->get('text_enabled');
        $data['text_disabled'] = $this->language->get('text_disabled');
        $data['text_yes'] = $this->language->get('text_yes');
        $data['text_no'] = $this->language->get('text_no');
        $data['text_select'] = $this->language->get('text_select');
        $data['text_none'] = $this->language->get('text_none');
        $data['text_place_holder_ic'] = $this->language->get('text_place_holder_ic');
        $data['text_place_holder_name'] = $this->language->get('text_place_holder_name');
        $data['text_place_holder_telephone'] = $this->language->get('text_place_holder_telephone');
        $data['text_place_holder_email'] = $this->language->get('text_place_holder_email');

        $data['filed_male'] = $this->language->get('text_male');
        $data['filed_female'] = $this->language->get('text_female');

        $data['entry_customer_ic']    = $this->language->get('entry_customer_ic');
        $data['entry_gender']   = $this->language->get('entry_gender');
        $data['entry_firstname'] = $this->language->get('entry_firstname');
        $data['entry_email'] = $this->language->get('entry_email');
        $data['entry_telephone'] = $this->language->get('entry_telephone');
        $data['entry_password'] = $this->language->get('entry_password');
        $data['entry_confirm'] = $this->language->get('entry_confirm');

        $data['button_continue'] = $this->language->get('button_continue');
        $data['button_clear'] = $this->language->get('button_clear');
        $data['button_back'] = $this->language->get('button_back');

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->error['customer_ic'])) {
            $data['error_customer_ic'] = $this->error['customer_ic'];
        } else {
            $data['error_customer_ic'] = '';
        }

        if (isset($this->error['email'])) {
            $data['error_email'] = $this->error['email'];
        } else {
            $data['error_email'] = '';
        }

        if (isset($this->error['firstname'])) {
            $data['error_firstname'] = $this->error['firstname'];
        } else {
            $data['error_firstname'] = '';
        }

        if (isset($this->error['phone_no'])) {
            $data['error_phone_no'] = $this->error['phone_no'];
        } else {
            $data['error_phone_no'] = '';
        }

        if (isset($this->error['password'])) {
            $data['error_password'] = $this->error['password'];
        } else {
            $data['error_password'] = '';
        }

        if (isset($this->error['confirm'])) {
            $data['error_confirm'] = $this->error['confirm'];
        } else {
            $data['error_confirm'] = '';
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/home')
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('appointment/appointment')
        );

        //success alert
        $data['success'] = isset($this->session->data['success']) ? $this->session->data['success'] : null;
        unset($this->session->data['success']);

        $data['action'] = $this->url->link('appointment/appointment');
        $data['back'] = $this->url->link('appointment/main');

        if (isset($this->request->post['firstname'])) {
            $data['firstname'] = $this->request->post['firstname'];
        } else {
            $data['firstname'] = '';
        }

        if (isset($this->request->post['gender'])) {
            $data['gender'] = $this->request->post['gender'];
        } else {
            $data['gender'] = 1;
        }

        if (isset($this->request->post['customer_ic'])) {
            $data['customer_ic'] = $this->request->post['customer_ic'];
        } else {
            $data['customer_ic'] = '';
        }

        if (isset($this->request->post['email'])) {
            $data['email'] = $this->request->post['email'];
        } else {
            $data['email'] = '';
        }

        if (isset($this->request->post['telephone'])) {
            $data['telephone'] = $this->request->post['telephone'];
        } else {
            $data['telephone'] = '';
        }

        if (isset($this->request->post['password'])) {
            $data['password'] = $this->request->post['password'];
        } else {
            $data['password'] = '';
        }

        if (isset($this->request->post['confirm'])) {
            $data['confirm'] = $this->request->post['confirm'];
        } else {
            $data['confirm'] = '';
        }

        $data['column_left'] = $this->load->controller('common/column_left');
        $data['column_right'] = $this->load->controller('common/column_right');
        $data['content_top'] = $this->load->controller('common/content_top');
        $data['content_bottom'] = $this->load->controller('common/content_bottom');
        $data['footer'] = $this->load->controller('common/footer');
        $data['header'] = $this->load->controller('common/header');

        if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/appointment/appointment_customer_form')) {
            $this->response->setOutput($this->load->view($this->config->get('config_template') . '/template/appointment/appointment_customer_form', $data));
        } else {
            $this->response->setOutput($this->load->view('default/template/appointment/appointment_customer_form', $data));
        }
    }

    protected function validateFormAppointment()
    {
        $customer_id = $this->get_customer_id($this->request->get['access_token']);

        $doctor_id = isset($this->request->post['doctor']) ? $this->request->post['doctor'] : null;

        if ($this->model_appointment_appointment->isNewCustomer($customer_id)) {
            if ((utf8_strlen($this->request->post['doctor']) < 1)) {
                $this->error['warning'] = $this->language->get('error_doctor');
            }
        }

        if ((utf8_strlen($this->request->post['date']) < 1)) {
            $this->error['name']['date'] = $this->language->get('error_date');
        }

        if (strtotime($this->request->post['date']) < strtotime(date('Y-m-d'))) {
            $this->error['name']['date'] = $this->language->get('error_date_less');
        }

        $user_holiday = $this->model_appointment_appointment->checkUserHoliday($doctor_id);
        $store_holiday = $this->model_appointment_appointment->checkStoreHoliday($this->config->get('store_id'));

        $check_booked = $this->model_appointment_appointment->checkBooked($doctor_id, $this->request->post['date'], $this->request->post['time']);

        if (!empty($check_booked)) {
            if ($doctor_id > 0) {
                $this->error['name']['time'] = $this->language->get('error_time_booked');
            }
        }

        foreach ($user_holiday as $holiday) {
            $dates = $this->createDateRangeArray($holiday['start'], $holiday['end']);
            if (in_array($this->request->post['date'], $dates)) {
                $this->error['name']['date'] = $this->language->get('error_date_unavailable');
            }
        }

        foreach ($store_holiday as $holiday) {
            $dates = $this->createDateRangeArray($holiday['start'], $holiday['end']);
            if (in_array($this->request->post['date'], $dates)) {
                $this->error['name']['date'] = $this->language->get('error_date_unavailable');
            }
        }

        if ((utf8_strlen($this->request->post['time']) < 1)) {
            $this->error['name']['time'] = $this->language->get('error_time');
        }

        // if ((utf8_strlen($this->request->post['status']) < 1)) {
        //     $this->error['name']['status'] = $this->language->get('error_status');
        // }

        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }

    protected function validateCustomerForm()
    {
        //** validation function
        function validIsNullOrEmpty($str)
        {
            $str = trim($str);
            return empty($str);
        }
        function validStrLen($str, $min, $max)
        {
            return (utf8_strlen($str) > $min && utf8_strlen($str) < $max);
        }
        function validIsNumeric($str)
        {
            return is_numeric($str);
        }
        function validIsEmail($str)
        {
            return filter_var($str, FILTER_VALIDATE_EMAIL);
        }
        function validIsDate($str)
        {
            $d = DateTime::createFromFormat('Y-m-d', $str);
            return $d && $d->format('Y-m-d') == $str;
        }

        if ((utf8_strlen($this->request->post['firstname']) < 1) || (utf8_strlen(trim($this->request->post['firstname'])) > 32)) {
            $this->error['firstname'] = $this->language->get('error_firstname');
        }

        if ((utf8_strlen($this->request->post['telephone']) < 3) || (utf8_strlen($this->request->post['telephone']) > 32)) {
            $this->error['telephone'] = $this->language->get('error_telephone');
        }

        if ((utf8_strlen($this->request->post['email']) < 3) || (utf8_strlen($this->request->post['email']) > 32)) {
            $this->error['email'] = $this->language->get('error_email');
        }


        $validate_ic = $this->model_appointment_appointment->customerExistsByIc($this->request->post['customer_ic']);

        if ((utf8_strlen($this->request->post['customer_ic']) < 3) || (utf8_strlen($this->request->post['customer_ic']) > 32)) {
            $this->error['customer_ic'] = $this->language->get('error_customer_ic');
        } elseif (!empty($validate_ic)) {
            $this->error['customer_ic'] = $this->language->get('error_ic_exists');
        }

        // if ((utf8_strlen($this->request->post['email']) > 0)) {
        //     if (!preg_match('/^[^\@]+@.*\.[a-z]{2,6}$/i', $this->request->post['email'])) {
        //         $this->error['email'] = $this->language->get('error_email');
        //     }
        // }


        if (!empty($this->request->post['email'])) {
            if ((utf8_strlen($this->request->post['email']) > 96) || !filter_var($this->request->post['email'], FILTER_VALIDATE_EMAIL)) {
                $this->error['email'] = $this->language->get('error_email');
            }
        }


        if ($this->request->post['password'] || (!isset($this->request->get['customer_id']))) {
            if ((utf8_strlen($this->request->post['password']) < 4) || (utf8_strlen($this->request->post['password']) > 20)) {
                $this->error['password'] = $this->language->get('error_password');
            }

            if ($this->request->post['password'] != $this->request->post['confirm']) {
                $this->error['confirm'] = $this->language->get('error_confirm');
            }
        }

        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }

   protected function validateCustomerPage()
   {
       if ((utf8_strlen($this->request->post['firstname']) < 1) || (utf8_strlen(trim($this->request->post['firstname'])) > 32)) {
           $this->error['firstname'] = $this->language->get('error_firstname');
       }

       // var_dump($this->error['firstname']);
       // die();

       if ((utf8_strlen($this->request->post['phone_no']) < 3) || (utf8_strlen($this->request->post['phone_no']) > 32)) {
           $this->error['phone_no'] = $this->language->get('error_telephone');
       }

       if ((utf8_strlen($this->request->post['email']) < 3) || (utf8_strlen($this->request->post['email']) > 32)) {
           $this->error['email'] = $this->language->get('error_email');
       }


       if (!empty($this->request->post['email'])) {
           if ((utf8_strlen($this->request->post['email']) > 96) || !filter_var($this->request->post['email'], FILTER_VALIDATE_EMAIL)) {
               $this->error['email'] = $this->language->get('error_email');
           }
       }

       // $validate_ic = $this->model_appointment_appointment->customerExistsByIc($this->request->post['customer_ic']);

       // if ((utf8_strlen($this->request->post['customer_ic']) < 3) || (utf8_strlen($this->request->post['customer_ic']) > 32)) {
        //     $this->error['customer_ic'] = $this->language->get('error_customer_ic');
       // } elseif (!empty($validate_ic)) {
        //     $this->error['customer_ic'] = $this->language->get('error_ic_exists');
       // }

       if ($this->error && !isset($this->error['warning'])) {
           $this->error['warning'] = $this->language->get('error_warning');
       }

       return !$this->error;
   }

    public function getService()
    {
        $json = array();

        $this->load->model('appointment/appointment');

        if (isset($this->request->get['service_id'])) {
            $service_id = $this->request->get['service_id'];
        } else {
            $service_id = '';
        }

        $json = $this->model_appointment_appointment->getService($service_id);

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function getDoctors()
    {
        $json = array();

        $this->load->model('appointment/appointment');

        if (isset($this->request->get['service_id'])) {
            $service_id = $this->request->get['service_id'];
        } else {
            $service_id = '';
        }


        $doctors= array();
        $result = $this->model_appointment_appointment->getService($service_id);

        if (!empty($result)) {
            $data = array(
            'doctor_id' =>  unserialize($result['doctor_id']),
            );

            // var_dump($data['services']);
            // die();

            $doctors = $this->model_appointment_appointment->getDoctors($data);
        }
        // var_dump($doctors);
        // die();

        $results =array();
        if (!empty($doctors)) {
            $this->load->model('tool/image');

            foreach ($doctors as $doctor) {
                if (!empty($doctor['image'])) {
                    $image =  $this->model_tool_image->resize($doctor['image'], 100, 100);
                } else {
                    $image = $this->model_tool_image->resize('catalog/logo/etcm_logo30.png', 100, 100);
                }


                $results[] = array(
                    'user_id'		=> $doctor['user_id'],
                    'doctor_name'	=> $doctor['firstname'] . ' ' . $doctor['lastname'],
                    'chinese_name' =>$doctor['chinesename'],
                    'image'			=> $image
                );

                // var_dump($data['doctors']);
                // die();
            }
        }




        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($results));
    }

    public function getTimes()
    {
        $json = array();

        $this->load->model('appointment/appointment');

        if (isset($this->request->get['date'])) {
            $date = date('l', strtotime($this->request->get['date']));
        } else {
            $date = '';
        }


        if (isset($this->request->get['doctor_id'])) {
            $doctor_id = $this->request->get['doctor_id'];
        } else {
            $doctor_id = 0;
        }

        if (isset($this->request->get['time'])) {
            $getTime = $this->request->get['time'];
        } else {
            $getTime = '';
        }

        $url='';
        if (isset($this->request->get['time'])) {
            $url .= '&time=' . $this->request->get['time'];
        }



        $data['time_selected'] = $getTime;

        $times = $this->model_appointment_appointment->getTimes($date, $doctor_id);

        if (!empty($times)) {
            foreach ($times as $time) {
                if (!empty($time['start_time']) && !empty($time['end_time'])) {
                    $temp = strtotime($time['start_time']);
                    array_push($json, date('h:i A', $temp));
                    while (strtotime($time['end_time']) > $temp) {
                        $temp = $temp + ($time['minutes'] * 60);
                        $temp2 = $temp + ($time['minutes'] * 60);
                        if ($temp2 <= strtotime($time['end_time'])) {
                            array_push($json, date('h:i A', $temp));
                        }
                    }
                }
            }
        } else {
            $json = array();
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function getServiceTimes()
    {
        $json = array();

        $this->load->model('appointment/appointment');

        if (isset($this->request->get['date'])) {
            $date = date('l', strtotime($this->request->get['date']));
        } else {
            $date = '';
        }

        if (isset($this->request->get['service_id'])) {
            $service_id = $this->request->get['service_id'];
        } else {
            $service_id = 0;
        }

        if (isset($this->request->get['time'])) {
            $getTime = $this->request->get['time'];
        } else {
            $getTime = '';
        }

        $url='';
        if (isset($this->request->get['time'])) {
            $url .= '&time=' . $this->request->get['time'];
        }



        $data['time_selected'] = $getTime;

        $times = $this->model_appointment_appointment->getServiceTimes($date, $service_id);

        foreach ($times as $doctor_times) {
            foreach ($doctor_times as $time) {
                if (!empty($time['start_time']) && !empty($time['end_time'])) {
                    $temp = strtotime($time['start_time']);
                    array_push($json, date('h:i A', $temp));
                    while (strtotime($time['end_time']) > $temp) {
                        $temp = $temp + ($time['minutes'] * 60);
                        $temp2 = $temp + ($time['minutes'] * 60);
                        if ($temp2 <= strtotime($time['end_time'])) {
                            array_push($json, date('h:i A', $temp));
                        }
                    }
                }
            }
        }

        $json_unique = array_unique($json);

        $timestamp = array();

        foreach ($json_unique as $key => $unique) {
            $timestamp[] = strtotime($unique);
        }

        sort($timestamp);

        foreach ($timestamp as $key => $time) {
            $time_format[] = date('h:i A', $time);
        }

        unset($json);

        if (!empty($time_format)) {
            $new_format = array();

            $time_zones = $this->config->get('config_time_zone');
            date_default_timezone_set($time_zones);

            $current_time = date('h:i A', time());
            $today_date = date('Y-m-d');
            $current_timestamp = strtotime($current_time);

            if ($today_date == $this->request->get['date']) {
                foreach ($time_format as $time) {
                    $timestamp = strtotime($time);

                    if ($timestamp > $current_timestamp) {
                        $new_format[] = $time;
                    }
                }
            } else {
                $new_format = $time_format;
            }

            $json = $new_format;
        } else {
            $json = [];
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function customfield()
    {
        $this->load->model('appointment/appointment');

        $json = array();

        // Customer Group
        if (isset($this->request->get['customer_group_id'])) {
            $customer_group_id = $this->request->get['customer_group_id'];
        } else {
            $customer_group_id = $this->config->get('config_customer_group_id');
        }

        $custom_fields = $this->model_appointment_appointment->getCustomFields(array('filter_customer_group_id' => $customer_group_id));

        foreach ($custom_fields as $custom_field) {
            $json[] = array(
                'custom_field_id' => $custom_field['custom_field_id'],
                'required'        => empty($custom_field['required']) || $custom_field['required'] == 0 ? false : true
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function searchCustomer()
    {
        //$this->load->language('sale/customer');
        $this->load->model('appointment/appointment');

        $this->load->library('pos_cart'); //
        $this->cart = new Pos_cart($this->registry);

        if (isset($this->request->post['customer_card'])) {
            $data['customer_card'] = $this->request->post['customer_card'];
        }
        if (isset($this->request->post['customer_ic'])) {
            $data['customer_ic'] = $this->request->post['customer_ic'];
        }

        if (isset($this->request->post['telephone_no'])) {
            $data['telephone_no'] = $this->request->post['telephone_no'];
        }

        $json['shipping'][] = array();
        $json = $this->model_appointment_appointment->selectCustomers($data);
        $this->cart->clearService();
        $this->cart->clearHerbal();



        if (empty($json)) {
            $json['errors'] = $this->language->get('error_not_exists');
        } else {
            $json['success']  = "Member Details";
        }
        return $this->response->setOutput(json_encode($json));
    }

    public function createDateRangeArray($strDateFrom, $strDateTo)
    {
        $aryRange=array();

        $iDateFrom=mktime(1, 0, 0, substr($strDateFrom, 5, 2), substr($strDateFrom, 8, 2), substr($strDateFrom, 0, 4));
        $iDateTo=mktime(1, 0, 0, substr($strDateTo, 5, 2), substr($strDateTo, 8, 2), substr($strDateTo, 0, 4));

        if ($iDateTo>=$iDateFrom) {
            array_push($aryRange, date('Y-m-d', $iDateFrom)); // first entry
            while ($iDateFrom<$iDateTo) {
                $iDateFrom+=86400; // add 24 hours
                array_push($aryRange, date('Y-m-d', $iDateFrom));
            }
        }

        return $aryRange;
    }

    public function get_customer_id($access_token)
    {
        $this->load->model('appointment/appointment');

        $customer = $this->model_appointment_appointment->check_unique_id($access_token);

        if (!empty($customer)) {
            return $customer['customer_id'];
        }
    }

    private function print_array($arr)
    {
        echo '<pre>';
        print_r($arr);
        echo '</pre>';
    }

    public function getUnavailableDate()
    {
        $json = [];
        $final_date = [];
        $compare_date_range = [];

        $this->load->model('appointment/appointment');

        $doctor_id = isset($this->request->post['doctor_id']) ? (int) $this->request->post['doctor_id'] : false;
        $month = isset($this->request->post['month']) ? $this->request->post['month'] : false;

        $time_zone = $this->config->get('config_time_zone');
        date_default_timezone_set($time_zone);

        $today_date = date('Y-m-d');
        $today_timestamp = strtotime($today_date);

        if ($doctor_id) {
            $doctor_holidays = $this->model_appointment_appointment->checkUserHoliday($doctor_id);
        } else {
            $doctor_holidays = [];
        }

        $store_id = 0;

        $store_holiday = $this->model_appointment_appointment->checkStoreHoliday($store_id);

        $date_range = $this->createDateRangeByMonthYearArray(date('n', strtotime($month)), date('Y', strtotime($month)));

        if (!empty($date_range)) {
            $one_month_later_timestamp = strtotime('+1 month', $today_timestamp);

            foreach ($date_range as $date) {
                $date_timestamp = strtotime($date);

                if ($today_timestamp > $date_timestamp) {
                    $compare_date_range[] = date('Y-m-d', $date_timestamp);
                }

                if ($date_timestamp > $one_month_later_timestamp) {
                    $compare_date_range[] = date('Y-m-d', $date_timestamp);
                }
            }

            if (!empty($doctor_holidays)) {
                foreach ($doctor_holidays as $holiday) {
                    $holiday_date_range = $this->createDateRangeArray($holiday['start'], $holiday['end']);

                    if (!empty($holiday_date_range)) {
                        foreach ($holiday_date_range as $date) {
                            if (in_array($date, $date_range)) {
                                $compare_date_range[] = $date;
                            }
                        }
                    }
                }
            }

            if (!empty($store_holiday)) {
                foreach ($store_holiday as $holiday) {
                    $holiday_date_range = $this->createDateRangeArray($holiday['start'], $holiday['end']);

                    if (!empty($holiday_date_range)) {
                        foreach ($holiday_date_range as $date) {
                            if (in_array($date, $date_range)) {
                                $compare_date_range[] = $date;
                            }
                        }
                    }
                }
            }

            foreach ($date_range as $date) {
                $date_range_day = date('l', strtotime($date));

                if ($doctor_id) {
                    $appointment_availability_time = $this->model_appointment_appointment->getDoctorAvailabilityTime($doctor_id, $date_range_day);

                    if (empty($appointment_availability_time)) {
                        $compare_date_range[] = $date;
                    }
                }
            }

            $compare_date_range = array_unique($compare_date_range);

            if (!empty($compare_date_range)) {
                foreach ($compare_date_range as $date) {
                    $day = date('l', strtotime($date));

                    $final_date[] = [
                        'date' => $date,
                        'day' => $day
                    ];
                }

                $date_column = array_column($final_date, 'date');
                $date_column = array_map('strtotime', $date_column);

                array_multisort($final_date, SORT_NUMERIC, $date_column, SORT_ASC);
            }
        }

        if (!empty($final_date)) {
            $json = $final_date;
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function createDateRangeByMonthYearArray($month, $year)
    {
        $aryRange = [];

        for ($day = 1; $day <= 31; $day++) {
            $time = mktime(12, 0, 0, $month, $day, $year);

            if (date('m', $time) == $month) {
                $aryRange[] = date('Y-m-d', $time);
            }
        }

        $num_of_days = count($aryRange);
        $last_day_element = $num_of_days - 1;

        $first_day = $aryRange[0];
        $first_day_timestamp = strtotime($first_day);

        $last_day = $aryRange[$last_day_element];
        $last_day_timestamp = strtotime($last_day);

        $one_day_later = date('Y-m-d', strtotime('+1 day', $last_day_timestamp));
        $two_weeks_later = date('Y-m-d', strtotime('+2 weeks', $last_day_timestamp));

        $one_day_before = date('Y-m-d', strtotime('-1 day', $first_day_timestamp));
        $two_weeks_before = date('Y-m-d', strtotime('-2 weeks', $first_day_timestamp));

        $days_later = $this->createDateRangeArray($one_day_later, $two_weeks_later);
        $days_before = $this->createDateRangeArray($two_weeks_before, $one_day_before);

        $aryRange = array_merge($aryRange, $days_before, $days_later);

        $date_column = array_map('strtotime', $aryRange);
        array_multisort($aryRange, SORT_NUMERIC, $date_column, SORT_ASC);

        return $aryRange;
    }

    public function addAppointment()
    {
        $this->load->language('appointment/appointment');


        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('tool/image');
        $this->load->model('appointment/appointment');


        $this->document->addStyle('catalog/view/theme/default/stylesheet/appointment_appointment.css?v='.time());

        $this->document->addStyle('catalog/view/javascript/jquery/datetimepicker/bootstrap-datetimepicker.min.css');
        $this->document->addScript('catalog/view/javascript/jquery/datetimepicker/moment.js');
        $this->document->addScript('catalog/view/javascript/jquery/datetimepicker/bootstrap-datetimepicker.min.js');
        $this->document->addStyle('catalog/view/theme/default/stylesheet/fullcalendar.min.css');
        $this->document->addScript('catalog/view/javascript/fullcalendar.min.js');


        if (isset($this->request->get['doctor_id'])) {
            $doctor_id = $this->request->get['doctor_id'];
        } else {
            $doctor_id = '';
        }

        if (isset($this->request->get['service'])) {
            $service = $this->request->get['service'];
        } else {
            $service = '';
        }


        if (isset($this->request->get['date'])) {
            $date = $this->request->get['date'];
        } else {
            $date = date('Y-m-d');
        }

        if (isset($this->request->get['time'])) {
            $time = $this->request->get['time'];
        } else {
            $time = '';
        }

        $url = '';


        if (isset($this->request->get['doctor_id'])) {
            $url .= '&doctor_id=' . $this->request->get['doctor_id'];
        }

        if (isset($this->request->get['service'])) {
            $url .= '&service=' . $this->request->get['service'];
        }


        if (isset($this->request->get['date'])) {
            $url .= '&date=' . $this->request->get['date'];
        }

        if (isset($this->request->get['time'])) {
            $url .= '&time=' . $this->request->get['time'];
        }


        $data['doctor_id'] = $doctor_id;
        $data['clinicalservice_id'] = $service;
        $data['date_clicked'] = $date;
        $data['time_selected'] = $time;


        $result =array();
        $doctors = $this->model_appointment_appointment->getDoctor($doctor_id);



        $data['services'] = $this->model_appointment_appointment->getServices();


        foreach ($data['services'] as $service) {
            $doctor_ids = unserialize($service['doctor_id']);


            if (in_array($doctor_id, $doctor_ids)) {
                $result[]= $service;
            }
        }

        $data['services'] = $result;

        $data['hide_header'] 	= isset($this->request->get['hide_header']) ? $this->request->get['hide_header'] : null;




        $data['footer'] = $this->load->controller('common/footer');
        $data['header'] = $this->load->controller('common/header');
        // $data['button_next'] =$this->url->link('appointment/appointment/nextButton');

        $this->response->setOutput($this->load->view('default/template/appointment/doctor_page1', $data));
    }


 public function confirm_appointment()
 {
     $this->load->language('appointment/appointment');

     $this->document->addStyle('catalog/view/theme/default/stylesheet/appointment_appointment.css?v='.time());

     $this->document->setTitle($this->language->get('heading_title'));

     $this->load->model('appointment/view');
     $this->load->model('appointment/appointment');


     if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateCustomerPage()) {
         $customer_info = $this->model_appointment_appointment ->customerExistsByIc($this->request->post['customer_ic']);

         $telephone = !empty($this->request->post['phone_no']) ? $this->request->post['phone_no'] : '';
         $email = !empty($this->request->post['email']) ? $this->request->post['email'] : '';

         if (!empty($telephone) && ($email)) {
             if (empty($customer_info)) {
                 $customer_info = $this->model_appointment_appointment->customerExistsByPhoneAndEmail($this->request->post['phone_no'], $this->request->post['email']);
             }
         }

         // if (empty($customer_info)) {
            //     $data['customer_id'] = $this->model_appointment_appointment->addCustomerAppointment($this->request->post);
            //     $data['email'] = $this->request->post['email'];
            //     $data['firstname'] = $this->request->post ['firstname'];
            //     $data['phone_no'] = $this->request->post ['phone_no'];
            //     $data['customer_ic'] = $this->request->post ['customer_ic'];
         // } else {
            //     $data['customer_id'] = $customer_info['customer_id'];
            //     $data['email'] =$customer_info['email'];
            //     $data['firstname'] =$customer_info['firstname'];
            //     $data['phone_no'] = $customer_info['telephone'];
            //     $data['customer_ic'] = $customer_info['customer_ic'];
         // }

         $data['customer_id']= 0;
         $data['date'] = isset($this->request->post['date']) ? $this->request->post['date'] : '';

         $data['time'] = isset($this->request->post['time']) ? date('h:i A', strtotime($this->request->post['time'])) : '';

         $data['got_doctor_id'] = isset($this->request->post['doctor_id']) ? true : false;
         $data['doctor_id'] = isset($this->request->post['doctor_id']) ? $this->request->post['doctor_id'] : 0;

         $data['service'] = isset($this->request->post['service']) ? $this->request->post['service'] : 0;

         $data['remark'] = isset($this->request->post['remark']) ? $this->request->post['remark'] : '';

         $data['firstname'] = isset($this->request->post['firstname']) ? $this->request->post['firstname'] : '';

         $data['email'] = isset($this->request->post['email']) ? $this->request->post['email'] : '';

         $data['phone_no'] = isset($this->request->post['phone_no']) ? $this->request->post['phone_no'] : '';


         $appointment_data = $this->model_appointment_appointment->addAppointmentData($data);

         $store = $this->model_appointment_appointment->getStore($appointment_data);

         if ($store) {
             $store_name = $store['name'];
         } else {
             $store_name = $this->config->get('config_name');
         }

         if ($appointment_data) {
             $appointment_info = $this->model_appointment_appointment->getAppointment($appointment_data);

             //doctor
             $doctor_id = $appointment_info['doctor_id'];

             if ($doctor_id != 0) {
                 $doctor_data = $this->model_appointment_appointment->getDoctor($doctor_id);
                 $doctor_name = $doctor_data['firstname'] . ' ' . $doctor_data['lastname'];
             }

             //customer
             $customer_id = $appointment_info['customer_id'];
             $email = $appointment_info['email'];
             $phone = $appointment_info['telephone'];

             $this->load->model('account/customer');
             $customer_data =  $this->model_appointment_appointment->getCustomerData($email, $phone);

             $customer_name = $customer_data['customer_name'];

             //service
             $service_name = $appointment_info['service_name'];

             // send email
             if ((!empty($appointment_info['email'])) || ($appointment_info['email'] != '-')) {
                 $subject = sprintf($this->language->get('text_subject'), $store_name);
                 $admin_subject = sprintf($this->language->get('text_subject_admin'), $customer_name, $appointment_data);

                 $appointment_details = array();

                 if (is_file(DIR_IMAGE . $this->config->get('config_logo'))) {
                     $appointment_details['image'] = HTTPS_IMAGE . $this->config->get('config_logo');
                 } else {
                     $appointment_details['image'] = '';
                 }

                 if (!empty($doctor_name)) {
                     $appointment_details['doctor_name'] = $doctor_name;
                 } else {
                     $appointment_details['doctor_name'] = '';
                 }

                 if (!empty($customer_name)) {
                     $appointment_details['customer_name'] = $customer_name;
                 } else {
                     $appointment_details['customer_name'] = '';
                 }

                 if (!empty($service_name)) {
                     $appointment_details['service_name'] = $service_name;
                 } else {
                     $appointment_details['service_name'] = '';
                 }

                 $appointment_details['url'] = HTTPS_SERVER;

                 $appointment_details['appointment_date'] = $this->request->post['date'];
                 $appointment_details['appointment_time'] = $this->request->post['time'];
                 $appointment_details['store_name'] = $store_name;

                 $this->load->model('setting/setting');
                 $this->load->model('localisation/country');
                 $this->load->model('localisation/zone');
                 $store_id = $this->config->get('config_store_id');
                 $store_info = $this->model_setting_setting->getSetting('config', $store_id);
                 $country = $this->model_localisation_country->getCountry($store_info['config_country_id']);
                 $zone = $this->model_localisation_zone->getZone($store_info['config_zone_id']);

                 //address
                 $appointment_details['config_name'] = $store_info['config_name'];
                 $appointment_details['config_address'] = nl2br($store_info['config_address']);
                 $appointment_details['config_country'] = $country['name'];
                 $appointment_details['config_zone'] = $zone['name'];
                 $appointment_details['config_telephone'] = $store_info['config_telephone'];
                 $appointment_details['config_email'] = $store_info['config_email'];



                 // send email to customer
                 $message = $this->load->view('default/template/appointment/email', $appointment_details);
                 $message_admin = $this->load->view('default/template/appointment/email_admin', $appointment_details);


                 $mail = new Mail($this->config->get('config_mail_engine'));
                 $mail->parameter = $this->config->get('config_mail_parameter');
                 $mail->smtp_hostname = $this->config->get('config_mail_smtp_hostname');
                 $mail->smtp_username = $this->config->get('config_mail_smtp_username');
                 $mail->smtp_password = html_entity_decode($this->config->get('config_mail_smtp_password'), ENT_QUOTES, 'UTF-8');
                 $mail->smtp_port = $this->config->get('config_mail_smtp_port');
                 $mail->smtp_timeout = $this->config->get('config_mail_smtp_timeout');

                 if (!empty($this->request->post['email']) && filter_var($this->request->post['email'])) {
                     $mail->setTo($this->request->post['email']);
                     $mail->setFrom($this->config->get('config_email'));
                     $mail->setSender($store_name);
                     $mail->setSubject($subject);
                     $mail->setHtml($message);
                     $mail->send();
                 }


                 // send email to admin

                 $admin_mail = new Mail($this->config->get('config_mail_engine'));
                 $admin_mail->parameter = $this->config->get('config_mail_parameter');
                 $admin_mail->smtp_hostname = $this->config->get('config_mail_smtp_hostname');
                 $admin_mail->smtp_username = $this->config->get('config_mail_smtp_username');
                 $admin_mail->smtp_password = html_entity_decode($this->config->get('config_mail_smtp_password'), ENT_QUOTES, 'UTF-8');
                 $admin_mail->smtp_port = $this->config->get('config_mail_smtp_port');
                 $admin_mail->smtp_timeout = $this->config->get('config_mail_smtp_timeout');

                 if (!empty($this->request->post['email']) && filter_var($this->request->post['email'])) {
                     $admin_mail->setTo($this->request->post['email']);
                     $admin_mail->setFrom($this->config->get('config_email'));
                     $admin_mail->setSender($store_name);
                     $admin_mail->setSubject($subject);
                     $admin_mail->setHtml($message);
                     $admin_mail->send();
                 }

                 // send email to all additional alert email
                 $additional_emails = $this->config->get('config_mail_alert_email');

                 if (!empty($additional_emails)) {
                     $emails = explode(',', $additional_emails);

                     foreach ($emails as $email) {
                         $additional_mail = new Mail($this->config->get('config_mail'));
                         $additional_mail->setTo($email);
                         $additional_mail->setFrom($this->config->get('config_email'));
                         $additional_mail->setSender($customer_name);
                         $additional_mail->setSubject($admin_subject);
                         $additional_mail->setHtml($message_admin);
                         $additional_mail->send();
                     }
                 }

                 // admin web notification
                 $notification_data = [
                     'appointment_id'		=> $appointment_data,
                     'customer_name'			=> $appointment_details['customer_name'],
                     'doctor_name'			=> $appointment_details['doctor_name'],
                     'appointment_date'		=> $appointment_details['appointment_date'],
                     'appointment_time'		=> $appointment_details['appointment_time']
                 ];

                 $notification = new Notification($this->registry);

                 if (($notification->new_appointment_notification_status == '1') && ($notification->notification_status == '1')) {
                     $notification->add_notification('new_appointment_notification', $notification_data);
                 }
             }

             if ($doctor_id != 0) {
                 $notification_template = $this->config->get('config_gcm_appointment');

                 if ($notification_template['status'] == '1') {
                     $template_title = $notification_template['title'];
                     $template_message = $notification_template['message'];

                     $find_title = array(
                         '{customer_name}'
                     );

                     $customer_full_name = $customer_data['firstname'] . ' ' . $customer_data['lastname'];

                     $replace_title = array(
                         'customer_name'		=> $customer_full_name
                     );

                     $find_message = array(
                         '{appointment_date}'
                     );

                     $replace_message = array(
                         'appointment_date'		=> $appointment_info['appointment_date']
                     );

                     $notification_title = str_replace($find_title, $replace_title, $template_title);
                     $notification_message = str_replace($find_message, $replace_message, $template_message);

                     $notification_data = array(
                         'body'          => $notification_title,
                         'badge'         => 1,
                         'sound'         => 'ping.aiff'
                     );

                     $data = array(
                         'title' => $notification_title,
                         'message' => $notification_message,
                         'user_id' => $doctor_id,
                         'type' => 1 			// New appointment type
                     );

                     $doctor_device = $this->model_appointment_appointment->getDoctorDevice($doctor_id);

                     if (!empty($doctor_device)) {
                         $gcm = new GCM($this->registry);
                         $gcm 	->sendTo($gcm->get_user_token($doctor_id))
                                 ->setData($data)
                                 ->setIosNotification($notification_data)
                                 ->setContentAvailable(true)
                                 ->send();
                     }
                 }
             }
         }


         $data['hide_header'] 	= isset($this->request->get['hide_header']) ? $this->request->get['hide_header'] : null;

         if (!empty($data['hide_header'])) {
             $this->response->redirect($this->url->link('appointment/appointment/success', '&hide_header= 1', 'SSL'));
         } else {
             $this->response->redirect($this->url->link('appointment/appointment/success', '', 'SSL'));
         }
     }

     $this->getCustomerPage();
 }
 
 protected function getCustomerPage()
    {
        $data['heading_title'] = $this->language->get('heading_title');

        $data['error_not_found'] = $this->language->get('error_not_found');

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->error['customer_ic'])) {
            $data['error_customer_ic'] = $this->error['customer_ic'];
        } else {
            $data['error_customer_ic'] = '';
        }

        if (isset($this->error['email'])) {
            $data['error_email'] = $this->error['email'];
        } else {
            $data['error_email'] = '';
        }

        if (isset($this->error['firstname'])) {
            $data['error_firstname'] = $this->error['firstname'];
        } else {
            $data['error_firstname'] = '';
        }

        if (isset($this->error['phone_no'])) {
            $data['error_phone_no'] = $this->error['phone_no'];
        } else {
            $data['error_phone_no'] = '';
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/home')
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('appointment/appointment')
        );


        if (isset($this->request->post['firstname'])) {
            $data['firstname'] = $this->request->post['firstname'];
        } else {
            $data['firstname'] = '';
        }

        if (isset($this->request->post['gender'])) {
            $data['gender'] = $this->request->post['gender'];
        } else {
            $data['gender'] = 1;
        }

        if (isset($this->request->post['customer_ic'])) {
            $data['customer_ic'] = $this->request->post['customer_ic'];
        } else {
            $data['customer_ic'] = '';
        }

        if (isset($this->request->post['email'])) {
            $data['email'] = $this->request->post['email'];
        } else {
            $data['email'] = '';
        }

        if (isset($this->request->post['phone_no'])) {
            $data['phone_no'] = $this->request->post['phone_no'];
        } else {
            $data['phone_no'] = '';
        }


        if (isset($this->request->post['remark'])) {
            $data['remark'] = $this->request->post['remark'];
        } else {
            $data['remark'] = '';
        }

        if (isset($this->request->post['customer_id'])) {
            $data['customer_id'] = $this->request->post['customer_id'];
        } elseif (!empty($customer_info)) {
            $data['customer_id'] = $customer_info['customer_id'];
        } else {
            $data['customer_id'] = '';
        }

        if (isset($this->request->get['date'])) {
            $date = $this->request->get['date'];
        } else {
            $date = '0000-00-00';
        }

        if (isset($this->request->get['service'])) {
            $service_id = $this->request->get['service'];
        } else {
            $service_id = '0';
        }

        if (isset($this->request->get['time'])) {
            $time = $this->request->get['time'];
        } else {
            $time = '';
        }

        if (isset($this->request->get['doctor_id'])) {
            $doctor_id = $this->request->get['doctor_id'];
        } else {
            $doctor_id = 0;
        }



        $url = '';

        if (isset($this->request->get['date'])) {
            $url .= '&date=' . $this->request->get['date'];
        }

        if (isset($this->request->get['service'])) {
            $url .= '&service=' . $this->request->get['service'];
        }

        if (isset($this->request->get['time'])) {
            $url .= '&time=' . $this->request->get['time'];
        }

        if (isset($this->request->get['doctor_id'])) {
            $url .= '&doctor_id=' . $this->request->get['doctor_id'];
        }

        $service =  $this->model_appointment_appointment->getService($service_id);
        $doctor = $this->model_appointment_appointment->getDoctor($doctor_id);

        $data['date'] = $date;
        $data['time'] = $time;
        $data['service'] = $service_id;
        $data['service_name'] = $service['name'];
        $data['doctor_id'] = $doctor_id;
        $data['doctor_name'] = $doctor['firstname']. ' ' . $doctor['lastname'];


        $data['hide_header'] 	= isset($this->request->get['hide_header']) ? $this->request->get['hide_header'] : null;



        $data['column_left'] = $this->load->controller('common/column_left');
        $data['column_right'] = $this->load->controller('common/column_right');
        $data['content_top'] = $this->load->controller('common/content_top');
        $data['content_bottom'] = $this->load->controller('common/content_bottom');
        $data['footer'] = $this->load->controller('common/footer');
        $data['header'] = $this->load->controller('common/header');


        $this->response->setOutput($this->load->view('default/template/appointment/customer_info', $data));
    }

    // protected function getCustomerPage()
    // {
    //     $data['heading_title'] = $this->language->get('heading_title');

    //     $data['error_not_found'] = $this->language->get('error_not_found');

    //     if (isset($this->error['warning'])) {
    //         $data['error_warning'] = $this->error['warning'];
    //     } else {
    //         $data['error_warning'] = '';
    //     }

    //     if (isset($this->error['customer_ic'])) {
    //         $data['error_customer_ic'] = $this->error['customer_ic'];
    //     } else {
    //         $data['error_customer_ic'] = '';
    //     }

    //     if (isset($this->error['email'])) {
    //         $data['error_email'] = $this->error['email'];
    //     } else {
    //         $data['error_email'] = '';
    //     }

    //     if (isset($this->error['firstname'])) {
    //         $data['error_firstname'] = $this->error['firstname'];
    //     } else {
    //         $data['error_firstname'] = '';
    //     }

    //     if (isset($this->error['phone_no'])) {
    //         $data['error_phone_no'] = $this->error['phone_no'];
    //     } else {
    //         $data['error_phone_no'] = '';
    //     }

    //     $data['breadcrumbs'] = array();

    //     $data['breadcrumbs'][] = array(
    //         'text' => $this->language->get('text_home'),
    //         'href' => $this->url->link('common/home')
    //     );

    //     $data['breadcrumbs'][] = array(
    //         'text' => $this->language->get('heading_title'),
    //         'href' => $this->url->link('appointment/appointment')
    //     );


    //     if (isset($this->request->post['firstname'])) {
    //         $data['firstname'] = $this->request->post['firstname'];
    //     } else {
    //         $data['firstname'] = '';
    //     }

    //     if (isset($this->request->post['gender'])) {
    //         $data['gender'] = $this->request->post['gender'];
    //     } else {
    //         $data['gender'] = 1;
    //     }

    //     if (isset($this->request->post['customer_ic'])) {
    //         $data['customer_ic'] = $this->request->post['customer_ic'];
    //     } else {
    //         $data['customer_ic'] = '';
    //     }

    //     if (isset($this->request->post['email'])) {
    //         $data['email'] = $this->request->post['email'];
    //     } else {
    //         $data['email'] = '';
    //     }

    //     if (isset($this->request->post['phone_no'])) {
    //         $data['phone_no'] = $this->request->post['phone_no'];
    //     } else {
    //         $data['phone_no'] = '';
    //     }


    //     if (isset($this->request->post['remark'])) {
    //         $data['remark'] = $this->request->post['remark'];
    //     } else {
    //         $data['remark'] = '';
    //     }

    //     if (isset($this->request->post['customer_id'])) {
    //         $data['customer_id'] = $this->request->post['customer_id'];
    //     } elseif (!empty($customer_info)) {
    //         $data['customer_id'] = $customer_info['customer_id'];
    //     } else {
    //         $data['customer_id'] = '';
    //     }

    //     if (isset($this->request->get['date'])) {
    //         $date = $this->request->get['date'];
    //     } else {
    //         $date = '0000-00-00';
    //     }

    //     if (isset($this->request->get['service'])) {
    //         $service_id = $this->request->get['service'];
    //     } else {
    //         $service_id = '0';
    //     }

    //     if (isset($this->request->get['time'])) {
    //         $time = $this->request->get['time'];
    //     } else {
    //         $time = '';
    //     }

    //     if (isset($this->request->get['doctor_id'])) {
    //         $doctor_id = $this->request->get['doctor_id'];
    //     } else {
    //         $doctor_id = 0;
    //     }



    //     $url = '';

    //     if (isset($this->request->get['date'])) {
    //         $url .= '&date=' . $this->request->get['date'];
    //     }

    //     if (isset($this->request->get['service'])) {
    //         $url .= '&service=' . $this->request->get['service'];
    //     }

    //     if (isset($this->request->get['time'])) {
    //         $url .= '&time=' . $this->request->get['time'];
    //     }

    //     if (isset($this->request->get['doctor_id'])) {
    //         $url .= '&doctor_id=' . $this->request->get['doctor_id'];
    //     }

    //     $service =  $this->model_appointment_appointment->getService($service_id);

    //     $doctor = $this->model_appointment_appointment->getDoctor($doctor_id);

    //     $data['date'] = $date;
    //     $data['time'] = $time;
    //     $data['service'] = $service_id;
    //     $data['service_name'] = $service['name'];
    //     $data['doctor_id'] = $doctor_id;
    //     $data['doctor_name'] = $doctor['firstname']. ' ' . $doctor['lastname'];


    //     $data['hide_header'] 	= isset($this->request->get['hide_header']) ? $this->request->get['hide_header'] : null;



    //     $data['column_left'] = $this->load->controller('common/column_left');
    //     $data['column_right'] = $this->load->controller('common/column_right');
    //     $data['content_top'] = $this->load->controller('common/content_top');
    //     $data['content_bottom'] = $this->load->controller('common/content_bottom');
    //     $data['footer'] = $this->load->controller('common/footer');
    //     $data['header'] = $this->load->controller('common/header');


    //     $this->response->setOutput($this->load->view('default/template/appointment/customer_info', $data));
    // }

    public function edit()
    {
        $this->load->language('appointment/appointment');

        $this->document->addStyle('catalog/view/theme/default/stylesheet/appointment_appointment.css?v='.time());

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('tool/image');

        $this->document->addStyle('catalog/view/javascript/jquery/datetimepicker/bootstrap-datetimepicker.min.css');
        $this->document->addScript('catalog/view/javascript/jquery/datetimepicker/moment.js');
        $this->document->addScript('catalog/view/javascript/jquery/datetimepicker/bootstrap-datetimepicker.min.js');
        $this->document->addStyle('catalog/view/theme/default/stylesheet/fullcalendar.min.css');
        $this->document->addScript('catalog/view/javascript/fullcalendar.min.js');


        $this->load->model('appointment/appointment');

        if (isset($this->request->get['doctor_id'])) {
            $doctor_id = $this->request->get['doctor_id'];
        } else {
            $doctor_id =' ';
        }

        if (isset($this->request->get['service'])) {
            $service = $this->request->get['service'];
        } else {
            $service = '';
        }


        if (isset($this->request->get['date'])) {
            $date = $this->request->get['date'];
        } else {
            $date = date('Y-m-d');
        }

        if (isset($this->request->get['time'])) {
            $time = $this->request->get['time'];
        } else {
            $time = '';
        }

        $url = '';


        if (isset($this->request->get['doctor_id'])) {
            $url .= '&doctor_id=' . $this->request->get['doctor_id'];
        }

        if (isset($this->request->get['service'])) {
            $url .= '&service=' . $this->request->get['service'];
        }


        if (isset($this->request->get['date'])) {
            $url .= '&date=' . $this->request->get['date'];
        }

        if (isset($this->request->get['time'])) {
            $url .= '&time=' . $this->request->get['time'];
        }



        $data['services'] = $this->model_appointment_appointment->getServices();

        $doctors = $this->model_appointment_appointment->getDoctors();

        foreach ($doctors as $doctor) {
            if (!empty($doctor['image'])) {
                $image =  $this->model_tool_image->resize($doctor['image'], 100, 100);
            } else {
                $image = $this->model_tool_image->resize('catalog/logo/etcm_logo30.png', 100, 100);
            }


            $data['doctors'][] = array(
                'user_id'		=> $doctor['user_id'],
                'doctor_name'	=> $doctor['firstname'] . ' ' . $doctor['lastname'],
                'chinese_name' =>$doctor['chinesename'],
                'image'			=> $image
            );
        }


        $data['store_id'] = $this->config->get('config_store_id');

        /*echo '<pre>';
        print_r($data['doctors']);
        echo '</pre>';*/



        $data['doctor_id'] = $doctor_id;
        $data['clinicalservice_id'] = $service;
        $data['date_clicked'] = $date;
        $data['time_selected'] = $time;

        $data['heading_title'] = $this->language->get('heading_title');

        // $data['button_back'] = $this->language->get('button_back');

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/home')
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('appointment/appointment')
        );


        $data['error_name'] 	= isset($this->error['name']) ? $this->error['name'] : null;

        $data['column_left'] = $this->load->controller('common/column_left');
        $data['column_right'] = $this->load->controller('common/column_right');
        $data['content_top'] = $this->load->controller('common/content_top');
        $data['content_bottom'] = $this->load->controller('common/content_bottom');


        $data['footer'] = $this->load->controller('common/footer');
        $data['header'] = $this->load->controller('common/header');

        $this->response->setOutput($this->load->view('default/template/appointment/appointment', $data));
    }

    public function appointmentConfirm()
    {
        $this->load->language('appointment/appointment');

        $this->document->addStyle('catalog/view/theme/default/stylesheet/appointment_appointment.css?v='.time());

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('appointment/view');
        $this->load->model('appointment/appointment');


        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateCustomerPage()) {
            $customer_info = $this->model_appointment_appointment ->customerExistsByIc($this->request->post['customer_ic']);

            $telephone = !empty($this->request->post['phone_no']) ? $this->request->post['phone_no'] : '';
            $email = !empty($this->request->post['email']) ? $this->request->post['email'] : '';

            if (!empty($telephone) && ($email)) {
                if (empty($customer_info)) {
                    $customer_info = $this->model_appointment_appointment->customerExistsByPhoneAndEmail($this->request->post['phone_no'], $this->request->post['email']);
                }
            }

            // if (empty($customer_info)) {
            //     $data['customer_id'] = $this->model_appointment_appointment->addCustomerAppointment($this->request->post);
            //     $data['email'] = $this->request->post['email'];
            //     $data['firstname'] = $this->request->post ['firstname'];
            //     $data['phone_no'] = $this->request->post ['phone_no'];
            //     $data['customer_ic'] = $this->request->post ['customer_ic'];
            // } else {
            //     $data['customer_id'] = $customer_info['customer_id'];
            //     $data['email'] =$customer_info['email'];
            //     $data['firstname'] =$customer_info['firstname'];
            //     $data['phone_no'] = $customer_info['telephone'];
            //     $data['customer_ic'] = $customer_info['customer_ic'];
            // }


            $data['date'] = isset($this->request->post['date']) ? $this->request->post['date'] : '';

            $data['time'] = isset($this->request->post['time']) ? date('h:i A', strtotime($this->request->post['time'])) : '';

            $data['got_doctor_id'] = isset($this->request->post['doctor_id']) ? true : false;
            $data['doctor_id'] = isset($this->request->post['doctor_id']) ? $this->request->post['doctor_id'] : 0;

            $data['service'] = isset($this->request->post['service']) ? $this->request->post['service'] : 0;

            $data['remark'] = isset($this->request->post['remark']) ? $this->request->post['remark'] : '';

            $data['firstname'] = isset($this->request->post['firstname']) ? $this->request->post['firstname'] : '';

            $data['email'] = isset($this->request->post['email']) ? $this->request->post['email'] : '';

            $data['phone_no'] = isset($this->request->post['phone_no']) ? $this->request->post['phone_no'] : '';



            $appointment_id = $this->model_appointment_appointment->addDoctorAppointment($data);

            $this->response->redirect($this->url->link('appointment/appointment/success', '', 'SSL'));
        }

        $this->getCustomerPage1();
    }

    protected function getCustomerPage1()
    {
        $this->document->addStyle('catalog/view/theme/default/stylesheet/appointment_appointment.css?v='.time());

        $data['heading_title'] = $this->language->get('heading_title');

        $data['error_not_found'] = $this->language->get('error_not_found');

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->error['customer_ic'])) {
            $data['error_customer_ic'] = $this->error['customer_ic'];
        } else {
            $data['error_customer_ic'] = '';
        }

        if (isset($this->error['email'])) {
            $data['error_email'] = $this->error['email'];
        } else {
            $data['error_email'] = '';
        }

        if (isset($this->error['firstname'])) {
            $data['error_firstname'] = $this->error['firstname'];
        } else {
            $data['error_firstname'] = '';
        }

        if (isset($this->error['phone_no'])) {
            $data['error_telephone'] = $this->error['phone_no'];
        } else {
            $data['error_telephone'] = '';
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/home')
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('appointment/appointment')
        );


        if (isset($this->request->post['firstname'])) {
            $data['firstname'] = $this->request->post['firstname'];
        } else {
            $data['firstname'] = '';
        }

        if (isset($this->request->post['gender'])) {
            $data['gender'] = $this->request->post['gender'];
        } else {
            $data['gender'] = 1;
        }

        if (isset($this->request->post['customer_ic'])) {
            $data['customer_ic'] = $this->request->post['customer_ic'];
        } else {
            $data['customer_ic'] = '';
        }

        if (isset($this->request->post['email'])) {
            $data['email'] = $this->request->post['email'];
        } else {
            $data['email'] = '';
        }

        if (isset($this->request->post['telephone'])) {
            $data['telephone'] = $this->request->post['telephone'];
        } else {
            $data['telephone'] = '';
        }

        if (isset($this->request->post['customer_name'])) {
            $data['customer_name'] = $this->request->post['customer_name'];
        } else {
            $data['customer_name'] = '';
        }

        if (isset($this->request->post['remark'])) {
            $data['remark'] = $this->request->post['remark'];
        } else {
            $data['remark'] = '';
        }

        if (isset($this->request->post['customer_id'])) {
            $data['customer_id'] = $this->request->post['customer_id'];
        } elseif (!empty($customer_info)) {
            $data['customer_id'] = $customer_info['customer_id'];
        } else {
            $data['customer_id'] = '';
        }

        if (isset($this->request->get['date'])) {
            $date = $this->request->get['date'];
        } else {
            $date = '0000-00-00';
        }

        if (isset($this->request->get['service'])) {
            $service_id = $this->request->get['service'];
        } else {
            $service_id = '0';
        }

        if (isset($this->request->get['time'])) {
            $time = $this->request->get['time'];
        } else {
            $time = '';
        }

        if (isset($this->request->get['doctor_id'])) {
            $doctor_id = $this->request->get['doctor_id'];
        } else {
            $doctor_id = 0;
        }



        $url = '';

        if (isset($this->request->get['date'])) {
            $url .= '&date=' . $this->request->get['date'];
        }

        if (isset($this->request->get['service'])) {
            $url .= '&service=' . $this->request->get['service'];
        }

        if (isset($this->request->get['time'])) {
            $url .= '&time=' . $this->request->get['time'];
        }

        if (isset($this->request->get['doctor_id'])) {
            $url .= '&doctor_id=' . $this->request->get['doctor_id'];
        }

        $service =  $this->model_appointment_appointment->getService($service_id);
        $doctor = $this->model_appointment_appointment->getDoctor($doctor_id);


        $data['date'] = $date;
        $data['time'] = $time;
        $data['service'] = $service_id;
        $data['service_name'] = $service['name'];
        $data['doctor_id'] = $doctor_id;
        $data['doctor_name'] = $doctor['firstname']. ' ' . $doctor['lastname'];




        $data['column_left'] = $this->load->controller('common/column_left');
        $data['column_right'] = $this->load->controller('common/column_right');
        $data['content_top'] = $this->load->controller('common/content_top');
        $data['content_bottom'] = $this->load->controller('common/content_bottom');
        $data['footer'] = $this->load->controller('common/footer');
        $data['header'] = $this->load->controller('common/header');


        $this->response->setOutput($this->load->view('default/template/appointment/customer_info1', $data));
    }
}
