<?php

class ControllerAndroidUser extends Controller
{
    private $call_function;
    private $s;
    private $json;
    private $user_info;

    public function index()
    {
        //load model required
        $this->load->model('android/user');
        //load core api function
        require DIR_SYSTEM . "/library/start_api.php";
    }


    #region user function start
    protected function view_profile()
    {
        $profile_info = $this->getProfile();
        if (empty($profile_info)) {
            $output = $this->response->setResponse2(204, $this->response->noResponse(), "user not found", "profile");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setResponse2(204, $profile_info, "success", "profile");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_profile_form()
    {
        $result = [
            "form_fields" => [
                "professions" => $this->getProfessions(),
            ],
            "data" => $this->getProfile()
        ];
        $output = $this->response->setResponse2(204, $result, "success", "profile");
        $this->api->trackResponse($output);
        return;
    }

    protected function update_profile()
    {
        $json = $this->json;
        $json['user_id'] = $this->session->data['user_id'];
        $updated = $this->model_android_user->update_user($json);
        $result = [
            "form_fields" => [
                "professions" => $this->getProfessions(),
            ],
            "data" => $this->getProfile()
        ];
        if (empty($updated)) {
            $output = $this->response->setCachedResponse(400, $result, "failed", "user");
            $this->api->trackResponse($output);
            return;
        } else {
            $this->syncToEtcm();
            $output = $this->response->setCachedResponse(200, $result, 'success', "user");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_permissions()
    {
        $user_id = $this->session->data['user_id'];
        $user_info = $this->model_android_user->getUserInfo($user_id);
        $permission_list = array();

        $permission_list = $this->getPermissions($user_info["user_group_id"]);

        $output = $this->response->setCachedResponse(200, $permission_list, 'success', "user");
        $this->api->trackResponse($output);
        return;
    }

    protected function get_store_list()
    {
        $hosting = HTTPS_SERVER;
        $path = 'etcm/doctorapp/user/get_all_store';
        $phone_no = $this->session->data['user_info']['contactno'];
        $store_id = $this->session->data['store_id'];
        $data = array(
            "phone_no" => $phone_no,
            "store_id" => $store_id,
            "domain" => $hosting
        );
        $result = $this->connectCurl($path, $data);
        if (!empty($result)) {
            if (!empty($result['error'])) {
                $output = $this->response->setCachedResponse(400, [], $result['message'], "user");
                $this->api->trackResponse($output);
                return;
            } else {
                $output = $this->response->setCachedResponse(200, $result['response'], $result['message'], "user");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setCachedResponse(204, [], "API Connection Errors : Please check the internet connection or API connection!", "user");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function change_store()
    {
        $hosting = HTTPS_SERVER;
        $path = 'etcm/doctorapp/user/select_store';

        $json = $this->json;

        $domain_id = !empty($json['domain_id']) ? $json['domain_id'] : false;
        $user_id = !empty($json['user_id']) ? $json['user_id'] : false;
        $store_id = isset($json['store_id']) ? $json['store_id'] : false;
        $phone_no = $this->session->data['user_info']['contactno'];

        $device_id = isset($_SERVER['HTTP_DEVICE_ID']) ? $_SERVER['HTTP_DEVICE_ID'] : false;

        if ($device_id) {
            $device_info = $this->model_android_user->getDeviceInfo($device_id);
        }

        $firebase_token = !empty($device_info['fcm_token']) ? $device_info['fcm_token'] : null;
        $huawei_token = !empty($device_info['huawei_token']) ? $device_info['huawei_token'] : null;

        $data = array(
            "domain" => $hosting,
            "phone_no" => $phone_no,
            "domain_id" => $domain_id,
            "user_id" => $user_id,
            "store_id" => $store_id,
            "firebase_token" => $firebase_token,
            "huawei_token" => $huawei_token,
        );
        $result = $this->connectCurl($path, $data);
        if (!empty($result)) {
            if (!empty($result['error'])) {
                $output = $this->response->setCachedResponse(400, new stdClass(), $result['message'], "user");
                $this->api->trackResponse($output);
                return;
            } else {
                //if success changed store, delete device info from previous store to prevent notification
                if ($device_id) {
                    $this->deleteDevice($device_id);
                }
                $output = $this->response->setCachedResponse(200, $result['response'], $result['message'], "user");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setCachedResponse(204, new stdClass(), "API Connection Errors : Please check the internet connection or API connection!", "user");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function logout()
    {
        $device_id = isset($_SERVER['HTTP_DEVICE_ID']) ? $_SERVER['HTTP_DEVICE_ID'] : false;
        if ($device_id) {
            $this->model_android_user->deleteUserDeviceInfo($device_id);
        }
        $output = $this->response->setResponse2(200, true, "Successfully Log out", "logout");
        $this->api->trackResponse($output);
        return;
    }

    protected function update_firebase_token()
    {
        $device_id = isset($_SERVER['HTTP_DEVICE_ID']) ? $_SERVER['HTTP_DEVICE_ID'] : false;
        $firebase_token = !empty($this->request->get['firebase_token']) ? $this->request->get['firebase_token'] : false;
        if ($firebase_token && $device_id) {
            $this->model_android_user->updateFirebaseToken($device_id, $firebase_token);
            $output = $this->response->setResponse2(200, $this->response->noResponse(), "success", "notification");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setResponse2(400, $this->response->noResponse(), "firebase_token and device_id is required", "notification");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function update_huawei_token()
    {
        $device_id = isset($_SERVER['HTTP_DEVICE_ID']) ? $_SERVER['HTTP_DEVICE_ID'] : false;
        $huawei_token = !empty($this->request->get['huawei_token']) ? $this->request->get['huawei_token'] : false;
        if ($huawei_token && $device_id) {
            $this->model_android_user->updateHuaweiToken($device_id, $huawei_token);
            $output = $this->response->setResponse2(200, $this->response->noResponse(), "success", "notification");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setResponse2(400, $this->response->noResponse(), "huawei_token and device_id is required", "notification");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function upload_image()
    {
        $json = $this->json;
        $image_str = !empty($json['image']) ? $json['image'] : false;
        if ($image_str && !empty($this->session->data['user_info'])) {
            $user_info = $this->session->data['user_info'];
            $folder_name = "user_profile_picture/";
            $dest_folder_path = DIR_IMAGE . $folder_name;
            if (!file_exists($dest_folder_path)) {
                mkdir($dest_folder_path, 0777, true);
            }

            $img_decode = base64_decode($image_str);

            $info = getimagesizefromstring($img_decode);
            $ext = str_replace('image/', '.', $info['mime']);
            $dest_name = mb_substr($user_info['firstname'] . " " . $user_info['lastname'], 0, 10) . " " . time() . strtolower($ext);
            $dest_name = str_replace(" ", "_", $dest_name);


            $dest_path = $dest_folder_path . $dest_name;

            if (file_put_contents($dest_path, $img_decode)) {
                $img_url = $folder_name . $dest_name;
                $updated = $this->model_android_user->update_image($img_url, $user_info['user_id']);
                if (empty($updated)) {
                    unlink($dest_path);
                    $output = $this->response->setCachedResponse(400, new stdClass(), "image upload failed", "user");
                    $this->api->trackResponse($output);
                    return;
                } else {
                    $this->syncToEtcm();
                    $output = $this->response->setCachedResponse(200, new stdClass(), 'success', "user");
                    $this->api->trackResponse($output);
                    return;
                }
            }
            $output = $this->response->setCachedResponse(400, new stdClass(), "upload failed", "user");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setCachedResponse(400, new stdClass(), 'image required', "user");
            $this->api->trackResponse($output);
            return;
        }
    }

    public function refresh_token()
    {
        if (!empty($_SERVER['HTTP_AUTHORIZATION'])) {
            list($_SERVER['PHP_AUTH_USER'], $_SERVER['PHP_AUTH_PW']) = explode(':', base64_decode(substr($_SERVER['HTTP_AUTHORIZATION'], 6)));
        }
        $token = !empty($_SERVER['PHP_AUTH_PW']) ? $_SERVER['PHP_AUTH_PW'] : false;

        if ($token) {
            $token_info = $this->obfuscate->decrypt($token);
            if (!(is_array($token_info) && isset($token_info['expired']) && isset($token_info['user_name']) && isset($token_info['store_id']) && isset($token_info['user_id']))) {
                $output = $this->response->setResponse2(401,    $this->response->noResponse(), "Wrong authorization format");
                $this->api->trackResponse($output);
                return;
            }
            if (strtotime($token_info['expired']) < strtotime(date('Y-m-d H:i:s'))) {
                date_default_timezone_set("Asia/Kuala_Lumpur");
                $now = strtotime(date("Y-m-d H:i:s"));
                $expired_date = date("Y-m-d H:i:s", strtotime("+1 month", $now));
                $user_info = array(
                    'user_name' => $token_info['user_name'],
                    'store_id' => $token_info['store_id'],
                    'user_id' => $token_info['user_id'],
                    'expired' => $expired_date
                );
                $access_token = $this->obfuscate->encrypt($user_info);
                $output = $this->response->setResponse2(200, array("access_token" => $access_token, "expired_date" => $expired_date), "token_refresh", "login");
                $this->api->trackResponse($output);
                return;
            } else {
                $output = $this->response->setResponse2(200, $this->response->noResponse(), "token is still active");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setResponse2(401, $this->response->noResponse(), "no authorization found");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function set_pin()
    {
        $hosting = HTTPS_SERVER;
        $path = 'etcm/doctorapp/user/set_pin';

        $json = $this->json;

        $phone_no = $this->session->data['user_info']['contactno'];
        $pin_no = isset($json['pin_no']) ? $json['pin_no'] : false;


        $data = array(
            'domain'    => $hosting,
            'phone_no'  => $phone_no,
            'pin_no'    => $pin_no,
        );

        $result = $this->connectCurl($path, $data);
        if (!empty($result)) {
            if (!empty($result['error'])) {
                $output = $this->response->setCachedResponse(400, new stdClass(), $result['message'], "user");
                $this->api->trackResponse($output);
                return;
            } else {
                $output = $this->response->setCachedResponse(200, new stdClass(), $result['message'], "user");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setCachedResponse(204, new stdClass(), "API Connection Errors : Please check the internet connection or API connection!", "user");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function verify_pin()
    {
        $hosting = HTTPS_SERVER;
        $path = 'etcm/doctorapp/user/verify_pin';

        $json = $this->json;

        $phone_no = $this->session->data['user_info']['contactno'];
        $pin_no = isset($json['pin_no']) ? $json['pin_no'] : false;


        $data = array(
            'domain'    => $hosting,
            'phone_no'  => $phone_no,
            'pin_no'    => $pin_no,
        );

        $result = $this->connectCurl($path, $data);
        if (!empty($result)) {
            if (!empty($result['error'])) {
                $output = $this->response->setCachedResponse(400, new stdClass(), $result['message'], "user");
                $this->api->trackResponse($output);
                return;
            } else {
                $output = $this->response->setCachedResponse(200, new stdClass(), $result['message'], "user");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setCachedResponse(204, new stdClass(), "API Connection Errors : Please check the internet connection or API connection!", "user");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function reset_pin()
    {
        $hosting = HTTPS_SERVER;
        $path = 'etcm/doctorapp/user/send_reset_otp';

        $json = $this->json;

        $phone_no = $this->session->data['user_info']['contactno'];
        $app_code = isset($json['app_code']) ? $json['app_code'] : false;


        $data = array(
            'domain'    => $hosting,
            'phone_no'  => $phone_no,
            'app_code'    => $app_code,
        );

        $result = $this->connectCurl($path, $data);
        if (!empty($result)) {
            if (!empty($result['error'])) {
                $output = $this->response->setCachedResponse(400, new stdClass(), $result['message'], "user");
                $this->api->trackResponse($output);
                return;
            } else {
                $result['response']['phone_no'] = (string)$phone_no;
                $output = $this->response->setCachedResponse(200, $result['response'], $result['message'], "user");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setCachedResponse(204, new stdClass(), "API Connection Errors : Please check the internet connection or API connection!", "user");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function validate_reset_pin()
    {
        $hosting = HTTPS_SERVER;
        $path = 'etcm/doctorapp/user/validate_reset_otp';

        $json = $this->json;

        $phone_no = $this->session->data['user_info']['contactno'];
        $otp = isset($json['otp']) ? $json['otp'] : false;


        $data = array(
            'domain'    => $hosting,
            'phone_no'  => $phone_no,
            'otp'    => $otp,
        );

        $result = $this->connectCurl($path, $data);
        if (!empty($result)) {
            if (!empty($result['error'])) {
                $output = $this->response->setCachedResponse(400, new stdClass(), $result['message'], "user");
                $this->api->trackResponse($output);
                return;
            } else {
                $output = $this->response->setCachedResponse(200, new stdClass(), $result['message'], "user");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setCachedResponse(204, new stdClass(), "API Connection Errors : Please check the internet connection or API connection!", "user");
            $this->api->trackResponse($output);
            return;
        }
    }
    #endregion

    #region for etcm call
    public function get_stores()
    {
        if ($this->api->checkOrigin()) {
            $user_id = isset($this->request->post['user_id']) ? $this->request->post['user_id'] : 0;
            if ($user_id) {
                $user_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "user WHERE user_id = '" . (int)$user_id . "'  AND status = '1'");
                if ($user_query->num_rows) {
                    if (strtotime($user_query->row['periodto']) > strtotime(date("Y-m-d"))) {
                        $this->load->model('setting/store');
                        $stores = $this->model_setting_store->getStores();

                        $stores[] = array('store_id' => "0", 'name' => htmlspecialchars_decode($this->config->get('config_name')));


                        $user_store_ids = $this->model_android_user->getUserStores($user_id);
                        if (!empty($stores)) {
                            $result = array();
                            foreach ($stores as $store) {
                                if (in_array($store['store_id'], $user_store_ids)) {
                                    $result[] = array(
                                        "store_id" => $store['store_id'],
                                        "name" => $store['name']
                                    );
                                }
                            }
                            if (!empty($result)) {
                                $output = $this->response->setResponse(200, array("stores" => $result, "label" => htmlspecialchars_decode($this->config->get('config_name'))), "Success");
                                $this->api->trackResponse($output);
                                return;
                            } else {
                                $output = $this->response->setResponse(403, array(), "You dont have access to any store");
                                $this->api->trackResponse($output);
                                return;
                            }
                        } else {
                            $output = $this->response->setResponse(403, array(), "Not found");
                            $this->api->trackResponse($output);
                            return;
                        }
                    } else {
                        $output = $this->response->setResponse(403, array(), "Account is expired");
                        $this->api->trackResponse($output);
                        return;
                    }
                } else {
                    $output = $this->response->setResponse(404, array(), "User not found");
                    $this->api->trackResponse($output);
                    return;
                }
            } else {
                $output = $this->response->setResponse(400, array(), "Missing Parameter");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setResponse(401, array(), "UNAUTHORISED");
            $this->api->trackResponse($output);
            return;
        }
    }

    public function login()
    {
        if ($this->api->checkOrigin()) {

            $user_id   = isset($this->request->post['user_id']) ? $this->request->post['user_id'] : false;
            $store_id  = isset($this->request->post['store_id']) ? $this->request->post['store_id'] : false;
            $device_id  = isset($this->request->post['device_id']) ? $this->request->post['device_id'] : false;
            $firebase_token  = isset($this->request->post['firebase_token']) ? $this->request->post['firebase_token'] : null;
            $huawei_token  = isset($this->request->post['huawei_token']) ? $this->request->post['huawei_token'] : null;
            if ($user_id) {
                $permission_list = array();
                $user_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "user WHERE user_id = '" . (int)$user_id . "'  AND status = '1'");
                if ($user_query->num_rows) {
                    $store_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "user_to_store s  LEFT JOIN " . DB_PREFIX . "setting l ON  (s.store_id = l.store_id) WHERE s.user_id = '" . (int)$user_query->row['user_id'] . "' AND s.store_id ='" . $store_id . "' AND l.key= 'config_language' ");
                    if ($store_query->num_rows) {
                        if (strtotime($user_query->row['periodto']) > strtotime(date("Y-m-d"))) {
                            //todo save device info (fcm maybe)

                            //todo tracking

                            //get permission
                            $permission_list = $this->getPermissions($user_query->row["user_group_id"]);
                            date_default_timezone_set("Asia/Kuala_Lumpur");
                            $now = strtotime(date("Y-m-d H:i:s"));
                            $expired_date = date("Y-m-d H:i:s", strtotime("+1 month", $now));

                            $user_info = array(
                                'user_name' => $user_query->row['username'],
                                'store_id' => $store_id,
                                'user_id' => $user_id,
                                'expired' => $expired_date
                            );

                            $access_token = $this->obfuscate->encrypt($user_info);

                            $info = array(
                                "user_id" => $user_id,
                                "device_id" => $device_id,
                                "access_token" => $access_token,
                                "fcm_token" => $firebase_token,
                                "huawei_token" => $huawei_token
                            );

                            $this->model_android_user->updateUserDeviceInfo($info);

                            $result = array(
                                "name" => $user_query->row['firstname'] . " " . $user_query->row['lastname'],
                                "profile_image" => "https://www.etcm.me/image/catalog/default-user-july17.jpg",
                                "domain_url" => HTTPS_SERVER . "index.php",
                                "access_token" => $access_token,
                                "expired_date" => $expired_date,
                                "permissions" => $permission_list,
                            );
                            $this->response->setResponse(200, $result, "Login success");
                            return;
                        } else {
                            $this->response->setResponse(419, array(), "Account is expired");
                            return;
                        }
                    } else {
                        $this->response->setResponse(403, array(), "You don't have access for the store");
                        return;
                    }
                } else {
                    $this->response->setResponse(419, array(), "Account is not active");
                    return;
                }
            } else {
                $this->response->setResponse(400, array(), "Missing parameter");
                return;
            }
        } else {
            $this->response->setResponse(401, array(), "UNAUTHORISED");
            return;
        }
    }

    #endregion

    #region internal function
    private function deleteDevice($device_id)
    {
        if ($device_id) {
            $this->model_android_user->deleteUserDeviceInfo($device_id);
        }
    }

    private function getPermissions($user_group_id = 0)
    {
        if (!$user_group_id) {
            $user_group_id = isset($this->request->get['id']) ? $this->request->get['id'] : 0;
        }
        $result = array();

        $user_group_permission = $this->db->query("SELECT permission FROM " . DB_PREFIX . "user_group WHERE user_group_id = '" . (int) $user_group_id . "'");

        $result = json_decode($user_group_permission->row['permission'], true);

        $result = $result == null ? unserialize($user_group_permission->row['permission']) : $result;

        $menus = $this->getMenus();
        $permission_list = array();
        foreach ($menus as $menu) {
            if (!empty($result['access'])) {
                if (in_array($menu, $result['access'])) {
                    $permission_list[] = str_replace('/', '.', $menu) . ".view";
                }
            }
            if (!empty($result['modify'])) {
                if (in_array($menu, $result['modify'])) {
                    $permission_list[] = str_replace('/', '.', $menu) . ".modify";
                }
            }
            if (!empty($result['delete'])) {
                if (in_array($menu, $result['delete'])) {
                    $permission_list[] = str_replace('/', '.', $menu) . ".delete";
                }
            }
        }
        if (empty($permission_list)) {
            return array();
        } else {
            return $permission_list;
        }
    }

    private function getMenus()
    {
        $result = array();

        $menus = $this->db->query("SELECT distinct(path) as path FROM " . DB_PREFIX . "admin_menu WHERE status = '1' ORDER BY path");

        if ($menus->num_rows) {
            $result = array_column($menus->rows, 'path');
        }

        //hardcode for notification menu
        $result[] = 'doctorapp/user_notification_setting';
        $result[] = 'doctorapp/notification_setting';

        sort($result);
        return $result;
    }

    private function getProfile()
    {
        $user_id = $this->user_info['user_id'];
        $profile_info = $this->model_android_user->getUserInfo($user_id);
        if (empty($profile_info)) {
            $result = [];
        } else {
            $gender = is_numeric($profile_info['gender']) ? $profile_info['gender'] : (strtolower($profile_info['gender']) == 'male' ? '1' : '2');

            $professions = !empty($profile_info['user_desc']['professions']) ? unserialize($profile_info['user_desc']['professions']) : [];
            $introduction = !empty($profile_info['user_desc']['description']) ? $profile_info['user_desc']['description'] : '';


            //user image
            $default_image = "https://www.etcm.me/image/catalog/default-user-july17.jpg";
            $profile_image = $profile_info['image'] ? $profile_info['image'] : null;
            if (!empty($profile_info) && $profile_info['image'] && is_file(DIR_IMAGE . $profile_info['image'])) {
                $profile_image = HTTPS_IMAGE . $profile_info['image'];
            } else {
                $profile_image = $default_image;
            }
            $result = array(
                "profile_image" => $profile_image,
                "name" => trim($profile_info['firstname'] . " " . $profile_info['lastname']),
                "email" => $profile_info['email'],
                // "telephone" => $profile_info['contactno'],
                // "username" => $profile_info['username'],
                "dob" => $profile_info['dob'],
                "ic" => $profile_info['ic'],
                "gender" => (int)$gender,
                "show_for_appointment" => (bool)$profile_info['show_for_appointment'],
                "enable_appointment" => (bool)$profile_info['enable_appointment'],
                "professions"   => $professions,
                "introduction"   => $introduction,
            );
        }
        return $result;
    }

    private function getProfessions()
    {
        $result = [];

        $etcm_url = HTTP_API . 'index.php?route=etcm/store_doctor/get_profession_categories&language=' . $this->session->data['language'];

        $etcm_profession_category_json = file_get_contents($etcm_url);
        $etcm_profession_category_arr = json_decode($etcm_profession_category_json, true);

        if (!empty($etcm_profession_category_arr['data'])) {
            foreach ($etcm_profession_category_arr['data'] as $profession) {
                $result[] = [
                    "id" => $profession['category_id'],
                    "name" => $profession['category_name']
                ];
            }
        }

        return $result;
    }

    private function syncToEtcm()
    {
        $db_holidays = $this->db->query("SELECT * FROM " . DB_PREFIX . "user_holiday WHERE end >= '" . $this->db->escape(date('Y-m-d')) . "'")->rows;

        $db_users = $this->db->query("SELECT * FROM " . DB_PREFIX . "user")->rows;
        $users = [];
        foreach ($db_users as $user) {
            $user_desc = $this->db->query("SELECT * FROM " . DB_PREFIX . "user_description WHERE user_id = '" . (int)$user['user_id'] . "'")->row;
            $treatments = $this->db->query("SELECT * FROM " . DB_PREFIX . "user_treatment WHERE user_id = '" . (int)$user['user_id'] . "'")->rows;

            $image = !empty($user['image']) ? HTTPS_IMAGE . $user['image'] : '';
            $users[] = [
                'user_id'               => $user['user_id'],
                'firstname'             => $user['firstname'],
                'lastname'              => $user['lastname'],
                'chinesename'           => $user['chinesename'],
                'image'                 => $image,
                'telephone'             => $user['contactno'],
                'gender'                => $user['gender'],
                'user_position'         => $user['position'],
                'position'              => !empty($user_desc['position']) ? $user_desc['position'] : '',
                'professions'           => !empty($user_desc['professions']) ? $user_desc['professions'] : '',
                'description'           => !empty($user_desc['description']) ? $user_desc['description'] : '',
                'sort_order'            => $user['doctor_sort_order'],
                'enable_appointment'    => $user['enable_appointment'],
                'show_for_appointment'  => $user['show_for_appointment'],
                'status'                => $user['status'],
                'treatments'            => $treatments
            ];
        }
        $post_data = [
            'store_url' => HTTPS_SERVER,
            'doctor_holidays'  => $db_holidays,
            'users'     => $users
        ];

        $path = 'etcm/syncing/syncing/update_user';
        $result = $this->connectCurl($path, $post_data);
        return $result;
    }

    private function connectCurl($path, $data)
    {
        $language = !empty($_SERVER['HTTP_ACCEPT_LANGUAGE']) ? $_SERVER['HTTP_ACCEPT_LANGUAGE'] : 'cn';
        $device_id = !empty($_SERVER['HTTP_DEVICE_ID']) ? $_SERVER['HTTP_DEVICE_ID'] : '';

        $url = HTTP_API . 'index.php?route=' . $path;
        $curl = curl_init();

        curl_setopt($curl, CURLOPT_HEADER, false);
        curl_setopt($curl, CURLINFO_HEADER_OUT, true);
        curl_setopt($curl, CURLOPT_USERAGENT, $this->request->server['HTTP_USER_AGENT']);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_POST, 1);
        curl_setopt($curl, CURLOPT_POSTFIELDS, htmlspecialchars_decode(json_encode($data)));
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array('Accept-Language: ' . $language, 'Device-Id: ' . $device_id, 'Content-Type: application/json'));
        curl_setopt($curl, CURLOPT_TIMEOUT, 15);

        $response = curl_exec($curl);

        $result = json_decode(htmlspecialchars_decode($response), true);

        curl_close($curl);

        return $result;
    }

    #endregion
}
