<?php

class ControllerAndroidStockStockIssue extends Controller
{
    private $call_function;
    private $s;
    private $json;
    private $user_info;

    public function index()
    {
        //load model required
        $this->load->model('android/stock/stock_issue');

        //load core api function
        require DIR_SYSTEM . "/library/start_api.php";
    }


    //stock issue function start

    protected function get_filters()
    {
        $filters = array(
            "filter_add_by" => $this->model_android_stock_stock_issue->getFilterAddBy(),
            "filter_customer" => $this->model_android_stock_stock_issue->getFilterCustomer(),
            "filter_locations" => $this->model_android_stock_stock_issue->getFilterLocation(),
            "filter_status" => $this->model_android_stock_stock_issue->getFilterStatus()
        );
        $output = $this->response->setCachedResponse(200, $filters, "Success", "stock_issue");
        $this->api->trackResponse($output);
        return;
    }

    protected function get_list()
    {
        //unused filter
        $filter_invoice_prefix = null;
        $filter_product_code = null;

        //fixed value filter
        $filter_store_id = $this->user_info['store_id'];

        $filter_date_from = null;
        $filter_date_to = null;
        $filter_batch_date_to = null;
        $filter_batch_date_from = null;
        $filter_product_name = null;
        $filter_add_by = null;
        $filter_customer = null;
        $filter_location_id = null;
        $filter_status = null;

        //pagination and sorting
        $page = 1;
        $limit = $this->config->get('config_limit_admin');
        $sort_column = null;
        $sort_direction = null;

        // if (!empty($this->json)) {

        $filter_date_from = isset($this->request->get['date_from']) && trim($this->request->get['date_from']) != '' ? $this->request->get['date_from'] : null;
        $filter_date_to = isset($this->request->get['date_to']) && trim($this->request->get['date_to']) != '' ? $this->request->get['date_to'] : null;
        $filter_batch_date_to = isset($this->request->get['batch_date_to']) && trim($this->request->get['batch_date_to']) != '' ? $this->request->get['batch_date_to'] : null;
        $filter_batch_date_from = isset($this->request->get['batch_date_from']) && trim($this->request->get['batch_date_from']) != '' ? $this->request->get['batch_date_from'] : null;
        $filter_product_name = isset($this->request->get['product_name']) && trim($this->request->get['product_name']) != '' ? $this->request->get['product_name'] : null;
        $filter_status = isset($this->request->get['status']) && trim($this->request->get['status']) != '' ? $this->request->get['status'] : null;

        $filter_add_by = isset($this->request->get['add_by_id']) && trim($this->request->get['add_by_id']) != '' ?  $this->request->get['add_by_id'] : null;
        $filter_customer = isset($this->request->get['customer_id']) && trim($this->request->get['customer_id']) != '' ?  $this->request->get['customer_id'] : null;
        $filter_location_id = isset($this->request->get['location_id']) && trim($this->request->get['location_id']) != '' ?  $this->request->get['location_id'] : null;

        // convert filters category and store id to array
        if (!empty($filter_add_by)) {
            $filter_add_by = explode(',', $filter_add_by);
            $filter_add_by = array_filter(array_map('trim', $filter_add_by));
            $filter_add_by = implode(', ', $filter_add_by);
        }

        if (!empty($filter_customer)) {
            $filter_customer = explode(',', $filter_customer);
            $filter_customer = array_filter(array_map('trim', $filter_customer));
            $filter_customer = implode(', ', $filter_customer);
        }

        if (trim($filter_location_id) != '') {
            $filter_location_id = explode(',', $filter_location_id);
            // $filter_location_id = array_filter(array_map('trim', $filter_location_id));
            $filter_location_id = implode(', ', $filter_location_id);
        }
        //pagination and filter
        $page = isset($this->request->get['page']) && trim($this->request->get['page']) != '' ? $this->request->get['page'] : 1;
        $limit = isset($this->request->get['show']) && trim($this->request->get['show']) != '' ? $this->request->get['show'] : $this->config->get('config_limit_admin');

        // $sort = isset($this->json['sort']) ? $this->json['sort'] : null;
        // $sort_column = $sort ? $sort['column'] : null;
        // $sort_direction = $sort ? $sort['direction'] : null;
        // }

        $filter_data = array(
            'filter_invoice_prefix' => $filter_invoice_prefix,
            'filter_add_by' => $filter_add_by,
            'filter_customer' => $filter_customer,
            'filter_product_name' => $filter_product_name,
            'filter_product_code' => $filter_product_code,
            'filter_date_from' => $filter_date_from,
            'filter_date_to' => $filter_date_to,
            'filter_batch_date_from' => $filter_batch_date_from,
            'filter_batch_date_to' => $filter_batch_date_to,
            'filter_store_id' => $filter_store_id,
            'filter_location_id' => $filter_location_id,
            'filter_status' => $filter_status,
            'sort' => $sort_column,
            'order' => $sort_direction,
            'start' => ($page - 1) * $limit,
            'limit' => $limit
        );

        // $total_stock_issues = $this->model_android_stock_stock_issue->getTotalStockIssues($filter_data);

        $results = $this->model_android_stock_stock_issue->getStockIssues($filter_data);

        if (!empty($results)) {
            foreach ($results as $result) {
                $store_name = !empty($result['store_name']) ? $result['store_name'] : $this->config->get('config_name');
                $weight_uom = !empty($result['weight_uom']) ? $result['weight_uom'] : '';

                $data['stock_issues'][] = [
                    'stock_issue_id' => $result['stock_issue_id'],
                    'invoice_prefix' => $result['invoice_prefix'],
                    'store_name'     => $store_name,
                    'customer_name'  => $result['customer_name'],
                    'product_name'   => $result['product_name'],
                    'product_code'   => $result['product_code'],
                    'date_added'     => $result['date_added'],
                    'batch_date'     => $result['batch_date'],
                    'description'    => nl2br($result['description']),
                    'status'         => $result['status'],
                    'status_name'    => $result['status_name'],
                    'location'       => $result['location'],
                    'location_id'    => $result['location_id'],
                    'stock_onhand'   => $result['stock_onhand'],
                    'stock_balance'  => $result['stock_balance'],
                    'quantity'       => $result['quantity'],
                    'weight_uom'     => $weight_uom,
                    'remark'         => $result['remark'],
                    'add_by'         => $result['add_by'],
                ];
            }
            // $data['total'] = $total_stock_issues;
            $output = $this->response->setCachedResponse(200, $data['stock_issues'], "Get list success", "stock_issue");
            $this->api->trackResponse($output);
            return;
        } else {
            $data['stock_issues'] = array();
            // $data['total'] = $total_stock_issues;
            $output = $this->response->setCachedResponse(204, $data['stock_issues'], "No result", "stock_issue");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function add()
    {
        $json = $this->json;
        $return_result = array();
        if (empty($json)) {
            $output = $this->response->setResponse2(400, array(), "missing parameter", "stock_issue");
            $this->api->trackResponse($output);
            return;
        }
        $return_result = $this->model_android_stock_stock_issue->addStockIssue($json);

        if ($return_result['status'] === true) {
            $output = $this->response->setResponse2(200, $return_result['result'], "success", "stock_issue");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setResponse2(422, $return_result['result'], "failed", "stock_issue");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function edit()
    {
        $json = $this->json;
        $return_result = array();
        if (empty($json)) {
            $output = $this->response->setResponse2(400, array(), "missing parameter", "stock_issue");
            $this->api->trackResponse($output);
            return;
        }
        $return_result = $this->model_android_stock_stock_issue->editStockIssue($json);

        if ($return_result['status'] === true) {
            $output = $this->response->setResponse2(200, $return_result['result'], "success", "stock_issue");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setResponse2(422, $return_result['result'], "failed", "stock_issue");
            $this->api->trackResponse($output);
            return;
        }
    }

    public function debug()
    {
        var_dump($this->session->data);
        die();
    }

    protected function get_info()
    {
        $stock_issue_id = isset($this->request->get['stock_issue_id']) ? $this->request->get['stock_issue_id'] : 0;
        if ($stock_issue_id) {
            $stock_issue_info = $this->model_android_stock_stock_issue->getStockIssue($stock_issue_id);

            // $data['stock_issue_item'] = [];
            if (!empty($stock_issue_info)) {
                $stock_issue_products = $stock_issue_info['stock_issue_item'];

                if (!empty($stock_issue_products)) {
                    foreach ($stock_issue_products as $product) {
                        $products[] = [
                            'product_id' => $product['product_id'],
                            'product_name' => $product['product_name'],
                            'product_code' => $product['product_code'],
                            'location_id' => $product['location_id'],
                            'location' => $product['location_text'],
                            'batch_date' => $product['batch_date'],
                            'quantity' => $product['quantity'],
                            'unit' => $product['unit'],
                            'remark' => $product['remark'],
                        ];
                    }
                }
                $data = array(
                    "stock_issue_id" => $stock_issue_info['stock_issue_id'],
                    "invoice_prefix" => $stock_issue_info['invoice_prefix'],
                    "customer_id" => $stock_issue_info['customer_id'],
                    "customer_name" => $stock_issue_info['customer_name'],
                    "date_added" => $stock_issue_info['date_added'],
                    "status" => $stock_issue_info['status'],
                    "staff" => $stock_issue_info['staff'],
                    "description" => $stock_issue_info['description'],
                    "products" => $products
                );
                $output = $this->response->setCachedResponse(200, $data, "Get info success", "stock_issue");
                $this->api->trackResponse($output);
                return;
            } else {
                $output = $this->response->setCachedResponse(204, array(), "Not found", "stock_issue");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setCachedResponse(400, array(), "Stock Issue Id is required", "stock_issue");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_products()
    {
        $data = $this->model_android_stock_stock_issue->getProductToStore($this->user_info['store_id']);

        foreach ($data as $row) {
            $products[$row['product_id']]['product_id'] = $row['product_id'];
            $products[$row['product_id']]['cn_name'] = $row['cn_name'];
            $products[$row['product_id']]['en_name'] = $row['en_name'];
            $products[$row['product_id']]['pinyin'] = $row['pinyin'];
            $products[$row['product_id']]['product_code'] = $row['product_code'];
            $products[$row['product_id']]['unit'] = $row['unit'];
            //location
            $products[$row['product_id']]['location'][$row['location_id']]['location_id'] = $row['location_id'];
            $products[$row['product_id']]['location'][$row['location_id']]['location_text'] = $row['location_text'];
            //batch_date
            $products[$row['product_id']]['location'][$row['location_id']]['batch_dates'][$row['batch_date']] = $row['batch_date'];
        }
        foreach ($products as $product) {

            $products[$product['product_id']]['location'] = array_values($product['location']);
            foreach ($products[$product['product_id']]['location'] as $key => $location) {
                $products[$product['product_id']]['location'][$key]['batch_dates'] = array_values($location['batch_dates']);
            }
        }
        $products = array_values($products);
        $products = !empty($products) ? $products : [];
        $output = $this->response->setCachedResponse(200, $products, "success", "product_to_store");
        $this->api->trackResponse($output);
        return;
    }

    protected function get_customers()
    {
        $data = $this->model_android_stock_stock_issue->getCustomers();

        if (!empty($data)) {
            $output = $this->response->setCachedResponse(200, $data, "success", "customers");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setCachedResponse(200, array(), "not found", "customers");
            $this->api->trackResponse($output);
            return;
        }
    }
}
