<?php
class ControllerAndroidStaffLeave extends Controller
{
    private $json;
    private $model_name;

    public function index()
    {
        //load required model
        $this->load->model('android/staff/leave');
        $this->model_name = $this->model_android_staff_leave;
        require DIR_SYSTEM . "/library/start_api.php";
    }

    protected function get_list()
    {
        $results = [];

        $page = !empty($this->request->get['page']) ? $this->request->get['page'] : 1;
        $show = !empty($this->request->get['show']) ? $this->request->get['show'] : 10;

        $filters = array(
            "start"     => ($page - 1) * $show,
            "limit"     => $show
        );

        $users = $this->model_name->getUsers($filters);

        if (!empty($users)) {
            foreach ($users as $user) {
                $name = trim($user['firstname'] . " " . $user['lastname']);
                $image = $this->getUserPhoto($user['image'], $name);

                //get leaves
                $leaves = [];
                $holidays = $this->model_name->getUserHolidays($user['user_id']);
                foreach ($holidays as $day) {
                    $leaves[] = [
                        "id"    => $day['id'],
                        "title" => $day['title'],
                        "start" => $day['start'],
                        "end"   => $day['end'],
                    ];
                }

                $results[] = [
                    "user_id"   => $user['user_id'],
                    "name"      => $name,
                    "image"     => $image,
                    "leaves"    => $leaves
                ];
            }
            $output = $this->response->setCachedResponse(200, $results, 'Success', 'staff');
        } else {
            $output = $this->response->setCachedResponse(404, [], 'No result found', 'staff');
        }
        $this->api->trackResponse($output);
        return;
    }

    protected function get_detail()
    {
        $user_id = !empty($this->request->get['user_id']) ? $this->request->get['user_id'] : 0;

        $result = [];
        if (!empty($user_id)) {
            $info = $this->model_name->getUser($user_id);
            if (!empty($info)) {
                $name = trim($info['firstname'] . " " . $info['lastname']);
                $image = $this->getUserPhoto($info['image'], $name);

                //get leaves
                $leaves = [];
                $holidays = $this->model_name->getUserHolidays($user_id);
                foreach ($holidays as $day) {
                    $leaves[] = [
                        "id"    => $day['id'],
                        "title" => $day['title'],
                        "start" => $day['start'],
                        "end"   => $day['end'],
                    ];
                }
                $result = [
                    "user_id"   => $info['user_id'],
                    "name"      => $name,
                    "image"     => $image,
                    "leaves"    => $leaves
                ];
                $output = $this->response->setCachedResponse(200, $result, 'success', 'staff');
                $this->api->trackResponse($output);
                return;
            } else {
                $output = $this->response->setCachedResponse(404, new stdClass(), 'Failed to get detail', 'staff');
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setCachedResponse(400, new stdClass(), 'user_id required', 'staff');
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function update()
    {
        $json = $this->json;
        if (empty($json)) {
            $output = $this->response->setResponse2(400, new stdClass(), 'missing json body', 'staff');
            $this->api->trackResponse($output);
            return;
        }
        if (empty($json['user_id']) || empty($json['leaves'])) {
            $output = $this->response->setResponse2(400, new stdClass(), 'user_id and leaves required', 'staff');
            $this->api->trackResponse($output);
            return;
        } else {
            $user_id = $json['user_id'];
        }

        $ids = [];
        foreach ($json['leaves'] as $item) {
            if (!empty($item['title']) && !empty($item['start']) && !empty($item['end'])) {
                $ids[] = (string) $this->model_name->updateHoliday($item, $user_id);
            }
        }
        $this->syncToEtcm();
        $output = $this->response->setResponse2(200, array("id" => $ids), "success", "staff");
        $this->api->trackResponse($output);
        return;
    }

    protected function delete()
    {
        $json = $this->json;

        if (!empty($json)) {
            foreach ($json as $id) {
                $this->model_name->deleteHoliday($id);
            }
            $this->syncToEtcm();
            $output = $this->response->setResponse2(200, new stdClass(), 'success', 'staff');
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setResponse2(400, new stdClass(), 'id required', 'staff');
            $this->api->trackResponse($output);
            return;
        }
    }

    private function getUserPhoto($image, $name)
    {
        $this->load->model('tool/image');
        if (is_file(DIR_IMAGE . $image)) {
            $image = $this->model_tool_image->resize($image, 120, 120);
        } else {
            $image = "https://ui-avatars.com/api/?background=random&bold=true&size=120&name=" . str_replace(' ', '+', $name);
        }

        return $image;
    }

    private function syncToEtcm()
    {
        $db_holidays = $this->db->query("SELECT * FROM " . DB_PREFIX . "user_holiday WHERE end >= '" . $this->db->escape(date('Y-m-d')) . "'")->rows;

        $post_data = [
            'store_url' => HTTPS_SERVER,
            'doctor_holidays'  => $db_holidays,
        ];

        $path = 'etcm/syncing/syncing/update_doctor_holiday';
        $result = $this->connectCurl($path, $post_data);
        return $result;
    }

    private function connectCurl($path, $data)
    {
        $language = !empty($_SERVER['HTTP_ACCEPT_LANGUAGE']) ? $_SERVER['HTTP_ACCEPT_LANGUAGE'] : 'cn';
        if ($language == 'zh') {
            $language = 'cn';
        }

        $device_id = !empty($_SERVER['HTTP_DEVICE_ID']) ? $_SERVER['HTTP_DEVICE_ID'] : '';

        $url = 'https://www.etcm.me/index.php?route=' . $path;
        $curl = curl_init();

        curl_setopt($curl, CURLOPT_HEADER, false);
        curl_setopt($curl, CURLINFO_HEADER_OUT, true);
        curl_setopt($curl, CURLOPT_USERAGENT, $this->request->server['HTTP_USER_AGENT']);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_POST, 1);
        curl_setopt($curl, CURLOPT_POSTFIELDS, htmlspecialchars_decode(json_encode($data)));
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array('Accept-Language: ' . $language, 'Device-Id: ' . $device_id, 'Content-Type: application/json'));
        curl_setopt($curl, CURLOPT_TIMEOUT, 15);

        $response = curl_exec($curl);

        $result = json_decode(htmlspecialchars_decode($response), true);

        curl_close($curl);

        return $result;
    }
}
