<?php

class ControllerAndroidSettingStoreOpening extends Controller
{
    private $json;
    private $model_name;

    public function index()
    {
        //load required model
        $this->load->model('android/setting/store_opening');

        $this->model_name = $this->model_android_setting_store_opening;

        require DIR_SYSTEM . "/library/start_api.php";
    }

    protected function get_list()
    {
        $results = [];

        $openings = $this->model_name->getStoreOpenings();

        if (!empty($openings)) {
            foreach ($openings as $open) {
                $opening_times = $this->model_name->getStoreOpeningTimes($open['store_opening_id']);
                $arr_working_hours = array();
                if (!empty($opening_times)) {
                    foreach ($opening_times as $time) {
                        $arr_working_hours[] = $time['start_time'] . '-' . $time['end_time'];
                    }
                }

                $results[] = [
                    'store_opening_id'  => $open['store_opening_id'],
                    'day'               => $open['day'],
                    'working_hours'     => $arr_working_hours
                ];
            }
        }

        if (!empty($results)) {
            $output = $this->response->setCachedResponse(200, $results, "Get list success", "store_opening");
        } else {
            $output = $this->response->setCachedResponse(404, [], "Get list success", "store_opening");
        }
        $this->api->trackResponse($output);
        return;
    }

    protected function get_detail()
    {

        $id = !empty($this->request->get['store_opening_id']) ? $this->request->get['store_opening_id'] : 0;
        if (empty($id)) {
            $output = $this->response->setCachedResponse(400, new stdClass(), "store_opening_id is required", "store_opening");
            $this->api->trackResponse($output);
            return;
        }
        $result = [];
        $info = $this->model_name->getStoreOpening($id);

        if (!empty($info)) {
            $opening_times = $this->model_name->getStoreOpeningTimes($id);
            $arr_working_hours = array();
            if (!empty($opening_times)) {
                foreach ($opening_times as $time) {
                    $arr_working_hours[] = [
                        "start_time" => $time['start_time'],
                        "end_time" => $time['end_time']
                    ];
                }
            }

            $result = [
                "store_opening_id" => $info['store_opening_id'],
                "day" => $info['day'],
                "session" => $info['session'],
                "enable_session" => (bool)$info['enable_session'],
                "working_hours"  => $arr_working_hours
            ];
        }

        if (!empty($result)) {
            $output = $this->response->setCachedResponse(200, $result, "Get detail success", "store_opening");
        } else {
            $output = $this->response->setCachedResponse(404, new stdClass(), "Detail not found", "store_opening");
        }
        $this->api->trackResponse($output);
        return;
    }

    protected function update()
    {
        $json = $this->json;
        if (empty($json)) {
            $output = $this->response->setResponse2(400, new stdClass(), 'missing json body', 'store_opening');
            $this->api->trackResponse($output);
            return;
        }

        $store_opening_ids = [];
        foreach ($json as $item) {
            if (!empty($item['day']) && !empty($item['working_hours'])) {
                $result = $this->model_name->updateStoreOpening($item);

                $store_opening_ids[] = (string)$result['store_opening_id'];
                //disabled update to etcm
                // $api_data = [
                //     'store_url' => HTTPS_SERVER,
                //     'store_opening_time'    => $result['xxx'],
                //     'day'                   => $item['day']
                // ];
                // $api_response = json_decode($this->etcm_save_opening($api_data), true);
            }
        }
        $this->syncToEtcm();
        $output = $this->response->setResponse2(200, array("store_opening_id" => $store_opening_ids), 'success', 'store_opening');
        $this->api->trackResponse($output);
        return;
    }

    protected function delete() {
        $json = $this->json;


        if (!empty($json)) {
            foreach($json as $id){
                $this->model_name->deleteStoreOpening($id);
            }
            $this->syncToEtcm();
            $output = $this->response->setResponse2(200, new stdClass(), 'success', 'store_opening');
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setResponse2(400, new stdClass(), 'store_opening_id required', 'store_opening');
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_filters()
    {
        $days = array("Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday");

        $available_day = $this->model_name->getAvailableDay();
        $returned_day = [];
        foreach ($days as $day) {
            if (!in_array($day, $available_day)) {
                $returned_day[] = $day;
            }
        }
        $result = [
            "days" => $returned_day,
        ];

        $output = $this->response->setResponse2(200, $result, 'success', 'store_opening');
        $this->api->trackResponse($output);
        return;
    }

    private function etcm_save_opening($data)
    {
        $post_data = [];

        $api_url = HTTP_API . 'index.php?route=etcm/store_opening/save_opening';

        $post_data['push_data'] = [
            'store_url'             => $data['store_url'],
            'day'                  => $data['day'],
            'store_opening_time'   => urldecode(http_build_query($data['store_opening_time']))
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $api_url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data['push_data']);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result = curl_exec($ch);

        curl_close($ch);

        return $result;
    }

    private function etcm_delete_opening($data)
    {
        $post_data = [];

        $api_url = HTTP_API . 'index.php?route=etcm/store_opening/delete_opening';

        $post_data['push_data'] = [
            'store_url'             => $data['store_url'],
            'day'                  => $data['day']
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $api_url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data['push_data']);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result = curl_exec($ch);

        curl_close($ch);

        return $result;
    }

    protected function syncToEtcm()
    {
        $db_openings = $this->db->query("SELECT * FROM " . DB_PREFIX . "store_opening")->rows;

        $openings = [];
        foreach ($db_openings as $opening) {
            $db_times = $this->db->query("SELECT * FROM " . DB_PREFIX . "store_opening_time WHERE store_opening_id = '" . (int)$opening['store_opening_id'] . "'")->rows;
            $openings[] = [
                "store_id"  => $opening['store_id'],
                'day'       => $opening['day'],
                'times'     => $db_times
            ];
        }

        $post_data = [
            'store_url' => HTTPS_SERVER,
            'openings' => $openings
        ];

        $path = 'etcm/syncing/syncing/update_store_opening';
        $result = $this->connectCurl($path, $post_data);
        return $result;
    }

    private function connectCurl($path, $data)
    {
        $language = !empty($_SERVER['HTTP_ACCEPT_LANGUAGE']) ? $_SERVER['HTTP_ACCEPT_LANGUAGE'] : 'cn';
        if ($language == 'zh') {
            $language = 'cn';
        }

        $device_id = !empty($_SERVER['HTTP_DEVICE_ID']) ? $_SERVER['HTTP_DEVICE_ID'] : '';

        $url = 'https://www.etcm.me/index.php?route=' . $path;
        $curl = curl_init();

        curl_setopt($curl, CURLOPT_HEADER, false);
        curl_setopt($curl, CURLINFO_HEADER_OUT, true);
        curl_setopt($curl, CURLOPT_USERAGENT, $this->request->server['HTTP_USER_AGENT']);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_POST, 1);
        curl_setopt($curl, CURLOPT_POSTFIELDS, htmlspecialchars_decode(json_encode($data)));
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array('Accept-Language: ' . $language, 'Device-Id: ' . $device_id, 'Content-Type: application/json'));
        curl_setopt($curl, CURLOPT_TIMEOUT, 15);

        $response = curl_exec($curl);

        $result = json_decode(htmlspecialchars_decode($response), true);

        curl_close($curl);

        return $result;
    }
}
