<?php

class ControllerAndroidSettingStoreHoliday extends Controller
{
    private $json;
    private $model_name;

    public function index()
    {
        //load required model
        $this->load->model('android/setting/store_holiday');

        $this->model_name = $this->model_android_setting_store_holiday;

        require DIR_SYSTEM . "/library/start_api.php";
    }

    protected function get_list()
    {
        $results = [];

        $page = !empty($this->request->get['page']) ? $this->request->get['page'] : 1;
        $show = !empty($this->request->get['show']) ? $this->request->get['show'] : 10;

        $filters = [
            'start'  => ($page - 1) * $show,
            'limit' => $show
        ];
        $holidays = $this->model_name->getHolidays($filters);

        if (!empty($holidays)) {
            foreach ($holidays as $day) {
                $results[] = [
                    'id'    => $day['id'],
                    'title' => $day['title'],
                    'start' => $day['start'],
                    'end'   => $day['end']
                    // 'start' => date('d/m/Y', strtotime($day['start'])),
                    // 'end'   => date('d/m/Y', strtotime($day['end']))
                ];
            }
        }

        if (!empty($results)) {
            $output = $this->response->setCachedResponse(200, $results, "Get list success", "store_holiday");
        } else {
            $output = $this->response->setCachedResponse(404, [], "Get list success", "store_holiday");
        }
        $this->api->trackResponse($output);
        return;
    }

    protected function get_detail()
    {
        $id = !empty($this->request->get['id']) ? $this->request->get['id'] : 0;
        if (empty($id)) {
            $output = $this->response->setResponse2(400, new stdClass(), 'id is required', 'store_holiday');
            $this->api->trackResponse($output);
            return;
        }
        $result = [];
        $info = $this->model_name->getHoliday($id);

        if (!empty($info)) {
            $result = [
                'id'    => $info['id'],
                'title' => $info['title'],
                'start' => $info['start'],
                'end'   => $info['end']
            ];
        }
        if (!empty($result)) {
            $output = $this->response->setCachedResponse(200, $result, "Get detail success", "store_holiday");
        } else {
            $output = $this->response->setCachedResponse(404, new stdClass(), "Detail not found", "store_holiday");
        }
        $this->api->trackResponse($output);
        return;
    }

    protected function update()
    {
        $json = $this->json;
        if (empty($json)) {
            $output = $this->response->setResponse2(400, new stdClass(), 'missing json body', 'store_holiday');
            $this->api->trackResponse($output);
            return;
        }

        $store_holiday_ids = [];
        foreach ($json as $item) {
            if (!empty($item['title']) && !empty($item['start']) && !empty($item['end'])) {
                $result = $this->model_name->updateHoliday($item);
                $store_holiday_ids[] = (string)$result;
            }
        }
        $this->syncToEtcm();
        $output = $this->response->setResponse2(200, ["id" => $store_holiday_ids], 'success', 'store_holiday');
        $this->api->trackResponse($output);
        return;
    }

    protected function delete()
    {
        $json = $this->json;

        if (!empty($json)) {
            foreach ($json as $id) {
                $this->model_name->deleteHoliday($id);
            }
            $this->syncToEtcm();
            $output = $this->response->setResponse2(200, new stdClass(), 'success', 'store_holiday');
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setResponse2(400, new stdClass(), 'id required', 'store_holiday');
            $this->api->trackResponse($output);
            return;
        }
    }

    private function syncToEtcm()
    {
        $db_holidays = $this->db->query("SELECT * FROM " . DB_PREFIX . "store_holiday WHERE end >= '".$this->db->escape(date('Y-m-d'))."'")->rows;

        $post_data = [
            'store_url' => HTTPS_SERVER,
            'holidays' => $db_holidays
        ];

        $path = 'etcm/syncing/syncing/update_store_holiday';
        $result = $this->connectCurl($path, $post_data);
        return $result;
    }

    private function connectCurl($path, $data)
    {
        $language = !empty($_SERVER['HTTP_ACCEPT_LANGUAGE']) ? $_SERVER['HTTP_ACCEPT_LANGUAGE'] : 'cn';
        if ($language == 'zh') {
            $language = 'cn';
        }

        $device_id = !empty($_SERVER['HTTP_DEVICE_ID']) ? $_SERVER['HTTP_DEVICE_ID'] : '';

        $url = 'https://www.etcm.me/index.php?route=' . $path;
        $curl = curl_init();

        curl_setopt($curl, CURLOPT_HEADER, false);
        curl_setopt($curl, CURLINFO_HEADER_OUT, true);
        curl_setopt($curl, CURLOPT_USERAGENT, $this->request->server['HTTP_USER_AGENT']);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_POST, 1);
        curl_setopt($curl, CURLOPT_POSTFIELDS, htmlspecialchars_decode(json_encode($data)));
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array('Accept-Language: ' . $language, 'Device-Id: ' . $device_id, 'Content-Type: application/json'));
        curl_setopt($curl, CURLOPT_TIMEOUT, 15);

        $response = curl_exec($curl);

        $result = json_decode(htmlspecialchars_decode($response), true);

        curl_close($curl);

        return $result;
    }
}
