<?php

class ControllerAndroidServicePartnerServicePartner extends Controller
{
    private $json;
    private $error;
    private $model_name;

    private $data_medical_record_info = [];
    private $data_customer_info = [];
    private $data_company_address = [];
    private $data_customer_addresses = [];
    private $data_customer_address = [];

    public function index()
    {
        //Load Model
        $this->load->model('android/service_partner/service_partner');
        $this->model_name = $this->model_android_service_partner_service_partner;

        // Load Required file
        require DIR_SYSTEM . "/library/start_api.php";
    }

    protected function add()
    {
        $medical_record_id = !empty($this->request->get['medical_record_id']) ? $this->request->get['medical_record_id'] : false;
        $data = [];
        if (!empty($medical_record_id)) {
            $data = $this->getForm();
            $output = $this->response->setCachedResponse(200, $data, "Sucess", "service_partner");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setCachedResponse(204, new stdClass(), "Invalid Parameter", " the medical record cannot be found!", "service_partner");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_stores()
    {
        if ($this->validateGetStores()) {
            $data = $this->getStoresForm();

            $path = 'etcm/service_partner/service_partner/get_stores';
            $result = $this->connectCurl($path, $data);
            if (!empty($result)) {
                if (!empty($result['error'])) {
                    $output = $this->response->setCachedResponse(204, new stdClass(), $result['message'], "service_partner");
                    $this->api->trackResponse($output);
                    return;
                } else {
                    $output = $this->response->setCachedResponse(200, $result['response'], $result['message'], "service_partner");
                    $this->api->trackResponse($output);
                    return;
                }
            } else {
                $output = $this->response->setCachedResponse(204, new stdClass(), "API Connection Errors : Please check the internet connection or API connection!", "service_partner");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setCachedResponse(400, new stdClass(), $this->error, "service_partner");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_store_detail()
    {
        if ($this->validateGetStoreDetail()) {
            $data = $this->getStoreDetailForm();

            $path = 'etcm/service_partner/service_partner/get_store_detail';
            $result = $this->connectCurl($path, $data);
            if (!empty($result)) {
                if (!empty($result['error'])) {
                    $output = $this->response->setCachedResponse(204, new stdClass(), $result['message'], "service_partner");
                    $this->api->trackResponse($output);
                    return;
                } else {
                    $output = $this->response->setCachedResponse(200, $result['response'], $result['message'], "service_partner");
                    $this->api->trackResponse($output);
                    return;
                }
            } else {
                $output = $this->response->setCachedResponse(204, new stdClass(), "API Connection Errors : Please check the internet connection or API connection!", "service_partner");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setCachedResponse(400, new stdClass(), $this->error, "service_partner");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_checkout()
    {
        if ($this->validateGetCheckout()) {
            $data = $this->getCheckoutForm();
            $prescriptions = $data['prescriptions'];
            $path = 'etcm/service_partner/service_partner/get_checkout';
            $result = $this->connectCurl($path, $data);
            if (!empty($result)) {
                if (!empty($result['error'])) {
                    $output = $this->response->setCachedResponse(204, new stdClass(), $result['message'], "service_partner");
                    $this->api->trackResponse($output);
                    return;
                } else {
                    $result['response']['credit']['required_pin'] = $this->config->get('config_required_pin') != '0' ? true : false;
                    $result['response']['payment_address'] = $this->getPaymentAddress();
                    $result['response']['payment_addresses'] = $this->getPaymentAddresses();
                    $result['response']['shipping_address'] = $this->getShippingAddress();
                    $result['response']['shipping_addresses'] = $this->getShippingAddresses();

                    $output = $this->response->setCachedResponse(200, $result['response'], $result['message'], "service_partner");
                    $this->api->trackResponse($output);
                    return;
                }
            } else {
                $output = $this->response->setCachedResponse(204, new stdClass(), "API Connection Errors : Please check the internet connection or API connection!", "service_partner");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setCachedResponse(204, new stdClass(), "Invalid Parameter : " . $this->error, "service_partner");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function checkout_confirm()
    {
        if (!empty($this->json['checkout_id']) && !empty($this->json['payment_method'])) {
            $data['checkout_id'] = $this->json['checkout_id'];
            $data['payment_method'] = $this->json['payment_method'];
            $data['shipping_method'] = !empty($this->json['shipping_method']) ? $this->json['shipping_method'] : null;
            $data['domain'] = HTTP_SERVER;
            $path = 'etcm/service_partner/service_partner/checkout_confirm';
            $result = $this->connectCurl($path, $data);
            if (!empty($result)) {
                if (!empty($result['error'])) {
                    $output = $this->response->setCachedResponse((int)$result['code'], new stdClass(), $result['message'], "service_partner");
                    $this->api->trackResponse($output);
                    return;
                } else {

                    $purchase_order_id = $this->model_name->savePO($result['response']['data']);


                    $response = $result['response']['payment_detail'];
                    $response['order_id'] = (int)$purchase_order_id;
                    $output = $this->response->setCachedResponse(200, $response, $result['message'], "service_partner");
                    $this->api->trackResponse($output);
                    return;
                }
            } else {
                $output = $this->response->setCachedResponse(500, new stdClass(), "API Connection Errors : Please check the internet connection or API connection!", "service_partner");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setCachedResponse(204, new stdClass(), "Invalid Parameter : no data to checkout !", "service_partner");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_purchased_orders()
    {
        $post = $this->json;
        $search = !empty($post['search']) ? $post['search'] : '';
        $page = !empty($post['page']) ? $post['page'] : 1;
        $status = !empty($post['status']) ? $post['status'] : '';
        $limit = !empty($post['limit']) ? $post['limit'] : $this->config->get('config_limit_admin');
        $filter_data = [
            'search' => $search,
            'status' => $status,
            'start'  => ($page - 1) * $limit,
            'limit'  => (int)$limit
        ];

        $purchased_orders = $this->model_name->getPurchasedOrders($filter_data);
        $result = $this->formattedPurchaseOrders($purchased_orders);

        if (!empty($result)) {
            $output = $this->response->setCachedResponse(200, $result, ' Success', "service_partner");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setCachedResponse(200, array(), ' No result! Please try another keyword!', "service_partner");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_purchase_order_statuses()
    {
        $canAccess = $this->load->controller('android/common/permission/canAccess', 'service_partner/purchase_order');
        if ($canAccess) {
            $result = $this->getPurchaseOrderStatuses();
        } else {
            $result = array();
        }
        if (!empty($result)) {

            $output = $this->response->setCachedResponse(200, $result, ' Success', "service_partner");
            return;
        } else {
            $output = $this->response->setCachedResponse(204, array(), " No result", "service_partner");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_purchased_order()
    {
        $data = [];
        if ($this->validateGetOrders()) {
            $data = [];
            $purchase_order_id = !empty($this->request->get['purchase_order_id']) ?  $this->request->get['purchase_order_id'] : 0;

            $data = $this->getPurchasedOrder($purchase_order_id);

            if (!empty($data)) {
                $output = $this->response->setCachedResponse(200, $data, ' Success', "service_partner");
                $this->api->trackResponse($output);
                return;
            } else {
                $output = $this->response->setCachedResponse(204, new stdClass(), "Invalid Parameter: some data are missing !", "service_partner");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setCachedResponse(204, new stdClass(), "Invalid Parameter: " . $this->error, "service_partner");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function cancel_purchase_order()
    {
        $cancelled_status = $this->config->get('config_service_partner_cancelled_status');
        $purchase_order_id = !empty($this->json['purchase_order_id']) ? $this->json['purchase_order_id'] : 0;
        $cancel_reason = !empty($this->json['cancel_reason']) ? trim($this->json['cancel_reason']) : '';
        if (!empty($purchase_order_id) && !empty($cancel_reason)) {

            $po_info = $this->model_name->getPO($purchase_order_id);
            $etcm_purchase_order_id = $po_info['etcm_purchase_order_id'];
            $update_data = array(
                "status_id" => 7,
                "etcm_status_code" => "CANCELLED",
                "date_cancelled" => date('Y-m-d H:i:s'),
                "cancel_reason" => $cancel_reason,
                "etcm_purchase_order_id" => $etcm_purchase_order_id
            );
            $this->model_name->updatePO($update_data);

            $post_data = array(
                // "tracking_no"   => $tracking_no,
                "status_code"   => $update_data['etcm_status_code'],
                // "date_payment"  => $date_payment,
                // "date_shipped"  => $date_shipped,
                // "date_rated"    => $date_rated,
                // "rate_details"  => $rate_details,
                // "date_completed"    => $date_completed,
                "date_cancelled"    => $update_data['date_cancelled'],
                "cancel_reason" => $cancel_reason,
                "purchase_order_id" => $etcm_purchase_order_id,
                "from" => "CLIENT"
            );
            $path = 'etcm/service_partner/service_partner/update_po';
            $result = $this->connectCurl($path, $post_data);
            if (!empty($result)) {
                if (!empty($result['error'])) {
                    $output = $this->response->setCachedResponse(204, new stdClass(), $result['message'], "service_partner");
                    return;
                } else {
                    $output = $this->response->setCachedResponse(200, new stdClass(), $result['message'], "service_partner");
                    return;
                }
            } else {
                $output = $this->response->setCachedResponse(204, new stdClass(), "API Connection Errors : Please check the internet connection or API connection!", "service_partner");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setCachedResponse(400, new stdClass(), "purchase order id & cancel reason required", "service_partner");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function reorder()
    {
        $medical_record_id = !empty($this->request->get['medical_record_id']) ? $this->request->get['medical_record_id'] : 0;
        if (empty($medical_record_id)) {
            $output = $this->response->setCachedResponse(400, new stdClass(), "medical record id required", "service_partner");
            $this->api->trackResponse($output);
            return;
        } else {
            $cs_id = $this->model_name->copyMedicalRecord($medical_record_id);
            if ($cs_id) {
                $output = $this->response->setCachedResponse(200, array('medical_record_id' => (int)$cs_id), ' Success', "service_partner");
                $this->api->trackResponse($output);
                return;
            }
            else{
                $output = $this->response->setCachedResponse(500, new stdClass(), ' Something went wrong', "service_partner");
                $this->api->trackResponse($output);
                return;
            }
        }
    }

    protected function pay()
    {
        $purchase_order_id = !empty($this->request->get['purchase_order_id']) ? $this->request->get['purchase_order_id'] : 0;
        if (!empty($purchase_order_id)) {

            $po_info = $this->model_name->getPO($purchase_order_id);
            $etcm_purchase_order_id = $po_info['etcm_purchase_order_id'];

            $post_data = array("etcm_purchase_order_id" => $etcm_purchase_order_id);
            $path = 'etcm/service_partner/service_partner/pay';
            $result = $this->connectCurl($path, $post_data);
            if (!empty($result)) {
                if (!empty($result['error'])) {
                    $output = $this->response->setCachedResponse(204, new stdClass(), $result['message'], "service_partner");
                    $this->api->trackResponse($output);
                    return;
                } else {
                    $output = $this->response->setCachedResponse(200, $result['response'], $result['message'], "service_partner");
                    $this->api->trackResponse($output);
                    return;
                }
            } else {
                $output = $this->response->setCachedResponse(204, new stdClass(), "API Connection Errors : Please check the internet connection or API connection!", "service_partner");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setCachedResponse(400, new stdClass(), "purchase order id is required", "service_partner");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function receive_purchase_order()
    {
        $received = $this->config->get('config_service_partner_received_status');
        $purchase_order_id = !empty($this->request->get['purchase_order_id']) ? $this->request->get['purchase_order_id'] : 0;
        if (!empty($purchase_order_id)) {

            $po_info = $this->model_name->getPO($purchase_order_id);
            if (!empty($po_info)) {
                $etcm_purchase_order_id = $po_info['etcm_purchase_order_id'];
                $update_data = array(
                    "status_id" => 5,
                    "etcm_status_code" => "COMPLETED",
                    "date_completed" => date('Y-m-d H:i:s'),
                    "etcm_purchase_order_id" => $etcm_purchase_order_id
                );
                $this->model_name->updatePO($update_data);

                $post_data = array(
                    // "tracking_no"   => $tracking_no,
                    "status_code"   => $update_data['etcm_status_code'],
                    // "date_payment"  => $date_payment,
                    // "date_shipped"  => $date_shipped,
                    // "date_rated"    => $date_rated,
                    // "rate_details"  => $rate_details,
                    "date_completed"    => $update_data['date_completed'],
                    // "date_cancelled"    => $update_data['date_cancelled'],
                    // "cancel_reason" => $cancel_reason,
                    "purchase_order_id" => $etcm_purchase_order_id,
                    "from" => "CLIENT"
                );
                $path = 'etcm/service_partner/service_partner/update_po';
                $result = $this->connectCurl($path, $post_data);
                if (!empty($result)) {
                    if (!empty($result['error'])) {
                        $output = $this->response->setCachedResponse(204, new stdClass(), $result['message'], "service_partner");
                        return;
                    } else {
                        $output = $this->response->setCachedResponse(200, new stdClass(), $result['message'], "service_partner");
                        return;
                    }
                } else {
                    $output = $this->response->setCachedResponse(204, new stdClass(), "API Connection Errors : Please check the internet connection or API connection!", "service_partner");
                    $this->api->trackResponse($output);
                    return;
                }
            } else {
                $output = $this->response->setCachedResponse(400, new stdClass(), "purchase order id is invalid", "service_partner");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setCachedResponse(400, new stdClass(), "purchase order id required", "service_partner");
            $this->api->trackResponse($output);
            return;
        }
    }

    #region not implement in app yet
    protected function add_favourite_store()
    {
        if (!empty($this->request->post['service_partner_id'])) {
            $data = ['service_partner_id' => (int)$this->request->post['service_partner_id'], 'domain' => HTTP_SERVER];
            $path = 'etcm/service_partner/service_partner/add_favourite_store';
            $result = $this->connectCurl($path, $data);
            if (!empty($result)) {
                if (!empty($result['error'])) {
                    $output = $this->response->setCachedResponse(204, [], $result['message'], "service_partner");
                    return;
                } else {
                    $output = $this->response->setCachedResponse(200, $result['response'], $result['message'], "service_partner");
                    return;
                }
            } else {
                $output = $this->response->setCachedResponse(204, [], "API Connection Errors : Please check the internet connection or API connection!", "service_partner");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setCachedResponse(204, [], "Invalid Parameter : No store selected! ", "service_partner");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function remove_favourite_store()
    {
        if (!empty($this->request->post['service_partner_id'])) {
            $data = ['service_partner_id' => (int)$this->request->post['service_partner_id'], 'domain' => HTTP_SERVER];
            $path = 'etcm/service_partner/service_partner/remove_favourite_store';
            $result = $this->connectCurl($path, $data);
            if (!empty($result)) {
                if (!empty($result['error'])) {
                    $output = $this->response->setCachedResponse(204, [], $result['message'], "service_partner");
                    return;
                } else {
                    $output = $this->response->setCachedResponse(200, $result['response'], $result['message'], "service_partner");
                    return;
                }
            } else {
                $output = $this->response->setCachedResponse(204, [], "API Connection Errors : Please check the internet connection or API connection!", "service_partner");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setCachedResponse(204, [], "Invalid Parameter : No store selected! ", "service_partner");
            $this->api->trackResponse($output);
            return;
        }
    }
    #endregion

    #region callback function for etcm server

    public function update_po()
    {
        $data = $this->json;
        $tracking_no = !empty($data['tracking_no']) ? $data['tracking_no'] : '';
        $estimated_date = !empty($data['estimated_date']) ? $data['estimated_date'] : '';
        $proof_of_delivery = !empty($data['proof_of_delivery']) ? $data['proof_of_delivery'] : '';
        $status_id = !empty($data['status_id']) ? $data['status_id'] : '';
        $etcm_status_code = !empty($data['etcm_status_code']) ? $data['etcm_status_code'] : '';
        $date_payment = !empty($data['date_payment']) ? $data['date_payment'] : '';
        $date_prepared = !empty($data['date_prepared']) ? $data['date_prepared'] : '';
        $date_shipped = !empty($data['date_shipped']) ? $data['date_shipped'] : '';
        $date_rated = !empty($data['date_rated']) ? $data['date_rated'] : '';
        $rate_details = !empty($data['rate_details']) ? $data['rate_details'] : '';
        $date_completed = !empty($data['date_completed']) ? $data['date_completed'] : '';
        $date_cancelled = !empty($data['date_cancelled']) ? $data['date_cancelled'] : '';
        $cancel_reason = !empty($data['cancel_reason']) ? $data['cancel_reason'] : '';
        $etcm_purchase_order_id = !empty($data['etcm_purchase_order_id']) ? $data['etcm_purchase_order_id'] : '';
        $update_data = array(
            "tracking_no"       => $tracking_no,
            "estimated_date"    => $estimated_date,
            "proof_of_delivery" => $proof_of_delivery,
            "status_id"         => $status_id,
            "etcm_status_code"  => $etcm_status_code,
            "date_payment"      => $date_payment,
            "date_prepared"     => $date_prepared,
            "date_shipped"      => $date_shipped,
            "date_rated"        => $date_rated,
            "rate_details"      => $rate_details,
            "date_completed"    => $date_completed,
            "date_cancelled"    => $date_cancelled,
            "cancel_reason"     => $cancel_reason,
            "etcm_purchase_order_id"    => $etcm_purchase_order_id
        );
        $this->model_name->updatePO($update_data);

        $this->sendNotification($etcm_purchase_order_id);
    }

    public function update_shipping()
    {
        $data = $this->json;
        $update_data = array(
            "etcm_purchase_order_id"    => $data['etcm_purchase_order_id'],
            "shipping_address"          => $data['shipping_address'],
            "shipping_address_json"     => $data['shipping_address_json'],
        );
        $this->model_name->updateShipping($update_data);
    }

    #endregion


    #region private function


    private function getForm()
    {
        $data = [];
        $service_partner_id = !empty($this->request->post['service_partner_id']) ?  $this->request->post['service_partner_id'] : 0;

        $service_partner_info = [
            'service_partner_id' => (int)0,
            'doc_no' => '',
            'doc_date' => '',
            'store' => '',
            'customer' => '',
            'service_partner' => '',
            'total' => '',
            'status_code' => '',
            'date_added' => '',
            'added_by' => '',
            'form_status' => !empty($this->request->post['service_partner_id']) ? 'edit' : 'add',
        ];

        // Payment Address
        $payment_address_data = $this->getCompanyAddressData();
        $payment_address = !empty($payment_address_data['response']['payment_address']) ? $payment_address_data['response']['payment_address'] : new stdClass();
        $payment_addresses = !empty($payment_address_data['response']['payment_addresses']) ? $payment_address_data['response']['payment_addresses'] : [];

        //prepend store address_id with '1' to diffentiate with customer_id
        if (!empty($payment_address['address_id'])) {
            $payment_address['address_id'] = (int)("1" . $payment_address['address_id']);
        }

        $tcm_shipping_addresses = [];
        if (!empty($payment_addresses)) {
            foreach ($payment_addresses as $key => $address) {
                $tcm_shipping_addresses[$key] = $address;
                $tcm_shipping_addresses[$key]['address_id'] = (int)("1" . $tcm_shipping_addresses[$key]['address_id']);
                $tcm_shipping_addresses[$key]['default'] = false;
                $payment_addresses[$key]['address_id'] = (int)("1" . $payment_addresses[$key]['address_id']);
            }
        }

        // Medical Record
        if (!empty($this->request->get['medical_record_id'])) {
            $this->request->post['medical_record_id'] = $this->request->get['medical_record_id'];
        } else if (!empty($service_partner_info['medical_record_id'])) {
            $this->request->post['medical_record_id'] = $service_partner_info['medical_record_id'];
        } else {
            $this->request->post['medical_record_id'] = 0;
        }

        $medical_info = $this->getMedicalRecordInfo();
        $step_2 = true;
        if (!empty($medical_info['prescriptions'])) {
            $prescriptions = $medical_info['prescriptions'];
            foreach ($prescriptions as $prescription) {
                if (!empty($prescription['unmatched_products'])) {
                    $step_2  = false;
                }
            }
        } else {
            $step_2 = false;
        }

        //overwrite to always true and only cater at get_stores_api asked by ST
        $step_2 = true;

        //$prescriptions = $this->getMedicalRecordProducts();
        // Customers
        if (!empty($service_partner_info['customer_id'])) {
            $this->request->post['customer_id'] = $service_partner_info['customer_id'];
        } else if (!empty($medical_info['customer_id'])) {
            $this->request->post['customer_id'] = $medical_info['customer_id'];
        } else {
            $this->request->post['customer_id'] = 0;
        }
        $customer_info = $this->getCustomer();
        $this->request->post['address_id'] = (!empty($customer_info['medical_record_id'])) ? $customer_info['medical_record_id'] : 0;

        /** Service Partner START */
        if (!empty($this->request->post['shipping_type'])) {
            $shipping_type = $this->request->post['shipping_type'];
        } else if (!empty($service_partner_info['shipping_type'])) {
            $shipping_type = $service_partner_info['shipping_type'];
        } else {
            $shipping_type = 'DELIVERY';
        }
        $shipping_types = $this->getShippingTypes();
        /** Service Partner END */

        /** Shipping Address Section START */
        /** Shipping Type */
        if ($shipping_type == 'DELIVERY') {
            $shipping = true;
        } else {
            $shipping = false;
        }

        /** Get All Customer's Address */
        if (!empty($this->request->post['address_id'])) {
            $this->request->post['address_id'] = $this->request->post['address_id'];
        } else if (!empty($customer_info['address_id'])) {
            $this->request->post['address_id'] = $customer_info['address_id'];
        } else {
            $this->request->post['address_id'] = 0;
        }
        $shipping_addresses = $this->getCustomerAddresses();
        $shipping_address = new stdClass();
        if (!empty($shipping_addresses)) {
            foreach ($shipping_addresses as $sa) {
                if ($sa['default'] == 1) {
                    $shipping_address = $sa;
                }
            }
        }

        //combine tcm address and customer address
        $shipping_addresses = array_merge($shipping_addresses, $tcm_shipping_addresses);

        /** Selected Shipping Address */
        if (!empty($this->request->post['shipping_address_id'])) {
            $this->request->post['shipping_address_id'] = $this->request->post['shipping_address_id'];
        } else if (!empty($service_partner_info['shipping_address_id'])) {
            $this->request->post['shipping_address_id'] = $service_partner_info['shipping_address_id'];
        } else if (!empty($customer_info['shipping_address_id'])) {
            $this->request->post['shipping_address_id'] = $customer_info['address_id'];
        } else {
            $this->request->post['shipping_address_id'] = 0;
        }
        //$shipping_address = []; //$this->getCustomerAddress();
        /** Shipping Address Section END */

        /** Medical Section START */
        if (!empty($this->request->post['service_type'])) {
            $service_type = $this->request->post['service_type'];
        } else if (!empty($medical_info['service_type'])) {
            $service_type = $medical_info['service_type'];
        } else {
            $service_type = 'DECOCTION_BY_PARTNER';
        }
        $service_types = $this->getServiceTypes();
        /** Medical Section START */

        if (!empty($step_2)) {
            $note = ' You may proceed to Step 2 : Get related stores/service partner that provide the service.';
        } else {
            $note = ' Some of the form data is incomplete ! So cannot proceed to Step 2: Get stores/service partner !';
        }

        /** Action Section START */
        $action_info = [
            'step_2' => $step_2,
        ]; //$this->getActionInfo();
        /** Action Section END */

        /** Data */
        $data = [
            'domain'                    => HTTP_SERVER,
            'service_partner'           => $service_partner_info,
            'customer'                  => $customer_info,
            'payment_address'           => $payment_address,
            'payment_addresses'         => $payment_addresses,
            'shipping_type'             => empty($shipping_addresses) ? 'PICKUP_FROM_STORE' : $shipping_type,
            'shipping_types'            => $shipping_types,
            'shipping_address_display'  => empty($shipping_addresses) ? false : $shipping,
            'shipping_address'          => $shipping_address,
            'shipping_addresses'        => $shipping_addresses,
            'service_type'              => $service_type,
            'service_types'             => $service_types,
            'medical_record'            => $medical_info,
            //'prescriptions'             => $prescriptions,
            'action'                    => $action_info,
            'note' => $note,
        ];

        return $data;
    }

    private function getStoresForm()
    {
        // Search > Location {Customer City, Zone} ({Total Result})
        // Filtering Out 
        // >> Price Range , 
        // >> Sorting >> Price (Lowest to High), Price (Highes to low), Score (Highest to low), Rating (Highest to low), Distance (Nearest to far)
        // Filtering In
        // >> Search store name
        // >> Sorting >> Price (Lowest to High), Price (Highes to low), Score (Highest to low), Rating (Highest to low), Distance (Nearest to far)
        // >> Filtering >> Score
        // >> Filtering >> Ratings
        // >> Filtering >> Score
        // >> Filtering >> Price Range
        // >> Filtering >> Badges/Tags/Offer/Exta service

        // Store Details
        // >> store image
        // >> labels/tags/badge (Featured Store ... or extra service)
        // >> store_name
        // >> rating
        // >> store_city 
        // >> store_zone
        // >> score
        // >> reviews
        // >> total
        // >> daily sales / total sales
        // >> estimated delivery (Same day deliver or 2-3 days)
        $json = $this->json;

        $medical_record_id = $json['medical_record_id'];
        $filter_reviews = !empty($json['filter_reviews']) ? $json['filter_reviews'] : '';
        $filter_ratings = !empty($json['filter_ratings']) ? $json['filter_ratings'] : '';
        $filter_store_name = !empty($json['filter_store_name']) ? $json['filter_store_name'] : '';
        $filter_store_city = !empty($json['filter_store_city']) ? $json['filter_store_city'] : '';
        $filter_latitude = !empty($json['filter_latitude']) ? $json['filter_latitude'] : '';
        $filter_longitude = !empty($json['filter_longitude']) ? $json['filter_longitude'] : '';
        $filter_sorting = !empty($json['filter_sorting']) ? $json['filter_sorting'] : '';
        $filter_favourite = !empty($json['filter_favourite']) ? $json['filter_favourite'] : '';
        $filter_budget_from = !empty($json['filter_budget_from']) ? $json['filter_budget_from'] : '';
        $filter_budget_to = !empty($json['filter_budget_to']) ? $json['filter_budget_to'] : '';

        $this->request->post['medical_record_id'] = $medical_record_id;
        $medical_info = $this->getMedicalRecordInfo();
        $customer_id = !empty($medical_info['customer_id']) ? $medical_info['customer_id'] : 0;
        $this->request->post['customer_id'] = $customer_id;

        $prescriptions = $this->getMedicalRecordProducts();

        $address_id = !empty($this->json['shipping_address_id']) ? $this->json['shipping_address_id'] : 0;
        $shipping_address = [];
        if ($address_id) {
            $address_id_prefix = substr($address_id, 0, 1);
            $address_id = substr($address_id, 1);
            if ($address_id_prefix == '2') {
                //address_id from customer address book
                $this->request->post['address_id'] = $address_id;
                $shipping_address = $this->getCustomerAddress();
            } else {
                //address_id from store address book
                $company_address_data = $this->getCompanyAddressData();
                $company_addresses = !empty($company_address_data['response']['payment_addresses']) ? $company_address_data['response']['payment_addresses'] : [];
                $shipping_address = [];
                foreach ($company_addresses as $address) {
                    if ($address['address_id'] == $address_id) {
                        $shipping_address = $address;
                    }
                }
            }
        }


        $data = [
            'domain' => HTTP_SERVER,
            'filter_reviews' => $filter_reviews,
            'filter_ratings' => $filter_ratings,
            'filter_store_name' => $filter_store_name,
            'filter_store_city' => $filter_store_city,
            'filter_latitude' => $filter_latitude,
            'filter_longitude' => $filter_longitude,
            'filter_sorting' => $filter_sorting,
            'filter_favourite' => $filter_favourite,
            'filter_budget_from' => $filter_budget_from,
            'filter_budget_to' => $filter_budget_to,
            'medical_record_id'  => (int)$this->json['medical_record_id'],
            'shipping_type' => !empty($this->json['shipping_type']) ? $this->json['shipping_type'] : 'PICKUP_FROM_STORE',
            'shipping_address_id' => (int)$address_id,
            'shipping_address' =>  $shipping_address,
            'service_type' => $this->json['service_type'],
            'prescriptions' =>  $prescriptions,
        ];
        return $data;
    }

    private function getStoreDetailForm()
    {
        $json = $this->json;

        $medical_record_id = $json['medical_record_id'];

        $this->request->post['medical_record_id'] = $medical_record_id;
        $medical_info = $this->getMedicalRecordInfo();

        $customer_id = !empty($medical_info['customer_id']) ? $medical_info['customer_id'] : 0;
        $this->request->post['customer_id'] = $customer_id;

        $prescriptions = $this->getMedicalRecordProducts();

        $service_partner_id = !empty($this->json['service_partner_id']) ? $this->json['service_partner_id'] : 0;
        $address_id = !empty($this->json['shipping_address_id']) ? $this->json['shipping_address_id'] : 0;
        $shipping_address = [];
        if ($address_id) {
            $address_id_prefix = substr($address_id, 0, 1);
            $address_id = substr($address_id, 1);
            if ($address_id_prefix == '2') {
                //address_id from customer address book
                $this->request->post['address_id'] = $address_id;
                $shipping_address = $this->getCustomerAddress();
            } else {
                //address_id from store address book
                $company_address_data = $this->getCompanyAddressData();
                $company_addresses = !empty($company_address_data['response']['payment_addresses']) ? $company_address_data['response']['payment_addresses'] : [];
                $shipping_address = [];
                foreach ($company_addresses as $address) {
                    if ($address['address_id'] == $address_id) {
                        $shipping_address = $address;
                    }
                }
            }
        }


        $data = [
            'domain' => HTTP_SERVER,
            'medical_record_id'  => (int)$this->json['medical_record_id'],
            'shipping_type' => !empty($this->json['shipping_type']) ? $this->json['shipping_type'] : 'PICKUP_FROM_STORE',
            'shipping_address_id' => (int)$address_id,
            'shipping_address' =>  $shipping_address,
            'service_partner_id' => $service_partner_id,
            'prescriptions' =>  $prescriptions,
        ];
        return $data;
    }

    private function validateGetStoreDetail()
    {
        $this->error = '';
        $json = $this->json;
        if (empty($json)) {
            $this->error = 'Some of parameter & data are missing !';
            return;
        } else {
            /** service partner id */

            if (empty($json['service_partner_id'])) {
                $this->error = "Service partner id is required";
                return;
            }

            /** Medical Id  */
            $customer_id = 0;
            if (empty($json['medical_record_id'])) {
                $this->error = 'The medical record must be selected!';
                return;
            } else {
                $this->request->post['medical_record_id'] = $json['medical_record_id'];
                $medical_record = $this->getMedicalRecordInfo();
                if (empty($medical_record)) {
                    $this->error = 'Invalid medical record & not exists! Please try again!';
                    return;
                } else {
                    if (empty($medical_record['prescriptions'])) {
                        $this->error = 'Medical record does not have any prescriptions';
                        return;
                    } else {
                        $product_unmatched = false;
                        foreach ($medical_record['prescriptions'] as $prescription) {
                            if (!empty($prescription['unmatched_products'])) {
                                $product_unmatched  = true;
                            }
                        }
                        if ($product_unmatched) {
                            $this->error = 'Cannot matched the product with available brewing partner';
                            return;
                        } else {
                            $customer_id = !empty($medical_record['customer_id']) ? $medical_record['customer_id'] : 0;
                            if (empty($customer_id)) {
                                $this->error = 'The customer parameter & data is missing!';
                                return;
                            } else {
                                $this->request->post['customer_id'] = $customer_id;
                                $customer_info = $this->getCustomer();
                                if (empty($customer_info)) {
                                    $this->error = ' Invalid customer & the customer data is not exists !';
                                    return;
                                }
                            }
                        }
                    }
                }
            }
        }
        return true;
    }

    private function validateGetStores()
    {
        $this->error = '';
        $json = $this->json;
        if (empty($json)) {
            $this->error = 'Some of parameter & data are missing !';
            return;
        } else {
            /** Medical Id  */
            $customer_id = 0;
            if (empty($json['medical_record_id'])) {
                $this->error = 'The medical record must be selected!';
                return;
            } else {
                $this->request->post['medical_record_id'] = $json['medical_record_id'];
                $medical_record = $this->getMedicalRecordInfo();
                if (empty($medical_record)) {
                    $this->error = 'Invalid medical record & not exists! Please try again!';
                    return;
                } else {
                    if (empty($medical_record['prescriptions'])) {
                        $this->error = 'Medical record does not have any prescriptions';
                        return;
                    } else {
                        $product_unmatched = false;
                        foreach ($medical_record['prescriptions'] as $prescription) {
                            if (!empty($prescription['unmatched_products'])) {
                                $product_unmatched  = true;
                            }
                        }
                        if ($product_unmatched) {
                            $this->error = 'Cannot matched the product with available brewing partner';
                            return;
                        } else {
                            $customer_id = !empty($medical_record['customer_id']) ? $medical_record['customer_id'] : 0;
                            if (empty($customer_id)) {
                                $this->error = 'The customer parameter & data is missing!';
                                return;
                            } else {
                                $this->request->post['customer_id'] = $customer_id;
                                $customer_info = $this->getCustomer();
                                if (empty($customer_info)) {
                                    $this->error = ' Invalid customer & the customer data is not exists !';
                                    return;
                                }
                            }
                        }
                    }
                }
            }
        }
        return true;
    }

    private function getPurchaseOrderStatuses()
    {
        $data = [];
        $language = !empty($_SERVER['HTTP_ACCEPT_LANGUAGE']) ? $_SERVER['HTTP_ACCEPT_LANGUAGE'] : 'cn';
        if ($language == 'en') {
            $data = [
                array(
                    'id'   => 1,
                    'status' => 0,
                    'code' => 'ALL',
                    'name' => 'All',
                    'image' => "https://www.etcm.me/image/doctorapp/order_status_icon/all.png",
                    'color' => null,
                    'sort_order' => 0,
                ),
                array(
                    'id'   => 1,
                    'status' => 1,
                    'code' => 'TO_PAY',
                    'name' => 'Pending',
                    'image' => "https://www.etcm.me/image/doctorapp/order_status_icon/to-pay.png",
                    'color' => '#D1D1D1',
                    'sort_order' => 1,
                ),
                array(
                    'id'   => 2,
                    'status' => 2,
                    'code' => 'TO_SHIP',
                    'name' => 'Preparing',
                    'image' => "https://www.etcm.me/image/doctorapp/order_status_icon/to-ship.png",
                    'color' => '#F38733',
                    'sort_order' => 2,
                ),
                array(
                    'id'   => 2,
                    'status' => 3,
                    'code' => 'TO_RECEIVE',
                    'name' => 'To Collect/Receive',
                    'image' => "https://www.etcm.me/image/doctorapp/order_status_icon/to-receive.png",
                    'color' => '#FF78BB',
                    'sort_order' => 3,
                ),
                array(
                    'id'   => 2,
                    'status' => 5,
                    'code' => 'COMPLETED',
                    'name' => 'Completed',
                    'image' => "https://www.etcm.me/image/doctorapp/order_status_icon/completed.png",
                    'color' => '#8FBB6C',
                    'sort_order' => 4,
                ),
                array(
                    'id'   => 2,
                    'status' => 7,
                    'code' => 'CANCELLED',
                    'name' => 'Cancelled',
                    'image' => "https://www.etcm.me/image/doctorapp/order_status_icon/cancelled.png",
                    'color' => '#F56B6B',
                    'sort_order' => 5,
                ),
            ];
        } else {
            $data = [
                array(
                    'id'   => 1,
                    'status' => 0,
                    'code' => 'ALL',
                    'name' => '全部',
                    'image' => "https://www.etcm.me/image/doctorapp/order_status_icon/all.png",
                    'color' => null,
                    'sort_order' => 0,
                ),
                array(
                    'id'   => 1,
                    'status' => 1,
                    'code' => 'TO_PAY',
                    'name' => '待定',
                    'image' => "https://www.etcm.me/image/doctorapp/order_status_icon/to-pay.png",
                    'color' => '#D1D1D1',
                    'sort_order' => 1,
                ),
                array(
                    'id'   => 2,
                    'status' => 1,
                    'code' => 'TO_SHIP',
                    'name' => '准备中',
                    'image' => "https://www.etcm.me/image/doctorapp/order_status_icon/to-ship.png",
                    'color' => '#F38733',
                    'sort_order' => 2,
                ),
                array(
                    'id'   => 2,
                    'status' => 3,
                    'code' => 'TO_RECEIVE',
                    'name' => '待自取/待收货',
                    'image' => "https://www.etcm.me/image/doctorapp/order_status_icon/to-receive.png",
                    'color' => '#FF78BB',
                    'sort_order' => 3,
                ),
                array(
                    'id'   => 2,
                    'status' => 5,
                    'code' => 'COMPLETED',
                    'name' => '已完成',
                    'image' => "https://www.etcm.me/image/doctorapp/order_status_icon/completed.png",
                    'color' => '#8FBB6C',
                    'sort_order' => 4,
                ),
                array(
                    'id'   => 2,
                    'status' => 7,
                    'code' => 'CANCELLED',
                    'name' => '已取消',
                    'image' => "https://www.etcm.me/image/doctorapp/order_status_icon/cancelled.png",
                    'color' => '#F56B6B',
                    'sort_order' => 5,
                ),
            ];
        }
        return $data;
    }

    private function formattedPurchaseOrders($purchase_orders)
    {
        $data = [];
        $statuses = $this->getPurchaseOrderStatuses();
        $arr_status = array();
        foreach ($statuses as $status) {
            $arr_status[$status['code']] = [
                "id"        => $status['id'],
                "status"    => $status['status'],
                "code"      => $status['code'],
                "name"      => $status['name'],
                "color"     => $status['color'],
                "sort_order" => $status['sort_order'],
            ];
        }
        if (!empty($purchase_orders)) {
            foreach ($purchase_orders as $po) {

                $estimated_text = $po['estimated_date'];
                if (date('Y', strtotime($estimated_text)) == '1970') {
                    $estimated_text = null;
                }

                switch ($po['etcm_status_code']) {
                    case 'TO_PAY':
                        $status_text_en = 'Pending payment';
                        $status_text_cn = '待付款';
                        break;
                    case  'TO_SHIP':
                        if (!empty($po['date_prepared'])) {
                            $date_text = date_format(date_create($po['date_prepared']), "j M Y");
                            $status_text_en = 'Started dispense on ' . $date_text;
                            $status_text_cn = '在' . $date_text  . '开始配药';
                        } else {
                            $status_text_en = 'Waiting for confirmation';
                            $status_text_cn = '待确认';
                        }
                        break;
                    case 'TO_RECEIVE':
                        if ($po['shipping_type'] == 'DELIVERY') {
                            $date_text = date_format(date_create($po['date_shipped']), "j M Y");
                            $status_text_en = 'Shipped on ' . $date_text;
                            $status_text_cn = '订单运送中 ' . $date_text;
                        } else {
                            $collect_date = !empty($estimated_text) ? $estimated_text : $po['date_shipped'];
                            $date_text = date_format(date_create($collect_date), "j M Y");
                            $status_text_en = 'Collect by ' . $date_text;
                            $status_text_cn = '已提取 ' . $date_text;
                        }
                        break;
                    case 'COMPLETED':
                        $date_text =  date_format(date_create($po['date_completed']), "j M Y");
                        $status_text_en = "Completed on $date_text";
                        $status_text_cn = "完成于 $date_text";
                        break;
                    case 'CANCELLED':
                        $date_text =  date_format(date_create($po['date_cancelled']), "j M Y");
                        $status_text_en = "Cancelled on $date_text";
                        $status_text_cn = "取消日期 $date_text";
                        break;
                    default:
                        $status_text_en = '';
                        $status_text_cn = '';
                }

                if (!empty($po['etcm_status_code'])) {
                    if ($po['etcm_status_code'] == 'TO_SHIP' && empty($po['date_prepared'])) {
                        $po['etcm_status_code'] = 'TO_PAY';
                    }
                    $status_name = str_replace('_', ' ', $po['etcm_status_code']);
                } else {
                    $status_name = null;
                }

                if (!empty($arr_status[$po['etcm_status_code']]['name'])) {
                    $status_name = $arr_status[$po['etcm_status_code']]['name'];
                    if ($po['etcm_status_code'] == 'TO_RECEIVE') {
                        if ($po['shipping_type'] == 'DELIVERY') {
                            $status_name = $this->session->data['language_id'] == 1 ? 'To Receive' : '待收货';
                        } else {
                            $status_name = $this->session->data['language_id'] == 1 ? 'To Collect' : '待自取';
                        }
                    }
                }

                $status_text = $this->session->data['language_id'] == 1 ? $status_text_en : $status_text_cn;


                $data[] = [
                    'purchase_order_id' => (int)$po['purchase_order_id'],
                    'doc_no' => $po['doc_no'],
                    'doc_date' => date('d M Y', strtotime($po['doc_date'])),
                    'status_text' => (string)$status_text,
                    'status' => $po['etcm_status_code'],
                    'status_name' => $status_name,
                    'color' => !empty($arr_status[$po['etcm_status_code']]['color']) ? $arr_status[$po['etcm_status_code']]['color'] : '#eeeeee',
                    'customer_id' => (int)$po['customer_id'],
                    'customer_name' => $po['customer_name'],
                    'customer_telephone' => $po['customer_telephone'],
                    'customer_email' => $po['customer_email'],
                    'service_partner_name' => $po['service_partner_name'],
                    'service_type' => $po['service_type'],
                    'shipping_type' => $po['shipping_type'],
                    'total' => (float)$po['service_partner_total'],
                    'total_text' => $po['service_partner_total_text'],
                ];
            }
        }
        return $data;
    }

    private function getPurchasedOrder($purchase_order_id)
    {
        $data = [];
        if (!empty($purchase_order_id)) {
            $result = $this->model_name->getPurchasedOrder($purchase_order_id);

            $total_data = !empty($result['service_partner_total_json']) ?  $result['service_partner_total_json'] : [];
            $totals = $this->formattedTotal($total_data);

            $prescription_data = !empty($result['service_partner_prescription_json']) ?  $result['service_partner_prescription_json'] : [];
            $prescriptions = $this->formattedPrescriptions($prescription_data);

            $image_data = !empty($result['image_json']) ? $result['image_json'] : [];
            $images = json_decode($image_data, true);

            $action = $this->getPurchasedOrderAction($result);

            $order_summary = $this->getOrderSummary($result);

            //get order detail from etcm
            $order_detail = [];
            $order_history =  [];
            $path_order = 'etcm/service_partner/service_partner/get_order_detail';
            $detail_result = $this->connectCurl($path_order, array("purchase_order_id" => $result['etcm_purchase_order_id']));
            if (!empty($detail_result)) {
                if (empty($detail_result['error'])) {
                    $order_detail = $detail_result['response'];

                    //order_history_part
                    foreach ($order_detail['history'] as $history) {
                        $order_history[] = array(
                            'date' => date_format(date_create($history['date_added']), "j M H:i"),
                            'text' => $history['comment']
                        );
                    }
                }
            }

            //get cancel reason
            // $reasons = $this->getCancelReasons();
            $reasons = null;

            $shipping_address = $result['shipping_type'] == 'PICKUP_FROM_STORE' ? 'Pickup from store' : $result['shipping_address'];

            $shipping_type = str_replace('_', ' ', ucfirst(strtolower($result['shipping_type'])));


            if (!empty($result)) {

                if ($result['etcm_status_code'] == 'TO_PAY') {
                    $payment_text = 'UNPAID';
                } else {
                    if ($result['payment_method'] == 'free_checkout') {
                        $payment_text = 'ETCM Pay';
                    } elseif ($result['payment_method'] == 'kiple') {
                        $payment_title = !empty($order_detail['payment_title']) ? "(" . $order_detail['payment_title'] . ")" : "";
                        $payment_text = "Online $payment_title";
                    } else {
                        $payment_text = $result['payment_method'];
                    }
                }

                //estimate text
                $estimated_text = $result['estimated_date'];
                if (date('Y', strtotime($estimated_text)) != '1970') {
                    $est_date = date('j M', strtotime($estimated_text));
                    $est_time = date('h:i A', strtotime($estimated_text));

                    if ($result['etcm_status_code'] == 'TO_SHIP' && !empty($result['date_prepared'])) {
                        $estimated_text_en = "Estimate dispensing process will complete on $est_date at $est_time";
                        $estimated_text_cn = "配药流程预计将完成于 $est_date $est_time";
                        if ($result['shipping_type'] == 'DELIVERY') {
                            $estimated_text_en = "Order will ship out by $est_date at $est_time";
                            $estimated_text_cn = "订单将发货于 $est_date $est_time";
                        }
                    }
                    if ($result['etcm_status_code'] == 'TO_RECEIVE') {
                        $estimated_text_en = "";
                        $estimated_text_cn = "";
                        if ($result['shipping_type'] != 'DELIVERY') {
                            $estimated_text_en = "Ready to collect by $est_date after $est_time";
                            $estimated_text_cn = "将被提取于 $est_date $est_time 之后";
                        }
                    }
                } elseif ($result['etcm_status_code'] == 'COMPLETED') {
                    $estimated_text_en = "Order Received";
                    $estimated_text_cn = "订单已完成";
                } elseif ($result['etcm_status_code'] == 'CANCELLED') {
                    $estimated_text_en = "Order Cancelled";
                    $estimated_text_cn = "订单已取消";
                } else {
                    $estimated_text_en = "Estimated: $estimated_text";
                    $estimated_text_cn = "预计" . str_replace(' working day(s)', "天的工作日", $estimated_text);
                }

                $estimated_text = $this->session->data['language_id'] == 1 ? $estimated_text_en : $estimated_text_cn;

                $tracking_no = (!empty($result['tracking_no']) && $result['shipping_type'] == 'DELIVERY') ? trim($result['tracking_no']) : null;
                $track_word = explode(' ', $tracking_no);
                $tracking_no = array_pop($track_word);

                $tracking_link = '';
                $tracking_no = trim($tracking_no);
                if (strtolower(substr($tracking_no, 0, 3)) === 'znd') {
                    $tracking_link = "https://tracking.my/lineclear/" . $tracking_no;
                } elseif (!empty($tracking_no)) {
                    $tracking_link = "https://www.aftership.com/track/" . $tracking_no;
                } else {
                    $tracking_link = null;
                }

                $data = [
                    'customer' => [
                        'customer_id' => (int)$result['customer_id'],
                        'customer_name' => $result['customer_name'],
                        'customer_telephone' => $result['customer_telephone'],
                        'customer_email' => $result['customer_email'],
                    ],
                    'delivery_address' => [
                        'shipping_type' => $shipping_type,
                        'estimated_date' => $estimated_text,
                        'shipping_address' => $shipping_address,
                    ],
                    'service_partner' => [
                        'service_partner_id' => (int)$result['service_partner_id'],
                        'service_partner_name' => $result['service_partner_name'],
                        'service_type' => $this->getServiceTypeName($result['service_type']),
                    ],
                    'medical' => [
                        'medical_record_id' => $result['medical_record_id'],
                        'prescriptions' => $prescriptions,
                        'images' => $images,
                        'shipping' => (string)$totals['total_data']['shipping'],
                        'shipping_text' => $totals['total_data']['shipping_text'],
                        'total' => $totals['total_data']['total'],
                        'total_text' => $totals['total_data']['total_text'],
                    ],
                    'payment' => [
                        'payment_method' => $payment_text,
                        'payment_address' => $result['payment_address']
                    ],
                    'total' => $totals['totals'],
                    'order' => [
                        'purchase_order_id' => (int)$result['purchase_order_id'],
                        'doc_no' => $result['doc_no'],
                        'doc_date' => date('d M Y H:i:s', strtotime($result['doc_date'])),
                        'status' => $result['etcm_status_code'],
                        'shipping_type' => $result['shipping_type'],
                        'estimated_date' => $estimated_text,
                        'date_ordered' => !empty($result['date_ordered']) ? date('d M Y H:i:s', strtotime($result['date_ordered'])) : null,
                        'date_payment' => !empty($result['date_payment']) ? date('d M Y H:i:s', strtotime($result['date_payment'])) : null,
                        'date_shipped' => !empty($result['date_shipped']) ? date('d M Y H:i:s', strtotime($result['date_shipped'])) : null,
                        'date_completed' => !empty($result['date_completed']) ? date('d M Y H:i:s', strtotime($result['date_completed'])) : null,
                        'date_cancelled' => !empty($result['date_cancelled']) ? date('d M Y H:i:s', strtotime($result['date_cancelled'])) : null,
                        'tracking_no' => (!empty($result['tracking_no']) && $result['shipping_type'] == 'DELIVERY') ? trim($result['tracking_no']) : null,
                        'tracking_no_link' => $tracking_link,
                        'proof_of_delivery' => !empty($result['proof_of_delivery']) ? $result['proof_of_delivery'] : null
                    ],
                    'order_summary' => $order_summary,
                    'order_history' => $order_history,
                    'action' => $action,
                    'cancel_reason' => $reasons,
                    'cancelled_reason' => !empty($result['cancel_reason']) ? $result['cancel_reason'] : null
                ];
            }
        }
        return $data;
    }

    private function getOrderSummary($order)
    {
        $estimated_text = $order['estimated_date'];
        if (date('Y', strtotime($estimated_text)) == '1970') {
            $estimated_text = null;
        }
        switch ($order['etcm_status_code']) {
            case 'TO_PAY':
                $title_en = 'Order Pending';
                $title_cn = '订单还未付款';
                $content_en = 'Please complete your payment';
                $content_cn = '请完成付款';
                $image = 'https://www.etcm.me/image/doctorapp/order_status_icon/to-pay-alt.png';
                break;
            case 'TO_SHIP':
                if (!empty($order['date_prepared'])) {
                    $title_en = 'Order has started prepare on';
                    $title_cn = '订单将开始准备';
                    $content_en = date_format(date_create($order['date_prepared']), "j M Y h:i A");
                    $content_cn = $content_en;
                } else {
                    $title_en = 'Waiting for confirmation';
                    $title_cn = '待确认';
                    $content_en = '';
                    $content_cn = $content_en;
                }
                $image = 'https://www.etcm.me/image/doctorapp/order_status_icon/to-ship-alt.png';
                break;
            case 'TO_RECEIVE':
                if ($order['shipping_type'] == 'DELIVERY') {
                    $title_en = 'Order has been shipped on';
                    $title_cn = '订单运送中';
                    $content_en = date_format(date_create($order['date_shipped']), "j M Y h:i A");
                    $content_cn = $content_en;
                } else {
                    $collect_date = !empty($estimated_text) ? $estimated_text : $order['date_shipped'];
                    $title_en = 'Order ready to be collected by';
                    $title_cn = '订单将被取货于';
                    $content_en = date_format(date_create($collect_date), "j M Y h:i A");
                    $content_cn = $content_en;
                }
                $image = 'https://www.etcm.me/image/doctorapp/order_status_icon/to-receive-alt.png';
                break;
            case 'COMPLETED':
                $title_en = 'Order has completed on';
                $title_cn = '订单已完成';
                $content_en = date_format(date_create($order['date_completed']), "j M Y h:i A");
                $content_cn = $content_en;
                $image = 'https://www.etcm.me/image/doctorapp/order_status_icon/completed-alt.png';
                break;
            case 'CANCELLED':
                $title_en = 'Order Cancelled';
                $title_cn = '订单已取消';
                $content_en = 'Cancel on ' . date_format(date_create($order['date_cancelled']), "j M Y h:i A");
                $content_cn = 'Cancel on ' . date_format(date_create($order['date_cancelled']), "j M Y h:i A");
                $image = 'https://www.etcm.me/image/doctorapp/order_status_icon/cancelled-alt.png';
                break;
            default:
                $title_en = '';
                $title_cn = '';
                $content_en = '';
                $content_cn = '';
                $image = 'https://www.etcm.me/image/doctorapp/order_status_icon/all-alt.png';
        }

        return [
            "title" => ($this->session->data['language_id'] == '1') ? $title_en : $title_cn,
            "content" => ($this->session->data['language_id'] == '1') ? $content_en : $content_cn,
            "image" => $image
        ];
    }

    private function getPurchasedOrderAction($po_info)
    {
        $status = $po_info['etcm_status_code'];
        $po_no = $po_info['doc_no'];
        $default_greeting = "Hi, I'm contacting you regarding brewing purchase order $po_no from ETCM Doctor App";
        $default_greeting = urlencode($default_greeting);
        $data = [];
        $contact_store = array(
            'action_type' => 'link',
            'action' => 'https://api.whatsapp.com/send?phone=60174012810&text=' . $default_greeting,
            'status' => true,
        );


        if ($status != 'COMPLETED' && $status != 'CANCELLED' && $status != 'TO_RECEIVE') {
            $cancel_button = array(
                'action_type' => 'api',
                'action' => null,
                'status' => true,
            );
        } else {
            $cancel_button = array(
                'action_type' => 'api',
                'action' => null,
                'status' => false,
            );
        }

        //cancel disable if already prepared
        if ($status == 'TO_SHIP' && !empty($po_info['date_prepared'])) {
            $cancel_button['status'] = false;
        }

        if ($status == 'COMPLETED') {
            $rate_button = array(
                'action_type' => 'api',
                'action' => null,
                'status' => true,
            );
            $reorder_button = array(
                'action_type' => 'api',
                'action' => null,
                'status' => true,
            );
        } else {
            $rate_button = array(
                'action_type' => 'api',
                'action' => null,
                'status' => false,
            );
            $reorder_button = array(
                'action_type' => 'api',
                'action' => null,
                'status' => false,
            );
        }

        if ($status == 'TO_RECEIVE' && $po_info['shipping_type'] == 'DELIVERY') {
            $received_button = array(
                'action_type' => 'api',
                'action' => null,
                'status' => true,
            );
        } else {
            $received_button = array(
                'action_type' => 'api',
                'action' => null,
                'status' => false,
            );
        }

        if ($status == 'TO_PAY') {
            $pay_button = array(
                'action_type' => 'api',
                'action' => null,
                'status' => true,
            );
        } else {
            $pay_button = array(
                'action_type' => 'api',
                'action' => null,
                'status' => false,
            );
        }

        $data = [
            'contact_store' => $contact_store,
            'pay_button' => $pay_button,
            'ship_button' => null,
            'cancel_button' => $cancel_button,
            'received_button' => $received_button,
            'rate_button' => $rate_button,
            'reorder_button' => $reorder_button
        ];
        return $data;
    }

    private function formattedTotal($totals)
    {
        $data = [];
        $total_amount = 0;
        $total_text = '';
        $shipping = "0";
        $shipping_text = '';
        $data['totals'] = [];
        $data['total_data'] = [];
        if (!empty($totals)) {
            $totals = json_decode($totals, true);
            foreach ($totals as $total) {


                //translate title
                switch ($total['code']) {
                    case 'sub_total':
                        $title_en = "Subtotal";
                        $title_cn = "商品小计";
                        break;
                    case 'tax':
                        $title_en = "Tax";
                        $title_cn = "税额";
                        break;
                    case 'rounding':
                        $title_en = "Rounding";
                        $title_cn = "舍入";
                        break;
                    case 'shipping':
                        $title_en = "Shipping";
                        $title_cn = "运输费";
                        break;
                    case 'credit':
                        $title_en = "ETCM Pay";
                        $title_cn = "ETCM 支付";
                        break;
                    case 'total':
                        $title_en = "Total";
                        $title_cn = "付款总额";
                        break;
                    default:
                        $title_en = $total['title'];
                        $title_cn = $total['title'];
                }

                $title = $this->session->data['language_id'] == 1 ? $title_en : $title_cn;

                $data['totals'][] = [
                    'title' => $title,
                    'value' => number_format($total['value'], 2),
                    'text' => !empty($total['text']) ? $total['text'] : $this->currency->format($total['value'], $this->config->get('config_currency'))
                ];

                if ($total['code'] == 'shipping') {
                    $shipping = number_format($total['value'], 2);
                    $shipping_text = !empty($total['text']) ? $total['text'] : $this->currency->format($total['value'], $this->config->get('config_currency'));
                }

                if ($total['code'] == 'sub_total') {
                    $total_amount = number_format($total['value'], 2);
                    $total_text = !empty($total['text']) ? $total['text'] : $this->currency->format($total['value'], $this->config->get('config_currency'));
                }
            }

            $data['total_data'] = [
                'shipping' => $shipping,
                'shipping_text' => $shipping_text,
                'total' => $total_amount,
                'total_text' => $total_text
            ];
        }
        return $data;
    }

    private function convertPresName($name)
    {
        if ($this->session->data['language_id'] == 1) {
            $name = str_replace('处方', 'Prescription', $name);
        } else {
            $name = str_replace('Prescription', '处方', $name);
        }
        return $name;
    }

    private function formattedPrescriptions($prescriptions)
    {
        $data = [];
        if (!empty($prescriptions)) {
            $prescriptions = json_decode($prescriptions, true);
            foreach ($prescriptions as $key => $prescription) {
                $language_id = $this->session->data['language_id'];

                $data[$key] = [
                    'name' => (string)$this->convertPresName($prescription['name']),
                    'times' => '共' . $prescription['times'] . '剂',
                    'day' => '每日' . $prescription['day'] . '次',
                    'consume_method' => !empty($prescription['consume_method']) ? $prescription['consume_method'] : '',
                    'take_type' => !empty($prescription['take_type']) ? $prescription['take_type'] : '',
                    "medical_instruction" => !empty($prescription['medical_instruction']) ? $prescription['medical_instruction'] : '',
                    'total_products' => $prescription['total_products'] . ' 药品',
                    'total_weights' => $prescription['total_weights'] . $prescription['uom'],
                    'total_amount' => $prescription['total_amount_text'],
                    'products' => [],
                ];

                if (!empty($prescription['products'])) {
                    foreach ($prescription['products'] as $product) {
                        $data[$key]['products'][] = [
                            'product_id' => (int)$product['customer_product_id'],
                            'product_name' => $product['customer_product_name'],
                            'quantity' => number_format($product['quantity'], 2),
                            'times' => (int)$product['times'],
                            'total_weight' => number_format($product['total_weight'], 2) . $product['uom'],
                            'total' => $product['total_text'],
                        ];
                    }
                }
            }
        }
        return $data;
    }

    private function validateGetOrders()
    {
        $this->error = '';
        $get_data = $this->request->get;
        if (empty($get_data)) {
            $this->error = ' the purchase order id cannot be empty !';
            return;
        } else {
            $purchase_order_id = !empty($get_data['purchase_order_id']) ? $get_data['purchase_order_id'] : 0;
            $purchased_order = $this->model_name->checkPurchaseOrder($purchase_order_id);
            if (empty($purchased_order)) {
                $this->error = ' invalid purchase order id & the purchase order data is not exists !';
                return;
            }
        }
        return true;
    }

    private function validateGetCheckout()
    {
        $this->error = '';
        $json = $this->json;
        if (empty($json)) {
            $this->error = 'Some of parameter & data are missing !';
            return;
        } else {
            /** Service Partner Id */
            if (empty($json['service_partner_id'])) {
                $this->error = ' please select your service partner before checkout!';
                return;
            }

            /** Medical Record Id */
            $customer_id = 0;
            if (empty($json['medical_record_id'])) {
                $this->error = ' please select the medical record before checkout!';
                return;
            } else {
                $this->request->post['medical_record_id'] = $json['medical_record_id'];
                $medical_record = $this->getMedicalRecordInfo();
                if (empty($medical_record)) {
                    $this->error = '  Invalid medical record & not exists! Please try again!';
                    return;
                } else {
                    $customer_id = !empty($medical_record['customer_id']) ? $medical_record['customer_id'] : 0;
                    if (empty($customer_id)) {
                        $this->error = '  the customer parameter & data is missing!';
                        return;
                    } else {
                        $this->request->post['customer_id'] = $customer_id;
                        $customer_info = $this->getCustomer();
                        if (empty($customer_info)) {
                            $this->error = ' Invalid customer & the customer data is not exists !';
                            return;
                        }
                    }
                }
            }

            /** Service Type */
            // if (empty($json['service_type'])) {
            //     $this->error = ' the service type must be selected!';
            //     return;
            // }

            /** Shipping Method */
            // if (empty($json['shipping_type'])) {
            //     $this->error = ' the shipping method must be selected!';
            //     return;
            // }

            /** Payment Address Id */
            // if (empty($json['payment_address_id'])) {
            //     $this->error = ' the payment address must be selected!';
            //     return;
            // }

            /** Shipping Address Id */
            if ($json['shipping_type'] == 'DELIVERY') {
                if (empty($json['shipping_address_id'])) {
                    $this->error = ' the shipping address must be selected!';
                    return;
                } else {
                    $address_id = $json['shipping_address_id'];
                    $address_id_prefix = substr($address_id, 0, 1);
                    $address_id = substr($address_id, 1);
                    if ($address_id_prefix == '2') {
                        //address_id from customer address book
                        $shipping_address = $this->model_name->getCustomerAddress($customer_id, $address_id);
                        if (empty($shipping_address)) {
                            $this->error = ' Invalid address & the address data is not exists !';
                            return;
                        }
                    } else {
                        //address_id from store address book
                        $company_address_data = $this->getCompanyAddressData();
                        $company_addresses = !empty($company_address_data['response']['payment_addresses']) ? $company_address_data['response']['payment_addresses'] : [];
                        $company_address = [];
                        foreach ($company_addresses as $address) {
                            if ($address['address_id'] == $address_id) {
                                $company_address = $address;
                            }
                        }
                        if (empty($company_address)) {
                            $this->error = ' Invalid address & the address data is not exists !';
                            return;
                        }
                    }
                }
            }
        }
        return true;
    }

    private function getCheckoutForm()
    {
        // Note
        // Shipping Address
        // Store Name
        // Prescription > Products Details
        // Shipping Method / Delivery Option > View all options
        // Payment Details/Address/Invoice
        // Payment Method > View all methods
        // Tip for service provider
        // Discount/Voucher/Coupon
        // Credit/Cashback
        // Invoice and Payment Details/Contact Info
        // Total > Subtotal, Shipping, Toatl
        // Action > 送出订单
        $medical_info = $this->getMedicalRecordInfo();
        $customer_id = !empty($medical_info['customer_id']) ? $medical_info['customer_id'] : 0;
        $customer_info = $this->getCustomer();

        $prescriptions = $this->getMedicalRecordProducts();

        $shipping_type = !empty($this->json['shipping_type']) ? $this->json['shipping_type'] : 'PICKUP_FROM_STORE';

        $address_id = 0;
        if ($shipping_type == 'DELIVERY') {
            $address_id = !empty($this->json['shipping_address_id']) ? $this->json['shipping_address_id'] : 0;
        }
        $shipping_address = [];
        if ($address_id) {
            $address_id_prefix = substr($address_id, 0, 1);
            $address_id = substr($address_id, 1);
            if ($address_id_prefix == '2') {
                //address_id from customer address book
                $this->request->post['address_id'] = $address_id;
                $shipping_address = $this->getCustomerAddress();
            } else {
                //address_id from store address book
                $company_address_data = $this->getCompanyAddressData();
                $company_addresses = !empty($company_address_data['response']['payment_addresses']) ? $company_address_data['response']['payment_addresses'] : [];
                $shipping_address = [];
                foreach ($company_addresses as $address) {
                    if ($address['address_id'] == $address_id) {
                        $shipping_address = $address;
                    }
                }
            }
        }

        //payment_address
        $payment_address_data = $this->getCompanyAddressData();
        $payment_address = !empty($payment_address_data['response']['payment_address']) ? $payment_address_data['response']['payment_address'] : new stdClass();
        if (!empty($payment_address['address_id'])) {
            $default_payment_address = (int)($payment_address['address_id']);
        }

        if (!empty($this->json['payment_address_id'])) {
            $default_payment_address = (int)(substr($this->json['payment_address_id'], 1));
        }

        $images = $this->getMedicalRecordImages();

        $data = [
            'domain' => HTTP_SERVER,
            'session_phone_no' => $this->session->data['user_info']['contactno'],
            'service_partner_id' => (int)$this->json['service_partner_id'],
            'medical_record_id'  => (int)$this->json['medical_record_id'],
            'customer' => $customer_info,
            'payment_address_id' => $default_payment_address,
            'shipping_type' => $shipping_type,
            'shipping_address_id' => (int)$address_id,
            'shipping_address' =>  $shipping_address,
            'service_type' => !empty($this->json['service_type']) ? $this->json['service_type'] : '',
            'use_credit' => !empty($this->json['use_credit']) ? true : false,
            'prescriptions' =>  $prescriptions,
            'images' => $images,
        ];
        return $data;
    }

    private function getCancelReasons()
    {
        $data = ['domain' => HTTP_SERVER];
        $path = 'etcm/service_partner/service_partner/get_cancel_reason';
        $reasons_result = $this->connectCurl($path, $data);
        $reasons = [];
        if (!empty($reasons_result)) {
            if (empty($reasons_result['error'])) {
                $reasons = $reasons_result['response'];
            }
        }
        return $reasons;
    }

    private function getCustomer()
    {
        if (empty($this->data_customer_info)) {
            $customer_id = !empty($this->request->post['customer_id']) ?  $this->request->post['customer_id'] : 0;
            $result = $this->model_name->getCustomer($customer_id);
            if (!empty($result)) {
                $this->data_customer_info = [
                    'customer_id' => (int)$result['customer_id'],
                    'customer_group' => $result['customer_group'],
                    'name' => $result['customer'],
                    'customer_ic' => $result['customer_ic'],
                    'age' => !empty($result['age']) ? $result['age'] : '',
                    'sex' => $result['sex'],
                    'telephone' => $result['telephone'],
                    'customer_card' => !empty($result['customer_card']) ? $result['customer_card'] : '',
                    'email' =>  !empty($result['email']) ? $result['email'] : '',
                    'address_id' =>  (int)$result['address_id'],
                ];
            }
        }
        return $this->data_customer_info;
    }

    private function getCustomerAddresses()
    {
        if (empty($this->data_customer_addresses)) {
            $customer_id = !empty($this->request->post['customer_id']) ?  $this->request->post['customer_id'] : 0;
            $address_id = !empty($this->request->post['address_id']) ?  $this->request->post['address_id'] : 0;
            $results = $this->model_name->getCustomerAddresses($customer_id, $address_id);
            if (!empty($results)) {
                $format = '{address_1} {address_2} {address_3}' . "\n" . '{city} {postcode} {zone} {country}';

                $find = [
                    '{address_1}', '{address_2}', '{address_3}', '{city}',
                    '{postcode}', '{zone}', '{country}'
                ];

                foreach ($results as $result) {
                    $replace = [
                        'address_1' => $result['address_1'],
                        'address_2' => $result['address_2'],
                        'address_3' => $result['address_3'],
                        'city' => $result['city'],
                        'postcode' => $result['postcode'],
                        'zone' => $result['zone'],
                        'country' => $result['country']
                    ];
                    //$formatted_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));
                    $formatted_address = trim(str_replace($find, $replace, $format));

                    //customer address_id is prepend with '2' to differentiate with store address_id
                    $this->data_customer_addresses[] = [
                        'address_id' => (int) ("2" . $result['address_id']),
                        'address' => $formatted_address,
                        'company' => $result['company'],
                        'recipient' => $result['firstname'] . $result['lastname'],
                        'contact' => $result['telephone'],
                        'zone_id' => (int)$result['zone_id'],
                        'country_id' => (int)$result['country_id'],
                        'default' => !empty($result['default_address']) ? true : false
                    ];
                }
            }
        }
        return $this->data_customer_addresses;
    }

    private function getShippingTypes()
    {
        $data = [];
        $language = !empty($_SERVER['HTTP_ACCEPT_LANGUAGE']) ? $_SERVER['HTTP_ACCEPT_LANGUAGE'] : 'cn';
        if ($language == 'en') {
            $data = [
                array(
                    'id'   => 1,
                    'code' => 'PICKUP_FROM_STORE',
                    'name' => 'Pickup From Store',
                    'display_shipping' => false,
                    'sort_order' => 0
                ),
                array(
                    'id'   => 2,
                    'code' => 'DELIVERY',
                    'name' => 'Delivery',
                    'display_shipping' => true,
                    'sort_order' => 0
                )
            ];
        } else {
            $data = [
                array(
                    'id'   => 1,
                    'code' => 'PICKUP_FROM_STORE',
                    'name' => '自取',
                    'display_shipping' => false,
                    'sort_order' => 0
                ),
                array(
                    'id'   => 2,
                    'code' => 'DELIVERY',
                    'name' => '送货上门',
                    'display_shipping' => true,
                    'sort_order' => 0
                )
            ];
        }
        return $data;
    }

    private function getCustomerAddress()
    {
        $data = [];
        if (empty($this->data_customer_address))
            $address_id = !empty($this->request->post['address_id']) ? $this->request->post['address_id'] : 0;
        $customer_id = !empty($this->request->post['customer_id']) ? $this->request->post['customer_id'] : 0;
        if (!empty($address_id) && !empty($customer_id)) {
            $results = $this->model_name->getCustomerAddress($customer_id, $address_id);
            if (!empty($results)) {
                foreach ($results as $result) {
                    $format = '{address_1} {address_2} {address_3}' . "\n" . '{city} {postcode} {zone} {country}';

                    $find = [
                        '{address_1}', '{address_2}', '{address_3}', '{city}',
                        '{postcode}', '{zone}', '{country}'
                    ];

                    foreach ($results as $result) {
                        $replace = [
                            'address_1' => $result['address_1'],
                            'address_2' => $result['address_2'],
                            'address_3' => $result['address_3'],
                            'city' => $result['city'],
                            'postcode' => $result['postcode'],
                            'zone' => $result['zone'],
                            'country' => $result['country']
                        ];
                        //$formatted_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));
                        $formatted_address = trim(str_replace($find, $replace, $format));

                        $this->data_customer_address = [
                            'address_id' => (int)$result['address_id'],
                            'address' => $result['firstname'] . $result['lastname'] . "\n" . $result['telephone'] . "\n" . $formatted_address,
                            'company' => $result['company'],
                            'recipient' => $result['firstname'] . $result['lastname'],
                            'contact' => $result['telephone'],
                            'zone_id' => (int)$result['zone_id'],
                            'country_id' => (int)$result['country_id'],
                            'default' => !empty($result['default_address']) ? true : false
                        ];
                    }
                }
            }
        }
        return $this->data_customer_address;
    }

    private function getServiceTypes()
    {
        $data = [];
        $language = !empty($_SERVER['HTTP_ACCEPT_LANGUAGE']) ? $_SERVER['HTTP_ACCEPT_LANGUAGE'] : 'cn';
        if ($language == 'en') {
            $data = [
                array(
                    'id'   => 1,
                    'code' => 'DECOCTION',
                    'name' => 'Decoction',
                    'sort_order' => 0,
                    'child'  => [
                        array(
                            'id'   => 2,
                            'code' => 'DECOCTION_BY_PARTNER',
                            'name' => 'Decoction: By Service Partner',
                            'sort_order' => 0
                        ),
                        array(
                            'id'   => 3,
                            'code' => 'DECOCTION_BRING_YOUR_OWN_HERBS',
                            'name' => 'Decoction: Own Prepared Herbs',
                            'sort_order' => 0
                        ),
                    ]
                ),
                array(
                    'id'   => 4,
                    'code' => 'GRANULE',
                    'name' => 'Granule',
                    'sort_order' => 0,
                    'child'  => [],
                ),
                array(
                    'id'   => 5,
                    'code' => 'HERBS',
                    'name' => 'Herbs',
                    'sort_order' => 0,
                    'child'  => [],
                ),
                /*
                //temporary disabled
                array(
                    'id'   => 6,
                    'code' => 'OINTMENT',
                    'name' => 'Ointment',
                    'sort_order' => 0,
                    'child'  => [],
                ),
                array(
                    'id'   => 7,
                    'code' => 'POWDER',
                    'name' => 'Powder',
                    'sort_order' => 0,
                    'child'  => [],
                ),
                */
            ];
        } else {
            $data = [
                array(
                    'id'   => 1,
                    'code' => 'DECOCTION',
                    'name' => '煎剂',
                    'sort_order' => 0,
                    'child'  => [
                        array(
                            'id'   => 2,
                            'code' => 'DECOCTION_BY_PARTNER',
                            'name' => '煎煮',
                            'sort_order' => 0
                        ),
                        array(
                            'id'   => 3,
                            'code' => 'DECOCTION_BRING_YOUR_OWN_HERBS',
                            'name' => '自备草药',
                            'sort_order' => 0
                        ),
                    ],
                ),
                array(
                    'id'   => 4,
                    'code' => 'GRANULE',
                    'name' => '颗粒剂',
                    'sort_order' => 0,
                    'child'  => [],
                ),
                array(
                    'id'   => 5,
                    'code' => 'HERBS',
                    'name' => '抓药',
                    'sort_order' => 0,
                    'child'  => [],
                ),
                /*
                //temporary disabled
                array(
                    'id'   => 6,
                    'code' => 'OINTMENT',
                    'name' => '膏剂',
                    'sort_order' => 0,
                    'child'  => [],
                ),
                array(
                    'id'   => 7,
                    'code' => 'POWDER',
                    'name' => '打粉',
                    'sort_order' => 0,
                    'child'  => [],
                ),
                */
            ];
        }
        return $data;
    }

    private function getServiceTypeName($type)
    {
        $name = str_replace('_', ' ', $type);
        $service_types = $this->getServiceTypes();
        foreach ($service_types as $service_type) {
            if ($service_type['code'] == $type) {
                $name = $service_type['name'];
                break;
            }
            if (!empty($service_type['child'])) {
                foreach ($service_type['child'] as $service_type2) {
                    if ($service_type2['code'] == $type) {
                        $name = $service_type2['name'];
                        break 2;
                    }
                }
            }
        }
        return $name;
    }

    private function getMedicalRecordInfo()
    {
        // $data = [];
        if (empty($this->data_medical_record_info)) {
            $medical_record_id = !empty($this->request->post['medical_record_id']) ?  $this->request->post['medical_record_id'] : 0;
            $result = $this->model_name->getMedicalRecordInfo($medical_record_id);
            if (!empty($result)) {
                $prescriptions = $this->getMedicalRecordPrescriptionsProducts();
                $images = $this->getMedicalRecordImages();
                $this->data_medical_record_info = [
                    'medical_record_id' => (int)$result['medical_record_id'],
                    'doc_date' => $result['doc_date'],
                    'doc_no' => $result['doc_no'],
                    'store' => $result['store'],
                    'doctor' => $result['doctor'],
                    'customer_id' => (int)$result['customer_id'],
                    'diagnostic'  => $result['diagnostic'],
                    'prescriptions'    => $prescriptions,
                    'images' => $images,
                ];
                //$this->request->post['customer_id'] = !empty($result['customer_id']) ? $result['customer_id'] : 0;
            }
        }
        return $this->data_medical_record_info;
    }

    private function getMedicalRecordProducts()
    {
        $data = [];
        $medical_record_id = !empty($this->request->post['medical_record_id']) ?  $this->request->post['medical_record_id'] : 0;
        $results = $this->model_name->getMedicalRecordProducts($medical_record_id);
        if (!empty($results)) {
            $data = $results;
        }
        return $data;
    }

    private function getMedicalRecordPrescriptionsProducts()
    {
        $data = [];
        $language = !empty($_SERVER['HTTP_ACCEPT_LANGUAGE']) ? $_SERVER['HTTP_ACCEPT_LANGUAGE'] : 'cn';
        $medical_record_id = !empty($this->request->post['medical_record_id']) ?  $this->request->post['medical_record_id'] : 0;
        $results = $this->model_name->getMedicalRecordPrescriptionsProducts($medical_record_id);
        if (!empty($results)) {
            $prescription_name = '处方 ';
            if ($language == 'en') {
                $prescription_name = 'Prescription ';
            }

            foreach ($results as $key => $result) {
                $unmtached_products = $this->model_name->getUnmatchedProducts($result['prescription_id']);
                $data[] = [
                    'name' => $prescription_name . ($key + 1),
                    'products' => $result['products'],
                    'unmatched_products' => $unmtached_products,
                    'time' => $result['time'],
                    'day' => $result['day'],
                    'consume_method' => $result['consume_method'],
                    'take_type' => $result['take_type'],
                    'total_products' => (int)$result['total_products']
                ];
            }
        }
        return $data;
    }

    private function getMedicalRecordImages()
    {
        $data = [];
        $medical_record_id = !empty($this->request->post['medical_record_id']) ?  $this->request->post['medical_record_id'] : 0;
        $results = $this->model_name->getMedicalRecordImages($medical_record_id);
        if (!empty($results)) {
            foreach ($results as $result) {
                $data[] =  HTTPS_HERBAL_IMAGE . str_replace(' ', '%20', $result['image']);
            }
        }
        return $data;
    }

    private function getCompanyAddressData()
    {
        if (empty($this->data_company_address)) {
            $api_data = ['domain' => HTTP_SERVER];
            $path = 'etcm/service_partner/service_partner/get_etcm_customer_address';
            $this->data_company_address = $this->connectCurl($path, $api_data);
        }
        return $this->data_company_address;
    }

    private function getPaymentAddress()
    {
        $payment_address_data = $this->getCompanyAddressData();
        $payment_address = !empty($payment_address_data['response']['payment_address']) ? $payment_address_data['response']['payment_address'] : new stdClass();
        //prepend store address_id with '1' to diffentiate with customer_id
        if (!empty($payment_address['address_id'])) {
            $payment_address['address_id'] = (int)("1" . $payment_address['address_id']);
        }
        return $payment_address;
    }

    private function getPaymentAddresses()
    {
        $payment_address_data = $this->getCompanyAddressData();
        $payment_addresses = !empty($payment_address_data['response']['payment_addresses']) ? $payment_address_data['response']['payment_addresses'] : [];
        if (!empty($payment_addresses)) {
            foreach ($payment_addresses as $key => $address) {
                $payment_addresses[$key]['address_id'] = (int)("1" . $payment_addresses[$key]['address_id']);
            }
        }
        return $payment_addresses;
    }
    private function getShippingAddress()
    {
        $shipping_addresses = $this->getShippingAddresses();
        $shipping_address = new stdClass();
        if (!empty($shipping_addresses)) {
            foreach ($shipping_addresses as $sa) {
                if ($sa['default'] == 1) {
                    $shipping_address = $sa;
                }
            }
        }
        return $shipping_address;
    }

    private function getShippingAddresses()
    {
        $tcm_shipping_addresses = [];
        $payment_addresses = $this->getPaymentAddresses();
        if (!empty($payment_addresses)) {
            foreach ($payment_addresses as $key => $address) {
                $tcm_shipping_addresses[$key] = $address;
                $tcm_shipping_addresses[$key]['default'] = false;
            }
        }

        $shipping_addresses = $this->getCustomerAddresses();
        $shipping_addresses = array_merge($shipping_addresses, $tcm_shipping_addresses);
        return $shipping_addresses;
    }

    private function connectCurl($path, $data, $debug = false)
    {
        $language = !empty($_SERVER['HTTP_ACCEPT_LANGUAGE']) ? $_SERVER['HTTP_ACCEPT_LANGUAGE'] : 'cn';
        if ($language == 'zh') {
            $language = 'cn';
        }

        $device_id = !empty($_SERVER['HTTP_DEVICE_ID']) ? $_SERVER['HTTP_DEVICE_ID'] : '';

        $url = HTTP_API . 'index.php?route=' . $path;
        $curl = curl_init();

        curl_setopt($curl, CURLOPT_HEADER, false);
        curl_setopt($curl, CURLINFO_HEADER_OUT, true);
        curl_setopt($curl, CURLOPT_USERAGENT, $this->request->server['HTTP_USER_AGENT']);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_POST, 1);
        curl_setopt($curl, CURLOPT_POSTFIELDS, htmlspecialchars_decode(json_encode($data)));
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array('Accept-Language: ' . $language, 'Device-Id: ' . $device_id, 'Content-Type: application/json'));
        curl_setopt($curl, CURLOPT_TIMEOUT, 15);

        $response = curl_exec($curl);
        if ($debug) {
            var_dump($response);
            die();
        }

        $result = json_decode(htmlspecialchars_decode($response), true);

        curl_close($curl);

        // var_dump($response);
        return $result;
    }

    private function sendNotification($etcm_purchase_order_id)
    {
        $status_to_notify = ['TO_RECEIVE', 'CANCELLED'];
        $this->load->model('android/common/notification');
        $po_info = $this->model_name->getPObyEtcmId($etcm_purchase_order_id);
        if (!empty($po_info['date_prepared'])) {
            $status_to_notify[] = 'TO_SHIP';
        }

        if (in_array($po_info['etcm_status_code'], $status_to_notify)) {
            $notification_type = 'service_partner_purchase_order';
            $app_url = $this->model_android_common_notification->getNotificationDataUrl('doctorapp', $notification_type);
            $data = array("url" => str_replace(":order-purchase-id", $po_info['purchase_order_id'], $app_url));

            $users = [$po_info['added_by'], $po_info['modified_by']];
            $users = array_unique($users);

            if (!empty($users)) {
                foreach ($users as $user_id) {
                    $language_id = $this->model_android_common_notification->getUserLanguageId($user_id);
                    $notification = $this->generateNotification($po_info, $language_id);
                    $params = array(
                        "user_id" => $user_id,
                        "notification" => $notification,
                        "notification_type" => $notification_type,
                        "data" => $data
                    );
                    $this->load->controller('android/common/notification/push', $params);
                }
            }
        }
    }

    private function generateNotification($info, $language_id)
    {
        switch ($info['etcm_status_code']) {
            case 'TO_RECEIVE':
                $title_en = 'Order' . (!empty($info['doc_no']) ? '[' . $info['doc_no'] . ']' : '') . ' has been shipped!';
                $title_cn = '订单' . (!empty($info['doc_no']) ? '[' . $info['doc_no'] . ']' : '') . ' 已发货！';

                $body_en = 'Click to see detail';
                $body_cn = '点击查看详情';
                break;
            case 'CANCELLED':
                $title_en = 'Order' . (!empty($info['doc_no']) ? '[' . $info['doc_no'] . ']' : '') . ' has been cancelled!';
                $title_cn = '订单' . (!empty($info['doc_no']) ? '[' . $info['doc_no'] . ']' : '') . ' 已取消！';

                $body_en = 'Click to see detail';
                $body_cn = '点击查看详情';
                break;
            default:
                $title_en = 'Order' . (!empty($info['doc_no']) ? '[' . $info['doc_no'] . ']' : '') . ' has been updated!';
                $title_cn = '订单' . (!empty($info['doc_no']) ? '[' . $info['doc_no'] . ']' : '') . ' 已更新！';

                $body_en = 'Click to see detail';
                $body_cn = '点击查看详情';
        }

        return array(
            'title' => $language_id == '1' ? $title_en : $title_cn,
            'body' => $language_id == '1' ? $body_en : $body_cn,
        );
    }
    #endregion
}
