<?php

class ControllerAndroidServiceSetting extends Controller
{

    public function index()
    {
        //load required model
        $this->load->model('android/service/setting');

        $this->model_name = $this->model_android_service_setting;
        require DIR_SYSTEM . "/library/start_api.php";
    }

    protected function get_list()
    {
        $results = [];

        $services = $this->model_name->getServices();

        if (!empty($services)) {
            foreach ($services as $svc) {
                $results[] = [
                    'service_id' => $svc['clinicalservice_id'],
                    'service_name' => $svc['name'],
                    'service_minute' => $svc['cs_minute'],
                    'service_price' => $this->currency->format($svc['price'], $this->config->get('config_currency')),
                ];
            }
            $output = $this->response->setCachedResponse(200, $results, "Get list success", "services");
        } else {
            $output = $this->response->setCachedResponse(404, new stdClass(), "Get list success", "services");
        }

        $this->api->trackResponse($output);
        return;
    }

    protected function get_form()
    {
        $service_id = !empty($this->request->get['service_id']) ? $this->request->get['service_id'] : null;
        $info = $this->model_name->getServiceInfo($service_id);
        if (!empty($info)) {
            //alter something
            // unset($info['clinicalservice_id']);
            // unset($info['store_id']);
            // unset($info['doctor_id']);
            // unset($info['doctor']);
            // unset($info['staff_id']);
            // unset($info['acupuncture_parts']);
            // unset($info['enable_acupuncture']);
            // unset($info['createby']);
            // unset($info['createdate']);
            // unset($info['modifyby']);
            // unset($info['modifydate']);
            $service_name = $this->session->data['language_id'] == 1 ? $info['en_name'] : $info['cn_name'];
            // $info['status'] = (bool)$info['status'];
            // $info['enable_appointment'] = (bool)$info['enable_appointment'];
            // $info['enable_etcm'] = (bool)$info['enable_etcm'];


            $data['service_id'] = $info['service_id'];
            $data['service_name'] = $service_name;
            $data['en_name'] = $info['en_name'];
            $data['cn_name'] = $info['cn_name'];
            $data['type'] = $info['type'];
            $data['cs_minute'] = $info['cs_minute'];
            $data['status'] = (bool)$info['status'];
            $data['enable_appointment'] = (bool)$info['enable_appointment'];
            $data['enable_etcm'] = (bool)$info['enable_etcm'];
            $data['cs_session'] = $info['cs_session'];
            $data['price'] = $info['price'];
            $data['tax_class_id'] = $info['tax_class_id'];
            $data['stores'] = $info['stores'];
            $data['doctors'] = $info['doctors'];
            $data['facilities'] = $info['facilities'];
        } else {
            $data = new stdClass();
        }

        $result = [
            "form_fields" => [
                "stores" => $this->getStores(),
                "doctors" => $this->getDoctors(),
                "facilities" => $this->getFacilities(),
                "types" => $this->getTypes(),
                "tax_classes" => $this->getTaxClasses(),
            ],
            "data" => $data
        ];
        $output = $this->response->setResponse2(200, $result, 'success', 'services');
        $this->api->trackResponse($output);
        return;
    }

    protected function update()
    {
        $json = $this->json;
        if (empty($json)) {
            $output = $this->response->setResponse2(400, new stdClass(), 'missing json body', 'services');
            $this->api->trackResponse($output);
            return;
        }

        $id = $this->model_name->updateService($json);
        $this->syncToEtcm();
        if ($id) {
            $output = $this->response->setResponse2(200, new stdClass(), 'success', 'services');
        } else {
            $output = $this->response->setResponse2(500, new stdClass(), 'something went wrong', 'services');
        }
        $this->api->trackResponse($output);
        return;
    }

    protected function delete()
    {
        $json = $this->json;


        if (!empty($json)) {
            foreach ($json as $id) {
                $this->model_name->delete_clinical_service($id);
            }
            $this->syncToEtcm();
            $output = $this->response->setResponse2(200, new stdClass(), 'success', 'services');
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setResponse2(400, new stdClass(), 'service_id required', 'services');
            $this->api->trackResponse($output);
            return;
        }
    }


    //private function

    private function getStores()
    {
        $results[] = [
            'store_id' => '0',
            'name' => $this->config->get('config_name'),
        ];
        $stores = $this->model_name->getStores();

        foreach ($stores as $store) {
            $results[] = array(
                'store_id' => $store['store_id'],
                'name' => $store['name']
            );
        }
        return $results;
    }

    private function getDoctors()
    {
        $results = [];
        $doctors = $this->model_name->getDoctors();

        foreach ($doctors as $doctor) {
            $results[] = array(
                'doctor_id' => $doctor['user_id'],
                'name' => $doctor['firstname'] . ' ' . $doctor['lastname']
            );
        }
        return $results;
    }

    private function getFacilities()
    {
        $results = [];
        $facilities = $this->model_name->getFacilities();

        foreach ($facilities as $facility) {
            $results[] = array(
                'facility_id' => $facility['facility_id'],
                'name' => $facility['name']
            );
        }
        return $results;
    }

    private function getTypes()
    {
        $results[] = [
            'id' => '1',
            'name' => $this->session->data['language_id'] == 1 ? 'Service' : '诊所服务',
        ];
        $results[] = [
            'id' => '2',
            'name' => $this->session->data['language_id'] == 1 ? 'Consultation' : '病诊',
        ];

        return $results;
    }

    private function getTaxClasses()
    {
        $results[] = [
            'tax_class_id' => '0',
            'name' => $this->session->data['language_id'] == '1' ? 'None' : '无'
        ];
        $taxes = $this->model_name->getTaxClasses();

        foreach ($taxes as $tax) {
            $results[] = array(
                'tax_class_id' => $tax['tax_class_id'],
                'name' => $tax['title']
            );
        }
        return $results;
    }


    private function syncToEtcm()
    {

        $db_services = $this->db->query("SELECT cs.*, en.name AS en_name, cn.name AS cn_name FROM " . DB_PREFIX . "clinical_service cs 
        LEFT JOIN " . DB_PREFIX . "clinical_service_description en ON(en.clinicalservice_id = cs.clinicalservice_id AND en.language_id = '1') 
        LEFT JOIN " . DB_PREFIX . "clinical_service_description cn ON(cn.clinicalservice_id = cs.clinicalservice_id AND cn.language_id = '2')
        WHERE cs.enable_etcm = '1'")->rows;
        $services = [];
        foreach ($db_services as $service) {

            $service_id = $service['clinicalservice_id'];

            $db_stores = $this->db->query("SELECT * FROM " . DB_PREFIX . "service_to_store WHERE service_id = '" . (int)$service_id . "'")->rows;
            $stores = [];
            if (!empty($db_stores)) {
                foreach ($db_stores as $store) {
                    $stores[] = [
                        'service_id'    => $service_id,
                        'store_id'   => $store['store_id']
                    ];
                }
            } else {
                foreach (unserialize($service['store_id']) as $id) {
                    $stores[] = [
                        'service_id'   => $service_id,
                        'store_id'     => $id
                    ];
                }
            }

            $db_doctors = $this->db->query("SELECT * FROM " . DB_PREFIX . "service_to_doctor WHERE service_id = '" . (int)$service_id . "'")->rows;
            $doctors = [];
            if (!empty($db_doctors)) {
                foreach ($db_doctors as $doctor) {
                    $doctors[] = [
                        'service_id'    => $service_id,
                        'doctor_id'   => $doctor['doctor_id']
                    ];
                }
            } else {
                foreach (unserialize($service['doctor_id']) as $id) {
                    $doctors[] = [
                        'service_id'    => $service_id,
                        'doctor_id'     => $id
                    ];
                }
            }

            $db_facilities = $this->db->query("SELECT * FROM " . DB_PREFIX . "service_to_facility WHERE service_id = '" . (int)$service_id . "'")->rows;
            $facilities = [];
            foreach ($db_facilities as $facility) {
                $facilities[] = [
                    'service_id'    => $service_id,
                    'facility_id'   => $facility['facility_id']
                ];
            }

            $services[] = [
                'service_id'    => $service_id,
                'en_name'       => $service['en_name'],
                'cn_name'       => $service['cn_name'],
                'minute'        => $service['cs_minute'],
                'type'          => $service['type'],
                'stores'        => $stores,
                'doctors'       => $doctors,
                'facilities'    => $facilities,
            ];
        }
        $post_data = [
            'store_url' => HTTPS_SERVER,
            'services' => $services
        ];

        $path = 'etcm/syncing/syncing/update_services';
        $result = $this->connectCurl($path, $post_data);
        return $result;
    }

    private function connectCurl($path, $data)
    {
        $language = !empty($_SERVER['HTTP_ACCEPT_LANGUAGE']) ? $_SERVER['HTTP_ACCEPT_LANGUAGE'] : 'cn';
        if ($language == 'zh') {
            $language = 'cn';
        }

        $device_id = !empty($_SERVER['HTTP_DEVICE_ID']) ? $_SERVER['HTTP_DEVICE_ID'] : '';

        $url = 'https://www.etcm.me/index.php?route=' . $path;
        $curl = curl_init();

        curl_setopt($curl, CURLOPT_HEADER, false);
        curl_setopt($curl, CURLINFO_HEADER_OUT, true);
        curl_setopt($curl, CURLOPT_USERAGENT, $this->request->server['HTTP_USER_AGENT']);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_POST, 1);
        curl_setopt($curl, CURLOPT_POSTFIELDS, htmlspecialchars_decode(json_encode($data)));
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array('Accept-Language: ' . $language, 'Device-Id: ' . $device_id, 'Content-Type: application/json'));
        curl_setopt($curl, CURLOPT_TIMEOUT, 15);

        $response = curl_exec($curl);

        $result = json_decode(htmlspecialchars_decode($response), true);

        curl_close($curl);

        return $result;
    }
}
