<?php

class ControllerAndroidServiceService extends Controller
{
    private $json;
    private $user_info;
    private $model_name;

    private $opencart_version = 3;

    public function index()
    {
        //load required model
        $this->load->model('android/service/service');

        $this->model_name = $this->model_android_service_service;
        require DIR_SYSTEM . "/library/start_api.php";
    }

    protected function get_service_list()
    {
        $filter_search = (string)trim($this->request->get['filter_search']);
        $filter_search = !empty($filter_search) ? $filter_search : null;
        $page = !empty($this->request->get['page']) ? $this->request->get['page'] : 1;
        $show = !empty($this->request->get['show']) ? $this->request->get['show'] : 10;

        $filters = array(
            "filter_search" => $filter_search,
            "start"         => ($page - 1) * $show,
            "limit"         => $show
        );

        $results = $this->model_name->getServiceList($filters);

        if (!empty($results)) {
            $output = $this->response->setCachedResponse(200, $results, "Get list success", "service");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setCachedResponse(204, array(), "No result", "service");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_doctors_available()
    {
        $service_id = !empty($this->request->get['service_id']) ? $this->request->get['service_id'] : null;
        if (empty($service_id)) {
            $output = $this->response->setCachedResponse(204, array(), "No result", "service");
            $this->api->trackResponse($output);
            return;
        }
        $this->load->model('android/appointment/appointment');
        $doctors = $this->model_android_appointment_appointment->getDoctorsAvailable($service_id);
        $results = [];
        foreach ($doctors as $doctor) {
            $available = $this->model_android_appointment_appointment->getDoctorAvailabilityStatus($doctor['id']);
            if ($available > 0) {
                $results[] = array(
                    "id" => $doctor["id"],
                    "name" => $doctor["name"],
                );
            }
        }

        if (!empty($results)) {
            $output = $this->response->setCachedResponse(200, $results, "Get list success", "service");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setCachedResponse(204, $results, "No result", "service");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_services_available()
    {
        $results = $this->model_name->getServiceAvailableList();

        if (!empty($results)) {
            $output = $this->response->setCachedResponse(200, $results, "Get list success", "service");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setCachedResponse(204, array(), "No result", "service");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_service_detail()
    {
        $service_id = !empty($this->request->get['service_id']) ? $this->request->get['service_id'] : false;
        if ($service_id) {
            $service_info = $this->model_name->getService($service_id);
            if (!empty($service_info)) {
                $output = $this->response->setCachedResponse(200, $service_info, "Success", "service");
                $this->api->trackResponse($output);
                return;
            } else {
                $output = $this->response->setCachedResponse(204, $this->response->noResponse(), "No result", "service");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setCachedResponse(400, $this->response->noResponse(), "service id is required", "service");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_service_form_info()
    {
        $this->load->language('android/service/service');


        $service_form_id = !empty($this->request->get['service_form_id']) ? $this->request->get['service_form_id'] : false;

        if ($service_form_id) {
            $service_form_info = $this->model_android_service_service->getServiceFormInfo($service_form_id);
            $services = array();

            if (!empty($service_form_info)) {

                //get customer info
                $customer_info = $this->model_name->getCustomer($service_form_info['customer_id']);

                if (!empty($customer_info)) {
                    $address_list = $this->model_name->getAddressesByCustomerId($service_form_info['customer_id']);
                    $address_list = !empty($address_list) ? $address_list : array();
                    $addresses = array();

                    foreach ($address_list as $row) {
                        $add_name = '';
                        $add_name .= !empty($row['address_1']) ? $row['address_1'] : '';
                        $add_name .= !empty($row['address_2']) ? ', ' . $row['address_2'] : '';
                        $add_name .= !empty($row['address_3']) ? ', ' . $row['address_3'] : '';
                        $add_name .= !empty($row['postcode']) ? ', ' . $row['postcode'] : '';
                        $add_name .= !empty($row['city']) ? ', ' . $row['city'] : '';
                        $add_name .= !empty($row['zone']) ? ', ' . $row['zone'] : '';

                        $addresses[] = array(
                            "id" => $row['address_id'],
                            "label" => $add_name
                        );
                    }

                    // $selected_address_id = $service_form_info['shipping_address_id'];

                    // $selected_address_id = empty($selected_address_id) ? $customer_info['address_id'] : $selected_address_id;


                    $customer = array(
                        "cn_name"            => $customer_info['firstname'],
                        "en_name"            => $customer_info['lastname'],
                        "name"               => trim($customer_info['firstname'] . " " . $customer_info['lastname']),
                        "customer_id"        => $customer_info['customer_id'],
                        "customer_ic"        => $customer_info['customer_ic'],
                        "email"              => $customer_info['email'],
                        "telephone1"         => $customer_info['telephone'],
                        "telephone2"         => $customer_info['telephone2'],
                        "gender_id"          => empty($customer_info['gender']) ? null : $customer_info['gender'],
                        "dob"                => $customer_info['dob'] == '0000-00-00' ? null : $customer_info['dob'],
                        "occupation"         => $customer_info['occupation'],
                        "nationality"        => $customer_info['nationality'],
                        "marital_status_id"  => empty($customer_info['marital_status']) ? null : $customer_info['marital_status'],
                        "religion_id"        => empty($customer_info['religion']) ? null : $customer_info['religion'],
                        "race_id"            => empty($customer_info['race']) ? null : $customer_info['race'],
                        "allergic"           => $customer_info['allergic'],
                        "diagnostic_history" => $customer_info['diagnostic_history'],
                        "default_address"    => $customer_info['address_id'],
                        "address"            => $addresses
                    );
                } else {
                    $customer = $this->response->noResponse();
                }

                $services =  $this->model_name->getServiceItems($service_form_id);

                $totals = $this->model_name->getServiceTotals($service_form_id);

                $totals = $this->formattedTotal($totals);

                $all_total = array();
                foreach ($totals as $total) {
                    $all_total[] = array(
                        "title" => $total['title'],
                        "value" => $this->currency->format($total['value'], $this->config->get('config_currency'))
                    );
                }

                $returned_services = array();
                foreach ($services as $row) {
                    $acupunctures = $this->model_name->getAcupuncturePointByServiceItemId($row['service_Item_id']);
                    // $doctors = $this->model_name->getDoctors();
                    $price = $this->currency->format($row['price'], $this->config->get('config_currency'));

                    $returned_services[] = array(
                        "service_id" => $row['clinicalservice_id'],
                        "service_item_id" => $row['service_Item_id'],
                        "hide_timer"    => true,
                        "start_time" => !empty($row['start_time']) ? $row['start_time'] : null,
                        "end_time" => !empty($row['end_time']) ? $row['end_time'] : null,
                        "service_name"  => $row['servicename'],
                        "service_minute"  => $row['serviceminutes'],
                        "gst" => $row['gst'],
                        "price" => $price,
                        "doctor" => array("id" => $row['user_id'], "name" => $row['doctor_name']),
                        "acupunctures" => $acupunctures,
                        // "service_form_id" => $row['service_form_id'],
                        // "modified_by" => $row['modifi_by'],
                    );
                }



                // $acupunctures = array();
                // foreach ($acupunctures as $acu) {
                //     $acupunctures[] = array(
                //         "id" => $acu['acupuncture_id'],
                //         "num_of_acupuncture" => $acu['num_of_acupuncture']

                //     );
                // }


                $result = array(
                    "service_form_id" => $service_form_id,
                    "allow_edit" => $service_form_info['order_action'] == 5 ? false : true,
                    "invoice_prefix"   => $service_form_info['invoice_prefix'],
                    "service_date" => $service_form_info['service_date'],
                    "date_added" => $service_form_info['date_added'],
                    "remark" =>   $service_form_info['remark'],
                    "customer" => $customer,
                    "totals" =>  $all_total,
                    "services" => $returned_services,
                );

                $output = $this->response->setCachedResponse(200, $result, "success", "service");
                $this->api->trackResponse($output);
                return;
            } else {
                $output = $this->response->setCachedResponse(204, array(), "Not found", "service");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setCachedResponse(400, $this->response->noResponse(), "service_form_id required", "service");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_service_form_list()
    {
        $this->load->language('android/service/service');

        //filter data
        $filter_status = null;
        $filter_invoice_prefix = null;
        $filter_customer_id = null;
        $filter_customer_ic = null;
        $filter_date_from = null;
        $filter_date_to = null;
        $filter_invoice_prefix = null;



        $filter_status = isset($this->request->get['status']) && trim($this->request->get['status']) != '' ? $this->request->get['status'] : null;
        $filter_customer_id = isset($this->request->get['customer_id']) && trim($this->request->get['customer_id']) != '' ?  $this->request->get['customer_id'] : null;
        $filter_customer_ic = isset($this->request->get['customer_ic']) && trim($this->request->get['customer_ic']) != '' ?  $this->request->get['customer_ic'] : null;
        $filter_date_from = isset($this->request->get['date_from']) && trim($this->request->get['date_from']) != '' ? $this->request->get['date_from'] : null;
        $filter_date_to = isset($this->request->get['date_to']) && trim($this->request->get['date_to']) != '' ? $this->request->get['date_to'] : null;
        $filter_invoice_prefix = isset($this->request->get['invoice_prefix']) && trim($this->request->get['invoice_prefix']) != '' ?  $this->request->get['invoice_prefix'] : null;
        $filter_name = isset($this->request->get['customer_name']) && trim($this->request->get['customer_name']) != '' ?  $this->request->get['customer_name'] : null;
        $filter_card_no = !empty($this->request->get['customer_card']) ? $this->request->get['customer_card'] : false;

        //pagination
        $page = !empty($this->request->get['page']) ? $this->request->get['page'] : 1;
        $show = !empty($this->request->get['show']) ? $this->request->get['show'] : 10;


        $filters = array(
            "filter_status" => $filter_status,
            "filter_invoice_prefix" => $filter_invoice_prefix,
            "filter_customer_id" => $filter_customer_id,
            "filter_customer_ic" => $filter_customer_ic,
            'filter_date_from' => $filter_date_from,
            'filter_date_to' => $filter_date_to,
            'filter_name' => $filter_name,
            'filter_card_no' => $filter_card_no,
            'filter_invoice_prefix' => $filter_invoice_prefix,
            "start"         => ($page - 1) * $show,
            "limit"         => $show
        );


        $results = $this->model_android_service_service->getServiceFormList($filters);

        if (!empty($results)) {
            foreach ($results as $result) {
                $store_name = !empty($result['store_name']) ? $result['store_name'] : htmlspecialchars_decode($this->config->get('config_name'));

                if ($result['gender'] == '1') {
                    $gen = $this->language->get('text_male');
                } elseif ($result['gender'] == '2') {
                    $gen = $this->language->get('text_female');
                } else {
                    $gen = '';
                }

                $data['services'][] = [
                    'service_form_id'     => $result['service_form_id'],
                    'invoice_prefix'      => $result['invoice_prefix'],
                    'service_date'        => $result['service_date'],
                    'customer_name'       => trim($result['customer_name']),
                    'customer_ic'         => trim($result['customer_ic']),
                    'status'              => strtoupper($result['status']),
                    'status_color'        => $result['serviceform_action'] == '5' ? "#8FBB6C" : "#F56B6B",
                    'payment_status'      => $result['order_action'] == '5' ? "PAID" : strtoupper($result['payment_status']),
                    'payment_status_color' => $result['order_action'] == '5' ? "#8FBB6C" : "#F56B6B",
                    'allow_edit'          => $result['order_action'] != '5' ? true : false,
                    'remark'              => $result['remark'],
                    // 'date_added'     => $result['date_added'],
                    // 'store_name'     => $store_name,
                    // 'total_price'    => $result['total_price'],
                    // 'consultation'   => $result['consultation'],
                    // 'net_amount'     => $result['net_amount'],
                    // 'order_invoice_prefix' => $result['order_invoice_prefix'],
                    // 'payment_method' => $result['payment_method'],

                    // 'customer_name'  => $result['customer_name'],
                    // 'age'            => $result['age'],
                    // 'telephone'      => $result['telephone'],
                    // 'occupation'     => $result['occupation'],
                    // 'allergic'       => $result['allergic'],
                    // 'add_by'         => $result['add_by'],
                    // 'gender'         => $gen,
                    // 'group_name' => $result['group_name'],


                ];
            }
            $output = $this->response->setCachedResponse(200, $data['services'], "Get list success", "service");
            $this->api->trackResponse($output);
            return;
        } else {
            $data['services'] = array();
            $output = $this->response->setCachedResponse(204, $data['services'], "No result", "service");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_filters()
    {
        $this->load->language('android/service/service');

        // $data['gender'][] = array(
        //     'id' => 1,
        //     'name' => $this->language->get('text_male'),
        // );
        // $data['gender'][] = array(
        //     'id' => 2,
        //     'name' => $this->language->get('text_female'),
        // );

        $filters = array(
            "filter_status" => $this->model_name->getFilterStatus(),
            // "filter_gender" => $data['gender']
        );
        $output = $this->response->setCachedResponse(200, $filters, "Success", "service");
        $this->api->trackResponse($output);
        return;
    }

    protected function addServiceForm1()
    {
        $user_id = $this->session->data['user_id'];
        $customer_id = !empty($this->request->post['customer_id']) ? $this->request->post['customer_id'] : false;

        if ($customer_id) {
            $data = array(
                "customer_id" => $customer_id,
                "store_id"    => $this->session->data['store_id'],
                "user_id"     => $user_id,
            );

            $serviceform_id = $this->model_name->addService($data);
            if (!empty($serviceform_id)) {
                $output = $this->response->setResponse2(200, array("serviceform_id" => $serviceform_id), "Success", "service");
                $this->api->trackResponse($output);
                return;
            } else {
                $output = $this->response->setResponse2(400, $this->response->noResponse(), "Failed to save record", "service");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setResponse2(400, $this->response->noResponse(), "customer_id is required", "service");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function save_service()
    {
        $data = $this->json;
        if (empty($data)) {
            $output = $this->response->setResponse2(400, $this->response->noResponse(), "missing json body", "service");
            $this->api->trackResponse($output);
            return;
        } else {
            $step = !empty($data['step']) ? $data['step'] : false;

            //disable step
            $step = false;

            if ($step == '1') {
                //for customer info
                $this->updateCustomersInfo($data);
                return;
            } elseif ($step == '2' || $step == '3') {
                //update medical record
                $this->updateServiceRecord($data);
                return;
            } else {
                $this->saveServiceForm($data);
            }
        }
    }

    private function updateCustomersInfo($json)
    {
        $user_id = $this->session->data['user_id'];

        $customer = !empty($json['customer']) ? $json['customer'] : array();
        $staff_id = !empty($json['staff_id']) ? $json['staff_id'] : false;
        $serviceform_id = !empty($json['serviceform_id']) ? $json['serviceform_id'] : 0;
        // $customer_name = !empty($json['customer_name']) ? $json['customer_name'] : '';


        if ($customer) {
            if ($this->validateCustomerInfo($customer)) {
                $data = array(
                    "serviceform_id" => $serviceform_id,
                    "customer" => $customer,
                    // "staff_id" => $staff_id,
                    "store_id" => $this->session->data['store_id'],
                    "user_id" => $user_id,

                );
                $result = $this->model_name->addServiceCustomer($data);
                if (!empty($result)) {
                    $output = $this->response->setResponse2(200, $result, "Success", "service");
                    $this->api->trackResponse($output);
                    return;
                } else {
                    $output = $this->response->setResponse2(400, $this->response->noResponse(), "Failed to save record", "service");
                    $this->api->trackResponse($output);
                    return;
                }
            } else {
                $output = $this->response->setResponse2(400, $this->response->noResponse(), "customer info not completed", "service");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setResponse2(400, $this->response->noResponse(), "customer_id and staff_id is required", "service");
            $this->api->trackResponse($output);
            return;
        }
    }

    private function validateCustomerInfo($customer)
    {
        $required_info = ['name', 'customer_ic', 'telephone1'];
        if (!empty($customer['customer_id'])) {
            return true;
        } else {
            $result = true;
            foreach ($required_info as $info) {
                if (empty($customer[$info])) {
                    $result = false;
                    break;
                }
            }
            return $result;
        }
    }

    private function updateServiceRecord($json)
    {
        $serviceform_id = !empty($json['serviceform_id']) ? $json['serviceform_id'] : false;
        $customer_id = !empty($json['customer']['customer_id']) ? $json['customer']['customer_id'] : false;
        // $staff_id = !empty($json['staff_id']) ? $json['staff_id'] : false;

        //service item info
        $remark = !empty($json['remark']) ? $json['remark'] : '';
        $status = !empty($json['status']) ? $json['status'] : 1;

        $this->load->library('clinicalservices');
        $this->cart = new Clinicalservices($this->registry);

        if ($customer_id && $serviceform_id) {

            //totals
            $total_data = array();
            $sort_order = array();

            $totals = array();
            $taxes = $this->cart->getTaxes();
            $total = 0;

            $this->load->model('pos/extension');

            $total_data = array(
                'totals' => &$totals,
                'taxes'  => &$taxes,
                'total'  => &$total
            );

            //display price
            $results = $this->model_pos_extension->getExtensions('total');

            foreach ($results as $key => $value) {
                $sort_order[$key] = $this->config->get('total_' . $value['code'] . '_sort_order');
            }

            array_multisort($sort_order, SORT_ASC, $results);

            foreach ($results as $result) {
                if ($this->config->get('total_' . $result['code'] . '_status')) {
                    $this->load->model('extension/total/' . $result['code']);
                    $this->{'model_extension_total_' . $result['code']}->getTotal($total_data);
                }

                $sort_order = array();

                foreach ($totals as $key => $value) {
                    $sort_order[$key] = $value['sort_order'];
                }

                array_multisort($sort_order, SORT_ASC, $totals);

                $data = array(
                    "serviceform_id" => $serviceform_id,
                    "customer_id"    => $customer_id,
                    "remark" => $remark,
                    "action" => $status,
                );
                $final_result = array(
                    "serviceform_id" => strval($serviceform_id),
                    "customer_id" => strval($customer_id)

                );
                // var_dump($totals);
                // die();
                $this->model_name->editServiceForm($serviceform_id, $data, $this->cart->getServices(), $totals);
                $output = $this->response->setResponse2(200, $final_result, "success", "service");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setResponse2(400, $this->response->noResponse(), "serviceform_id, customer_id is required", "service");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_service_history()
    {
        $this->load->language('android/service/service');

        //filter data
        $filter_date_from = null;
        $filter_date_to = null;
        $filter_invoice_prefix = null;
        $filter_store_id = null;
        $filter_status = null;
        $filter_total_price = null;

        $filter_date_from = isset($this->request->get['date_from']) && trim($this->request->get['date_from']) != '' ? $this->request->get['date_from'] : null;
        $filter_date_to = isset($this->request->get['date_to']) && trim($this->request->get['date_to']) != '' ? $this->request->get['date_to'] : null;
        $filter_invoice_prefix = isset($this->request->get['invoice_prefix']) && trim($this->request->get['invoice_prefix']) != '' ?  $this->request->get['invoice_prefix'] : null;
        $filter_store_id = isset($this->request->get['store_id']) && trim($this->request->get['store_id']) != '' ?  $this->request->get['store_id'] : null;
        $filter_status = isset($this->request->get['status']) && trim($this->request->get['status']) != '' ? $this->request->get['status'] : null;
        $filter_total_price = isset($this->request->get['total_price']) && trim($this->request->get['total_price']) != '' ? $this->request->get['total_price'] : null;


        if (trim($filter_store_id) != '') {
            $filter_store_id = explode(',', $filter_store_id);
            $filter_store_id = implode(', ', $filter_store_id);
        }
        //pagination
        $page = !empty($this->request->get['page']) ? $this->request->get['page'] : 1;
        $show = !empty($this->request->get['show']) ? $this->request->get['show'] : 10;

        $filters = array(
            "filter_date_from" => $filter_date_from,
            "filter_end_to" => $filter_date_to,
            "filter_invoice_prefix" => $filter_invoice_prefix,
            "filter_store_id" => $filter_store_id,
            "filter_status" => $filter_status,
            "filter_total_price" => $filter_total_price,
            "start"         => ($page - 1) * $show,
            "limit"         => $show

        );

        $serviceFormList = $this->model_android_service_service->getServiceHistoryList($filters);

        if (!empty($serviceFormList)) {
            foreach ($serviceFormList as $service) {
                $store_name = !empty($result['store_name']) ? $result['store_name'] : htmlspecialchars_decode($this->config->get('config_name'));

                $data['service_forms'][] = [
                    'service_form_id' => $service['service_form_id'],
                    'service_date' => $service['service_date'],
                    'date_added' => $service['date_added'],
                    'invoice_prefix' => $service['invoice_prefix'],
                    'store_id' => $service['store_id'],
                    'store_name' => $store_name,
                    'remark' => $service['remark'],
                    'status' => $service['status'],
                    'total_price' => $service['total_price'],
                    'date_modified' => $service['date_modified'],
                    'modifi_by' => $service['modifi_by'],
                    'customer_name' => $service['customer_name'],
                    'telephone' => $service['telephone'],
                    'age' => $service['age'],
                    'servicename' => $service['servicename'],
                    'price' => $service['price'],
                    // 'staff_id' => $service['user_id'],
                    'service_time' => $service['service_time'],
                    'start_time' => $service['start_time'],
                    'end_time' => $service['end_time'],
                    'service_period' => $service['service_period'],
                    'service_minute' => $service['serviceminutes'],
                    'order_no' => $service['order_no'],
                    'payment_status' => $service['payment_status'],
                    'payment_method' => $service['payment_method'],
                    'payment_date' => $service['payment_date'],
                ];
            }
            $output = $this->response->setCachedResponse(200, $data['service_forms'], "Service Form History List Success", "service");
            $this->api->trackResponse($output);
            return;
        } else {
            $data['service_forms'] = array();
            $output = $this->response->setCachedResponse(204, $data['service_forms'], "No result", "service");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_service_item_detail()
    {
        $serviceform_id = !empty($this->request->get['serviceform_id']) ? $this->request->get['serviceform_id'] : false;

        if ($serviceform_id) {
            $service_item_details = $this->model_name->getServiceItems($serviceform_id);
            if (!empty($service_item_details)) {
                $output = $this->response->setCachedResponse(200, $service_item_details, "Success", "service");
                $this->api->trackResponse($output);
                return;
            } else {
                $output = $this->response->setCachedResponse(204, $this->response->noResponse(), "No result", "service");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setCachedResponse(400, $this->response->noResponse(), "serviceform_id is required", "service");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_clinical_service_list()
    {
        $this->load->language('android/service/service');

        //filter data
        $filter_name = null;

        $filter_name = isset($this->request->get['name']) && trim($this->request->get['name']) != '' ?  $this->request->get['name'] : null;

        //pagination
        $page = !empty($this->request->get['page']) ? $this->request->get['page'] : 1;
        $show = !empty($this->request->get['show']) ? $this->request->get['show'] : 10;

        $filters = array(
            "filter_name" => $filter_name,
            "start"       => ($page - 1) * $show,
            "limit"       => $show
        );

        $results = $this->model_name->getClinicalServiceList($filters);

        if (!empty($results)) {
            foreach ($results as $clinicalService) {
                $data['clinicalServices'][] = array(
                    'service_id'              => $clinicalService['clinicalservice_id'],
                    'service_name'            => $clinicalService['name'],
                    'service_minute'                => $clinicalService['cs_minute'],
                    'price'                 => $clinicalService['price'],
                    // 'formated_price'         => $this->currency->format($clinicalService['price'], $this->config->get('config_currency')),
                    // 'type'                    => $clinicalService['type']
                );
            }
            $output = $this->response->setCachedResponse(200, $data['clinicalServices'], "Get Service List success", "service");
            $this->api->trackResponse($output);
            return;
        } else {
            $data['clinicalServices'] = array();
            $output = $this->response->setCachedResponse(204, $data['clinicalServices'], "No result", "service");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_meridian_list()
    {

        //filter data
        $filter_acupuncture_point = null;
        $filter_meridian = null;
        $filter_acupuncture_point_code = null;
        $filter_body_part = null;

        $filter_acupuncture_point = isset($this->request->get['name']) && trim($this->request->get['name']) != '' ?  $this->request->get['name'] : null;

        $filter_acupuncture_point_code = isset($this->request->get['code']) && trim($this->request->get['code']) != '' ?  $this->request->get['code'] : null;

        $filter_body_part = isset($this->request->get['filter_body_part']) && trim($this->request->get['filter_body_part']) != '' ?  $this->request->get['filter_body_part'] : null;

        // $filter_meridian = isset($this->request->get['meridian']) && trim($this->request->get['meridian']) != '' ?  $this->request->get['meridian'] : null;

        //pagination
        $page = !empty($this->request->get['page']) ? $this->request->get['page'] : 1;
        $show = !empty($this->request->get['show']) ? $this->request->get['show'] : 10;

        $filters = array(
            "filter_acupuncture_point" => $filter_acupuncture_point,
            "filter_acupuncture_point_code" => $filter_acupuncture_point_code,
            "filter_body_part" => $filter_body_part,
            // "filter_meridian" => $filter_meridian,
            "start"       => ($page - 1) * $show,
            "limit"       => $show
        );

        $results = $this->model_name->getMeridianList($filters);

        if (!empty($results)) {
            foreach ($results as $result) {
                $data['acupuncture_points'][] = array(
                    'acupuncture_id'            => $result['acupuncture_id'],
                    'name'                        => $result['name'],
                    'meridian'                    => $result['meridian'],
                    // 'code'                        => $result['code'],
                    // 'location'                    => $result['location'],
                    // 'ways'                        => $result['ways'],
                    // 'symptoms'                    => $result['symptoms'],
                );
            }
            $output = $this->response->setCachedResponse(200, $data['acupuncture_points'], "Get Meridian List success", "service");
            $this->api->trackResponse($output);
            return;
        } else {
            $data['acupuncture_points'] = array();
            $output = $this->response->setCachedResponse(204, $data['acupuncture_points'], "No result", "service");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_body_part_list()
    {
        //filter data 
        $filter_acupuncture_point = null;
        $filter_meridian = null;
        $filter_acupuncture_point_code = null;

        $filter_acupuncture_point = isset($this->request->get['name']) && trim($this->request->get['name']) != '' ?  $this->request->get['name'] : null;

        $filter_acupuncture_point_code = isset($this->request->get['code']) && trim($this->request->get['code']) != '' ?  $this->request->get['code'] : null;

        $filter_meridian = isset($this->request->get['parent_id']) && trim($this->request->get['parent_id']) != '' ?  $this->request->get['parent_id'] : null;

        //pagination
        $page = !empty($this->request->get['page']) ? $this->request->get['page'] : 1;
        $show = !empty($this->request->get['show']) ? $this->request->get['show'] : 10;

        $filters = array(
            "filter_acupuncture_point" => $filter_acupuncture_point,
            "filter_acupuncture_point_code" => $filter_acupuncture_point_code,
            "filter_meridian" => $filter_meridian,
            "start" => ($page - 1) * $show,
            "limit"       => $show
        );

        $results = $this->model_name->getBodyList($filters);

        if (!empty($results)) {
            foreach ($results as $result) {
                $data['acupuncture_points'][] = array(
                    'acupuncture_id'            => $result['acupuncture_id'],
                    'name'                        => $result['name'],
                    // 'code'                        => $result['code'],
                    'meridian'                    => $result['meridian'],
                    // 'location'                    => $result['location'],
                    // 'ways'                        => $result['ways'],
                    // 'symptoms'                    => $result['symptoms'],
                );
            }
            $output = $this->response->setCachedResponse(200, $data['acupuncture_points'], "Get Body List success", "service");
            $this->api->trackResponse($output);
            return;
        } else {
            $data['acupuncture_points'] = array();
            $output = $this->response->setCachedResponse(204, $data['acupuncture_points'], "No result", "service");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_acupuncture_body_part()
    {
        $filter_body_part = null;

        $filter_body_part = isset($this->request->get['name']) && trim($this->request->get['name']) != '' ?  $this->request->get['name'] : null;

        //pagination
        $page = !empty($this->request->get['page']) ? $this->request->get['page'] : 1;
        $show = !empty($this->request->get['show']) ? $this->request->get['show'] : 10;

        $filters = array(
            "filter_body_part" => $filter_body_part,
            "start" => ($page - 1) * $show,
            "limit"       => $show
        );

        $results = $this->model_name->getacupunctureBodyList($filters);
        if (!empty($results)) {
            foreach ($results as $result) {
                $data['acupuncture_points'][] = array(
                    'acupuncture_id'            => $result['acupuncture_id'],
                    'name'                        => $result['name'],
                    // 'code'                        => $result['code'],
                    // 'meridian'                    => $result['meridian'],
                    // 'location'                    => $result['location'],
                    // 'ways'                        => $result['ways'],
                    // 'symptoms'                    => $result['symptoms'],
                );
            }
            $output = $this->response->setCachedResponse(200, $data['acupuncture_points'], "Get Acupuncture Body List success", "service");
            $this->api->trackResponse($output);
            return;
        } else {
            $data['acupuncture_points'] = array();
            $output = $this->response->setCachedResponse(204, $data['acupuncture_points'], "No result", "service");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_summary_info()
    {
        $service_form_id = !empty($this->request->get['service_form_id']) ? $this->request->get['service_form_id'] : false;

        if ($service_form_id) {
            $service_summary_info = $this->model_name->getSummaryInfo($service_form_id);

            if (!empty($service_summary_info)) {
                $output = $this->response->setCachedResponse(200, $service_summary_info, "Success", "service");
                $this->api->trackResponse($output);
                return;
            } else {
                $output = $this->response->setCachedResponse(204, $this->response->noResponse(), "No result", "service");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setCachedResponse(400, $this->response->noResponse(), "service_form_id is required", "service");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function add_service_cart()
    {
        $json = $this->json;

        if (empty($json)) {
            $output = $this->response->setResponse2(400, $this->response->noResponse(), "missing json body", "service");
            $this->api->trackResponse($output);
            return;
        } else {
            $service_form_id = !empty($json['service_form_id']) ? $json['service_form_id'] : 0;

            if ($service_form_id) {
                $staff_id = !empty($json['staff_id']) ? $json['staff_id'] : 0;
                $price  = !empty($json['price']) ? $json['price'] : '';
                $starttime = !empty($json['starttime']) ? $json['starttime'] : '';
                $endtime = !empty($json['endtime']) ? $json['endtime'] : '';
            } else {
                $output = $this->response->setResponse(400, $this->response->noResponse(), "service_form_id is required", "service");
                $this->api->trackResponse($output);
                return;
            }
        }
    }

    protected function set_timer()
    {
        $json = $this->json;
        $service_item_id = !empty($json['service_item_id']) ? $json['service_item_id'] : false;
        $start_time = !empty($json['start_time']) ? $json['start_time'] : '';
        $end_time = !empty($json['end_time']) ? $json['end_time'] : '';


        if ($service_item_id && ($start_time || $end_time)) {
            $data = array(
                "service_Item_id" => $service_item_id,
                "start_time" => $start_time,
                "end_time" => $end_time,
            );

            $success = $this->model_name->setTime($data);
            $getserviceformid = $this->model_name->getServiceItem($service_item_id);
            $service_form_id = $getserviceformid['service_form_id'];
            if ($success) {
                $output = $this->response->setResponse2(200, $this->getInfo($service_form_id, 'all'), "success", "service");
                $this->api->trackResponse($output);
                return;
            } else {
                $output = $this->response->setResponse2(400, $this->response->noResponse(), "failed to save", "service");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setResponse2(400, $this->response->noResponse(), "service_item_id, start_time or end_time are required", "service");
            $this->api->trackResponse($output);
            return;
        }
    }

    private function saveServiceForm($json)
    {
        $service_form_id = !empty($json['service_form_id']) ? $json['service_form_id'] : false;
        $customer_id = !empty($json['customer']['customer_id']) ? $json['customer']['customer_id'] : false;
        $doctor_id = !empty($json['doctor_id']) ? $json['doctor_id'] : false;
        // $address_id = !empty($json['address_id']) ? $json['address_id'] : false;
        //service info
        $service_json = !empty($json['services']) ? $json['services'] : array();

        //service item info
        $remark = !empty($json['remark']) ? $json['remark'] : '';
        $status = !empty($json['status']) ? $json['status'] : 1;


        if (empty($doctor_id)) {
            $doctor_id = $this->session->data['user_id'];
        }

        if ($doctor_id) {
            //load customer model
            $this->load->model('android/customer/customer');

            if (empty($customer_id)) {
                //add customer first
                $customer = !empty($json['customer']) ? $json['customer'] : false;
                if ($this->validateCustomerInfo($customer)) {
                    $customer_group_id = !empty($customer['customer_group_id']) ? trim($customer['customer_group_id']) : '';
                    $customer_card = !empty($customer['registration_card_no']) ? trim($customer['registration_card_no']) : '';
                    $customer_ic = !empty($customer['customer_ic']) ? trim($customer['customer_ic']) : '';
                    $firstname = !empty($customer['name']) ? trim($customer['name']) : '';
                    $gender_id = !empty($customer['gender_id']) ? trim($customer['gender_id']) : '';
                    $dob = !empty($customer['dob']) ? trim($customer['dob']) : '';
                    $email = !empty($customer['email']) ? trim($customer['email']) : '';
                    $telephone1 = !empty($customer['telephone1']) ? trim($customer['telephone1']) : '';
                    $telephone2 = !empty($customer['telephone2']) ? trim($customer['telephone2']) : '';
                    $home = !empty($customer['home']) ? trim($customer['home']) : '';
                    $occupation = !empty($customer['occupation']) ? trim($customer['occupation']) : '';
                    $nationality = !empty($customer['nationality']) ? trim($customer['nationality']) : '';
                    $marital_status_id = !empty($customer['marital_status_id']) ? trim($customer['marital_status_id']) : '';
                    $religion_id = !empty($customer['religion_id']) ? trim($customer['religion_id']) : '';
                    $race_id = !empty($customer['race_id']) ? trim($customer['race_id']) : '';
                    $allergic = !empty($customer['allergic']) ? trim($customer['allergic']) : '';
                    $diagnostic_history = !empty($customer['diagnostic_history']) ? trim($customer['diagnostic_history']) : '';


                    $data = array(
                        "customer_id" => null,
                        "customer_group_id" => $customer_group_id,
                        "customer_card" => $customer_card,
                        "customer_ic" => $customer_ic,
                        "firstname" => $firstname,
                        "lastname" => '',
                        "gender_id" => $gender_id,
                        "dob" => $dob,
                        "email" => $email,
                        "telephone1" => $telephone1,
                        "telephone2" => $telephone2,
                        "home" => $home,
                        "occupation" => $occupation,
                        "nationality" => $nationality,
                        "marital_status_id" => $marital_status_id,
                        "religion_id" => $religion_id,
                        "race_id" => $race_id,
                        "allergic" => $allergic,
                        "diagnostic_history" => $diagnostic_history,
                    );

                    $customer_id = $this->model_android_customer_customer->updateCustomer($data);

                    //check address data and update
                    $addresses = !empty($customer['address']) ? $customer['address'] : array();
                    foreach ($addresses as $address) {
                        if ($this->validateAddressInfo($address)) {
                            $address_1 = !empty($address['address_1']) ? $address['address_1'] : '';
                            $address_2 = !empty($address['address_2']) ? $address['address_2'] : '';
                            $address_3 = !empty($address['address_3']) ? $address['address_3'] : '';
                            $city = !empty($address['city']) ? $address['city'] : '';
                            $postcode = !empty($address['post_code']) ? $address['post_code'] : '';
                            $country_id = !empty($address['country_id']) ? $address['country_id'] : '129';
                            $zone_id = !empty($address['zone_id']) ? $address['zone_id'] : '0';
                            $default = !empty($address['default']) ? $address['default'] : false;

                            $data = array(
                                "address_id" => null,
                                "customer_id" => $customer_id,
                                "firstname" => $firstname,
                                "lastname" => '',
                                "company" => '',
                                "address_1" => $address_1,
                                "address_2" => $address_2,
                                "address_3" => $address_3,
                                "city" => $city,
                                "postcode" => $postcode,
                                "country_id" => $country_id,
                                "zone_id" => $zone_id,
                                "default" => $default,
                            );
                            $this->model_android_customer_customer->updateAddress($data);
                        }
                    }
                } else {
                    $output = $this->response->setResponse2(400, $this->response->noResponse(), "customer info is not completed", "service");
                    $this->api->trackResponse($output);
                    return;
                }
            }


            $this->load->library('tax');
            $this->tax = new Tax($this->registry);

            //cart library
            $this->load->library('clinicalservices');
            $this->cart = new Clinicalservices($this->registry);


            $this->cart->clear();

            $services = array();

            if (!empty($service_json)) {
                foreach ($service_json as $service) {
                    $service_id = $service['service_id'];
                    $staff_id = $service['doctor_id'];
                    $service_details = $this->model_name->getServiceDetails($service_id);
                    $starttime = '0.00';
                    $endtime = '0.00';
                    $price = !empty($service['price']) ? $service['price'] : 0;
                    $price = str_replace('RM', '', $price);
                    $this->cart->set($service_id, $staff_id, $price, $starttime, $endtime);
                }
            }

            foreach ($service_json as $service) {
                $service_id = $service['service_id'];
                $price = !empty($service['price']) ? $service['price'] : 0;
                $price = str_replace('RM', '', $price);
                $service_info = $this->model_name->getServiceInfo($service_id);
                $sub_tax = $this->tax->calculateTax($price, $service_info['tax_class_id'], $this->config->get('config_tax'));

                $total = $sub_tax['total'];
                $tax = $sub_tax['tax'];
                $subtotal = $sub_tax['net_amount'];
                $acupunctures = $service['acupunctures'];


                $services[] = array(
                    "service_id" => $service_id,
                    "service_item_id" => !empty($service['service_item_id']) ? $service['service_item_id'] : null,
                    "doctor_id" => $service['doctor_id'],
                    // "staff_name" => $service['staff_name'],
                    "service_name" => $service_info['service_name'],
                    "service_minute" => $service_info['service_minute'],
                    "start_time" => !empty($service['start_time']) ? $service['start_time'] : '',
                    "end_time" => !empty($service['end_time']) ? $service['end_time'] : '',
                    "price" => $price,
                    "tax_class_id" => $service_info['tax_class_id'],
                    "tax_code" => $this->tax->getClassCode($service_info['tax_class_id']),
                    "tax_format" => $sub_tax['format'],
                    'tax' => $tax,
                    "net_amount" =>  $sub_tax['net_amount'],
                    "total" =>  $total,
                    'subtotal' => $subtotal,
                    "acupunctures" => $acupunctures,
                );
            }

            if ($this->opencart_version == 2) {

                //totals
                $total_data = array();
                $sort_order = array();

                $totals = array();
                $total = 0;
                $taxes = $this->cart->getTaxes();

                $this->load->model('pos/extension');

                //display price
                $results = $this->model_pos_extension->getExtensions('total');

                foreach ($results as $key => $value) {
                    $sort_order[$key] = $this->config->get($value['code'] . '_sort_order');
                }

                array_multisort($sort_order, SORT_ASC, $results);

                foreach ($results as $result) {
                    if ($this->config->get($result['code'] . '_status')) {
                        $this->load->model('total/' . $result['code']);
                        $this->{'model_total_' . $result['code']}->getTotal($total_data, $total, $taxes);
                    }

                    $sort_order = array();

                    foreach ($total_data as $key => $value) {
                        $sort_order[$key] = $value['sort_order'];
                    }

                    array_multisort($sort_order, SORT_ASC, $total_data);
                }

                $order_total = $this->formattedTotal($total_data);
            } else {
                //totals
                $total_data = array();
                $sort_order = array();

                $totals = array();
                $taxes = $this->cart->getTaxes();
                $total = 0;

                $this->load->model('pos/extension');

                $total_data = array(
                    'totals' => &$totals,
                    'taxes'  => &$taxes,
                    'total'  => &$total
                );


                //display price
                $results = $this->model_pos_extension->getExtensions('total');

                foreach ($results as $key => $value) {
                    $sort_order[$key] = $this->config->get('total_' . $value['code'] . '_sort_order');
                }

                array_multisort($sort_order, SORT_ASC, $results);

                foreach ($results as $result) {
                    if ($this->config->get('total_' . $result['code'] . '_status')) {
                        $this->load->model('extension/total/' . $result['code']);
                        $this->{'model_extension_total_' . $result['code']}->getTotal($total_data);
                    }

                    $sort_order = array();

                    foreach ($totals as $key => $value) {
                        $sort_order[$key] = $value['sort_order'];
                    }

                    array_multisort($sort_order, SORT_ASC, $totals);
                }

                $order_total = $this->formattedTotal($totals);
            }

            $data = array(
                "service_form_id" => $service_form_id,
                "customer_id"  => $customer_id,
                "doctor_id" => $doctor_id,
                "remark"  => $remark,
                "order_total" => $order_total,
                "services" => $services,
            );


            $service_form_id = $this->model_name->saveServiceForm($data);
            if ($service_form_id) {
                $output = $this->response->setResponse2(200, $this->getInfo($service_form_id, 'all'), "success", "service");
                $this->api->trackResponse($output);
                return;
            } else {
                $output = $this->response->setResponse2(400, $this->response->noResponse(), "failed to save", "service");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setResponse2(400, $this->response->noResponse(), "doctor_id is required", "service");
            $this->api->trackResponse($output);
            return;
        }
    }

    private function getInfo($service_form_id)
    {
        $this->load->language('android/service/service');

        $this->load->library('tax');
        $this->tax = new Tax($this->registry);

        $result = $this->response->noResponse();
        $service_form_info = $this->model_name->getServiceFormInfo($service_form_id);

        if (!empty($service_form_info)) {

            $this->cart->clear();

            //get customer info
            $customer_info = $this->model_name->getCustomer($service_form_info['customer_id']);

            if (!empty($customer_info)) {
                $address_list = $this->model_name->getAddressesByCustomerId($service_form_info['customer_id']);
                $address_list = !empty($address_list) ? $address_list : array();
                $addresses = array();

                foreach ($address_list as $row) {
                    $add_name = '';
                    $add_name .= !empty($row['address_1']) ? $row['address_1'] : '';
                    $add_name .= !empty($row['address_2']) ? ', ' . $row['address_2'] : '';
                    $add_name .= !empty($row['address_3']) ? ', ' . $row['address_3'] : '';
                    $add_name .= !empty($row['postcode']) ? ', ' . $row['postcode'] : '';
                    $add_name .= !empty($row['city']) ? ', ' . $row['city'] : '';
                    $add_name .= !empty($row['zone']) ? ', ' . $row['zone'] : '';

                    $addresses[] = array(
                        "id" => $row['address_id'],
                        "label" => $add_name
                    );
                }

                // if ($customer_info['gender'] == '1') {
                //     $gen = $this->language->get('text_male');
                // } elseif ($customer_info['gender'] == '2') {
                //     $gen = $this->language->get('text_female');
                // } else {
                //     $gen = '';
                // }

                $customer = array(
                    "cn_name"            => $customer_info['firstname'],
                    "en_name"            => $customer_info['lastname'],
                    "name"      => trim($customer_info['firstname'] . " " . $customer_info['lastname']),
                    "customer_id"        => $customer_info['customer_id'],
                    "customer_ic"        => $customer_info['customer_ic'],
                    "email"              => $customer_info['email'],
                    "telephone1"         => $customer_info['telephone'],
                    "dob"                => $customer_info['dob'] == '0000-00-00' ? null : $customer_info['dob'],
                    "customer_card"      => $customer_info['customer_card'],
                    "gender_id"          => empty($customer_info['gender']) ? null : $customer_info['gender'],
                    // "gender_id"          => $gen,
                    "telephone"         => $customer_info['telephone'],
                    "occupation"         => $customer_info['occupation'],
                    "nationality"        => $customer_info['nationality'],
                    "marital_status_id"  => empty($customer_info['marital_status']) ? null : $customer_info['marital_status'],
                    "religion_id"        => empty($customer_info['religion']) ? null : $customer_info['religion'],
                    "race_id"            => empty($customer_info['race']) ? null : $customer_info['race'],
                    "address"            => $addresses

                );
            } else {
                $customer = $this->response->noResponse();
            }
            $services =  $this->model_name->getServiceItems($service_form_id);

            $totals = $this->model_name->getServiceTotals($service_form_id);
            $totals = $this->formattedTotal($totals);
            $all_total = array();
            foreach ($totals as $total) {
                $all_total[] = array(
                    "title" => $total['title'],
                    "value" => $this->currency->format($total['value'], $this->config->get('config_currency'))
                );
            }

            $returned_service_list = array();
            foreach ($services as $serve) {

                $sub_tax = $this->tax->calculateTax($serve['price'], $serve['tax_class_id'], $this->config->get('config_tax'));
                $price = $this->currency->format($serve['price'], $this->config->get('config_currency'));

                $acupunctures = $this->model_name->getAcupuncturePointByServiceItemId($serve['service_Item_id']);

                $doctors = $this->model_name->getDoctors();
                $returned_service_list[] = array(
                    "service_id" => $serve['clinicalservice_id'],
                    "service_item_id" => $serve['service_Item_id'],
                    "hide_timer"    => true,
                    "start_time" => !empty($serve['start_time']) ? $serve['start_time'] : null,
                    "end_time" => !empty($serve['end_time']) ? $serve['end_time'] : null,
                    // "service_form_id" => $serve['service_form_id'],
                    "service_name"  => $serve['servicename'],
                    "service_minute"  => $serve['serviceminutes'],
                    "gst" => $serve['gst'],
                    "price" => $price,
                    // "tax_class_id" => $serve['tax_class_id'],
                    // "tax_format" => $sub_tax['format'],
                    // "net_amount" =>  $sub_tax['net_amount'],

                    "doctor" => array(
                        "id" => $serve['user_id'],
                        "name" => $serve['doctor_name']
                    ),
                    "acupunctures" => $acupunctures,
                );
            }

            $acupunctures = $this->model_name->getAcupuncturePoints();

            $result = array(
                "service_form_id" => (string)$service_form_id,
                "invoice_prefix"   => $service_form_info['invoice_prefix'],
                "customer" => $customer,
                "totals" =>  $all_total,
                "services" => $returned_service_list,

            );
        }
        return $result;
    }

    protected function copy_service()
    {
        $service_form_id = !empty($this->request->get['service_form_id']) ? $this->request->get['service_form_id'] : false;

        $section = !empty($this->request->get['section']) ? $this->request->get['section'] : 'all';

        if ($service_form_id) {
            $service_form_info = $this->model_name->getServiceFormInfo($service_form_id);

            if (!empty($service_form_info)) {

                $customer_info = $this->model_name->getCustomer($service_form_info['customer_id']);

                if (!empty($customer_info)) {
                    if ($customer_info['gender'] == '1') {
                        $gen = $this->language->get('text_male');
                    } elseif ($customer_info['gender'] == '2') {
                        $gen = $this->language->get('text_female');
                    } else {
                        $gen = '';
                    }

                    $customer = array(
                        "customer_name"      => $customer_info['customer_name'],
                        "customer_ic"        => $customer_info['customer_ic'],
                        "email"              => $customer_info['email'],
                        "dob"                => $customer_info['dob'],
                        "customer_card"      => $customer_info['customer_card'],
                        "gender"             => $gen,
                        "telephone"         => $customer_info['telephone']
                    );
                } else {
                    $customer = $this->response->noResponse();
                }


                $service_infos = $this->model_name->getServiceItems($service_form_id);
                $services = array();
                if (!empty($service_infos)) {
                    $all_doctors = $this->model_name->getDoctors();
                    $all_points = $this->model_name->getAcupuncturePoints();
                    foreach ($service_infos as $service_info) {

                        $services[] = array(
                            "service_id" => $service_info['clinicalservice_id'],
                            "service_name" => $service_info['servicename'],
                            "service_minute" => $service_info['serviceminutes'],
                            "price" => $service_info['price'],
                            "doctors" => $all_doctors,
                            "acupuncture" => $all_points,

                        );
                    }
                }




                //build result to send
                switch (strtolower($section)) {
                    case "services":
                        $results = array(
                            'services' => $services,
                        );
                        break;
                    default:
                        $results = array(
                            "invoice_prefix" => $service_form_info['invoice_prefix'],
                            "service_date" => $service_form_info['service_date'],
                            'remark' => $service_form_info['remark'],
                            'services' => $services,
                            'customer' => $customer,
                        );
                }
                // var_dump($services);
                // die();

                $output = $this->response->setCachedResponse(200, $results, "Success", "service");
                $this->api->trackResponse($output);
                return;
            } else {
                $output = $this->response->setCachedResponse(200, $this->response->noResponse(), "Success", "service");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setCachedResponse(400, $this->response->noResponse(), "service_form_id is required", "service");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function complete()
    {
        $service_form_id = !empty($this->request->get['service_form_id']) ? $this->request->get['service_form_id'] : false;
        if ($service_form_id) {
            $this->model_name->completeService($service_form_id);
            $output = $this->response->setCachedResponse(200, $this->response->noResponse(), "success", "service");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setCachedResponse(400, $this->response->noResponse(), "service_form_id is required", "service");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function cancel()
    {
        $service_form_id = !empty($this->request->get['service_form_id']) ? $this->request->get['service_form_id'] : false;
        if ($service_form_id) {
            $this->model_name->cancelService($service_form_id);
            $output = $this->response->setCachedResponse(200, $this->response->noResponse(), "success", "service");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setCachedResponse(400, $this->response->noResponse(), "service_form_id is required", "service");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function delete()
    {
        $service_form_id = !empty($this->request->post['service_form_id']) ? $this->request->post['service_form_id'] : false;
        if ($service_form_id) {
            $this->model_name->deleteServiceForm($service_form_id);
            $output = $this->response->setCachedResponse(200, $this->response->noResponse(), "success", "service");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setCachedResponse(400, $this->response->noResponse(), "service_form_id required", "service");
            $this->api->trackResponse($output);
            return;
        }
    }


    public function test_background_job()
    {
        date_default_timezone_set('Asia/Kuala_Lumpur');
        $sql = "SELECT * FROM " . DB_PREFIX . "service_item WHERE start_time <> '' AND end_time = ''";
        $query = $this->db->query($sql);
        // echo json_encode($query->rows);
        // date("Y-m-d H:i:s", strtotime(date("2022-06-23 11:30:32.9000") . " +30 minutes"));

        if (!empty($query->rows)) {
            foreach ($query->rows as $row) {
                $now = date('Y-m-d H:i:s');
                $start_time = $row['start_time'];
                $service_minute = $row['serviceminutes'];
                $end_time = date("Y-m-d H:i:s", strtotime($start_time . "+$service_minute minutes"));
                echo "service_minute:$service_minute";
                echo "<br>";
                echo "now:$now";
                echo "<br>";
                echo "start_time:$start_time";
                echo "<br>";
                echo "end_time:$end_time";
                echo "<br>";
                if ($end_time <= $now) {
                    echo "exceed time: Yes";
                    $this->sendTimerNotification($row);
                } else {
                    echo "exceed time: No";
                }
                echo "<br>";
                echo "<br>";
            }
        } else {
            echo "No service need reminder for now";
        }
    }

    private function sendTimerNotification($info)
    {
        $this->load->model('android/common/notification');
        $app_url = $this->model_android_common_notification->getNotificationDataUrl('doctorapp', 'service_form');
        $app_url = str_replace(':id', $info['service_form_id'], $app_url);
        $app_url = str_replace(':customer-id', '', $app_url);
        $data = array("url" => $app_url);

        $title_en = $info['servicename'] . ' timer is up !';
        $title_cn = $info['servicename'] . ' timer is up !';

        $body_en = 'Click Here to see service form';
        $body_cn = 'Click Here to see service form';
        $notification = array(
            'title' => $this->session->data['language_id'] == '1' ? $title_en : $title_cn,
            'body' => $this->session->data['language_id'] == '1' ? $body_en : $body_cn,
        );
        $params = array(
            "user_id" => $info['user_id'],
            "notification" => $notification,
            "notification_type" => 'service_form',
            "data" => $data
        );
        $this->load->controller('android/common/notification/push', $params);
    }

    private function formattedTotal($totals)
    {
        $total_data = array();
        foreach ($totals as $total) {
            switch ($total['code']) {
                case 'sub_total':
                    $title_en = "Subtotal";
                    $title_cn = "商品小计";
                    break;
                case 'tax':
                    $title_en = "Tax";
                    $title_cn = "税额";
                    break;
                case 'rounding':
                    $title_en = "Rounding";
                    $title_cn = "舍入";
                    break;
                case 'shipping':
                    $title_en = "Shipping";
                    $title_cn = "运输费";
                    break;
                case 'credit':
                    $title_en = "ETCM Pay";
                    $title_cn = "ETCM 支付";
                    break;
                case 'total':
                    $title_en = "Total";
                    $title_cn = "付款总额";
                    break;
                default:
                    $title_en = $total['title'];
                    $title_cn = $total['title'];
            }

            $title = $this->session->data['language_id'] == 1 ? $title_en : $title_cn;
            $total_data[] = array(
                "key" => isset($total['key']) ? $total['key'] : '',
                "code" => $total['code'],
                "title" => $title,
                "text" => isset($total['text']) ? $total['text'] : '',
                "tax_code" => isset($total['tax_code']) ? $total['tax_code'] : '',
                "value" => $total['value'],
                "sort_order" => isset($total['sort_order']) ? $total['sort_order'] : '',
            );
        }
        return $total_data;
    }

    private function validateAddressInfo($address)
    {
        $required_info = [
            'address_1',
            'city',
            'post_code',
            'zone_id'
        ];

        $result = true;
        foreach ($required_info as $info) {
            if (empty($address[$info])) {
                $result = false;
                break;
            }
        }
        return $result;
    }
}
