<?php

class ControllerAndroidReportStockSummary extends Controller
{

    public function index()
    {
        date_default_timezone_set("Asia/Kuala_Lumpur");
        //load required model
        $this->load->model('android/report/stock_summary');
        $this->model_name = $this->model_android_report_stock_summary;

        require DIR_SYSTEM . "/library/start_api.php";
    }

    protected function get_summary()
    {
        $product_name = !empty($this->request->get['product_name']) ? $this->request->get['product_name'] : null;
        $store_id = isset($this->request->get['store_id']) ? $this->request->get['store_id'] : $this->session->data['store_id'];
        $category_id = !empty($this->request->get['category_id']) ? $this->request->get['category_id'] : null;
        $min_qty = !empty($this->request->get['min_quantity']) ? $this->request->get['min_quantity'] : null;
        $max_qty = !empty($this->request->get['max_quantity']) ? $this->request->get['max_quantity'] : null;

        $page = !empty($this->request->get['page']) ? $this->request->get['page'] : '1';
        $show = !empty($this->request->get['show']) ? $this->request->get['show'] : '10';

        $allStores = $this->getAllStore();

        $all_stores = array_column($allStores, 'id');

        $filters = array(
            "product_name"  => $product_name,
            "store_id"      => $store_id,
            "category_id"   => $category_id,
            "min_qty"       => $min_qty,
            "max_qty"       => $max_qty,
            "all_stores"    => $all_stores,
            "start"         => ($page - 1) * $show,
            "limit"         => $show
        );

        $stocks = $this->model_name->getStocks($filters);
        $result = array();
        foreach ($allStores as $store) {
            $stores[$store['id']] = $store['name'];
        }

        foreach ($stocks as $stock) {
            $product_name = $this->session->data['language_id'] == 1 ? $stock['en_name'] : $stock['cn_name'];
            $product_code = !empty($stock['code']) ? "(" . $stock['code'] . ")" : '';
            $product_name .= $product_code;
            $result[] = array(
                "product_id"    => $stock['product_id'],
                "store_id"      => $stock['store_id'],
                "product_name"  => $product_name,
                "store_name"    => $stores[$stock['store_id']],
                "category_name" => $stock['category_name'],
                "quantity"      => $stock['onhand_quantity'],
            );
        }

        $output = $this->response->setCachedResponse(200, $result, 'Success', 'report');
        $this->api->trackResponse($output);
        return;
    }

    protected function get_transactions()
    {
        $product_id = !empty($this->request->get['product_id']) ? $this->request->get['product_id'] : 0;

        if (empty($product_id)) {
            $output = $this->response->setCachedResponse(404, array(), 'product_id required', 'report');
            $this->api->trackResponse($output);
            return;
        }
        if ($this->model_name->productStockExists($product_id)) {
            $today = date('Y-m-d');
            $start_date = $today;
            $end_date = $today;
            if (!empty($this->request->get['start_date'])) {
                $start_date = $this->request->get['start_date'];
            }
            if (!empty($this->request->get['end_date'])) {
                $end_date = $this->request->get['end_date'];
            }

            $store_id = isset($this->request->get['store_id']) ? $this->request->get['store_id'] : $this->session->data['store_id'];

            $filter_doc_no = !empty($this->request->get['doc_no']) ? $this->request->get['doc_no'] : null;
            $filter_person_name = !empty($this->request->get['person_name']) ? $this->request->get['person_name'] : null;

            $page = !empty($this->request->get['page']) ? $this->request->get['page'] : '1';
            $show = !empty($this->request->get['show']) ? $this->request->get['show'] : '10';

            $filters = array(
                "doc_no"        => $filter_doc_no,
                "person_name"   => $filter_person_name,
                "start_date"    => $start_date,
                "end_date"      => $end_date,
                "store_id"      => $store_id,
                "start"         => ($page - 1) * $show,
                "limit"         => $show
            );

            $transaction_items = $this->model_name->getStockTransactions($product_id, $filters);

            $config_weight = $this->config->get('config_weight');

            $open_stock = $this->model_name->getOpenStock($start_date . ' 00:00:00', $product_id, $store_id);
            $close_stock = $this->model_name->getCloseStock($end_date . ' 23:59:59', $product_id, $store_id);

            $open_stock = $this->weight->format((float) $open_stock, $config_weight);
            $close_stock = $this->weight->format((float) $close_stock, $config_weight);

            $transactions = array();

            foreach ($transaction_items as $item) {
                $transactions[] = array(
                    "name"      => $item['name'],
                    "date"      => date('d M Y', strtotime($item['date_added'])),
                    "doc_no"    => $item['id'],
                    "add"       => $item['add'],
                    "deduct"    => $item['deduct'],
                    "balance"   => $item['balance'],
                );
            }

            $result = array(
                "open_stock"    => $open_stock,
                "close_stock"   => $close_stock,
                "transactions"  => $transactions,
            );

            $output = $this->response->setCachedResponse(200, $result, 'Success', 'report');
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setCachedResponse(404, array(), 'Not Found', 'report');
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_summary_filters()
    {
        $stores = [];

        if ($this->session->data['user_info']['viewalldata']) {
            $stores = $this->getAllStore();
        } else {
            $userStores = $this->model_name->getUserStore();

            if (count($userStores) > 0) {
                foreach ($this->getAllStore() as $store) {
                    if (in_array($store['id'], $userStores)) {
                        $stores[] = $store;
                    }
                }
            }
        }

        $categories = $this->model_name->getCategories();

        $result = array(
            "stores"        => $stores,
            "categories"    => $categories
        );

        $output = $this->response->setCachedResponse(200, $result, 'Success', 'report');
        $this->api->trackResponse($output);
        return;
    }

    private function getAllStore()
    {
        $stores = array();

        $this->load->model('setting/store');
        $db_stores = $this->model_setting_store->getStores();

        $stores[] = array('id' => "0", 'name' => htmlspecialchars_decode($this->config->get('config_name')) . " (HQ)");

        foreach ($db_stores as $store) {
            $stores[] = array(
                "id"    => $store['store_id'],
                "name"  => $store['name'],
            );
        }

        $columns = array_column($stores, 'name');
        array_multisort($columns, SORT_ASC, $stores);

        return $stores;
    }
}
