<?php

class ControllerAndroidReportStock extends Controller
{
    private $call_function;
    private $s;
    private $json;
    private $user_info;

    public function index()
    {
        //load model required
        $this->load->model('android/report/stock');

        //load core api function
        require DIR_SYSTEM . "/library/start_api.php";
    }

    protected function get_list()
    {
        $result = array();
        $filter_data = array();

        $page = 1;
        $limit = $this->config->get('config_limit_admin');

        $filter_product_code = null;
        $filter_product_name = null;
        $filter_store_id = $this->session->data['store_id'];
        $filter_categories = null;
        $filter_low_stock = null;
        $sort = null;
        $sort_column = null;
        $sort_direction = null;

        if (isset($this->request->get['filterproductname']) && $this->request->get['filterproductname'] != '') {
            $filter_product_name = $this->request->get['filterproductname'];
        }
        if (isset($this->request->get['filterstoreid']) && !empty($this->request->get['filterstoreid'])) {
            $filter_store_id = $this->request->get['filterstoreid'];
        }
        if (isset($this->request->get['filtercategories']) && !empty($this->request->get['filtercategories'])) {
            $filter_categories = $this->request->get['filtercategories'];
        }
        if (isset($this->request->get['filterlowstock']) && $this->request->get['filterlowstock'] != '') {
            $filter_low_stock = $this->request->get['filterlowstock'];
        }
        if (isset($this->request->get['page']) && $this->request->get['page'] != '') {
            $page = $this->request->get['page'];
        }
        if (isset($this->request->get['show']) && $this->request->get['show'] != '') {
            $limit = $this->request->get['show'];
        }
        if (isset($this->request->get['sort']) && $this->request->get['sort'] != '') {
            $sort = $this->request->get['sort'];
        }

        // convert filters category and store id to array
        if (!empty($filter_categories)) {
            $filter_categories = explode(',', $filter_categories);
            $filter_categories = array_filter(array_map('trim', $filter_categories));
        }

        if ($filter_store_id != '') {
            $filter_store_id = explode(',', $filter_store_id);
            // $filter_store_id = array_filter(array_map('trim', $filter_store_id));
        }

        $filter_data = array(
            // "filter_product_code" => $filter_product_code,
            "filter_product_name" => $filter_product_name,
            "filter_store_id" => $filter_store_id,
            "filter_categories" => $filter_categories,
            "filter_low_stock" => $filter_low_stock,
            'sort' => $sort,
            "start" => ($page - 1) * $limit,
            "limit" => $limit
        );
        $stocks = $this->model_android_report_stock->getStockSummary($filter_data);
        $stores = $this->get_all_store();

        foreach ($stocks as $stock) {
            // $product_name = $this->session->data['language_id'] == '1' ? $stock['en_name'] : $stock['cn_name'];
            $product_name = $stock['name'];
            $result[] = array(
                "product_id" => $stock['product_id'],
                "code" => $stock['code'],
                "name" => $product_name,
                "store_id" => $stock['store_id'],
                // "store_name" => isset($stores[$stock['store_id']]) ? $stores[$stock['store_id']] : 'Invalid Store Id',
                "store_name" => $stock['store_name'],
                "quantity" => $stock['quantity_text']
            );
        }

        $this->response->setCachedResponse(200, $result, "success", "stock_summary");
        return;
    }


    protected function get_detail_list()
    {
        if (isset($this->request->get['product_id']) && $this->request->get['product_id'] != '') {
            $product_id = $this->request->get['product_id'];
        } else {
            $product_id = null;
        }
        if (isset($this->request->get['store_id']) && $this->request->get['store_id'] != '') {
            $store_id = $this->request->get['store_id'];
        } else {
            $store_id = null;
        }

        if ($product_id && is_numeric($store_id)) {
            $detail = $this->model_android_report_stock->getStockDetail($product_id, $store_id);
            if (!empty($detail)) {
                $result = array();
                foreach ($detail as $row) {
                    $result[] = array(
                        "location" => $row['location_text'],
                        "batch_date" => $row['batch_date'],
                        "quantity" => $row['quantity_text']
                    );
                }
                $this->response->setCachedResponse(200, $result, "success", "stock_summary");
                return;
            } else {
                $this->response->setCachedResponse(204, array(), "not found", "stock_summary");
                return;
            }
        } else {
            $this->response->setCachedResponse(400, array(), "Missing parameter", "stock_summary");
            return;
        }
    }

    protected function get_filters()
    {
        $filters = array(
            "filter_categories" => $this->model_android_report_stock->getFilterCategories(),
            "filter_store_id" => $this->model_android_report_stock->getFilterStoreId()
        );
        $this->response->setCachedResponse(200, $filters, "Success", "stock_summary");
        return;
    }

    protected function get_product_autocomplete()
    {
        $product_name = isset($this->request->get['product']) ? $this->request->get['product'] : '';
        $result = array();
        if (trim($product_name)) {
            $products = $this->model_android_report_stock->productAutocomplete($product_name);
            if (!empty($products)) {
                foreach ($products as $product) {
                    $result[] = $this->session->data['language_id'] == '1' ? $product['en_name'] : $product['cn_name'];
                }
            }
        }
        $this->response->setCachedResponse(200, $result, 'success', 'products');
        return;
    }

    #region internal function
    private function get_all_store()
    {
        $result = array();
        $this->load->model('setting/store');
        $stores = $this->model_setting_store->getStores();
        $default_store = $this->model_android_report_stock->getDefaultStore();
        if ($default_store) {
            $stores[] = array('store_id' => "0", 'name' => $default_store);
        }
        foreach ($stores as $store) {
            $result[$store['store_id']] = $store['name'];
        }

        return $result;
    }

    //used for update product_name pinyin
    protected function update_product()
    {
        $sql = "SELECT * FROM oc_product_description WHERE language_id='2' AND name <>'' ";
        // limit 0, 100";
        $query = $this->db->query($sql);
        if ($query->num_rows) {
            echo "<table>";
            echo "<tr>";
            echo "<th>Product ID</th>";
            echo "<th>Name</th>";
            echo "</tr>";
            foreach ($query->rows as $row) {
                $cn_name = $row['name'];
                if (preg_match('/[\x{4e00}-\x{9fa5}]/u', $cn_name) > 0) {

                    //call api to convert
                    $curl = curl_init();

                    curl_setopt_array($curl, array(
                        CURLOPT_URL => 'https://helloacm.com/api/pinyin/?cached&s=' . urlencode($cn_name),
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => '',
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_CUSTOMREQUEST => 'GET',
                    ));

                    $response = curl_exec($curl);

                    curl_close($curl);
                    $response = json_decode($response, true);
                    $pinyin = implode(" ", $response['result']);

                    //update oc_product
                    $sql = "UPDATE oc_product SET pinyin='" . $this->db->escape($pinyin) . "' WHERE product_id='" . (int)$row['product_id'] . "'";
                    $this->db->query($sql);
                    echo "<tr>";
                    echo "<td>" . $row['product_id'] . "</td>";
                    echo "<td>" . $cn_name . "</td>";
                    echo "<td>" . $pinyin . "</td>";
                    echo "</tr>";
                }
            }
            echo "</table>";
        }
    }

    #endregion
}
