<?php

class ControllerAndroidReportService extends Controller
{
    private $json;
    private $model_name;
    private $filter_status_id = ['1', '5', '7'];
    private $filter_payment_status_id = ['1', '17', '5'];

    public function index()
    {
        date_default_timezone_set("Asia/Kuala_Lumpur");
        //load required model
        $this->load->model('android/report/service');
        $this->model_name = $this->model_android_report_service;

        require DIR_SYSTEM . "/library/start_api.php";
    }

    protected function get_summary()
    {
        $status = !empty($this->request->get['status']) ? $this->request->get['status'] : null;
        $status = is_numeric($status) ? $status : null;
        $filter['status'] = $status;
        $last_updated = $this->model_name->getLastUpdate();

        if (!empty($last_updated)) {
            $last_updated = "Record until " . date('j M Y, H:i:s', strtotime($last_updated));
        } else {
            $last_updated = '';
        }

        $currency = $this->config->get('config_currency');

        $today = strtotime('today');
        // ****************************** today summary ******************************
        $filter['date_start'] = date('Y-m-d');
        $filter['date_end'] = date('Y-m-d');
        $today_total = $this->model_name->getTotalSale($filter);

        $today_summary = array(
            "amount_text" => $this->currency->format($today_total, $currency),
        );

        // ****************************** weekly summary ******************************
        $filter['date_start'] = date('N', $today) == 1 ? date('Y-m-d', $today) : date('Y-m-d', strtotime('last monday', $today));
        $filter['date_end'] = date('N', $today) == 7 ? date('Y-m-d', $today) : date('Y-m-d', strtotime('next sunday', $today));
        $this_week_total = $this->model_name->getTotalSale($filter);

        $weekly_summary = array(
            "amount_text" => $this->currency->format($this_week_total, $currency),
        );

        // ****************************** yearly summary ******************************
        $filter['date_start'] = date('Y-01-01');
        $filter['date_end'] = date('Y-12-31');
        $this_year_total = $this->model_name->getTotalSale($filter);

        $yearly_summary = array(
            "amount_text" => $this->currency->format($this_year_total, $currency),
        );

        $result = array(
            "last_updated"      => $last_updated,
            "today_summary"     => $today_summary,
            "weekly_summary"    => $weekly_summary,
            "yearly_summary"    => $yearly_summary,
        );

        $output = $this->response->setCachedResponse(200, $result, 'Success', 'report');
        $this->api->trackResponse($output);
        return;
    }

    protected function get_transactions()
    {
        $date_start = !empty($this->request->get['date_start']) ? $this->request->get['date_start'] : '';
        $date_end = !empty($this->request->get['date_end']) ? $this->request->get['date_end'] : '';
        $date_type = !empty($this->request->get['date_type']) ? $this->request->get['date_type'] : '';

        $status = !empty($this->request->get['status']) ? $this->request->get['status'] : null;
        $status = is_numeric($status) ? $status : null;


        $payment_status = !empty($this->request->get['payment_status']) ? $this->request->get['payment_status'] : null;
        $payment_status = is_numeric($payment_status) ? $payment_status : null;

        $customer_id = !empty($this->request->get['customer_id']) ? $this->request->get['customer_id'] : null;
        $customer_name = !empty($this->request->get['customer_name']) ? $this->request->get['customer_name'] : null;

        $amount_start = !empty($this->request->get['amount_start']) ? $this->request->get['amount_start'] : '';
        $amount_end = !empty($this->request->get['amount_end']) ? $this->request->get['amount_end'] : '';

        $page = !empty($this->request->get['page']) ? $this->request->get['page'] : '1';
        $show = !empty($this->request->get['show']) ? $this->request->get['show'] : '10';

        $currency = $this->config->get('config_currency');

        if (empty($date_start) || empty($date_end)) {
            $sort_by_type = !empty($date_type) ? $date_type : 'THIS_YEAR';
            if (!empty($sort_by_type)) {
                $today = strtotime('today');
                $yesterday = strtotime('yesterday');
                switch ($sort_by_type) {
                    case "THIS_YEAR":
                        $date_start = date('Y-01-01');
                        $date_end = date('Y-12-31');
                        break;
                    case "THIS_MONTH":
                        $date_start = date('Y-m-01');
                        $date_end = date('Y-m-t');
                        break;
                    case "THIS_WEEK":
                        $date_start = date('N', $today) == 1 ? date('Y-m-d', $today) : date('Y-m-d', strtotime('last monday', $today));
                        $date_end = date('N', $today) == 7 ? date('Y-m-d', $today) : date('Y-m-d', strtotime('next sunday', $today));
                        break;
                    case "YESTERDAY":
                        $date_start = date('Y-m-d', $yesterday);
                        $date_end = date('Y-m-d', $yesterday);
                        break;
                    case "TODAY":
                    default:
                        $date_start = date('Y-m-d');
                        $date_end = date('Y-m-d');
                }
            }
        }

        $filter = array(
            'date_start'    => $date_start,
            'date_end'      => $date_end,
            'customer_id'   => $customer_id,
            'customer_name' => $customer_name,
            'amount_start'  => $amount_start,
            'amount_end'    => $amount_end,
            'status'        => $status,
            'payment_status' => $payment_status,
            'start'         => ($page - 1) * $show,
            'limit'         => $show
        );

        $transactions = $this->model_name->getTransactions($filter);

        $list = [];
        if (!empty($transactions)) {
            $arr_status = $this->getStatuses();
            foreach ($transactions as $tx) {
                $list[] = array(
                    "id" => $tx['service_form_id'],
                    "doc_no" => $tx['invoice_prefix'],
                    "doc_date" => date('j M Y', strtotime($tx['service_date'])),
                    "customer_name" => $tx['customer_name'],
                    "customer_ic" => $tx['customer_ic'],
                    "status_text" => !empty($arr_status[$tx['serviceform_action']]['name']) ? $arr_status[$tx['serviceform_action']]['name'] : '',
                    "status_color" => !empty($arr_status[$tx['serviceform_action']]['color']) ? $arr_status[$tx['serviceform_action']]['color'] : '#000000',
                    "payment_status_text" => !empty($arr_status[$tx['order_action']]['name']) ? $arr_status[$tx['order_action']]['name'] : '',
                    "payment_status_color" => !empty($arr_status[$tx['order_action']]['color']) ? $arr_status[$tx['order_action']]['color'] : '#000000',
                    "amount_text" => $this->currency->format($tx['total_price'], $currency),
                );
            }
        }

        $summary = $this->model_name->getTotalTransactions($filter);
        $total_transactions = $summary['transactions'];
        $amount = (float)$summary['amount'];

        $transaction_amount = $this->currency->format($amount, $currency);

        $result = array(
            'list' => $list,
            'total_transaction' => $total_transactions,
            'transaction_amount' => $transaction_amount
        );

        $output = $this->response->setCachedResponse(200, $result, 'Success', 'report');
        $this->api->trackResponse($output);
        return;
    }

    protected function get_item_transactions()
    {
        $date_start = !empty($this->request->get['date_start']) ? $this->request->get['date_start'] : '';
        $date_end = !empty($this->request->get['date_end']) ? $this->request->get['date_end'] : '';
        $date_type = !empty($this->request->get['date_type']) ? $this->request->get['date_type'] : '';

        $status = !empty($this->request->get['status']) ? $this->request->get['status'] : null;
        $status = is_numeric($status) ? $status : null;


        $payment_status = !empty($this->request->get['payment_status']) ? $this->request->get['payment_status'] : null;
        $payment_status = is_numeric($payment_status) ? $payment_status : null;

        $customer_id = !empty($this->request->get['customer_id']) ? $this->request->get['customer_id'] : null;
        $customer_name = !empty($this->request->get['customer_name']) ? $this->request->get['customer_name'] : null;

        $doctor_id = !empty($this->request->get['doctor_id']) ? $this->request->get['doctor_id'] : null;

        $amount_start = !empty($this->request->get['amount_start']) ? $this->request->get['amount_start'] : '';
        $amount_end = !empty($this->request->get['amount_end']) ? $this->request->get['amount_end'] : '';

        $page = !empty($this->request->get['page']) ? $this->request->get['page'] : '1';
        $show = !empty($this->request->get['show']) ? $this->request->get['show'] : '10';

        $currency = $this->config->get('config_currency');

        if (empty($date_start) || empty($date_end)) {
            $sort_by_type = !empty($date_type) ? $date_type : 'THIS_YEAR';
            if (!empty($sort_by_type)) {
                $today = strtotime('today');
                $yesterday = strtotime('yesterday');
                switch ($sort_by_type) {
                    case "THIS_YEAR":
                        $date_start = date('Y-01-01');
                        $date_end = date('Y-12-31');
                        break;
                    case "THIS_MONTH":
                        $date_start = date('Y-m-01');
                        $date_end = date('Y-m-t');
                        break;
                    case "THIS_WEEK":
                        $date_start = date('N', $today) == 1 ? date('Y-m-d', $today) : date('Y-m-d', strtotime('last monday', $today));
                        $date_end = date('N', $today) == 7 ? date('Y-m-d', $today) : date('Y-m-d', strtotime('next sunday', $today));
                        break;
                    case "YESTERDAY":
                        $date_start = date('Y-m-d', $yesterday);
                        $date_end = date('Y-m-d', $yesterday);
                        break;
                    case "TODAY":
                    default:
                        $date_start = date('Y-m-d');
                        $date_end = date('Y-m-d');
                }
            }
        }

        $filter = array(
            'date_start'    => $date_start,
            'date_end'      => $date_end,
            'doctor_id'     => $doctor_id,
            'customer_id'   => $customer_id,
            'customer_name' => $customer_name,
            'amount_start'  => $amount_start,
            'amount_end'    => $amount_end,
            'status'        => $status,
            'payment_status' => $payment_status,
            'start'         => ($page - 1) * $show,
            'limit'         => $show
        );

        $transactions = $this->model_name->getItemTransactions($filter);

        $list = [];
        if (!empty($transactions)) {
            $arr_status = $this->getStatuses();
            foreach ($transactions as $tx) {
                $list[] = array(
                    "id" => $tx['service_form_id'],
                    "doc_no" => $tx['invoice_prefix'],
                    "doc_date" => date('j M Y', strtotime($tx['service_date'])),
                    "customer_name" => $tx['customer_name'],
                    "doctor_name" => $tx['doctor_name'],
                    "service_name" => $tx['servicename'],
                    "customer_ic" => $tx['customer_ic'],
                    "status_text" => !empty($arr_status[$tx['serviceform_action']]['name']) ? $arr_status[$tx['serviceform_action']]['name'] : '',
                    "status_color" => !empty($arr_status[$tx['serviceform_action']]['color']) ? $arr_status[$tx['serviceform_action']]['color'] : '#000000',
                    "payment_status_text" => !empty($arr_status[$tx['order_action']]['name']) ? $arr_status[$tx['order_action']]['name'] : '',
                    "payment_status_color" => !empty($arr_status[$tx['order_action']]['color']) ? $arr_status[$tx['order_action']]['color'] : '#000000',
                    "amount_text" => $this->currency->format($tx['total_price'], $currency),
                );
            }
        }

        $summary = $this->model_name->getTotalItemTransactions($filter);
        $total_transactions = $summary['transactions'];
        $amount = (float)$summary['amount'];

        $transaction_amount = $this->currency->format($amount, $currency);

        $result = array(
            'list' => $list,
            'total_transaction' => $total_transactions,
            'transaction_amount' => $transaction_amount
        );

        $output = $this->response->setCachedResponse(200, $result, 'Success', 'report');
        $this->api->trackResponse($output);
        return;
    }

    protected function get_filters()
    {
        //doc statuses
        $statuses[] = ["id" => "0", "name" => "All"];
        $arr_status = $this->getStatuses();
        foreach ($this->filter_status_id as $stat_id) {
            if (!empty($arr_status[$stat_id])) {
                $statuses[] = array(
                    "id" => $stat_id,
                    "name" => $arr_status[$stat_id]['name']
                );
            }
        }

        //payment statuses
        $payment_statuses[] = ["id" => "0", "name" => "All"];
        foreach ($this->filter_payment_status_id as $stat_id) {
            if (!empty($arr_status[$stat_id])) {
                $payment_statuses[] = array(
                    "id" => $stat_id,
                    "name" => $arr_status[$stat_id]['name']
                );
            }
        }

        $result = array(
            "status"    => $statuses,
            "payment_status" => $payment_statuses
        );

        $output = $this->response->setCachedResponse(200, $result, 'Success', 'report');
        $this->api->trackResponse($output);
        return;
    }

    private function getStatuses()
    {
        $return_statuses = [];
        $db_statuses = $this->model_name->getStatuses();
        if (!empty($db_statuses)) {
            foreach ($db_statuses as $status) {
                switch ($status['id']) {
                    case '1':
                        $color = "#F38733";
                        break;
                    case '5':
                        $color = "#8FBB6C";
                        break;
                    case '2':
                        $color = "#3997C4";
                        break;
                    case '17':
                    case '7':
                        $color = "#F56B6B";
                        break;
                    default:
                        $color = "#000000";
                }
                $return_statuses[$status['id']]['color'] = $color;
                $return_statuses[$status['id']]['name'] = $status['name'];
            }
        }
        return $return_statuses;
    }
}
