<?php

class ControllerAndroidReportReport extends Controller
{
    private $json;

    private $reports = array(
        array(
            "cn_name" => "处方笺",
            "en_name" => "Medical Record",
            "path" => "herbal/new_herbal",
            "app_link" => "report/medical_record",
            "key"   => "report/medical_record",
            "icon" => "https://www.etcm.me/image/doctorapp/report_icon/report-herbal-remedies.png"
        ),
        array(
            "cn_name" => "诊所服务",
            "en_name" => "Service Form",
            "path" => "service/service_form",
            "app_link" => "report/service_form",
            "key"   => "report/service_form",
            "icon" => "https://www.etcm.me/image/doctorapp/report_icon/report-service-form.png"
        ),
        array(
            "cn_name" => "煎药销售订单",
            "en_name" => "Brewing Sales Order",
            "path" => "service_partner/sale_order",
            "app_link" => "report/brewing_sale_order",
            "key"   => "report/brewing_sale_order",
            "icon" => "https://www.etcm.me/image/doctorapp/report_icon/report-brewing-service.png"
        ),
        array(
            "cn_name" => "煎药购买订单",
            "en_name" => "Brewing Purchase Order",
            "path" => "service_partner/purchase_order",
            "app_link" => "report/brewing_purchase_order",
            "key"   => "report/brewing_purchase_order",
            "icon" => "https://www.etcm.me/image/doctorapp/report_icon/report-brewing-purchase.png"
        ),
        array(
            "cn_name" => "出货",
            "en_name" => "Stock",
            "app_link" => "report/stock_summary",
            "path" => "report/product_stock",
            "app_link" => "/report/stock_summary",
            "key"   => "report/stock_summary",
            "icon" => "https://www.etcm.me/image/doctorapp/report_icon/report-stock.png"
        ),
        array(
            "cn_name" => "交易记录",
            "en_name" => "Credit Transactions",
            "path" => "report/credit",
            "app_link" => "report/credit",
            "key"   => "report/credit",
            "icon" => "https://www.etcm.me/image/doctorapp/report_icon/report-transaction.png"
        ),
        array(
            "cn_name" => "医师日销售额",
            "en_name" => "Daily Sales by Doctor",
            "path" => "report/sale_summary_doctor",
            "app_link" => "report/sale_summary_doctor",
            "key"   => "report/sale_summary_doctor",
            "icon" => "https://www.etcm.me/image/doctorapp/report_icon/report-sales-doctor.png"
        ),
        // array(
        //     "cn_name" => "收银系统",
        //     "en_name" => "POS",
        //     "app_link" => "report/pos",
        //     "key"   => "report/pos",
        //     "icon" => "https://www.etcm.me/image/doctorapp/report_icon/report-pos.png"
        // ),
    );


    public function index()
    {
        //load required model
        $this->load->model('android/report/report');

        $this->model_name = $this->model_android_report_report;

        require DIR_SYSTEM . "/library/start_api.php";
    }

    protected function get_list()
    {
        $result = [];

        $permission = $this->getPermissions();
        foreach ($this->reports as $report) {
            $granted = false;
            if (in_array($report['path'], $permission)) {
                $granted = true;
                if ($report['path'] == 'report/sale_summary_doctor') {
                    $granted = false;
                    if ($this->session->data['user_info']['viewalldata'] != '1') {
                        if ($this->session->data['user_info']['position'] == '2') {
                            $granted = true;
                        }
                    } else {
                        $granted = true;
                    }
                }
            }
            if ($granted) {
                $result[] = array(
                    'title' => $this->session->data['language_id'] == 1 ? $report['en_name'] : $report['cn_name'],
                    'app_link' => $report['app_link'],
                    'key' => $report['key'],
                    'icon' => $report['icon']
                );
            }
        }

        $output = $this->response->setCachedResponse(200, $result, 'Success', 'report');
        $this->api->trackResponse($output);
        return;
    }

    protected function get_files()
    {
        $result = [];

        if (!empty($this->request->get['key'])) {
            $key = $this->request->get['key'];
            $base_path = str_replace("/system/", '/', DIR_SYSTEM);
            $request_path = $base_path . 'doctor_app/template/' . $key;
            if (is_dir($request_path)) {
                $files = array_diff(scandir($request_path), array('.', '..'));

                foreach ($files as $file) {
                    $result[] = HTTPS_SERVER . "doctor_app/template/$key/$file";
                }
            }
            $output = $this->response->setCachedResponse(200, $result, 'Success', 'report');
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setCachedResponse(400, $result, 'key is required', "report");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_doctors()
    {
        $filter_search = '';
        if (!empty($this->request->get['filter_search'])) {
            $filter_search = (string)trim($this->request->get['filter_search']);
        }
        $filter_search = !empty($filter_search) ? $filter_search : null;
        $page = !empty($this->request->get['page']) ? $this->request->get['page'] : 0;
        $show = !empty($this->request->get['show']) ? $this->request->get['show'] : 15;

        $filters = array(
            "filter_search" => $filter_search,
            "start"         => !empty($page) ? (($page - 1) * $show) : null,
            "limit"         => $show
        );

        $doctors = $this->model_name->getDoctors($filters);
        $results = array();
        foreach ($doctors as $doctor) {
            $results[] = array(
                "id" => $doctor['id'],
                "name" => ucwords($doctor['name'])
            );
        }
        $output = $this->response->setCachedResponse(200, $results, "Get list success", "report");
        $this->api->trackResponse($output);
        return;
    }

    protected function get_customers()
    {
        $filter_search = '';
        if (!empty($this->request->get['filter_search'])) {
            $filter_search = (string) trim($this->request->get['filter_search']);
        }

        $filter_search = !empty($filter_search) ? $filter_search : null;
        $page = !empty($this->request->get['page']) ? $this->request->get['page'] : 0;
        $show = !empty($this->request->get['show']) ? $this->request->get['show'] : 15;

        $filters = array(
            "filter_search" => $filter_search,
            "start"         => !empty($page) ? (($page - 1) * $show) : null,
            "limit"         => $show
        );

        $customers = $this->model_name->getCustomers($filters);
        $results = array();
        foreach ($customers as $customer) {
            $results[] = array(
                "id"    => $customer['customer_id'],
                "name"  => trim($customer['firstname'] . ' ' . $customer['lastname']),
                "phone" => !empty($customer['telephone']) ? $customer['telephone'] : '-',
                "ic_no" => !empty($customer['customer_ic']) ? $customer['customer_ic'] : '-',
            );
        }
        $output = $this->response->setCachedResponse(200, $results, "Get list success", "report");
        $this->api->trackResponse($output);
        return;
    }

    protected function get_brewing_customers()
    {
        $filter_search = '';
        if (!empty($this->request->get['filter_search'])) {
            $filter_search = (string) trim($this->request->get['filter_search']);
        }

        $filter_search = !empty($filter_search) ? $filter_search : null;
        $page = !empty($this->request->get['page']) ? $this->request->get['page'] : 0;
        $show = !empty($this->request->get['show']) ? $this->request->get['show'] : 15;

        $filters = array(
            "filter_search" => $filter_search,
            "start"         => !empty($page) ? (($page - 1) * $show) : null,
            "limit"         => $show
        );

        $customers = $this->model_name->getBrewingCustomers($filters);
        $results = array();
        foreach ($customers as $customer) {
            $results[] = array(
                "id"    => $customer['customer_id'],
                "name"  => $customer['customer_name'],
                "phone" => !empty($customer['customer_telephone']) ? $customer['customer_telephone'] : '-',
                "email" => !empty($customer['customer_email']) ? $customer['customer_email'] : '-',
            );
        }
        $output = $this->response->setCachedResponse(200, $results, "Get list success", "report");
        $this->api->trackResponse($output);
        return;
    }

    private function getPermissions()
    {
        $permission = array();
        if (!empty($this->session->data['user_info'])) {
            $user_group_id = $this->session->data['user_info']['user_group_id'];
            $user_group_permission = $this->db->query("SELECT permission FROM " . DB_PREFIX . "user_group WHERE user_group_id = '" . (int) $user_group_id . "'");
            if ($user_group_permission->num_rows) {
                $result = json_decode($user_group_permission->row['permission'], true);

                $result = $result == null ? unserialize($user_group_permission->row['permission']) : $result;

                $result['access'][] = "report/credit";
                $permission = $result['access'];
            }
        }
        return $permission;
    }
}
