<?php

class ControllerAndroidReportDailySales extends Controller
{
    private $json;
    private $model_name;
    private $filter_payment_status_id = ['1', '17', '5'];

    public function index()
    {
        date_default_timezone_set("Asia/Kuala_Lumpur");
        //load required model
        $this->load->model('android/report/daily_sales');
        $this->model_name = $this->model_android_report_daily_sales;

        require DIR_SYSTEM . "/library/start_api.php";
    }

    protected function get_sales_by_doctor()
    {
        $date_start = !empty($this->request->get['date_start']) ? $this->request->get['date_start'] : '';
        $date_end = !empty($this->request->get['date_end']) ? $this->request->get['date_end'] : '';
        $date_type = !empty($this->request->get['date_type']) ? $this->request->get['date_type'] : '';

        $payment_status = isset($this->request->get['payment_status']) ? $this->request->get['payment_status'] : null;
        $payment_status = is_numeric($payment_status) ? $payment_status : 5;

        $doctor_id = !empty($this->request->get['doctor_id']) ? $this->request->get['doctor_id'] : null;
        $doctor_id = is_numeric($doctor_id) ? $doctor_id : 0;

        $page = !empty($this->request->get['page']) ? $this->request->get['page'] : '1';
        $show = !empty($this->request->get['show']) ? $this->request->get['show'] : '10';

        if (empty($date_start) || empty($date_end)) {
            $sort_by_type = !empty($date_type) ? $date_type : 'TODAY';
            if (!empty($sort_by_type)) {
                $today = strtotime('today');
                $yesterday = strtotime('yesterday');
                switch ($sort_by_type) {
                    case "THIS_YEAR":
                        $date_start = date('Y-01-01');
                        $date_end = date('Y-12-31');
                        break;
                    case "THIS_MONTH":
                        $date_start = date('Y-m-01');
                        $date_end = date('Y-m-t');
                        break;
                    case "THIS_WEEK":
                        $date_start = date('N', $today) == 1 ? date('Y-m-d', $today) : date('Y-m-d', strtotime('last monday', $today));
                        $date_end = date('N', $today) == 7 ? date('Y-m-d', $today) : date('Y-m-d', strtotime('next sunday', $today));
                        break;
                    case "YESTERDAY":
                        $date_start = date('Y-m-d', $yesterday);
                        $date_end = date('Y-m-d', $yesterday);
                        break;
                    case "TODAY":
                    default:
                        $date_start = date('Y-m-d');
                        $date_end = date('Y-m-d');
                }
            }
        }

        $filter = array(
            'date_start'        => $date_start,
            'date_end'          => $date_end,
            'payment_status'    => $payment_status,
            'doctor_id'         => $doctor_id,
            'start'             => ($page - 1) * $show,
            'limit'             => $show
        );

        $doctor_sales = [];
        $sales = $this->model_name->getDoctorSales($filter);
        if (!empty($sales)) {
            $this->load->model('tool/image');
            foreach ($sales as $sale) {
                $image = $sale['image'];
                if (is_file(DIR_IMAGE . $image)) {
                    $image = $this->model_tool_image->resize($image, 120, 120);
                } else {
                    $image = "https://ui-avatars.com/api/?background=random&bold=true&size=120&name=" . str_replace(' ', '+', $sale['doctor_name']);
                }

                $medical        = $sale['medical'];
                $consultation   = $sale['consultation'];
                $service        = $sale['service'];
                $total_sales    = $medical + $consultation + $service;

                $new_medical        = $sale['new_medical'];
                $new_consultation   = $sale['new_consultation'];
                $new_service        = $sale['new_service'];
                $new_customer_sales = $new_medical + $new_consultation + $new_service;

                $existing_medical        = $sale['existing_medical'];
                $existing_consultation   = $sale['existing_consultation'];
                $existing_service        = $sale['existing_service'];
                $existing_customer_sales = $existing_medical + $existing_consultation + $existing_service;

                $medical = $this->currency->format($medical, $this->config->get('config_currency'));
                $consultation = $this->currency->format($consultation, $this->config->get('config_currency'));
                $service = $this->currency->format($service, $this->config->get('config_currency'));
                $total_sales = $this->currency->format($total_sales, $this->config->get('config_currency'));

                $new_customer_sales = $this->currency->format($new_customer_sales, $this->config->get('config_currency'));
                $existing_customer_sales = $this->currency->format($existing_customer_sales, $this->config->get('config_currency'));

                $new_customer = $sale['new_patient'];
                $existing_customer = $sale['existing_patient'];

                $doctor_sales[] = array(
                    "doctor_image"              => $image,
                    "doctor_id"                 => $sale['doctor_id'],
                    "doctor_name"               => $sale['doctor_name'],
                    "total_sales"               => $total_sales,
                    "new_customer_sales"        => $new_customer_sales,
                    "existing_customer_sales"   => $existing_customer_sales,
                    "new_customer"              => $new_customer,
                    "existing_customer"         => $existing_customer,
                    "service"                   => $service,
                    "medical"                   => $medical,
                    "consultation"              => $consultation,
                );
            }
        }

        $last_updated = $this->model_name->getLastUpdate();

        if (!empty($last_updated)) {
            $last_updated = "Record until " . date('j M Y, H:i:s', strtotime($last_updated));
        } else {
            $last_updated = '';
        }

        //total data
        $total_data = $this->model_name->getResultTotal($filter);

        $total_all_sales        = $total_data['all_medical_total'] + $total_data['all_consultation_total'] + $total_data['all_service_total'];
        $total_new_sales        = $total_data['new_medical_total'] + $total_data['new_consultation_total'] + $total_data['new_service_total'];
        $total_existing_sales   = $total_data['existing_medical_total'] + $total_data['existing_consultation_total'] + $total_data['existing_service_total'];

        $total_all_sales = $this->currency->format($total_all_sales, $this->config->get('config_currency'));
        $total_new_sales = $this->currency->format($total_new_sales, $this->config->get('config_currency'));
        $total_existing_sales = $this->currency->format($total_existing_sales, $this->config->get('config_currency'));

        $result = array(
            "last_updated" => $last_updated,
            "list" => $doctor_sales,
            "total" => [
                "total_all_sales"       => $total_all_sales,
                "total_new_sales"       => $total_new_sales,
                "total_existing_sales"  => $total_existing_sales,
            ]
        );

        $output = $this->response->setCachedResponse(200, $result, 'Success', 'report');
        $this->api->trackResponse($output);
        return;
    }

    protected function get_filters()
    {
        $arr_status = $this->getStatuses();
        //payment statuses
        $payment_statuses[] = ["id" => "0", "name" => "All"];
        foreach ($this->filter_payment_status_id as $stat_id) {
            if (!empty($arr_status[$stat_id])) {
                $payment_statuses[] = array(
                    "id" => $stat_id,
                    "name" => $arr_status[$stat_id]['name']
                );
            }
        }

        $result = array(
            "payment_status"    => $payment_statuses
        );
        $output = $this->response->setCachedResponse(200, $result, 'Success', 'report');
        $this->api->trackResponse($output);
        return;
    }

    private function getStatuses()
    {
        $return_statuses = [];
        $db_statuses = $this->model_name->getStatuses();
        if (!empty($db_statuses)) {
            foreach ($db_statuses as $status) {
                switch ($status['id']) {
                    case '1':
                        $color = "#F38733";
                        break;
                    case '5':
                        $color = "#8FBB6C";
                        break;
                    case '18':
                        $color = "#3997C4";
                        break;
                    case '17':
                    case '7':
                        $color = "#F56B6B";
                        break;
                    default:
                        $color = "#000000";
                }
                $return_statuses[$status['id']]['color'] = $color;
                $return_statuses[$status['id']]['name'] = $status['name'];
            }
        }
        return $return_statuses;
    }
}
