<?php

class ControllerAndroidReportCredit extends Controller
{
    private $json;

    public function index()
    {
        require DIR_SYSTEM . "/library/start_api.php";
    }

    protected function get_list()
    {
        $path = "etcm/report/credit/get_list";
        $requested = [];
        $requested['hosting'] = HTTPS_SERVER;

        $requested['sort_by_type'] = !empty($this->request->get['date_type']) ? $this->request->get['date_type'] : '';
        $requested['date_start'] = !empty($this->request->get['date_start']) ? $this->request->get['date_start'] : '';
        $requested['date_end'] = !empty($this->request->get['date_end']) ? $this->request->get['date_end'] : '';

        $requested['page'] = !empty($this->request->get['page']) ? $this->request->get['page'] : '1';
        $requested['show'] = !empty($this->request->get['show']) ? $this->request->get['show'] : '10';


        $result = $this->connectCurl($path, $requested);
        if (!empty($result)) {
            if (!empty($result['error'])) {
                $output = $this->response->setCachedResponse(204, new stdClass(), $result['message'], "report");
                $this->api->trackResponse($output);
                return;
            } else {
                $output = $this->response->setCachedResponse(200, $result['response'], $result['message'], "report");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setCachedResponse(204, new stdClass(), "API Connection Errors : Please check the internet connection or API connection!", "report");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_detail()
    {
        $path = "etcm/report/credit/get_detail";
        $requested = [];
        $requested['hosting'] = HTTPS_SERVER;

        $requested['transaction_id'] = !empty($this->request->get['transaction_id']) ? $this->request->get['transaction_id'] : '0';


        $result = $this->connectCurl($path, $requested);
        if (!empty($result)) {
            if (!empty($result['error'])) {
                $output = $this->response->setCachedResponse(204, new stdClass(), $result['message'], "report");
                $this->api->trackResponse($output);
                return;
            } else {
                $output = $this->response->setCachedResponse(200, $result['response'], $result['message'], "report");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setCachedResponse(204, new stdClass(), "API Connection Errors : Please check the internet connection or API connection!", "report");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function connectCurl($path, $data)
    {
        $language = !empty($_SERVER['HTTP_ACCEPT_LANGUAGE']) ? $_SERVER['HTTP_ACCEPT_LANGUAGE'] : 'cn';
        $device_id = !empty($_SERVER['HTTP_DEVICE_ID']) ? $_SERVER['HTTP_DEVICE_ID'] : '';

        $url = HTTP_API . 'index.php?route=' . $path;
        $curl = curl_init();

        curl_setopt($curl, CURLOPT_HEADER, false);
        curl_setopt($curl, CURLINFO_HEADER_OUT, true);
        curl_setopt($curl, CURLOPT_USERAGENT, $this->request->server['HTTP_USER_AGENT']);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_POST, 1);
        curl_setopt($curl, CURLOPT_POSTFIELDS, htmlspecialchars_decode(json_encode($data)));
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array('Accept-Language: ' . $language, 'Device-Id: ' . $device_id, 'Content-Type: application/json'));
        curl_setopt($curl, CURLOPT_TIMEOUT, 15);

        $response = curl_exec($curl);

        // var_dump($response);

        $result = json_decode(htmlspecialchars_decode($response), true);

        curl_close($curl);

        return $result;
    }
}
