<?php

class ControllerAndroidReportBrewingPurchase extends Controller
{
    private $model_name;

    public function index()
    {
        date_default_timezone_set("Asia/Kuala_Lumpur");

        //load required model
        $this->load->model('android/report/brewing_purchase');
        $this->model_name = $this->model_android_report_brewing_purchase;

        require DIR_SYSTEM . "/library/start_api.php";
    }

    protected function get_summary()
    {
        $status = !empty($this->request->get['status']) ? $this->request->get['status'] : null;

        $filter['status'] = strtolower($status) != 'all' ? $status : null;

        $last_updated = $this->model_name->getLastUpdate();

        if (!empty($last_updated)) {
            $last_updated = "Record until " . date('j M Y, H:i:s', strtotime($last_updated));
        } else {
            $last_updated = '';
        }

        $currency = $this->config->get('config_currency');

        $today = strtotime('today');
        // ****************************** today summary ******************************
        $filter['date_start'] = date('Y-m-d 00:00:00');
        $filter['date_end'] = date('Y-m-d 23:59:59');
        $today_total = $this->model_name->getTotalSale($filter);
        $today_commission = 0;

        $today_summary = array(
            "amount_text"  => $this->currency->format($today_total, $currency),
            "commission"   => $this->currency->format($today_commission, $currency)
        );

        // ****************************** weekly summary ******************************
        $filter['date_start'] = date('N', $today) == 1 ? date('Y-m-d 00:00:00', $today) : date('Y-m-d 00:00:00', strtotime('last monday', $today));
        $filter['date_end'] = date('N', $today) == 7 ? date('Y-m-d 23:59:59', $today) : date('Y-m-d 23:59:59', strtotime('next sunday', $today));
        $this_week_total = $this->model_name->getTotalSale($filter);
        $this_week_commission = 0;

        $weekly_summary = array(
            "amount_text" => $this->currency->format($this_week_total, $currency),
            "commission"   => $this->currency->format($this_week_commission, $currency)
        );

        // ****************************** yearly summary ******************************
        $filter['date_start'] = date('Y-01-01 00:00:00');
        $filter['date_end'] = date('Y-12-31 23:59:59');
        $this_year_total = $this->model_name->getTotalSale($filter);
        $this_year_commission = 0;

        $yearly_summary = array(
            "amount_text" => $this->currency->format($this_year_total, $currency),
            "commission"   => $this->currency->format($this_year_commission, $currency)
        );

        $result = array(
            "last_updated"      => $last_updated,
            "today_summary"     => $today_summary,
            "weekly_summary"    => $weekly_summary,
            "yearly_summary"    => $yearly_summary,
        );

        $output = $this->response->setCachedResponse(200, $result, 'Success', 'report');
        $this->api->trackResponse($output);
        return;
    }

    protected function get_transactions()
    {
        $date_start = !empty($this->request->get['date_start']) ? $this->request->get['date_start'] : '';
        $date_end = !empty($this->request->get['date_end']) ? $this->request->get['date_end'] : '';
        $date_type = !empty($this->request->get['date_type']) ? $this->request->get['date_type'] : '';

        $status = !empty($this->request->get['status']) ? $this->request->get['status'] : null;
        $status = strtolower($status) != 'all' ? $status : null;
        $customer_name = !empty($this->request->get['customer_name']) ? $this->request->get['customer_name'] : null;
        $customer_id = !empty($this->request->get['customer_id']) ? $this->request->get['customer_id'] : null;

        $amount_start = !empty($this->request->get['amount_start']) ? $this->request->get['amount_start'] : '';
        $amount_end = !empty($this->request->get['amount_end']) ? $this->request->get['amount_end'] : '';

        $page = !empty($this->request->get['page']) ? $this->request->get['page'] : '1';
        $show = !empty($this->request->get['show']) ? $this->request->get['show'] : '10';

        $currency = $this->config->get('config_currency');

        if (empty($date_start) || empty($date_end)) {
            $sort_by_type = !empty($date_type) ? $date_type : 'THIS_YEAR';
            if (!empty($sort_by_type)) {
                $today = strtotime('today');
                $yesterday = strtotime('yesterday');
                switch ($sort_by_type) {
                    case "THIS_YEAR":
                        $date_start = date('Y-01-01 00:00:00');
                        $date_end = date('Y-12-31 23:59:59');
                        break;
                    case "THIS_MONTH":
                        $date_start = date('Y-m-01 00:00:00');
                        $date_end = date('Y-m-t 23:59:59');
                        break;
                    case "THIS_WEEK":
                        $date_start = date('N', $today) == 1 ? date('Y-m-d 00:00:00', $today) : date('Y-m-d 00:00:00', strtotime('last monday', $today));
                        $date_end = date('N', $today) == 7 ? date('Y-m-d 23:59:59', $today) : date('Y-m-d 23:59:59', strtotime('next sunday', $today));
                        break;
                    case "YESTERDAY":
                        $date_start = date('Y-m-d 00:00:00', $yesterday);
                        $date_end = date('Y-m-d 23:59:59', $yesterday);
                        break;
                    case "TODAY":
                    default:
                        $date_start = date('Y-m-d 00:00:00');
                        $date_end = date('Y-m-d 23:59:59');
                }
            }
        }

        $filter = array(
            'date_start'    => $date_start,
            'date_end'      => $date_end,
            'customer_name' => $customer_name,
            'customer_id'   => $customer_id,
            'amount_start'  => $amount_start,
            'amount_end'    => $amount_end,
            'status'        => $status,
            'start'         => ($page - 1) * $show,
            'limit'         => $show
        );

        $transactions = $this->model_name->getTransactions($filter);

        $list = [];
        if (!empty($transactions)) {
            $arr_status = $this->getStatuses();
            foreach ($transactions as $tx) {
                $list[] = array(
                    "id"            => $tx['purchase_order_id'],
                    "doc_no"        => $tx['doc_no'],
                    "doc_date"      => date('j M Y H:i:s',strtotime($tx['doc_date'])),
                    "customer_name" => $tx['customer_name'],
                    "customer_phone" => $tx['customer_telephone'],
                    "status_text"   => !empty($arr_status[$tx['etcm_status_code']]['name']) ? $arr_status[$tx['etcm_status_code']]['name'] : '',
                    "status_color"  => !empty($arr_status[$tx['etcm_status_code']]['color']) ? $arr_status[$tx['etcm_status_code']]['color'] : '#000000',
                    "amount_text"   => $this->currency->format($tx['grand_total'], $currency),
                );
            }
        }

        $summary = $this->model_name->getTotalTransactions($filter);
        $total_transactions = $summary['transactions'];
        $amount = (float)$summary['amount'];
        $transaction_amount = $this->currency->format($amount, $currency);

        $result = array(
            'list'                  => $list,
            'total_transaction'     => $total_transactions,
            'transaction_amount'    => $transaction_amount,
        );

        $output = $this->response->setCachedResponse(200, $result, 'Success', 'report');
        $this->api->trackResponse($output);
        return;
    }

    protected function get_filters()
    {
        $statuses = [];
        $arr_status = $this->getStatuses();
        foreach ($arr_status as $stat) {
            $statuses[] = array(
                "code"  => $stat['code'],
                "name"  => $stat['name'],
            );
        }

        $result = array(
            "status"    => $statuses
        );

        $output = $this->response->setCachedResponse(200, $result, 'Success', 'report');
        $this->api->trackResponse($output);
        return;
    }

    private function getStatuses()
    {
        $data = [];
        if ($this->session->data['language_id'] == '1') {
            $data = [
                "ALL" => array(
                    'code' => 'ALL',
                    'name' => 'ALL',
                    'color' => null,
                ),
                "TO_PAY" => array(
                    'code' => 'TO_PAY',
                    'name' => 'To Pay',
                    'color' => '#D1D1D1',
                ),
                "TO_SHIP" => array(
                    'code' => 'TO_SHIP',
                    'name' => 'To Ship',
                    'color' => '#F38733',
                ),
                "TO_RECEIVE" => array(
                    'code' => 'TO_RECEIVE',
                    'name' => 'To Receive',
                    'color' => '#FF78BB',
                ),
                "COMPLETED" => array(
                    'code' => 'COMPLETED',
                    'name' => 'Completed',
                    'color' => '#8FBB6C',
                ),
                "CANCELLED" => array(
                    'code' => 'CANCELLED',
                    'name' => 'Cancelled',
                    'color' => '#F56B6B',
                ),
            ];
        } else {
            $data = [
                "ALL" => array(
                    'code' => 'ALL',
                    'name' => '全部',
                    'color' => null,
                ),
                "TO_PAY" => array(
                    'code' => 'TO_PAY',
                    'name' => '待付款',
                    'color' => '#D1D1D1',
                ),
                "TO_SHIP" => array(
                    'code' => 'TO_SHIP',
                    'name' => '待出货',
                    'color' => '#F38733',
                ),
                "TO_RECEIVE" => array(
                    'code' => 'TO_RECEIVE',
                    'name' => '待收货',
                    'color' => '#FF78BB',
                ),
                "COMPLETED" => array(
                    'code' => 'COMPLETED',
                    'name' => '已完成',
                    'color' => '#8FBB6C',
                ),
                "CANCELLED" => array(
                    'code' => 'CANCELLED',
                    'name' => '已取消',
                    'color' => '#F56B6B',
                ),
            ];
        }
        return $data;
    }
}
