<?php

class ControllerAndroidProductProduct extends Controller
{
    private $json;
    private $model_name;
    private $error;

    public function index()
    {
        //load required model
        $this->load->model('android/product/product');

        $this->model_name = $this->model_android_product_product;
        require DIR_SYSTEM . "/library/start_api.php";
    }

    protected function get_list()
    {
        $filter_search = !empty($this->request->get['keyword']) ? trim($this->request->get['keyword']) : null;

        $min_sell_price = !empty($this->request->get['min_sell_price']) ? $this->request->get['min_sell_price'] : null;
        $max_sell_price = !empty($this->request->get['max_sell_price']) ? $this->request->get['max_sell_price'] : null;

        $sort_by = !empty($this->request->get['sort_by']) ? strtolower($this->request->get['sort_by']) : null;
        $sort_direction = !empty($this->request->get['sort_direction']) ? strtoupper($this->request->get['sort_direction']) : null;

        $page = !empty($this->request->get['page']) ? $this->request->get['page'] : 1;
        $show = !empty($this->request->get['show']) ? $this->request->get['show'] : 10;

        $filters = array(
            "filter_search"     => $filter_search,
            "min_sell_price"    => $min_sell_price,
            "max_sell_price"    => $max_sell_price,
            "sort_by"           => $sort_by,
            "sort_direction"    => $sort_direction,
            "start"             => ($page - 1) * $show,
            "limit"             => $show
        );

        $products = $this->model_name->getProducts($filters);

        if (!empty($products)) {
            $results = array();
            $this->load->model('tool/image');
            foreach ($products as $product) {
                $price = $this->currency->format($product['price'], $this->config->get('config_currency'));

                $image = $product['image'];
                if (is_file(DIR_IMAGE . $image)) {
                    $image = $this->model_tool_image->resize($image, 120, 120);
                } else {
                    $image = $this->model_tool_image->resize('no_image.png', 120, 120);
                }

                $results[] = array(
                    "product_id"    => $product['product_id'],
                    "image"         => $image,
                    "code"          => $product['code'],
                    "en_name"       => $product['en_name'],
                    "cn_name"       => $product['cn_name'],
                    "category"      => $product['category_name'],
                    "price"         => $price,
                );
            }
            $output = $this->response->setCachedResponse(200, $results, "Get list success", "products");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setCachedResponse(204, array(), 'No result', 'products');
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_detail()
    {
        $product_id = !empty($this->request->get['product_id']) ? $this->request->get['product_id'] : false;
        if ($product_id) {
            $product_info = $this->model_name->getProduct($product_id);
            if (!empty($product_info)) {
                $this->load->model('tool/image');
                $image = $product_info['image'];
                if (is_file(DIR_IMAGE . $image)) {
                    $image = $this->model_tool_image->resize($image, 480, 480);
                } else {
                    $image = null;
                }
                $result = array(
                    "product_id"    => $product_info['product_id'],
                    "image"         => $image,
                    "en_name"       => $product_info['en_name'],
                    "cn_name"       => $product_info['cn_name'],
                    "model"         => $product_info['model'],
                    "code"          => $product_info['code'],
                    "price"         => $product_info['price'],
                    "cost_price"    => $product_info['costprice'],
                    "tax_class_id"  => $product_info['tax_class_id'],
                    "weight"        => (string)($product_info['weight'] + 0),
                    "weight_class_id"   => $product_info['weight_class_id'],
                    "status"        => (bool)$product_info['internal_status'],
                    "pos_selling"   => (bool)$product_info['selling_product'],
                );

                $output = $this->response->setCachedResponse(200, $result, "Success", "products");
                $this->api->trackResponse($output);
                return;
            } else {
                $output = $this->response->setCachedResponse(204, $this->response->noResponse(), "No result", "products");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setCachedResponse(400, $this->response->noResponse(), "product id is required", "products");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function save()
    {
        $json = $this->json;
        if (empty($json)) {
            $output = $this->response->setResponse2(400, $this->response->noResponse(), "missing json body", "products");
            $this->api->trackResponse($output);
            return;
        } else {
            if ($this->validateProductInfo($json)) {
                $product_id = !empty($json['product_id']) ? $json['product_id'] : null;
                $en_name = !empty($json['en_name']) ? $json['en_name'] : null;
                $cn_name = !empty($json['cn_name']) ? $json['cn_name'] : null;
                $model = !empty($json['model']) ? $json['model'] : null;
                $code = !empty($json['code']) ? $json['code'] : null;
                $price = !empty($json['price']) ? $json['price'] : null;
                $cost_price = !empty($json['cost_price']) ? $json['cost_price'] : null;
                $pos_selling = !empty($json['pos_selling']) ? (int)$json['pos_selling'] : null;
                $weight = !empty($json['weight']) ? $json['weight'] : null;
                $weight_class_id = !empty($json['weight_class_id']) ? $json['weight_class_id'] : null;
                $status = !empty($json['status']) ? (int)$json['status'] : null;
                $image = !empty($json['image']) ? $json['image'] : null;
                $tax_class_id = !empty($json['tax_class_id']) ? $json['tax_class_id'] : null;


                if ($product_id) {
                    //edit
                    $data = array(
                        "product_id"        => $product_id,
                        "en_name"           => $en_name,
                        "cn_name"           => $cn_name,
                        "model"             => $model,
                        "code"              => $code,
                        "sellingprice"      => $price,
                        "costprice"         => $cost_price,
                        "pos_selling"       => $pos_selling,
                        "weight"            => $weight,
                        "weight_class_id"   => $weight_class_id,
                        "internal_status"   => $status,
                        "tax_class_id"      => $tax_class_id
                    );
                    $product_id = $this->model_name->editProduct($data);
                } else {
                    //add new
                    $en_name = trim($json['en_name']);
                    $cn_name = !empty($cn_name) ? trim($cn_name) : $en_name;

                    $product_desc[1]['name'] = $en_name;
                    $product_desc[2]['name'] = $cn_name;

                    //stores
                    $this->load->model('setting/store');
                    $stores = $this->model_setting_store->getStores();
                    $all_store_ids[] = 0;
                    foreach ($stores as $store) {
                        $all_store_ids[] = $store['store_id'];
                    }

                    $data = array(
                        "model"             => $model,
                        "code"              => $code,
                        "quantity"          => 1,
                        "minimum"           => 1,
                        "subtract"          => 1,
                        "shipping"          => 1,
                        "sellingprice"      => $price,
                        "costprice"         => $cost_price,
                        "pos_selling"       => $pos_selling,
                        "product_type"      => 1,
                        "weight"            => $weight,
                        "weight_class_id"   => $weight_class_id,
                        "length_class_id"   => $this->config->get('config_length_class_id'),
                        "status"            => 0,
                        "internal_status"   => $status,
                        "tax_class_id"      => $tax_class_id,
                        "product_desc"      => $product_desc,
                        "product_store"     => $all_store_ids
                    );
                    $product_id = $this->model_name->addProduct($data);
                }



                if ($product_id) {

                    //upload image
                    if (!empty($image)) {
                        $product_info = $this->model_name->getProduct($product_id);
                        if (!empty($product_info)) {
                            $img_url = '';
                            $ori_img_path = !empty($product_info['image']) ? DIR_IMAGE . $product_info['image'] : null;
                            $folder_name = "catalog/products/";
                            $dest_folder_path = DIR_IMAGE . $folder_name;
                            //create folder if not exists
                            if (!file_exists($dest_folder_path)) {
                                mkdir($dest_folder_path, 0777, true);
                            }

                            $img_decode = base64_decode($image);
                            $info = getimagesizefromstring($img_decode);
                            $ext = str_replace('image/', '.', $info['mime']);
                            $dest_name = str_replace(' ', '_', $product_info['en_name']) . "_" . time() . strtolower($ext);

                            $dest_path = $dest_folder_path . $dest_name;

                            if (file_put_contents($dest_path, $img_decode)) {
                                $img_url = $folder_name . $dest_name;
                                $this->model_name->saveImage($product_id, $img_url);
                                if (!empty($ori_img_path) && $ori_img_path != $dest_path) {
                                    //delete previous image
                                    if (file_exists($ori_img_path)) {
                                        unlink($ori_img_path);
                                    }
                                }
                            }
                        }
                    }

                    $output = $this->response->setResponse2(200, array("product_id" => (string)$product_id), "Success", "products");
                    $this->api->trackResponse($output);
                    return;
                } else {
                    $output = $this->response->setResponse2(400, $this->response->noResponse(), "Failed to save", "products");
                    $this->api->trackResponse($output);
                    return;
                }
            } else {
                $output = $this->response->setResponse2(400, $this->response->noResponse(), $this->error, "products");
                $this->api->trackResponse($output);
                return;
            }
        }
    }

    protected function delete()
    {
        $product_id = !empty($this->json['product_id']) ? $this->json['product_id'] : false;
        if ($product_id) {
            $this->model_name->deleteProduct($product_id);
            $product_info = $this->model_name->getProduct($product_id);
            if (empty($product_info)) {
                $output = $this->response->setResponse2(200, $this->response->noResponse(), "Success", "products");
                $this->api->trackResponse($output);
                return;
            } else {
                $output = $this->response->setResponse2(400, $this->response->noResponse(), "Failed to delete", "products");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setCachedResponse(400, $this->response->noResponse(), "product id is required", "products");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function upload_image()
    {
        $json = $this->json;
        if (empty($json)) {
            $output = $this->response->setResponse2(400, array(), "missing json body", "products");
            $this->api->trackResponse($output);
            return;
        } else {
            $product_id = !empty($json['product_id']) ? $json['product_id'] : false;

            if ($product_id) {
                $product_info = $this->model_name->getProduct($product_id);
                if (!empty($product_info)) {
                    $image = !empty($json['image']) ? $json['image'] : null;
                    if (!empty($image)) {
                        $img_url = '';
                        $ori_img_path = !empty($product_info['image']) ? DIR_IMAGE . $product_info['image'] : null;
                        $folder_name = "catalog/products/";
                        $dest_folder_path = DIR_IMAGE . $folder_name;
                        //create folder if not exists
                        if (!file_exists($dest_folder_path)) {
                            mkdir($dest_folder_path, 0777, true);
                        }

                        $img_decode = base64_decode($image);
                        $info = getimagesizefromstring($img_decode);
                        $ext = str_replace('image/', '.', $info['mime']);
                        $dest_name = str_replace(' ', '_', $product_info['en_name']) . "_" . time() . strtolower($ext);

                        $dest_path = $dest_folder_path . $dest_name;

                        if (file_put_contents($dest_path, $img_decode)) {
                            $img_url = $folder_name . $dest_name;
                            $this->model_name->saveImage($product_id, $img_url);
                            if (!empty($ori_img_path) && $ori_img_path != $dest_path) {
                                //delete previous image
                                if (file_exists($ori_img_path)) {
                                    unlink($ori_img_path);
                                }
                            }
                        }

                        if ($img_url) {
                            $this->load->model('tool/image');
                            if (is_file(DIR_IMAGE . $img_url)) {
                                $img_url = $this->model_tool_image->resize($img_url, 480, 480);
                            } else {
                                $img_url = null;
                            }
                            $output = $this->response->setResponse2(200, ["image" => $img_url], "success", "products");
                            $this->api->trackResponse($output);
                            return;
                        } else {
                            $output = $this->response->setResponse2(400, $this->response->noResponse(), "failed", "products");
                            $this->api->trackResponse($output);
                            return;
                        }
                    } else {
                        $output = $this->response->setResponse2(400, $this->response->noResponse(), "no image passed", "products");
                        $this->api->trackResponse($output);
                        return;
                    }
                } else {
                    $output = $this->response->setResponse2(400, $this->response->noResponse(), "product id is invalid", "products");
                    $this->api->trackResponse($output);
                    return;
                }
            } else {
                $output = $this->response->setResponse2(400, $this->response->noResponse(), "product_id is required", "products");
                $this->api->trackResponse($output);
                return;
            }
        }
    }

    protected function delete_image()
    {
        $product_id = !empty($this->json['product_id']) ? $this->json['product_id'] : false;
        if ($product_id) {
            $product_info = $this->model_name->getProduct($product_id);
            $ori_img_path = !empty($product_info['image']) ? DIR_IMAGE . $product_info['image'] : null;

            if (!empty($ori_img_path)) {
                if (file_exists($ori_img_path)) {
                    $deleted = unlink($ori_img_path);
                } else {
                    $deleted = true;
                }
            } else {
                $deleted = true;
            }
            if ($deleted) {
                $this->model_name->deleteImage($product_id);
                $output = $this->response->setCachedResponse(200, $this->response->noResponse(), "success", "products");
                $this->api->trackResponse($output);
                return;
            } else {
                $output = $this->response->setCachedResponse(400, $this->response->noResponse(), "failed to delete", "products");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setCachedResponse(400, $this->response->noResponse(), "product id is required", "products");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_tax_classes()
    {
        $results = [];

        $tax_classes = $this->model_name->getTaxClasses();

        if (!empty($tax_classes)) {
            foreach ($tax_classes as $tax) {
                $results[] = array(
                    "id"    => $tax['tax_class_id'],
                    "name"  => $tax['title'],
                );
            }
        }

        $output = $this->response->setCachedResponse(200, $results, "Success", "products");
        $this->api->trackResponse($output);
        return;
    }

    protected function get_weight_classes()
    {
        $results = [];
        $weight_classes = $this->model_name->getWeightClasses();

        if (!empty($weight_classes)) {
            foreach ($weight_classes as $wc) {
                $results[] = array(
                    "id"    => $wc['weight_class_id'],
                    "name"  => $wc['unit']
                );
            }
        }

        $output = $this->response->setCachedResponse(200, $results, "Success", "products");
        $this->api->trackResponse($output);
        return;
    }

    private function validateProductInfo($data)
    {
        $this->error = '';
        if (empty($data['en_name'])) {
            $this->error .= "Product name";
        }
        if (empty($data['code'])) {
            $this->error .= !empty($this->error) ? ", code" : "code";
        }
        if (empty($data['model'])) {
            $this->error .= !empty($this->error) ? ", model" : "model";
        }

        $this->error .= !empty($this->error) ? " is required" : "";

        return !$this->error;
    }
}
