<?php

class ControllerAndroidPrescriptionProduct extends Controller
{
    private $json;
    private $user_info;
    private $model_name;

    public function index()
    {
        //load required model
        $this->load->model('android/prescription/product');

        $this->model_name = $this->model_android_prescription_product;
        require DIR_SYSTEM . "/library/start_api.php";
    }

    protected function get_product_list()
    {
        $filter_search = (string)trim($this->request->get['filter_search']);
        $filter_search = !empty($filter_search) ? $filter_search : null;

        if (isset($this->request->get['filter_categories']) && trim($this->request->get['filter_categories']) != '') {
            //handle chinese comma
            $filter_categories = $this->request->get['filter_categories'];
            $filter_categories =  explode(",", $filter_categories);
        } else {
            $filter_categories = array();
        }

        $filter_categories = array_filter(array_map('trim', $filter_categories));


        $page = !empty($this->request->get['page']) ? $this->request->get['page'] : 1;
        $show = !empty($this->request->get['show']) ? $this->request->get['show'] : 10;

        $filters = array(
            "filter_search"     => $filter_search,
            "filter_categories" => $filter_categories,
            "start"             => ($page - 1) * $show,
            "limit"             => $show
        );

        $products = $this->model_name->getProductList($filters);

        if (!empty($products)) {
            $results = array();
            // $this->load->model('tool/image');
            $no_stock_text = $this->session->data['language_id'] == 1 ? " Out of stock" : " 缺货";
            foreach ($products as $product) {
                // $image = $product['image'];
                // if (is_file(DIR_IMAGE . $image)) {
                //     $image = $this->model_tool_image->resize($image, 120, 120);
                // } else {
                //     $image = $this->model_tool_image->resize('no_image.png', 120, 120);
                // }
                $got_stock = $product['stock_qty'] > 0 ? true : false;
                $label = $product['label'];
                $label .= $got_stock ? '' : $no_stock_text;
                $results[] = array(
                    "id" => $product['id'],
                    // "label" => $product['label'],
                    "label" => $label,
                    // "image" => $image,
                    "got_stock" => $got_stock
                );
            }
            $output = $this->response->setCachedResponse(200, $results, "Get list success", "product");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setCachedResponse(204, array(), "No result", "product");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_product_detail()
    {
        $product_id = !empty($this->request->get['product_id']) ? $this->request->get['product_id'] : false;
        if ($product_id) {
            $product_info = $this->model_name->getProduct($product_id);
            if (!empty($product_info)) {
                $output = $this->response->setCachedResponse(200, $product_info, "Success", "product");
                $this->api->trackResponse($output);
                return;
            } else {
                $output = $this->response->setCachedResponse(204, $this->response->noResponse(), "No result", "product");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setCachedResponse(400, $this->response->noResponse(), "product id is required", "product");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_categories()
    {
        $results = [];
        $categories = $this->model_name->getCategories();

        // $results[] = [
        //     "id" => "0",
        //     "name" => $this->session->data['language_id'] == 1 ? "All" : "所有"
        // ];
        if (!empty($categories)) {
            foreach ($categories as $category) {
                $results[] = array(
                    "id"    => $category['id'],
                    "name"  => strtoupper($category['name'])
                );
            }
        }
        $output = $this->response->setCachedResponse(200, $results, 'success', 'product');
        $this->api->trackResponse($output);
        return;
    }
}
