<?php

class ControllerAndroidPrescriptionPrescription extends Controller
{
    private $json;
    private $user_info;
    private $model_name;

    public function index()
    {
        //load required model
        $this->load->model('android/prescription/prescription');

        $this->model_name = $this->model_android_prescription_prescription;
        require DIR_SYSTEM . "/library/start_api.php";
    }

    protected function get_prescription_list()
    {
        $filter_search = (string)trim($this->request->get['filter_search']);
        $filter_search = !empty($filter_search) ? $filter_search : null;
        $page = !empty($this->request->get['page']) ? $this->request->get['page'] : 1;
        $show = !empty($this->request->get['show']) ? $this->request->get['show'] : 10;

        $filters = array(
            "filter_search" => $filter_search,
            "start"         => ($page - 1) * $show,
            "limit"         => $show
        );

        $results = $this->model_name->getPrescriptionList($filters);

        if (!empty($results)) {
            $output = $this->response->setCachedResponse(200, $results, "Get list success", "prescription");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setCachedResponse(204, array(), "No result", "prescription");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_prescription_detail()
    {
        $prescription_id = !empty($this->request->get['prescription_id']) ? $this->request->get['prescription_id'] : false;
        if ($prescription_id) {
            $prescription_info = $this->model_name->getPrescription($prescription_id);
            if (!empty($prescription_info)) {
                $output = $this->response->setCachedResponse(200, $prescription_info, "Success", "prescription");
                $this->api->trackResponse($output);
                return;
            } else {
                $output = $this->response->setCachedResponse(204, $this->response->noResponse(), "No result", "prescription");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setCachedResponse(400, $this->response->noResponse(), "prescription id is required", "prescription");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_consume_methods()
    {
        $methods = $this->model_name->getConsumeMethods();
        $output = $this->response->setCachedResponse(200, $methods, "Get List success", "prescription");
        $this->api->trackResponse($output);
        return;
    }

    protected function get_take_types()
    {
        $types = $this->model_name->getTakeTypes();
        $output = $this->response->setCachedResponse(200, $types, "Get List success", "prescription");
        $this->api->trackResponse($output);
        return;
    }

    protected function get_herb_services()
    {
        $result = array();
        $types = $this->model_name->getHerbServiceTypes();

        if (!empty($types)) {
            foreach ($types as $type) {
                $result[] = array(
                    "type" => $type['type'],
                    "name" => $type['name'],
                );
            }
            $output = $this->response->setCachedResponse(204, $result, "Success", "prescription");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setCachedResponse(204, $result, "No result", "prescription");
            $this->api->trackResponse($output);
            return;
        }
    }
}
