<?php

class ControllerAndroidPrescriptionMedicine extends Controller
{
    private $model_name;

    private $etcm_categories = [
        // array(
        //     "id" => "E_HERBS",
        //     "cn_name" => "ETCM中药汤剂",
        //     "en_name" => "ETCM Herbs",
        // ),
        // array(
        //     "id" => "E_NGP",
        //     "cn_name" => "ETCM 配方颗粒",
        //     "en_name" => "ETCM NGP Granule"
        // )
    ];
    public function index()
    {
        //load required model
        $this->load->model('android/prescription/medicine');

        $this->model_name = $this->model_android_prescription_medicine;
        require DIR_SYSTEM . "/library/start_api.php";
    }

    //get list of product and prescriptions
    protected function get_items()
    {
        $filter_search = !empty($this->request->get['filter_search']) ? $this->request->get['filter_search'] : null;
        $filter_search = (string)trim($filter_search);

        $category_id = !empty($this->request->get['category_id']) ? $this->request->get['category_id'] : null;
        $dispense_code = !empty($this->request->get['dispense_code']) ? $this->request->get['dispense_code'] : null;
        $type = !empty($this->request->get['type']) ? $this->request->get['type'] : null;


        $page = !empty($this->request->get['page']) ? $this->request->get['page'] : 1;
        $show = !empty($this->request->get['show']) ? $this->request->get['show'] : 10;

        $filters = array(
            "filter_search"     => $filter_search,
            "type"              => $type,
            "filter_categories" => $category_id,
            "dispense_code"     => $dispense_code,
            "start"             => ($page - 1) * $show,
            "limit"             => $show
        );

        $items = $this->model_name->getItems($filters);

        if (!empty($items)) {
            $results = array();
            foreach ($items as $item) {
                $label = $item['label'];
                $results[] = array(
                    "id" => $item['id'],
                    "label" => $label,
                    "type" => $item['type'],
                    "price" => $this->currency->format($item['price']),
                );
            }
            $output = $this->response->setCachedResponse(200, $results, "Get list success", "prescription");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setCachedResponse(204, array(), "No result", "prescription");
            $this->api->trackResponse($output);
            return;
        }
    }

    //get product categories
    protected function get_categories()
    {
        $results = [];
        if (!empty($this->etcm_categories)) {
            foreach ($this->etcm_categories as $cat) {
                $results[] = array(
                    "id"    => $cat['id'],
                    "name"  => $this->session->data['language_id'] == '1' ? $cat['en_name'] : $cat['cn_name']
                );
            }
        }
        $categories = $this->model_name->getCategories();

        if (!empty($categories)) {
            $display_categories = $this->config->get('config_herbal_categories');
            foreach ($categories as $category) {
                if (!empty($display_categories)) {
                    $display = in_array($category['id'], $display_categories) ? true : false;
                } else {
                    $display = true;
                }
                if ($display) {
                    $results[] = array(
                        "id"    =>  $category['id'],
                        "name"  =>  strtoupper($category['name'])
                    );
                }
            }
        }
        $output = $this->response->setCachedResponse(200, $results, 'success', 'prescription');
        $this->api->trackResponse($output);
        return;
    }

    //get consume method
    protected function get_consume_methods()
    {
        $results = [];

        $methods = $this->model_name->getConsumeMethods();

        if (!empty($methods)) {
            foreach ($methods as $method) {
                $results[] = array(
                    "id"    => $method['cook_type_id'],
                    "name"  => $method['name'],
                );
            }
        }

        $output = $this->response->setCachedResponse(200, $results, "Get List success", "prescription");
        $this->api->trackResponse($output);
        return;
    }

    //get take type
    protected function get_take_types()
    {
        $results = [];
        $types = $this->model_name->getTakeTypes();
        if (!empty($types)) {
            foreach ($types as $type) {
                $results[] = array(
                    "id"    => $type['taketype_id'],
                    "name"  => $type['name'],
                );
            }
        }

        $output = $this->response->setCachedResponse(200, $results, "Get List success", "prescription");
        $this->api->trackResponse($output);
        return;
    }

    //get medication dispense
    protected function get_medication_dispense()
    {
        $results = array();
        $category_id = !empty($this->request->get['category_id']) ? $this->request->get['category_id'] : null;

        $product_type = strtolower($this->model_name->getProductTypeByCategoryId($category_id));


        $herbs_dispense_code = [
            'SELF_HERBS',
            'SELF_BREWING',
            'DECOCTION_BY_PARTNER',
            'HERBS',
        ];
        $granule_dispense_code = [
            'SELF_GRANULE',
            'GRANULE',
        ];

        $enable_list = [];
        if ($product_type == 'herbs') {
            $enable_list = $herbs_dispense_code;
        }
        if ($product_type == 'granule') {
            $enable_list = $granule_dispense_code;
        }


        $parent_types = $this->model_name->getMedicationDispenses();

        if (!empty($parent_types)) {
            $selected_child = false;
            foreach ($parent_types as $row) {
                $msg = null;

                $enable_parent = false;
                if ($row['dispense_code'] == 'ETCM') {
                    if (in_array($category_id, array_column($this->etcm_categories, 'id'))) {
                        $enable_parent = true;
                    } else {
                        if ($this->session->data['language_id'] == '1') {
                            $msg = "Only applies to " . implode(", ", array_column($this->etcm_categories, 'en_name')) . " category";
                        } else {
                            $msg = "您选择的药物不属于 " . implode(", ", array_column($this->etcm_categories, 'cn_name')) . " 此分类。";
                        }
                    }
                } else {
                    $enable_parent = true;
                }

                $childrens = [];
                $children_types = $this->model_name->getMedicationDispenses($row['medication_dispense_id']);
                if (!empty($children_types)) {
                    foreach ($children_types as $row_child) {
                        $enable_child = false;
                        $preselect = false;
                        if ($row['dispense_code'] != 'ETCM') {
                            $enable_child = true;
                            if (in_array($row_child['dispense_code'], $enable_list)) {
                                $preselect = !$selected_child;
                                $selected_child = true;
                            }
                        } else {
                            if (!empty($enable_list)) {
                                if (in_array($row_child['dispense_code'], $enable_list)) {
                                    $enable_child = true;
                                    $preselect = !$selected_child;
                                    $selected_child = true;
                                }
                            } else {
                                $enable_child = true;
                                $preselect = !$selected_child;
                                $selected_child = true;
                            }
                        }
                        $childrens[] = array(
                            "code" => $row_child['dispense_code'],
                            "name" => $row_child['name'],
                            "enable" => $enable_child && $enable_parent,
                            "preselect" => $preselect
                        );
                    }
                }

                $results[] = array(
                    "code" => $row['dispense_code'],
                    "name" => $row['name'],
                    "enable" => $enable_parent,
                    "message" => $msg,
                    "children" => $childrens
                );
            }
        }

        $output = $this->response->setCachedResponse(204, $results, "Success", "prescription");
        $this->api->trackResponse($output);
        return;
    }

    //get day_time selection_list
    protected function get_time_day_selection_list()
    {
        $category_id = !empty($this->request->get['category_id']) ? $this->request->get['category_id'] : null;
        $results['day'] = [];
        $results['time'] = [];
        $product_type = strtolower($this->model_name->getProductTypeByCategoryId($category_id));


        if ($product_type == 'granule') {
            $results['day'] = [2];
            for ($i = 1; $i <= 30; $i++) {
                $results['time'][] = $i * 3;
            }
        }

        $output = $this->response->setCachedResponse(204, $results, "Success", "prescription");
        $this->api->trackResponse($output);
        return;
    }

    protected function save_prescription()
    {
        $json = $this->json;
        if (empty($json)) {
            $output = $this->response->setResponse2(400, new stdClass(), "missing json body", "prescription");
            $this->api->trackResponse($output);
            return;
        }

        $name = !empty($json['name']) ? trim($json['name']) : '';
        if (empty($name) || empty($json['items']) || empty($json['code'])) {
            $output = $this->response->setResponse2(400, new stdClass(), "name, code, items required", "prescription");
            $this->api->trackResponse($output);
            return;
        }

        if ($this->model_name->savePrescription($json)) {
            $output = $this->response->setResponse2(200, new stdClass(), "Success", "prescription");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setResponse2(400, new stdClass(), "Failed to save", "prescription");
            $this->api->trackResponse($output);
            return;
        }
    }

    #region private function

    #endregion
}
