<?php

class ControllerAndroidMedicalRecordMedicalRecord extends Controller
{
    private $json;
    private $user_info;
    private $model_name;
    private $notice;
    private $warning;
    private $opencart_version = 3;

    private $date_type = [
        array(
            "type" => "TODAY",
            "en_name" => "Today",
            "cn_name" => "今天"
        ),
        array(
            "type" => "YESTERDAY",
            "en_name" => "Yesterday",
            "cn_name" => "昨天"
        ),
        array(
            "type" => "THIS_WEEK",
            "en_name" => "This Week",
            "cn_name" => "这个星期"
        ),
        array(
            "type" => "THIS_MONTH",
            "en_name" => "This Month",
            "cn_name" => "这个月"
        ),
        array(
            "type" => "THIS_YEAR",
            "en_name" => "This Year",
            "cn_name" => "今年"
        ),
    ];

    private $etcm_categories = [
        // array(
        //     "id" => "E_HERBS",
        //     "cn_name" => "ETCM 中药汤剂",
        //     "en_name" => "ETCM Herbs",
        // ),
        // array(
        //     "id" => "E_NGP",
        //     "cn_name" => "ETCM 配方颗粒",
        //     "en_name" => "ETCM NGP Granule"
        // )
    ];

    private $dosage_unit_en = [
        'SELF_HERBS'    => '',
        'SELF_BREWING'  => 'ml',
        'SELF_GRANULE'  => 'potion',
        'DECOCTION_BY_PARTNER'  => 'ml',
        'HERBS' => '',
        'GRANULE'   => 'potion',
    ];

    private $dosage_unit_cn = [
        'SELF_HERBS'    => '',
        'SELF_BREWING'  => '毫升',
        'SELF_GRANULE'  => '格',
        'DECOCTION_BY_PARTNER'  => '毫升',
        'HERBS' => '',
        'GRANULE'   => '格',
    ];

    public function index()
    {
        //cart library
        $this->load->library('medical_record_cart');
        $this->cart = new medical_record_cart($this->registry);

        //tax
        $this->load->library('tax');
        $this->tax = new Tax($this->registry);

        //load required model
        $this->load->model('android/medical_record/medical_record');

        $this->model_name = $this->model_android_medical_record_medical_record;
        require DIR_SYSTEM . "/library/start_api.php";
    }

    protected function get_filters()
    {
        if ($this->session->data['language_id'] == '1') {
            $gender = array(
                array(
                    "id" => "1",
                    "name" => "Male"
                ),
                array(
                    "id" => "2",
                    "name" => "Female"
                )
            );
        } else {
            $gender = array(
                array(
                    "id" => "1",
                    "name" => "男性"
                ),
                array(
                    "id" => "2",
                    "name" => "女性"
                )
            );
        }
        $status = array();
        $order_status = $this->model_name->getOrderStatuses();
        $arr_stat_used = ['1', '5'];
        foreach ($order_status as $row) {
            if (in_array($row['order_status_id'], $arr_stat_used))
                $status[] = array(
                    "id" => $row['order_status_id'],
                    "name" => $row['name'],
                );
        }

        $date_filter = [];
        foreach ($this->date_type as $item) {
            $date_filter[] = array(
                "id" => $item['type'],
                "name" => $this->session->data['language_id'] == '1' ? $item['en_name'] : $item['cn_name']
            );
        }
        $filters = array(
            "gender" => $gender,
            "status" => $status,
            "date_filter" => $date_filter
        );
        $output = $this->response->setCachedResponse(200, $filters, "Success", "medical_record");
        $this->api->trackResponse($output);
        return;
    }

    protected function get_list()
    {
        $customer_id = !empty($this->request->get['customer_id']) ? $this->request->get['customer_id'] : false;
        $status_id = !empty($this->request->get['status_id']) ? $this->request->get['status_id'] : false;
        $gender = !empty($this->request->get['gender']) ? $this->request->get['gender'] : false;
        $dob = !empty($this->request->get['dob']) ? $this->request->get['dob'] : false;
        $doc_no_start = !empty($this->request->get['doc_no_start']) ? $this->request->get['doc_no_start'] : false;
        $doc_no_end = !empty($this->request->get['doc_no_end']) ? $this->request->get['doc_no_end'] : false;
        $name = !empty($this->request->get['name']) ? $this->request->get['name'] : false;
        $telephone = !empty($this->request->get['telephone']) ? $this->request->get['telephone'] : false;
        $ic_no = !empty($this->request->get['ic_no']) ? $this->request->get['ic_no'] : false;
        $card_no = !empty($this->request->get['card_no']) ? $this->request->get['card_no'] : false;

        $service = !empty($this->request->get['service']) ? $this->request->get['service'] : false;

        $keyword = !empty($this->request->get['keyword']) ? $this->request->get['keyword'] : null;

        $all_store = false;
        if (isset($this->request->get['all'])) {
            $all = $this->request->get['all'];
            if ($all == 'true' || $all == '0') {
                $all_store = true;
            }
        }

        //date filter function
        $date_start = !empty($this->request->get['date_start']) ? $this->request->get['date_start'] : false;
        $date_end = !empty($this->request->get['date_end']) ? $this->request->get['date_end'] : false;
        $date_filter = !empty($this->request->get['date_filter']) ? $this->request->get['date_filter'] : '';

        if (empty($date_start) && empty($date_end)) {
            $date_type = !empty($date_filter) ? $date_filter : null;

            $today = strtotime('today');
            $yesterday = strtotime('yesterday');
            switch ($date_type) {
                case "THIS_YEAR":
                    $date_start = date('Y-01-01');
                    $date_end = date('Y-12-31');
                    break;
                case "THIS_MONTH":
                    $date_start = date('Y-m-01');
                    $date_end = date('Y-m-t');
                    break;
                case "THIS_WEEK":
                    $date_start = date('N', $today) == 1 ? date('Y-m-d', $today) : date('Y-m-d', strtotime('last monday', $today));
                    $date_end = date('N', $today) == 7 ? date('Y-m-d', $today) : date('Y-m-d', strtotime('next sunday', $today));
                    break;
                case "YESTERDAY":
                    $date_start = date('Y-m-d', $yesterday);
                    $date_end = date('Y-m-d', $yesterday);
                    break;
                case "TODAY":
                    $date_start = date('Y-m-d');
                    $date_end = date('Y-m-d');
                    break;
                default:
                    $date_start = '';
                    $date_end = '';
            }
        }

        $page = !empty($this->request->get['page']) ? $this->request->get['page'] : 1;
        $show = !empty($this->request->get['show']) ? $this->request->get['show'] : 10;

        $filters = array(
            "keyword"       => trim($keyword),
            "customer_id"   => $customer_id,
            "status_id"     => $status_id,
            "gender"        => $gender,
            "dob"           => $dob,
            "doc_no_start"  => $doc_no_start,
            "doc_no_end"    => $doc_no_end,
            "date_start"    => $date_start,
            "date_end"      => $date_end,
            "name"          => $name,
            "telephone"     => $telephone,
            "ic_no"         => $ic_no,
            "card_no"       => $card_no,
            "all_store"     => $all_store,
            "service"       => $service,
            "start"         => ($page - 1) * $show,
            "limit"         => $show
        );

        $medical_records = $this->model_name->getMedicalRecords($filters);
        $total_medical_records = (int)$this->model_name->getTotalMedicalRecords($filters);
        $results = array();
        foreach ($medical_records as $record) {
            $prescriptions = $this->model_name->getPrescriptionSummary($record['clinical_sale_id']);
            $services = $this->model_name->getServices($record['clinical_sale_id']);
            $images = $this->model_name->getImages($record['clinical_sale_id']);

            //customer info summary
            //Customer Name, IC, Phone, Gender, Age, 
            $customer_info = $this->model_name->getCustomer($record['customer_id']);

            if (!empty($customer_info)) {
                //calculate age
                $age = '0';
                if ($customer_info['dob'] != '0000-00-00') {
                    $date = new DateTime($customer_info['dob']);
                    $now = new DateTime();
                    $interval = $now->diff($date);
                    $age = $interval->y;
                }
                $customer_name          = trim($customer_info['firstname'] . " " . $customer_info['lastname']);
                $customer_ic   = $customer_info['customer_ic'];
                $customer_telephone1    = $customer_info['telephone'];
                $customer_gender_id     = empty($customer_info['gender']) ? null : $customer_info['gender'];
                $customer_age           = "$age";
            } else {
                $customer_name = null;
                $customer_ic = null;
                $customer_telephone1 = null;
                $customer_gender_id = null;
                $customer_age = null;
            }


            $results[] = array(
                'customer_name' => $customer_name,
                'customer_ic' => $customer_ic,
                'telephone1' => $customer_telephone1,
                'gender_id' => $customer_gender_id,
                'age' => $customer_age,
                'clinical_sale_id' => $record['clinical_sale_id'],
                'doc_no' => $record['invoice_prefix'],
                'status' => $record['status'],
                'payment_status' => $record['payment_status'],
                'date' => $record['sales_date'],
                'store' => htmlspecialchars_decode($record['store']),
                'doctor' => $record['doctor'],
                'price' => $this->currency->format($record['total'], $this->config->get('config_currency')),
                'diagnostic' => $record['diagnostic'],
                'prescriptions' => !empty($prescriptions) ? $prescriptions : array(),
                'services' => !empty($services) ? array_column($services, 'servicename') : array(),
                'images' => array_map(function ($url) {
                    return HTTPS_HERBAL_IMAGE . str_replace(' ', '%20', $url);
                }, array_column($images, 'image')),
            );
        }

        if (!empty($results)) {
            // $output = $this->response->setCachedResponse(200, $results, "Get list success", "medical_record");
            $output = $this->response->setCachedResponse(200, array("total" => $total_medical_records, "result" => $results), "Get list success", "medical_record");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setCachedResponse(204, array("total" => $total_medical_records, "result" => $results), "No result", "medical_record");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_info()
    {
        $clinical_sale_id = !empty($this->request->get['medical_record_id']) ? $this->request->get['medical_record_id'] : false;
        if ($clinical_sale_id) {

            $result = $this->getInfo($clinical_sale_id);
            if (!empty($result)) {
                $output = $this->response->setCachedResponse(200, $result, "success", "medical_record");
                $this->api->trackResponse($output);
                return;
            } else {
                $output = $this->response->setCachedResponse(204, new stdClass(), "No Result", "medical_record");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setCachedResponse(400, new stdClass(), "medical_record_id required", "medical_record");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_form()
    {
        $clinical_sale_id = !empty($this->request->get['medical_record_id']) ? $this->request->get['medical_record_id'] : false;
        if ($clinical_sale_id) {

            $result = $this->getForm($clinical_sale_id);
            if (!empty($result)) {
                $output = $this->response->setCachedResponse(200, $result, "success", "medical_record");
                $this->api->trackResponse($output);
                return;
            } else {
                $output = $this->response->setCachedResponse(204, new stdClass(), "No Result", "medical_record");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setCachedResponse(400, new stdClass(), "medical_record_id required", "medical_record");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function add_images()
    {
        $json = $this->json;
        if (empty($json)) {
            $output = $this->response->setResponse2(400, array(), "missing json body", "medical_record");
            $this->api->trackResponse($output);
            return;
        } else {
            $medical_record_id = !empty($json['medical_record_id']) ? $json['medical_record_id'] : false;
            if ($medical_record_id) {
                $images = !empty($json['images']) ? $json['images'] : array();
                if (!empty($images)) {
                    $result = array();

                    //get medical_record info
                    $medical_record_info = $this->model_name->getClinicalSale($medical_record_id);
                    //get customer info
                    $customer_info = $this->model_name->getCustomer($medical_record_info['customer_id']);

                    if (!empty($customer_info)) {
                        $customer_id = $customer_info['customer_id'];
                        $customer_ic = $customer_info['customer_ic'];
                        $customer_name = trim($customer_info['firstname'] . "_" . $customer_info['lastname']);
                        $customer_name = str_replace(' ', '_', $customer_name);

                        $doc_no = $medical_record_info['invoice_prefix'];
                        $doc_no = str_replace(' ', '_', $doc_no);

                        //create img dir if not exists
                        $folder_name = "$customer_id" . "_" . "$customer_name/";
                        // $doc_no"."_".$medical_record_info['sales_date']."_".;
                        $dest_folder_path = DIR_HERBAL . $folder_name;
                        if (!file_exists($dest_folder_path)) {
                            mkdir($dest_folder_path, 0777, true);
                        }
                        $file_no = 0;
                        $success_upload = 0;
                        $limit_upload = 3;
                        foreach ($images as $image_data) {
                            if ($success_upload >= $limit_upload) continue;
                            $image_id = 0;
                            $full_image_path = '';
                            $category_id = !empty($image_data['category_id']) ? $image_data['category_id'] : 0;
                            $remark = !empty($image_data['remark']) ? $image_data['remark'] : '';
                            $img_str = !empty($image_data['image']) ? $image_data['image'] : false;
                            if ($img_str) {
                                $img_decode = base64_decode($img_str);

                                $info = getimagesizefromstring($img_decode);
                                $ext = str_replace('image/', '.', $info['mime']);

                                $dest_name = '';
                                do {
                                    $file_no++;
                                    $dest_name = $doc_no . "_" . $medical_record_info['sales_date'] . "_" . $file_no . strtolower($ext);
                                    $image_exist = $this->model_name->checkImageUploaded($dest_name);
                                } while ($image_exist);

                                $dest_path = $dest_folder_path . $dest_name;

                                if (file_put_contents($dest_path, $img_decode)) {
                                    $img_url = $folder_name . $dest_name;
                                    $data = array(
                                        "category_id" => $category_id,
                                        "clinical_sale_id" => $medical_record_id,
                                        "customer_ic" => $customer_ic,
                                        "remark" => $remark,
                                        "image" => $img_url
                                    );
                                    $image_id = $this->model_name->addClinicalSaleImage($data);
                                    if (empty($image_id)) {
                                        unlink($dest_path);
                                    } else {
                                        $full_image_path = HTTPS_HERBAL_IMAGE . $img_url;
                                    }
                                }
                            }
                            if ($full_image_path != '') {
                                $success_upload = $success_upload + 1;
                            }
                            $result[] = array('image_id' => $image_id, "url" => $full_image_path);
                        }
                        $output = $this->response->setResponse2(200, $result, "success", "medical_record");
                        $this->api->trackResponse($output);
                        return;
                    } else {
                        $output = $this->response->setResponse2(400, array(), "medical_record is invalid", "medical_record");
                        $this->api->trackResponse($output);
                        return;
                    }
                } else {
                    $output = $this->response->setResponse2(204, array(), "no image passed", "medical_record");
                    $this->api->trackResponse($output);
                    return;
                }
            } else {
                $output = $this->response->setResponse2(400, array(), "medical_record_id is required", "medical_record");
                $this->api->trackResponse($output);
                return;
            }
        }
    }

    protected function delete_images()
    {
        $json = $this->json;
        if (empty($json)) {
            $output = $this->response->setResponse2(400, new stdClass(), "missing json body", "medical_record");
            $this->api->trackResponse($output);
            return;
        } else {
            $images = !empty($json['images']) ? $json['images'] : false;
            if ($images) {
                $deleted_image = 0;
                foreach ($images as $img_id) {
                    $image_info = $this->model_name->getClinicalSaleImage($img_id);
                    if (!empty($image_info)) {
                        $image_path = DIR_HERBAL . $image_info['image'];
                        if (file_exists($image_path)) { //check if file exist
                            if (!is_dir($image_path)) { //check if it's a file not dir
                                if (unlink($image_path)) { //check if success delete
                                    //delete from db
                                    $this->model_name->deleteClinicalSaleImage($img_id);
                                    $deleted_image++;
                                }
                            }
                        } else {
                            //delete from db if file already didnt exist in server
                            $this->model_name->deleteClinicalSaleImage($img_id);
                            $deleted_image++;
                        }
                    }
                }

                if ($deleted_image) {
                    $output = $this->response->setResponse2(200, new stdClass(), "$deleted_image image(s) deleted", "medical_record");
                    $this->api->trackResponse($output);
                    return;
                } else {
                    $output = $this->response->setResponse2(204, new stdClass(), "No image was deleted", "medical_record");
                    $this->api->trackResponse($output);
                    return;
                }
            } else {
                $output = $this->response->setResponse2(400, new stdClass(), "missing parameter", "medical_record");
                $this->api->trackResponse($output);
                return;
            }
        }
    }

    protected function save()
    {
        $json = $this->json;
        if (empty($json)) {
            $output = $this->response->setResponse2(400, new stdClass(), "missing json body", "medical_record");
            $this->api->trackResponse($output);
            return;
        }

        $medical_record_id      = !empty($json['medical_record_id']) ? $json['medical_record_id'] : false;
        $shipping_address_id    = !empty($json['shipping_address_id']) ? $json['shipping_address_id'] : false;
        $customer_id            = !empty($json['customer']['customer_id']) ? $json['customer']['customer_id'] : false;
        $doctor_id              = !empty($json['doctor_id']) ? $json['doctor_id'] : false;
        //diagnostic info
        $diagnostic         = !empty($json['diagnostics']['diagnostic']) ? $json['diagnostics']['diagnostic'] : '';
        $doctor_advice      = !empty($json['diagnostics']['doctor_advice']) ? $json['diagnostics']['doctor_advice'] : '';
        $pulse              = !empty($json['diagnostics']['pulse']) ? $json['diagnostics']['pulse'] : '';
        $disease            = !empty($json['diagnostics']['disease']) ? $json['diagnostics']['disease'] : '';
        $treatment          = !empty($json['diagnostics']['treatment']) ? $json['diagnostics']['treatment'] : '';
        $acupuncture        = !empty($json['diagnostics']['acupuncture']) ? $json['diagnostics']['acupuncture'] : '';
        $symptom            = !empty($json['diagnostics']['symptom']) ? $json['diagnostics']['symptom'] : '';
        $remark             = !empty($json['diagnostics']['remark']) ? $json['diagnostics']['remark'] : '';
        $service_type       = !empty($json['service_type']) ? $json['service_type'] : 0;
        $herb_service_type  = !empty($json['herb_service_type']) ? $json['herb_service_type'] : '';
        $herb_service_type  = $service_type == '0' ? $herb_service_type : '';
        $delete_images      = !empty($json['delete_images']) ? $json['delete_images'] : array();
        // $service_json       = !empty($json['prescriptions']['services']) ? $json['prescriptions']['services'] : array();
        // $prescription_json  = !empty($json['prescriptions']['prescription']) ? $json['prescriptions']['prescription'] : array();

        //price
        $consultation_fee           = !empty($json['consultation_fee']) ? $json['consultation_fee'] : 0;
        $collect_consultation_price = $consultation_fee > 0 ? 1 : 0;

        //doctor_id set to current user if doctor
        if ($this->session->data['user_info']['position'] == 2 && empty($doctor_id)) {
            $doctor_id = $this->session->data['user_id'];
        }

        // if (!empty($doctor_id)) {

        //load customer model
        $this->load->model('android/customer/customer');
        if (empty($customer_id)) {
            //add customer first
            $customer = !empty($json['customer']) ? $json['customer'] : false;
            if ($this->validateCustomerInfo($customer)) {
                //check if customer already exist
                $customer_id = $this->checkCustomerExist($customer);
                if (!$customer_id) {
                    $customer_group_id  = !empty($customer['customer_group_id']) ? trim($customer['customer_group_id']) : '';
                    $customer_card      = !empty($customer['registration_card_no']) ? trim($customer['registration_card_no']) : '';
                    $customer_ic        = !empty($customer['customer_ic']) ? trim($customer['customer_ic']) : '';
                    $firstname          = !empty($customer['name']) ? trim($customer['name']) : '';
                    $gender_id          = !empty($customer['gender_id']) ? trim($customer['gender_id']) : '';
                    $dob                = !empty($customer['dob']) ? trim($customer['dob']) : '';
                    $email              = !empty($customer['email']) ? trim($customer['email']) : '';
                    $telephone1         = !empty($customer['telephone1']) ? trim($customer['telephone1']) : '';
                    $telephone2         = !empty($customer['telephone2']) ? trim($customer['telephone2']) : '';
                    $home               = !empty($customer['home']) ? trim($customer['home']) : '';
                    $occupation         = !empty($customer['occupation']) ? trim($customer['occupation']) : '';
                    $nationality        = !empty($customer['nationality']) ? trim($customer['nationality']) : '';
                    $marital_status_id  = !empty($customer['marital_status_id']) ? trim($customer['marital_status_id']) : '';
                    $religion_id        = !empty($customer['religion_id']) ? trim($customer['religion_id']) : '';
                    $race_id            = !empty($customer['race_id']) ? trim($customer['race_id']) : '';
                    $allergic           = !empty($customer['allergic']) ? trim($customer['allergic']) : '';
                    $diagnostic_history = !empty($customer['diagnostic_history']) ? trim($customer['diagnostic_history']) : '';

                    $data = array(
                        "customer_id"       => null,
                        "customer_group_id" => $customer_group_id,
                        "customer_card"     => $customer_card,
                        "customer_ic"       => $customer_ic,
                        "firstname"         => $firstname,
                        "lastname"          => '',
                        "gender_id"         => $gender_id,
                        "dob"               => $dob,
                        "email"             => $email,
                        "telephone1"        => $telephone1,
                        "telephone2"        => $telephone2,
                        "home"              => $home,
                        "occupation"        => $occupation,
                        "nationality"       => $nationality,
                        "marital_status_id" => $marital_status_id,
                        "religion_id"       => $religion_id,
                        "race_id"           => $race_id,
                        "allergic"          => $allergic,
                        "diagnostic_history" => $diagnostic_history,
                    );
                    $customer_id = $this->model_android_customer_customer->updateCustomer($data);

                    //check address data and update
                    $addresses = !empty($customer['address']) ? $customer['address'] : array();
                    foreach ($addresses as $address) {
                        if ($this->validateAddressInfo($address)) {
                            $address_1  = !empty($address['address_1']) ? $address['address_1'] : '';
                            $address_2  = !empty($address['address_2']) ? $address['address_2'] : '';
                            $address_3  = !empty($address['address_3']) ? $address['address_3'] : '';
                            $city       = !empty($address['city']) ? $address['city'] : '';
                            $postcode   = !empty($address['post_code']) ? $address['post_code'] : '';
                            $country_id = !empty($address['country_id']) ? $address['country_id'] : '129';
                            $zone_id    = !empty($address['zone_id']) ? $address['zone_id'] : '0';
                            $default    = !empty($address['default']) ? $address['default'] : false;

                            $data = array(
                                "address_id"    => null,
                                "customer_id"   => $customer_id,
                                "firstname"     => $firstname,
                                "lastname"      => '',
                                "company"       => '',
                                "address_1"     => $address_1,
                                "address_2"     => $address_2,
                                "address_3"     => $address_3,
                                "city"          => $city,
                                "postcode"      => $postcode,
                                "country_id"    => $country_id,
                                "zone_id"       => $zone_id,
                                "default"       => $default,
                            );
                            $this->model_android_customer_customer->updateAddress($data);
                        }
                    }
                }
            } else {
                $output = $this->response->setResponse2(400, new stdClass(), "customer info not completed", "medical_record");
                $this->api->trackResponse($output);
                return;
            }
        }

        if (empty($shipping_address_id)) {
            $default_address = $this->model_android_customer_customer->getCustomerDefaultAddress($customer_id);
            if (!empty($default_address['address_id'])) {
                $shipping_address_id = $default_address['address_id'];
            }
        }

        $this->cart->clear();

        $herbal_prescription = [];
        $herbal_service = [];
        if ($medical_record_id) {
            $herbal_prescription = $this->model_name->getHerbalPrescription($medical_record_id);
            foreach ($herbal_prescription as $prescription) {
                $psp_name = !empty($prescription['name']) ? $prescription['name'] : '';
                $psp_times = !empty($prescription['times']) ? $prescription['times'] : '';
                $psp_day = !empty($prescription['day']) ? $prescription['day'] : '';
                $psp_cook = !empty($prescription['cook']) ? $prescription['cook'] : '';
                $psp_taketype = !empty($prescription['taketype']) ? $prescription['taketype'] : '';

                $psp_category_id = !empty($prescription['category_id']) ? $prescription['category_id'] : '';
                $psp_discount = !empty($prescription['discount']) ? $prescription['discount'] : '';
                $psp_dispense_code = !empty($prescription['dispense_code']) ? $prescription['dispense_code'] : '';
                $psp_daily_dosage = !empty($prescription['daily_dosage']) ? $prescription['daily_dosage'] : '';
                $psp_contraindications = !empty($prescription['contraindications']) ? $prescription['contraindications'] : '';
                $psp_usage = !empty($prescription['medication_method']) ? $prescription['medication_method'] : '';
                $psp_remark = !empty($prescription['remark']) ? $prescription['remark'] : '';


                $psp_data = array(
                    "name" => $psp_name,
                    "times" => $psp_times,
                    "day" => $psp_day,
                    "cook" => $psp_cook,
                    "taketype" => $psp_taketype,
                    "category_id" => $psp_category_id,
                    "discount" => $psp_discount,
                    "dispense_code" => $psp_dispense_code,
                    "daily_dosage" => $psp_daily_dosage,
                    "contraindications" => $psp_contraindications,
                    "usage" => $psp_usage,
                    "remark" => $psp_remark,
                );


                $herbal_product = $this->model_name->getHerbalProduct($prescription['clinical_sale_prescription_id']);

                if ($herbal_product) {
                    $key = $this->cart->addPrescription($psp_data);
                    foreach ($herbal_product as $product) {

                        $prod_data = array(
                            'key' => $key,
                            'product_id' => $product['product_id'],
                            'quantity' => $product['quantity'],
                            'times' => $product['times'],
                            'day' => $product['day'],
                            'price' => $product['price'],
                            'cook' => $product['cook'],
                            'taketype' => $product['taketype'],
                            'discount' => $product['discount'],
                            'usage' => $psp_usage,
                        );
                        $this->cart->addProduct($prod_data);
                    }
                } //end product
            }

            $herbal_service = $this->model_name->getHerbalService($medical_record_id);
            if ($herbal_service) {
                foreach ($herbal_service as $services) {
                    $this->cart->setService($services['clinicalservice_id'], $services['staffincharge'], $services['price']);
                } //loop services
            }
        }

        // if (!empty($prescription_json)) {
        //     foreach ($prescription_json as $item) {
        //         $usage = !empty($item['usage']) ? $item['usage'] : '';
        //         $key = $this->cart->addPrescription2(0, $item['name'], $item['prescription_id'], $item['times'], $item['consume_method'], $item['take_type'], $item['day'], $usage);
        //         if (!empty($item['products'])) {
        //             foreach ($item['products'] as $product) {
        //                 $this->cart->addProduct2($key, $product['product_id'], $product['quantity'], $item['times'], $item['consume_method'], $item['take_type'], $item['day'], $usage, $product['price'], $product['discount']);
        //             }
        //         } else {
        //             $output = $this->response->setResponse2(400, new stdClass(), "Products required for prescription", "medical_record");
        //             $this->api->trackResponse($output);
        //             return;
        //         }
        //     }
        // }

        // if (!empty($service_json)) {
        //     foreach ($service_json as $service) {
        //         $service_id = $service['service_id'];
        //         $staff_id = $service['doctor_id'];
        //         $service_details = $this->model_name->getServiceDetails($service_id);
        //         $price = !empty($service_details['price']) ? $service_details['price'] : 0;
        //         $this->cart->setService($service_id, $staff_id, $price);
        //     }
        // }


        if (!empty($herbal_prescription)) {
            $doctor_detail = $this->model_name->getUser($doctor_id);
            $tax_class_id = $doctor_detail['tax_class_id'];
            $tax_code = $this->tax->getClassCode($tax_class_id);


            // Herbs Totals
            $this->load->model('pos/extension');
            $total_data = array();
            $totals = array();
            $total = 0;
            $taxes = $this->cart->getTaxes();
            if ($this->opencart_version == 2) {
                // Display prices
                $sort_order = array();
                $results = $this->model_pos_extension->getExtensions('total');
                foreach ($results as $key => $value) {
                    $sort_order[$key] = $this->config->get($value['code'] . '_sort_order');
                }
                array_multisort($sort_order, SORT_ASC, $results);

                foreach ($results as $result) {

                    if ($this->config->get($result['code'] . '_status')) {
                        $this->load->model('total/' . $result['code']);
                        $this->{'model_total_' . $result['code']}->getTotal($total_data, $total, $taxes);
                    }

                    $sort_order = array();
                    foreach ($total_data as $key => $value) {
                        $sort_order[$key] = $value['sort_order'];
                    }

                    array_multisort($sort_order, SORT_ASC, $totals);
                }

                $order_total = $total_data;

                //medical totals
                $total_data_total = 0;
                $total_data_tax = 0;
                $total_data_subtotal = 0;
                foreach ($order_total as $total) {
                    if ($total['code'] == 'total') {
                        $total_data_total = $total['value'];
                    }
                    if ($total['code'] == 'tax') {
                        $total_data_tax = $total['value'];
                    }
                }

                // $medical_total_json  = !empty($json['medical_total']) ? $json['medical_total'] : $total_data_subtotal + $consultation_fee;
                $medical_total_json  = $total_data_total - $total_data_tax + $consultation_fee;

                $medical_total_data = array();
                $medical_total = 0;
                $medical_taxes = $this->tax->calculateTax($medical_total_json, $tax_class_id);
                $medical_taxes_rates = $this->cart->getDoctorTaxes($medical_total_json, $tax_class_id);
                $tax_format = $medical_taxes['format'];

                $medical_total_data[] = array(
                    'key'       => '',
                    'code'      => 'sub_total',
                    'title'     => 'Sub total',
                    'text'      => $this->currency->format($medical_taxes['net_amount'], $this->config->get('config_currency')),
                    'value'     => $medical_taxes['net_amount'],
                    'tax_code'  => '',
                    'sort_order' => $this->config->get('sub_total_sort_order')
                );

                $medical_total += $medical_taxes['net_amount'];

                foreach ($medical_taxes_rates as $key => $value) {
                    $medical_total_data[] = array(
                        'key'       => $key,
                        'code'      => 'tax',
                        'title'     => $this->tax->getRateName($key),
                        'tax_code'  => $this->tax->getRateCode($key),
                        'text'      => $this->currency->format($value, $this->config->get('config_currency')),
                        'value'     => $value,
                        'sort_order' => $this->config->get('tax_sort_order')
                    );

                    $medical_total += $value;
                }

                $medical_total_data[] = array(
                    'key'       => '',
                    'code'      => 'total',
                    'title'     => 'total',
                    'text'      => $this->currency->format(max(0, $medical_total), $this->config->get('config_currency')),
                    'tax_code'  => '',
                    'value'     => max(0, $medical_total),
                    'sort_order' => $this->config->get('total_sort_order')
                );
            } else {
                //for opencart version 3
                $total_data = array(
                    'totals'    => &$totals,
                    'taxes'     => &$taxes,
                    'total'     => &$total
                );

                // Display prices
                $sort_order = array();
                $results = $this->model_pos_extension->getExtensions('total');
                foreach ($results as $key => $value) {
                    $sort_order[$key] = $this->config->get('total_' . $value['code'] . '_sort_order');
                }
                array_multisort($sort_order, SORT_ASC, $results);

                foreach ($results as $result) {

                    if ($this->config->get('total_' . $result['code'] . '_status')) {
                        $this->load->model('extension/total/' . $result['code']);
                        $this->{'model_extension_total_' . $result['code']}->getTotal($total_data);
                    }

                    $sort_order = array();
                    foreach ($totals as $key => $value) {
                        $sort_order[$key] = $value['sort_order'];
                    }

                    array_multisort($sort_order, SORT_ASC, $totals);
                }

                $order_total = $totals;

                //medical totals
                $total_data_total = 0;
                $total_data_tax = 0;
                foreach ($total_data['totals'] as $total) {
                    if ($total['code'] == 'total') {
                        $total_data_total = $total['value'];
                    }
                    if ($total['code'] == 'tax') {
                        $total_data_tax = $total['value'];
                    }
                }

                // $medical_total_json  = !empty($json['medical_total']) ? $json['medical_total'] : $total_data_subtotal + $consultation_fee;
                // $medical_total_json  = $total_data_subtotal + $consultation_fee;
                $medical_total_json  = $total_data_total - $total_data_tax + $consultation_fee;

                $medical_total_data = array();
                $medical_total = 0;
                $medical_taxes = $this->tax->calculateTax($medical_total_json, $tax_class_id);
                $medical_taxes_rates = $this->cart->getDoctorTaxes($medical_total_json, $tax_class_id);
                $tax_format = $medical_taxes['format'];

                $medical_total_data[] = array(
                    'key'       => '',
                    'code'      => 'sub_total',
                    'title'     => 'Sub total',
                    'text'      => $this->currency->format($medical_taxes['net_amount'], $this->config->get('config_currency')),
                    'value'     => $medical_taxes['net_amount'],
                    'tax_code'  => '',
                    'sort_order' => $this->config->get('sub_total_sort_order')
                );

                $medical_total += $medical_taxes['net_amount'];

                foreach ($medical_taxes_rates as $key => $value) {
                    $medical_total_data[] = array(
                        'key'       => $key,
                        'code'      => 'tax',
                        'title'     => $this->tax->getRateName($key),
                        'tax_code'  => $this->tax->getRateCode($key),
                        'text'      => $this->currency->format($value, $this->config->get('config_currency')),
                        'value'     => $value,
                        'sort_order' => $this->config->get('tax_sort_order')
                    );

                    $medical_total += $value;
                }

                $medical_total_data[] = array(
                    'key'       => '',
                    'code'      => 'total',
                    'title'     => 'total',
                    'text'      => $this->currency->format(max(0, $medical_total), $this->config->get('config_currency')),
                    'tax_code'  => '',
                    'value'     => max(0, $medical_total),
                    'sort_order' => $this->config->get('total_sort_order')
                );
            }
            //consultation fee total
            $doctor_tax = 0;
            if ($collect_consultation_price) {
                $total_doctor_data_tax = 0;

                $doctor_taxes_rates = $this->cart->getDoctorTaxes($consultation_fee, $tax_class_id);
                foreach ($doctor_taxes_rates as $key => $value) {
                    $total_doctor_data[] = array(
                        'key' => $key,
                        'code' => 'tax',
                        'title' => $this->tax->getRateName($key),
                        'tax_code' => $this->tax->getRateCode($key),
                        'text' => $this->currency->format($value, $this->config->get('config_currency')),
                        'value' => $value,
                        'sort_order' => $this->config->get('tax_sort_order')
                    );
                }

                foreach ($total_doctor_data as $total_doctor) {
                    if ($total_doctor['code'] == 'tax') {
                        $total_doctor_data_tax = $total_doctor['value'];
                    }
                }
                $doctor_tax = $total_doctor_data_tax;
            }

            // cart item
            $arr_prescriptions = array();
            $arr_products = array();
            //start prescription
            $pres_no = 0;
            foreach ($this->cart->getPrescription() as $prescription_id => $prescription) {
                $pres_no++;
                $name = $prescription['name'];
                if ($this->session->data['language_id'] == '1') {
                    $name = "Prescription " . $pres_no;
                } else {
                    $name = "处方  " . $pres_no;
                }
                $arr_prescriptions[$prescription_id] = array(
                    'key' => $prescription['key'],
                    'id' => $prescription['id'],
                    'name' => $name,
                    'discount' => $prescription['discount'],
                    'day' => $prescription['day'],
                    'times' => $prescription['times'],
                    'cook' => $prescription['cook'],
                    'taketype' => $prescription['taketype'],
                    'quantity' => $prescription['quantity'],
                    'category_id' => $prescription['category_id'],
                    'dispense_code' => $prescription['dispense_code'],
                    'daily_dosage' => $prescription['daily_dosage'],
                    'contraindications' => $prescription['contraindications'],
                    'usage' => $prescription['usage'],
                    'remark' => $prescription['remark'],
                );

                foreach ($this->cart->getProducts($prescription_id) as $key => $products) {

                    $price_discount = $products['price'] * $products['times'] * $products['quantity'] - $products['discount'];

                    $sub_tax = $this->tax->calculateTax($price_discount, $products['tax_class_id'], $this->config->get('config_tax'));
                    $total = $sub_tax['total'];
                    $tax = $sub_tax['tax'];
                    $subtotal = $sub_tax['net_amount'];

                    $product_weight = 0;
                    $product_tax = 0;
                    $product_subtotal = 0;
                    if ($products['weight'] > 0) {
                        $product_weight = ($products['weight'] / $products['quantity']) / $products['times'];
                    }
                    if ($subtotal > 0) {
                        $product_subtotal = ($subtotal / $products['quantity']) / $products['times'];
                    }
                    if ($tax > 0) {
                        $product_tax = ($tax / $products['quantity']) / $products['times'];
                    }

                    $arr_products[$prescription_id][] = array(
                        'product_id'        => $products['product_id'],
                        'name'              => $products['name'],
                        'code'              => $products['code'],
                        'quantity'          => $products['quantity'],
                        'times'             => $products['times'],
                        'cook'              => $products['cook'],
                        'taketype'          => $products['taketype'],
                        'stock'             => $products['stock'],
                        'day'               => $products['day'],
                        'usage'             => $products['usage'],
                        'price'             => $products['price'],
                        'discount'          => $products['discount'],
                        'subtotal'          => $subtotal,
                        'total'             => $total,
                        'tax'               => $tax,
                        'product_tax'       => $product_tax,
                        'product_subtotal'  => $product_subtotal,
                        'tax_class_id'      => $products['tax_class_id'],
                        'tax_code'          => $this->tax->has($products['tax_class_id']) ? $this->tax->getClassCode($products['tax_class_id']) : '',
                        'tax_format'        => $sub_tax['format'],
                        'weight'            => $products['weight'],
                        'product_weight'    => $product_weight,
                        'weight_class_id'   => $products['weight_class_id'],
                    );
                } //end products
            } //end prescription
        }

        if (!empty($herbal_service)) {
            $arr_service = array();
            foreach ($this->cart->getService() as $key => $service) {
                $sub_tax = $this->tax->calculateTax($service['total'], $service['tax_class_id'], $this->config->get('config_tax'));
                $total = $sub_tax['total'];
                $tax = $sub_tax['tax'];
                $subtotal = $sub_tax['net_amount'];

                $arr_service[$key] = array(
                    'service_id'        => $key,
                    'staff_id'          => $service['staff_id'],
                    'staff_name'        => $service['staff_name'],
                    'service_name'      => $service['service_name'],
                    'service_minute'    => $service['service_minute'],
                    'price'             => $service['price'],
                    'subtotal'          => $subtotal,
                    'total'             => $total,
                    'net_total'         => $sub_tax['net_amount'],
                    'total_whit_gst'    => $sub_tax['net_amount'] + $sub_tax['tax'],
                    'tax'               => $tax,
                    'net_tax'           => $sub_tax['tax'],
                    'net_price'         => $sub_tax['net_amount'],
                    'tax_class_id'      => $service['tax_class_id'],
                    'tax_format'        => $sub_tax['format'],
                    'tax_code'          => $this->tax->getClassCode($service['tax_class_id'])
                );
            } //end service
        }

        $data = array(
            "medical_record_id"     => $medical_record_id,
            "customer_id"           => $customer_id,
            "shipping_address_id"   => $shipping_address_id,
            "doctor_id"             => $doctor_id,
            "service_type"          => $service_type,
            "herb_service_type"     => $herb_service_type,
            "diagnostic"            => $diagnostic,
            "doctoradvice"          => $doctor_advice,
            "pulse"                 => $pulse,
            "disease"               => $disease,
            "treatment"             => $treatment,
            "acupuncture"           => $acupuncture,
            "symptom"               => $symptom,
            "remark"                => $remark,
            "prescription"          => $arr_prescriptions,
            "products"              => $arr_products,
            "service"               => $arr_service,
            "tax_class_id"          => $tax_class_id,
            "tax_code"              => $tax_code,
            "doctor_tax"            => $doctor_tax,
            "tax_format"            => $tax_format,
            "medical_total_data"    => $medical_total_data,
            "order_total"           => $order_total,
            "medical_total"         => $medical_total_json,
            "consultation_fee"      => $consultation_fee,
            "collect_consultation_price" => $collect_consultation_price,
            "delete_images"         => $delete_images
        );
        $medical_record_id = $this->model_name->saveClinicalSale($data);
        if ($medical_record_id) {
            $this->cart->setMedicalRecordId($medical_record_id);
            if (!empty($delete_images)) {
                $this->deleteImages($delete_images);
            }
            $return_result = $this->getInfo($medical_record_id);
            $return_result = !empty($return_result) ? $return_result : new stdClass();
            $output = $this->response->setResponse2(200, $return_result, "success", "medical_record");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setResponse2(400, new stdClass(), "failed to save", "medical_record");
            $this->api->trackResponse($output);
            return;
        }
        // } else {
        //     $output = $this->response->setResponse2(400, new stdClass(), "Please select doctor at step 2", "medical_record");
        //     $this->api->trackResponse($output);
        //     return;
        // }
    }

    protected function complete()
    {
        $json = $this->json;
        $medical_record_id = !empty($json['medical_record_id']) ? $json['medical_record_id'] : false;
        $medical_total_json = isset($json['medical_total']) ? (is_numeric($json['medical_total']) ? $json['medical_total'] : false) : false;
        $consultation_fee = isset($json['consultation_fee']) ? (is_numeric($json['consultation_fee']) ? $json['consultation_fee'] : false) : false;
        $service_total = isset($json['service_fee']) ? (is_numeric($json['service_fee']) ? $json['service_fee'] : false) : false;

        if (($medical_record_id !== false) && ($medical_total_json !== false) && ($consultation_fee !== false)) {

            $this->cart->clear();
            $medical_info = $this->getInfo($medical_record_id);
            if ($medical_info['consultation_fee'] != $consultation_fee || $medical_info['medical_total'] != $medical_total_json) {


                //update total data
                $doctor_detail = $this->model_name->getUser($medical_info['doctor_id']);
                $tax_class_id = $doctor_detail['tax_class_id'];
                //prepare medical_total_data
                $medical_total_data = array();
                $medical_total = 0;
                $medical_taxes = $this->tax->calculateTax($medical_total_json, $tax_class_id);
                $medical_taxes_rates = $this->cart->getDoctorTaxes($medical_total_json, $tax_class_id);

                $medical_total_data[] = array(
                    'key'       => '',
                    'code'      => 'sub_total',
                    'title'     => 'Sub total',
                    'text'      => $this->currency->format($medical_taxes['net_amount'], $this->config->get('config_currency')),
                    'value'     => $medical_taxes['net_amount'],
                    'tax_code'  => '',
                    'sort_order' => $this->config->get('sub_total_sort_order')
                );

                $medical_total += $medical_taxes['net_amount'];

                foreach ($medical_taxes_rates as $key => $value) {
                    $medical_total_data[] = array(
                        'key'       => $key,
                        'code'      => 'tax',
                        'title'     => $this->tax->getRateName($key),
                        'tax_code'  => $this->tax->getRateCode($key),
                        'text'      => $this->currency->format($value, $this->config->get('config_currency')),
                        'value'     => $value,
                        'sort_order' => $this->config->get('tax_sort_order')
                    );

                    $medical_total += $value;
                }

                $medical_total_data[] = array(
                    'key'       => '',
                    'code'      => 'total',
                    'title'     => 'total',
                    'text'      => $this->currency->format(max(0, $medical_total), $this->config->get('config_currency')),
                    'tax_code'  => '',
                    'value'     => max(0, $medical_total),
                    'sort_order' => $this->config->get('total_sort_order')
                );

                //consultation fee total
                $collect_consultation_price = $consultation_fee > 0 ? 1 : 0;

                $doctor_tax = 0;
                if ($collect_consultation_price) {
                    $total_doctor_data_tax = 0;

                    $doctor_taxes_rates = $this->cart->getDoctorTaxes($consultation_fee, $tax_class_id);
                    foreach ($doctor_taxes_rates as $key => $value) {
                        $total_doctor_data[] = array(
                            'key' => $key,
                            'code' => 'tax',
                            'title' => $this->tax->getRateName($key),
                            'tax_code' => $this->tax->getRateCode($key),
                            'text' => $this->currency->format($value, $this->config->get('config_currency')),
                            'value' => $value,
                            'sort_order' => $this->config->get('tax_sort_order')
                        );
                    }

                    if (!empty($total_doctor_data)) {
                        foreach ($total_doctor_data as $total_doctor) {
                            if ($total_doctor['code'] == 'tax') {
                                $total_doctor_data_tax = $total_doctor['value'];
                            }
                        }
                    }
                    $doctor_tax = $total_doctor_data_tax;
                }

                $data = array(
                    "medical_total_data" => $medical_total_data,
                    "medical_total" => $medical_total_json,
                    "collect_consultation_price" => $collect_consultation_price,
                    "consultation_fee" => $consultation_fee,
                    "doctor_tax" => $doctor_tax,
                );
                $this->model_name->updateMedicalTotal($medical_record_id, $data);
            }

            $this->model_name->completeClinicalSale($medical_record_id);
            if ($medical_info['allow_edit_service']) { //to ensure only send notification to new service added
                $this->sendNotificationToService($medical_info);

                if ($service_total !== false) {
                    $this->model_name->updateServiceTotal($medical_record_id, $service_total);
                }
            }

            $output = $this->response->setCachedResponse(200, new stdClass(), "success", "medical_record");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setCachedResponse(400, new stdClass(), "medical_record_id, medical_total, consultation_fee are required", "medical_record");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function cancel()
    {
        $medical_record_id = !empty($this->request->get['medical_record_id']) ? $this->request->get['medical_record_id'] : false;
        if ($medical_record_id) {
            $this->model_name->cancelClinicalSale($medical_record_id);
            $output = $this->response->setCachedResponse(200, new stdClass(), "success", "medical_record");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setCachedResponse(400, new stdClass(), "medical_record_id required", "medical_record");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function delete()
    {
        $medical_record_id = !empty($this->request->post['medical_record_id']) ? $this->request->post['medical_record_id'] : false;
        if ($medical_record_id) {
            $this->model_name->deleteClinicalSale($medical_record_id);
            $output = $this->response->setCachedResponse(200, new stdClass(), "success", "medical_record");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setCachedResponse(400, new stdClass(), "medical_record_id required", "medical_record");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_doctors()
    {
        $filter_search = '';
        if (!empty($this->request->get['filter_search'])) {
            $filter_search = (string)trim($this->request->get['filter_search']);
        }
        $filter_search = !empty($filter_search) ? $filter_search : null;
        $page = !empty($this->request->get['page']) ? $this->request->get['page'] : null;
        $show = !empty($this->request->get['show']) ? $this->request->get['show'] : null;

        $filters = array(
            "filter_search" => $filter_search,
            "start"         => !empty($page) ? (($page - 1) * $show) : null,
            "limit"         => $show
        );

        $doctors = $this->model_name->getDoctors($filters);
        $this->load->model('tool/image');
        $results = array();
        foreach ($doctors as $doctor) {
            $image = $doctor['image'];
            if (is_file(DIR_IMAGE . $image)) {
                $image = $this->model_tool_image->resize($image, 120, 120);
            } else {
                $image = "https://ui-avatars.com/api/?background=random&bold=true&size=120&name=" . str_replace(' ', '+', $doctor['name']);
            }
            $results[] = array(
                "id" => $doctor['id'],
                "name" => ucwords($doctor['name']),
                "image" => $image
            );
        }
        $output = $this->response->setCachedResponse(200, $results, "Get list success", "doctors");
        $this->api->trackResponse($output);
        return;
    }

    protected function get_prescription_form()
    {
        //cart library
        $this->load->library('medical_record_cart');
        $this->cart = new medical_record_cart($this->registry);

        //tax
        $this->load->library('tax');
        $this->tax = new Tax($this->registry);

        $prescription_id = !empty($this->request->get['prescription_id']) ? $this->request->get['prescription_id'] : 0;
        if ($prescription_id) {
            $prescription_info = $this->cart->getPrescription($prescription_id);

            $this->load->model('android/prescription/medicine');
            if (!empty($prescription_info['dispense_code'])) {
                $dispense_info = $this->cart->getDispenseInfo($prescription_info['dispense_code']);
                $product_type = !empty($dispense_info['product_type']) ? $dispense_info['product_type'] : '';
            } else {
                $category_id = $prescription_info['category_id'];


                $product_type = strtolower($this->model_android_prescription_medicine->getProductTypeByCategoryId($category_id));
            }

            //take types
            $take_types = [];
            $types = $this->model_android_prescription_medicine->getTakeTypes();
            if (!empty($types)) {
                foreach ($types as $type) {
                    $take_types[] = array(
                        "id"    => $type['taketype_id'],
                        "name"  => $type['name'],
                    );
                }
            }

            //day time preset
            $ngp_day_list = [2];
            for ($i = 1; $i <= 30; $i++) {
                $ngp_time_list[] = $i * 3;
            }

            if ($product_type == 'granule') {
                $f_day_list = $ngp_day_list;
                $f_time_list = $ngp_time_list;
            } else {
                $f_day_list = [];
                $f_time_list = [];
            }

            //dispense_method
            $dispense_methods = [];
            $herbs_dispense_code = [
                'SELF_HERBS',
                'SELF_BREWING',
                'DECOCTION_BY_PARTNER',
                'HERBS',
            ];
            $granule_dispense_code = [
                'SELF_GRANULE',
                'GRANULE',
            ];

            if ($this->session->data['language_id'] == 1) {
                $daily_dosage_unit = $this->dosage_unit_en;
            } else {
                $daily_dosage_unit = $this->dosage_unit_cn;
            }

            $enable_list = [];
            if ($product_type == 'herbs') {
                $enable_list = $herbs_dispense_code;
            }
            if ($product_type == 'granule') {
                $enable_list = $granule_dispense_code;
            }

            $parent_types = $this->model_android_prescription_medicine->getMedicationDispenses();

            if (!empty($parent_types)) {
                $selected_child = false;
                foreach ($parent_types as $row) {
                    $msg = null;

                    $enable_parent = true;
                    // if ($row['dispense_code'] == 'ETCM') {
                    //     if (in_array($category_id, array_column($this->etcm_categories, 'id'))) {
                    //         $enable_parent = true;
                    //     } else {
                    //         if ($this->session->data['language_id'] == '1') {
                    //             $msg = "Only applies to " . implode(", ", array_column($this->etcm_categories, 'en_name')) . " category";
                    //         } else {
                    //             $msg = "您选择的药物不属于 " . implode(", ", array_column($this->etcm_categories, 'cn_name')) . " 此剂型/药态/分类。";
                    //         }
                    //     }
                    // } else {
                    //     $enable_parent = true;
                    // }

                    $childrens = [];
                    $children_types = $this->model_android_prescription_medicine->getMedicationDispenses($row['medication_dispense_id']);
                    if (!empty($children_types)) {
                        foreach ($children_types as $row_child) {
                            // $enable_child = false;
                            $enable_child = true;
                            $preselect = false;
                            if ($row['dispense_code'] != 'ETCM') {
                                $enable_child = true;
                                if (in_array($row_child['dispense_code'], $enable_list)) {
                                    $preselect = !$selected_child;
                                    $selected_child = true;
                                }
                            } else {
                                if (!empty($enable_list)) {
                                    if (in_array($row_child['dispense_code'], $enable_list)) {
                                        $enable_child = true;
                                        $preselect = !$selected_child;
                                        $selected_child = true;
                                    }
                                } else {
                                    $enable_child = true;
                                    $preselect = !$selected_child;
                                    $selected_child = true;
                                }
                            }

                            //day time list preset
                            $time_list = [];
                            $day_list = [];
                            if ($row_child['product_type'] == 'granule') {
                                $time_list = $ngp_time_list;
                                $day_list = $ngp_day_list;
                            }

                            $childrens[] = array(
                                "code" => $row_child['dispense_code'],
                                "name" => $row_child['name'],
                                "dosage_unit" => !empty($daily_dosage_unit[$row_child['dispense_code']]) ? $daily_dosage_unit[$row_child['dispense_code']] : null,
                                "day_list" => $day_list,
                                "time_list" => $time_list,
                                "enable" => $enable_child && $enable_parent,
                                // "preselect" => $preselect
                                "preselect" => null
                            );
                        }
                    }

                    $dispense_methods[] = array(
                        "code" => $row['dispense_code'],
                        "name" => $row['name'],
                        "enable" => $enable_parent,
                        "message" => $msg,
                        "children" => $childrens
                    );
                }
            }

            $result['form_fields'] = array(
                "dispense_methods" => $dispense_methods,
                "take_types" => $take_types,
                "day_list" => $f_day_list,
                "time_list" => $f_time_list,
            );

            $result['data'] = $this->format_prescription($prescription_info);
            $result['data']['medical_record_id'] = !empty($this->session->data['medical_record_id']) ? $this->session->data['medical_record_id'] : 0;

            $output = $this->response->setCachedResponse(200, $result, "success", "medical_record");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setCachedResponse(400, new stdClass(), "prescription_id required", "medical_record");
            $this->api->trackResponse($output);
            return;
        }
    }

    #region cart API
    protected function add_items()
    {
        $json = $this->json;

        if (empty($json)) {
            $output = $this->response->setResponse2(400, new stdClass(), "missing json body", "medical_record");
            $this->api->trackResponse($output);
            return;
        }

        $category_id = !empty($json['category_id']) ? $json['category_id'] : false;
        $prescription_id = !empty($json['prescription_id']) ? $json['prescription_id'] : 0;
        if (empty($this->session->data['clinical_sale_prescription'][$prescription_id])) {
            $prescription_id = 0;
        }
        if (!empty($prescription_id)) {
            $dispense_code = $this->session->data['clinical_sale_prescription'][$prescription_id]['dispense_code'];
            $dispense_info = $this->cart->getDispenseInfo($dispense_code);
            $product_type = $dispense_info['product_type'];
        } else {
            $this->load->model('android/prescription/medicine');
            $product_type = $this->model_android_prescription_medicine->getProductTypeByCategoryId($category_id);
        }

        $items = !empty($json['items']) ? $json['items'] : [];

        $products_to_add = [];
        $arr_prescriptions_name = [];
        $arr_prescriptions_id = [];

        $match_failed = false;

        if (!empty($items)) {
            foreach ($items as $item) {
                $id = !empty($item['id']) ? $item['id'] : '';
                $qty = !empty($item['qty']) ? $item['qty'] : 1;
                $type = !empty($item['type']) ? $item['type'] : '';
                if ($type == 'prescription') {
                    $prescription_detail = $this->model_name->getPrescription($id);
                    $prescription_product = $prescription_detail['products'];
                    if ($product_type == 'granule') {
                        //convert product to ngp first as prescription can consist of ngp or herbs
                        $prescription_product = [];
                        foreach ($prescription_detail['products'] as $herbs) {
                            $converted_product = $this->cart->herbsToNgp($herbs['product_id'], $herbs['quantity']);
                            if (!empty($converted_product)) {
                                $prescription_product[] = $converted_product;
                            } else {
                                $prescription_product[] =  array(
                                    "product_id" => $herbs['product_id'],
                                    "quantity"  => $herbs['quantity'],
                                    "price"     => $herbs['price']
                                );

                                // if (!$force_save) {
                                //     $match_failed = true;
                                //     break 2;
                                // }
                            }
                        }
                    }

                    if ($product_type == 'herbs') {
                        //convert product to herbs first as prescription can consist of ngp or herbs
                        $prescription_product = [];
                        foreach ($prescription_detail['products'] as $herbs) {
                            $converted_product = $this->cart->ngpToHerbs($herbs['product_id'], $herbs['quantity']);
                            if (!empty($converted_product)) {
                                $prescription_product[] = $converted_product;
                            } else {
                                $prescription_product[] =  array(
                                    "product_id" => $herbs['product_id'],
                                    "quantity"  => $herbs['quantity'],
                                    "price"     => $herbs['price']
                                );

                                // if (!$force_save) {
                                //     $match_failed = true;
                                //     break 2;
                                // }
                            }
                        }
                    }


                    $arr_prescriptions_name[] = $prescription_detail['name'];
                    $arr_prescriptions_id[] = $prescription_detail['prescription_id'];

                    //looping prescription_product
                    foreach ($prescription_product as $product) {
                        $products_to_add[] = array(
                            "product_id" => $product['product_id'],
                            "quantity"  => $product['quantity'],
                            "price"     => $product['price']
                        );
                    }
                }
                if ($type == 'product') {
                    $product_detail = $this->model_name->getProduct($id);
                    $products_to_add[] = array(
                        "product_id" => $product_detail['product_id'],
                        "quantity"  => $qty,
                        "price"     => $product_detail['price']
                    );

                    $arr_prescriptions_name[] = $product_detail['name'];
                    $arr_prescriptions_id[] = $product_detail['product_id'];
                }
            }
        }

        if ($match_failed) {
            $output = $this->response->setCachedResponse(400, new stdClass(), "Some of the product inside prescriptions cannot be converted to NGP product", "medical_record");
            $this->api->trackResponse($output);
            return;
        }

        if (!empty($products_to_add)) {
            //create blank prescription if no prescription_id
            if (empty($prescription_id)) {
                $pres_data = array(
                    "name" => "Prescription",
                    "category_id" => $category_id,
                    "times" => 3,
                    "day"   => 2
                );
                $key = $this->cart->addPrescription($pres_data);
            } else {
                $key = $prescription_id;
            }

            //add product
            foreach ($products_to_add as $prod) {
                $prod_data = array(
                    'key' => $key,
                    'product_id' => $prod['product_id'],
                    'quantity' => $prod['quantity'],
                    'times' => 3,
                    'day' => 2,
                    'price' => $prod['price']
                );
                $this->cart->addProduct($prod_data);
            }

            //check & convert prescriptions item

            $this->cart->updateDB();
            $this->updateMedicalTotal();

            $output = $this->response->setCachedResponse(200, ['prescription_id' => "$key"], "Success", "medical_record");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setCachedResponse(400, new stdClass(), "No items to add", "medical_record");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function update_prescription()
    {
        $json = $this->json;

        if (empty($json)) {
            $output = $this->response->setResponse2(400, new stdClass(), "missing json body", "medical_record");
            $this->api->trackResponse($output);
            return;
        }

        $prescription_id = !empty($json['prescription_id']) ? $json['prescription_id'] : 0;
        $draft = $json['draft'] === null ? true : false;
        if ($prescription_id) {
            $times = !empty($json['times']) ? $json['times'] : 0;
            $day = !empty($json['day']) ? $json['day'] : 0;
            $usage = !empty($json['usage']) ? $json['usage'] : '';
            $cook = !empty($json['cook']) ? $json['cook'] : '';
            $taketype = !empty($json['taketype']) ? $json['taketype'] : '';
            $category_id = !empty($json['category_id']) ? $json['category_id'] : '';
            $discount = !empty($json['discount']) ? $json['discount'] : 0;
            $quantity = !empty($json['quantity']) ? $json['quantity'] : 0;
            $dispense_code = !empty($json['dispense_code']) ? $json['dispense_code'] : '';
            $daily_dosage = !empty($json['daily_dosage']) ? $json['daily_dosage'] : '';
            $contraindications = !empty($json['contraindications']) ? $json['contraindications'] : '';
            $remark = !empty($json['remark']) ? $json['remark'] : '';

            $data = array(
                "key"   => $prescription_id,
                "times" => $times,
                "day" => $day,
                "usage" => $usage,
                "cook" => $cook,
                "taketype" => $taketype,
                "category_id" => $category_id,
                "discount" => $discount,
                "quantity" => $quantity,
                "dispense_code" => $dispense_code,
                "daily_dosage" => $daily_dosage,
                "contraindications" => $contraindications,
                "remark" => $remark,
            );
            $this->cart->updatePrescription($data);

            if (!$draft) {
                $this->cart->updateDB();
                $this->updateMedicalTotal();

                //check if fail convert or unmatched etcm
                $this->checkItemsUnmatched($prescription_id);
            }
            if (!empty($this->warning)) {
                $output = $this->response->setCachedResponse(404, ['prescription_id' => "$prescription_id"], $this->warning, "medical_record");
            } else {
                $output = $this->response->setCachedResponse(200, ['prescription_id' => "$prescription_id"], "Success", "medical_record");
            }
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setCachedResponse(400, new stdClass(), "prescription_id required", "medical_record");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function delete_prescription()
    {
        $json = $this->json;

        if (empty($json)) {
            $output = $this->response->setResponse2(400, new stdClass(), "missing json body", "medical_record");
            $this->api->trackResponse($output);
            return;
        }

        $prescription_id = !empty($json['prescription_id']) ? $json['prescription_id'] : '';
        if (!empty($prescription_id)) {
            if (is_array($prescription_id)) {
                foreach ($prescription_id as $id) {
                    $this->cart->removePrescription($id);
                }
            } else {
                $this->cart->removePrescription($prescription_id);
            }
            $this->cart->updateDB();
            $this->updateMedicalTotal();
            $output = $this->response->setCachedResponse(200, new stdClass(), "Success", "medical_record");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setResponse2(400, new stdClass(), "prescription_id required", "medical_record");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function update_item()
    {
        $json = $this->json;

        if (empty($json)) {
            $output = $this->response->setResponse2(400, new stdClass(), "missing json body", "medical_record");
            $this->api->trackResponse($output);
            return;
        }

        $prescription_id = !empty($json['prescription_id']) ? $json['prescription_id'] : 0;

        if ($prescription_id) {
            $products = !empty($json['products']) ? $json['products'] : [];

            if (is_array($products)) {
                foreach ($products as $product) {
                    $product_id = $product['product_id'];
                    if (!is_numeric($product_id)) continue;
                    $quantity = $product['quantity'];
                    $ngpDetail = $this->model_name->isNgpProducts($product_id, true);
                    if (!empty($ngpDetail['compressscale'])) {
                        $quantity = round(($quantity / $ngpDetail['compressscale']), 2);
                    }
                    $prod_data = array(
                        "prescription_id" => $prescription_id,
                        "product_id" => $product_id,
                        "price"     => $product['price'],
                        "quantity"  => $quantity
                    );
                    $this->cart->updateProduct($prod_data);
                }
                $this->cart->updateDB();
                $this->updateMedicalTotal();
            }


            $output = $this->response->setCachedResponse(200, new stdClass(), "Success", "medical_record");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setCachedResponse(400, new stdClass(), "prescription_id required", "medical_record");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function delete_item()
    {
        $json = $this->json;

        if (empty($json)) {
            $output = $this->response->setResponse2(400, new stdClass(), "missing json body", "medical_record");
            $this->api->trackResponse($output);
            return;
        }

        $prescription_id = !empty($json['prescription_id']) ? $json['prescription_id'] : 0;

        if ($prescription_id) {
            $product_ids = !empty($json['product_ids']) ? $json['product_ids'] : [];

            if (is_array($product_ids)) {
                foreach ($product_ids as $id) {
                    if (!is_numeric($id)) continue;
                    $this->cart->removeProduct($prescription_id, $id);
                }
                $this->cart->updateDB();
                $this->updateMedicalTotal();
            }


            $output = $this->response->setCachedResponse(200, new stdClass(), "Success", "medical_record");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setCachedResponse(400, new stdClass(), "prescription_id required", "medical_record");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function add_service()
    {
        $json = $this->json;

        if (empty($json)) {
            $output = $this->response->setResponse2(400, new stdClass(), "missing json body", "medical_record");
            $this->api->trackResponse($output);
            return;
        }

        $service_id = !empty($json['service_id']) ? $json['service_id'] : 0;
        $doctor_id = !empty($json['doctor_id']) ? $json['doctor_id'] : 0;
        $price = !empty($json['price']) ? $json['price'] : 0;
        if (!empty($service_id)) {
            $id = 0;
            $allow_edit = $this->model_name->allowEditService($this->session->data['medical_record_id']);
            if ($allow_edit) {
                $id = $this->cart->setService($service_id, $doctor_id, $price);
            }
            $this->cart->updateDB();
            // $this->updateMedicalTotal();
            $output = $this->response->setCachedResponse(200, ["id" => $id], "Success", "medical_record");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setCachedResponse(400, new stdClass(), "service_id required", "medical_record");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function delete_service()
    {
        $json = $this->json;

        if (empty($json)) {
            $output = $this->response->setResponse2(400, new stdClass(), "missing json body", "medical_record");
            $this->api->trackResponse($output);
            return;
        }

        $service_id = !empty($json['service_id']) ? $json['service_id'] : 0;

        if ($service_id) {
            $allow_edit = $this->model_name->allowEditService($this->session->data['medical_record_id']);
            if ($allow_edit) {
                $this->cart->removeService($service_id);
            }
            $this->cart->updateDB();
            // $this->updateMedicalTotal();
            $output = $this->response->setCachedResponse(200, new stdClass(), "Success", "medical_record");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setCachedResponse(400, new stdClass(), "service_id required", "medical_record");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_prescription_products()
    {
        $prescription_id = !empty($this->request->get['prescription_id']) ? $this->request->get['prescription_id'] : 0;
        if ($prescription_id) {
            $prescription_detail = $this->getFormattedPrescriptionItems($prescription_id);
            $result = $prescription_detail[0];
            $arr_product_id = [];
            foreach ($result['products'] as $key => $prod) {
                $arr_product_id[] = $prod['product_id'];

                $quantity = $prod['quantity'];
                $ngpDetail = $this->model_name->isNgpProducts($prod['product_id'], true);
                if (!empty($ngpDetail['compressscale'])) {
                    $quantity = $quantity * $ngpDetail['compressscale'];
                }

                $result['products'][$key]['quantity'] = (string)$quantity;
                $result['products'][$key]['weight'] = (string)$quantity;
                $result['products'][$key]['times'] = (string)$prod['times'];
                $result['products'][$key]['day'] = (string)$prod['day'];
                $result['products'][$key]['discount'] = (string)$prod['discount'];
            }

            $notice = null;
            if ($this->model_name->isNgpProducts($arr_product_id)) {
                $notice = $this->session->data['language_id'] == 1 ? "NGP Granule: Please use the dosage of the decoction pieces, and the system will automatically convert the dosage of granules for you." : "配方颗粒剂型：请您用饮片的用量下药，系统会自动转换颗粒用量。";
            }
            $result = !empty($result) ? array_merge(['notice' => $notice], $result) : new stdClass();
            $output = $this->response->setCachedResponse(200, $result, "success", "medical_record");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setCachedResponse(400, new stdClass(), "prescription_id required", "medical_record");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_prescriptions()
    {
    }

    protected function delete_unmatched_products()
    {
        $json = $this->json;

        if (empty($json)) {
            $output = $this->response->setResponse2(400, new stdClass(), "missing json body", "medical_record");
            $this->api->trackResponse($output);
            return;
        }

        $prescription_id = !empty($json['prescription_id']) ? $json['prescription_id'] : '';
        if (!empty($prescription_id)) {

            // temporary disabled
            // if (is_array($prescription_id)) {
            //     foreach ($prescription_id as $id) {
            //         $this->cart->removeUnmatchedProducts($id);
            //     }
            // } else {
            //     $this->cart->removeUnmatchedProducts($prescription_id);
            // }
            // $this->cart->updateDB();
            // $this->updateMedicalTotal();

            $output = $this->response->setCachedResponse(200, new stdClass(), "Success", "medical_record");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setResponse2(400, new stdClass(), "prescription_id required", "medical_record");
            $this->api->trackResponse($output);
            return;
        }
    }

    #endregion

    #region internal function

    private function deletePrescription($key)
    {
        $this->cart->removePrescription($key);
    }

    private function deleteImages($images)
    {
        if (is_array($images)) {
            $deleted_image = 0;
            foreach ($images as $img_id) {
                $image_info = $this->model_name->getClinicalSaleImage($img_id);
                if (!empty($image_info)) {
                    $image_path = DIR_HERBAL . $image_info['image'];
                    if (file_exists($image_path)) { //check if file exist
                        if (!is_dir($image_path)) { //check if it's a file not dir
                            if (unlink($image_path)) { //check if success delete
                                //delete from db
                                $this->model_name->deleteClinicalSaleImage($img_id);
                                $deleted_image++;
                            }
                        }
                    } else {
                        //delete from db if file already didnt exist in server
                        $this->model_name->deleteClinicalSaleImage($img_id);
                        $deleted_image++;
                    }
                }
            }
        }
    }

    private function format_prescription($data)
    {
        $result = array(
            "prescription_id" => (string) $data['key'],
            "day" => (string) $data['day'],
            "times" => (string) $data['times'],
            "take_type" => is_numeric($data['taketype']) ? (string) $data['taketype'] : (string) 1,
            "category_id" => (string) $data['category_id'],
            "dispense_code" => !empty($data['dispense_code']) ? $data['dispense_code'] : null,
            "daily_dosage" => !empty($data['daily_dosage']) ? (string) $data['daily_dosage'] : null,
            "contraindications" => !empty($data['contraindications']) ? (string)$data['contraindications'] : null,
            "usage" => !empty($data['usage']) ? (string)$data['usage'] : null,
            "remark" => !empty($data['remark']) ? (string)$data['remark'] : null,
        );

        return $result;
    }

    private function checkItemsUnmatched($prescription_id)
    {
        $this->warning = '';

        $language_id = $this->session->data['language_id'];
        $ngp_unmatched_products = [];
        $etcm_unmatched_products = [];

        $products = $this->cart->getProducts($prescription_id);
        foreach ($products as $product) {
            if ($product['convert_matched'] == false) {
                $ngp_unmatched_products[] = $product['name'];
            }
            if ($product['etcm_matched'] == false) {
                $etcm_unmatched_products[] = $product['name'];
            }
        }
        $all_unmatched_products = array_unique(array_merge($ngp_unmatched_products, $etcm_unmatched_products), SORT_REGULAR);

        // $etcm_matched_error_en = "ETCM Alliance Pharmacy Reminder: The drugs you selected \"" . implode('", "', $etcm_unmatched_products) . "\" are not complete in this pharmacy/formulation. If you continue to \"Save\", the above medicines will not be saved to the selected prescription.";

        // $ngp_matched_error_en = "NGP New Green Formula Granules Conversion Reminder: The medicines you choose \"" . implode('", "', $ngp_unmatched_products) . "\" are not complete in the formula granules, and it is recommended to use Chinese herbal medicines/medicinal materials. If you continue to \"Save\", the above medicines will not be saved to the selected prescription.";

        // $etcm_matched_error_cn = "ETCM 联盟药房提醒:  您选择的药物 \"" . implode('", "', $etcm_unmatched_products) . "\" 在此药房/剂型里不齐全。如果您继续“保存”，以上的药物不会被保存进所选择的处方里。";

        // $ngp_matched_error_cn = "NGP 新绿色配方颗粒转换提醒:  您选择的药物 \"" . implode('", "', $ngp_unmatched_products) . "\" 在配方颗粒剂里不齐全，建议用中草药/药材。如果您继续“保存”，以上的药物不会被保存进所选择的处方里。";

        // if (!empty($etcm_unmatched_products)) {
        //     if ($language_id == 1) {
        //         $this->warning = $etcm_matched_error_en;
        //     } else {
        //         $this->warning = $etcm_matched_error_cn;
        //     }
        // }
        // if (!empty($ngp_unmatched_products)) {
        //     $this->warning .= !empty($this->warning) ? "\n\n" : '';
        //     if ($language_id == 1) {
        //         $this->warning .= $ngp_matched_error_en;
        //     } else {
        //         $this->warning .= $ngp_matched_error_cn;
        //     }
        // }

        // // dummy_data
        // for ($i = 0; $i < 10; $i++) {
        //     $all_unmatched_products = array_merge($all_unmatched_products, $all_unmatched_products);
        // }

        if (!empty($all_unmatched_products)) {
            if ($language_id == 1) {
                $this->warning = "Reminder: Some of the following drugs are incomplete, please replace the \"out of stock\" drugs or change the dosage form/state/dispensing method. If you continue to save, you will not be able to send the order to the ETCM Dispensing Alliance.";
                foreach ($all_unmatched_products as $key => $prod) {
                    $this->warning .= "\n" . ($key + 1) . ". " . $prod;
                }
            } else {
                $this->warning = "提醒: 以下有些药物品种不齐全，请麻烦更换“缺货”的药物或者更换剂型/药态/药房。如果继续保存，将无法发送药单到ETCM药房联盟。";
                foreach ($all_unmatched_products as $key => $prod) {
                    $this->warning .= "\n" . ($key + 1) . ". " . $prod;
                }
            }
        }
    }

    private function checkAllowComplete($prescriptions)
    {
        // $this->notice = '';
        $product_error = [];
        $prescription_error = [];
        $allow_complete = true;
        //check_dispense_code
        $codes = array_column($prescriptions, 'dispense_code');
        $got_etcm_dispense = false;
        foreach ($codes as $code) {
            if (substr($code, 0, 5) !== 'SELF_') {
                $got_etcm_dispense = true;
                break;
            }
        }

        //temporary dont check
        // if ($got_etcm_dispense) {
        //     foreach ($prescriptions as $p) {
        //         if (substr($p['dispense_code'], 0, 5) !== 'SELF_') {
        //             foreach ($p['products'] as $prod) {
        //                 if (!$prod['etcm_matched'] || !$prod['convert_matched']) {
        //                     $allow_complete = false;
        //                     if (!in_array($prod['name'], $product_error)) {
        //                         $product_error[] = $prod['name'];
        //                     }
        //                     if (!in_array($p['name'], $prescription_error)) {
        //                         $prescription_error[] = $p['name'];
        //                     }
        //                     // break 2;
        //                 }
        //             }
        //         }
        //     }
        // }

        if (!$allow_complete) {

            // //create notice
            // if ($this->session->data['language_id'] == '1') {
            //     $this->notice = "Notice:";
            //     $this->notice .= "\nThere are some issue in " . implode(",", $prescription_error) . ". Please check the product(s) listed below:\n" . implode(", ", $product_error);
            // } else {
            //     $this->notice = "提示：";
            //     $this->notice .= "\n您的" . implode("，", $prescription_error) . "面对些许问题，比如药材/颗粒不匹配您所选择的剂型/药方或不存在这ETCM药方联盟当中。请检查以下药材/颗粒：\n" . implode("，", $product_error);
            // }

            if (!empty($this->session->data['medical_record_id'])) {
                $this->model_name->revertPending($this->session->data['medical_record_id']);
            }
        }

        return $allow_complete;
    }

    private function checkAllowBrewing($prescriptions)
    {
        $allow_complete = true;

        //check_dispense_code
        $codes = array_column($prescriptions, 'dispense_code');
        $got_etcm_dispense = false;
        foreach ($codes as $code) {
            if (substr($code, 0, 5) !== 'SELF_') {
                $got_etcm_dispense = true;
                break;
            }
        }

        //temporary dont check
        if ($got_etcm_dispense) {
            foreach ($prescriptions as $p) {
                if (substr($p['dispense_code'], 0, 5) !== 'SELF_') {
                    foreach ($p['products'] as $prod) {
                        if (!$prod['etcm_matched'] || !$prod['convert_matched']) {
                            $allow_complete = false;
                            break 2;
                        }
                    }
                }
            }
        }

        return $allow_complete;
    }

    private function getFormattedPrescriptionItems($key = 0)
    {
        $arr_prescriptions = array();

        $language_id = $this->session->data['language_id'];
        if ($language_id == 1) {
            $dosage_unit = $this->dosage_unit_en;
        } else {
            $dosage_unit = $this->dosage_unit_cn;
        }

        if (!empty($this->session->data['clinical_sale_prescription'])) {
            $this->load->model('android/prescription/medicine');
            if ($key > 0) {
                if (!empty($this->cart->getPrescription($key))) {
                    $cart_prescriptions[$key] = $this->cart->getPrescription($key);
                }
            } else {
                $cart_prescriptions = $this->cart->getPrescription();
            }
            if (!empty($cart_prescriptions)) {
                foreach ($cart_prescriptions as $prescription_id => $prescription) {
                    $name = $prescription['name'];
                    $arr_products[$prescription_id] = array();

                    $weight = 0;
                    $amount = 0;
                    $total_weight = 0;
                    $total_amount = 0;
                    $total_item = count($this->cart->getProducts($prescription_id));
                    if (!empty($this->session->data['clinical_sale_products'][$prescription_id])) {
                        foreach ($this->cart->getProducts($prescription_id) as $key => $products) {
                            $price_discount = $products['price'] * $products['times'] * $products['quantity'] - $products['discount'];
                            $sub_tax = $this->tax->calculateTax($price_discount, $products['tax_class_id'], $this->config->get('config_tax'));
                            $total = $this->currency->format($sub_tax['total'], $this->config->get('config_currency'));
                            $tax = $this->currency->format($sub_tax['tax'], $this->config->get('config_currency'));
                            $subtotal = $this->currency->format($sub_tax['net_amount'], $this->config->get('config_currency'));
                            $subprice = $this->currency->format($products['price'] * $products['quantity'], $this->config->get('config_currency'));
                            $arr_products[$prescription_id][] = array(
                                'product_id' => $products['product_id'],
                                'name' => $products['name'],
                                'code' => $products['code'],
                                'quantity' => $products['quantity'] + 0,
                                'times' => $products['times'],
                                'cook' => $products['cook'],
                                'taketype' => $products['taketype'],
                                'stock' => $products['stock'],
                                'convert_matched' => $products['convert_matched'],
                                'etcm_matched' => $products['etcm_matched'],
                                'day' => $products['day'],
                                'currency' => $this->currency->getSymbolLeft($this->config->get('config_currency')),
                                'price' => (string)$products['price'],
                                'subprice' => $subprice,
                                'discount' => $products['discount'],
                                'subtotal' => $subtotal,
                                'total' => $total,
                                'tax' => $tax,
                                'tax_class_id' => $products['tax_class_id'],
                                'weight' => (string)($products['quantity'] + 0),
                                'weight_class_id' => $products['weight_class_id'],
                                'weight_class' => $products['weight_class'],
                                'weight_format' => (string)($products['quantity'] + 0)
                            );
                            $weight += ($products['quantity']);
                            $total_weight += ($products['quantity'] * $products['times']);

                            // $amount += ($products['price'] * $products['quantity']);
                            $amount += ($products['price'] * $products['quantity']);
                            $total_amount += ($products['price'] * $products['quantity'] * $products['times']);

                            $weight_class_unit = $products['weight_class'];
                        }
                        $columns_1 = array_column($arr_products[$prescription_id], 'convert_matched');
                        $columns_2 = array_column($arr_products[$prescription_id], 'etcm_matched');
                        array_multisort($columns_1, SORT_ASC, $columns_2, SORT_ASC, $arr_products[$prescription_id]);
                        //end products
                    }
                    $weight = $weight . $weight_class_unit;
                    $total_weight = $total_weight . $weight_class_unit;
                    $amount = $this->currency->format($amount);
                    $total_amount = $this->currency->format($total_amount);

                    $take_type = is_numeric($prescription['taketype']) ? $prescription['taketype'] : 1;
                    $take_type_name = $this->cart->getTakeTypeName($take_type);
                    $category_name = $this->model_android_prescription_medicine->getCategoryNameById($prescription['category_id']);


                    $medication_instruction = [];
                    $dispense_text = '';
                    if (!empty($prescription['dispense_code'])) {
                        $dispense_text = $this->getDispenseCodeText($prescription['dispense_code']);
                        $medication_instruction[] = $dispense_text;
                    }

                    // if (!empty($take_type_name)) {
                    //     $medication_instruction[] = $take_type_name;
                    // }

                    if (!empty($prescription['times']) && !empty($prescription['day'])) {
                        $day_time_text_en = 'Total ' . $prescription['times'] . ' day, ' . $prescription['day'] . ' times daily';

                        $day_time_text_cn = '共' . $prescription['times'] . '剂/天, 每天' . $prescription['day'] . '次';

                        $medication_instruction[] = $language_id == 1 ? $day_time_text_en : $day_time_text_cn;
                    }

                    if (!empty($prescription['daily_dosage'])) {
                        $daily_dosage_text_en = $prescription['daily_dosage'] . $dosage_unit[$prescription['dispense_code']] . "/day";

                        $daily_dosage_text_cn = "每次 " . $prescription['daily_dosage'] . $dosage_unit[$prescription['dispense_code']];

                        $medication_instruction[] = $language_id == 1 ? $daily_dosage_text_en : $daily_dosage_text_cn;
                    }
                    if (!empty($prescription['dispense_code'])) {
                        $medication_instruction[] = $this->getPackagingText($prescription);
                    }

                    $summary_en = "Items: $total_item, Weight:$weight, Amount:$amount";
                    $summary_cn = "共 $total_item 味药，每剂" . $weight . "，价格：$amount";

                    $arr_prescriptions[] = array(
                        'prescription_id' => (string)$prescription['key'],
                        'name' => $this->convertPresName($name),
                        'day' => (string)$prescription['day'],
                        'times' => (string)$prescription['times'],
                        // 'discount' => (string)$prescription['discount'],
                        // 'consume_method' => $prescription['cook'],
                        'take_type' => (string) $take_type,
                        'take_type_name' => (string) $take_type_name,
                        "category_id" => (string) $prescription['category_id'],
                        "category_name" => $category_name,
                        "dispense_code" => (string) $prescription['dispense_code'],
                        "dispense_name" => (string) $dispense_text,
                        "daily_dosage" => (string) $prescription['daily_dosage'],
                        "contraindications" => (string) $prescription['contraindications'],
                        "usage" => !empty($prescription['usage']) ? (string)$prescription['usage'] : null,
                        "remark" => !empty($prescription['remark']) ? (string)$prescription['remark'] : null,
                        // 'quantity' => (string)$prescription['quantity'],
                        "medical_instruction" => implode(", ", array_filter($medication_instruction)),
                        "summary" => $this->session->data['language_id'] == 1 ? $summary_en : $summary_cn,
                        "total_summary_left" => "Total Weight:$total_weight",
                        "total_summary_right" => "Total Amount:$total_amount",
                        "weight" => $weight,
                        "amount" => $amount,
                        "total_weight" => "$total_weight",
                        "total_amount" => "$total_amount",
                        'products' => $arr_products[$prescription_id],
                    );
                }
            }
        }

        return $arr_prescriptions;
    }

    private function getDispenseCodeText($code)
    {
        $text = '';
        $sql = "SELECT m.*, md.name FROM " . DB_PREFIX . "medication_dispense m LEFT JOIN " . DB_PREFIX . "medication_dispense_description md ON(md.medication_dispense_id = m.medication_dispense_id AND md.language_id='" . (int)$this->session->data['language_id'] . "') 
        WHERE m.dispense_code='" . $this->db->escape($code) . "'";
        $query = $this->db->query($sql);
        if (!empty($query->row['name'])) {
            $text .= $query->row['name'];

            $sql_parent = "SELECT m.*, md.name FROM " . DB_PREFIX . "medication_dispense m LEFT JOIN " . DB_PREFIX . "medication_dispense_description md ON(md.medication_dispense_id = m.medication_dispense_id AND md.language_id='" . (int)$this->session->data['language_id'] . "') 
            WHERE m.medication_dispense_id='" . $this->db->escape($query->row['parent_id']) . "'";
            $query_parent = $this->db->query($sql_parent);
            if (!empty($query_parent->row['name'])) {
                $text .= '(' . $query_parent->row['name'] . ')';
            }
        }

        return $text;
    }

    private function getPackagingText($prescription)
    {
        $language_id = $this->session->data['language_id'];
        $pack_code = [
            'SELF_BREWING',
            'DECOCTION_BY_PARTNER',
        ];
        $ngp_code = [
            'SELF_GRANULE',
            'GRANULE'
        ];
        if (in_array($prescription['dispense_code'], $pack_code)) {
            $no_of_pack = $prescription['day'] * $prescription['times'];
            $text = $language_id == 1 ? 'Total ' . $no_of_pack . ' packs' : '共' . $no_of_pack . '包';
        } elseif (in_array($prescription['dispense_code'], $ngp_code)) {
            $box_needed = ceil(($prescription['day'] * $prescription['times']) / 6);
            $text = $language_id == 1 ? 'Total ' . $box_needed . ' boxes' : '共' . $box_needed . '盒';
        } else {
            $text = null;
        }

        return $text;
    }

    private function getFormattedPrescriptionInfo($prescriptions)
    {
        $result = [];

        $language_id = $this->session->data['language_id'];
        if ($language_id == 1) {
            $dosage_unit = $this->dosage_unit_en;
        } else {
            $dosage_unit = $this->dosage_unit_cn;
        }
        $this->load->model('android/prescription/medicine');
        foreach ($prescriptions as $id => $prescription) {
            $name = $prescription['name'];
            $products = [];
            $weight = 0;
            $amount = 0;
            $total_weight = 0;
            $total_amount = 0;
            $total_item = count($prescription['products']);
            foreach ($prescription['products'] as $product) {
                $products[] = array(
                    "product_id" => $product['product_id'],
                    "name" => $product['product_name'],
                    "code" => $product['product_code'],
                    "quantity" => $product['quantity'] + 0,
                    "times" => $product['times'],
                    "cook" => $product['cook'],
                    "taketype" => $product['taketype'],
                    "stock" => true, //as can be as history data
                    'convert_matched' => true, //as can be as history data
                    'etcm_matched' => true, //as can be as history data
                    "day" => $product['day'],
                    "currency" => $this->currency->getSymbolLeft($this->config->get('config_currency')),
                    "price" => (string)$product['price'],
                    "subprice" => $this->currency->format(($product['price'] * $product['quantity']), $this->config->get('config_currency')),
                    "discount" => $product['discount'],
                    "subtotal" => $this->currency->format($product['t_net_price'], $this->config->get('config_currency')),
                    "total" => $this->currency->format($product['rowtotal'], $this->config->get('config_currency')),
                    "tax" => $this->currency->format($product['t_gst'], $this->config->get('config_currency')),
                    "tax_class_id" => $product['tax_class_id'],
                    "weight" => (string)($product['quantity'] + 0),
                    "weight_class_id" => $product['weight_class_id'],
                    "weight_class" => $product['unit'],
                    "weight_format" => (string)($product['quantity'] + 0)
                );

                $weight += ($product['quantity']);
                $total_weight += ($product['quantity'] * $product['times']);

                $amount += ($product['price'] * $product['quantity']);
                $total_amount += ($product['price'] * $product['quantity'] * $product['times']);

                $weight_class_unit = $product['unit'];
            }

            $weight = $weight . $weight_class_unit;
            $total_weight = $total_weight . $weight_class_unit;
            $amount = $this->currency->format($amount);
            $total_amount = $this->currency->format($total_amount);

            $take_type = is_numeric($prescription['taketype']) ? $prescription['taketype'] : 1;

            $take_type_name = $this->cart->getTakeTypeName($take_type);
            $category_name = $this->model_android_prescription_medicine->getCategoryNameById($prescription['category_id']);

            $medication_instruction = [];
            if (!empty($prescription['dispense_code'])) {
                $dispense_text = $this->getDispenseCodeText($prescription['dispense_code']);
                $medication_instruction[] = $dispense_text;
            }

            // if (!empty($take_type_name)) {
            //     $medication_instruction[] = $take_type_name;
            // }

            if (!empty($prescription['times']) && !empty($prescription['day'])) {
                $day_time_text_en = 'Total ' . $prescription['times'] . ' day, ' . $prescription['day'] . ' times daily';

                $day_time_text_cn = '共' . $prescription['times'] . '剂/天, 每天' . $prescription['day'] . '次';

                $medication_instruction[] = $language_id == 1 ? $day_time_text_en : $day_time_text_cn;
            }

            if (!empty($prescription['daily_dosage'])) {
                $daily_dosage_text_en = $prescription['daily_dosage'] . $dosage_unit[$prescription['dispense_code']] . "/day";

                $daily_dosage_text_cn = "每次 " . $prescription['daily_dosage'] . $dosage_unit[$prescription['dispense_code']];

                $medication_instruction[] = $language_id == 1 ? $daily_dosage_text_en : $daily_dosage_text_cn;
            }

            if (!empty($prescription['dispense_code'])) {
                $medication_instruction[] = $this->getPackagingText($prescription);
            }

            $summary_en = "Items: $total_item, Weight:$weight, Amount:$amount";
            $summary_cn = "共 $total_item 味药，每剂" . $weight . "，价格：$amount";

            $result[] = array(
                "prescription_id" => (string)($id + 1),
                'name' => $this->convertPresName($name),
                'day' => (string)$prescription['day'],
                'times' => (string)$prescription['times'],
                // "discount" => (string)($prescription['discount'] + 0),
                // "consume_method" => $consume_method,
                "take_type" => (string) $take_type,
                'take_type_name' => (string) $take_type_name,
                "category_id" => (string) $prescription['category_id'],
                "category_name" => $category_name,
                "dispense_code" => (string) $prescription['dispense_code'],
                "dispense_name" => (string) $dispense_text,
                "daily_dosage" => (string) $prescription['daily_dosage'],
                "contraindications" => (string) $prescription['contraindications'],
                "usage" => !empty($prescription['usage']) ? (string)$prescription['usage'] : null,
                "remark" => !empty($prescription['remark']) ? (string)$prescription['remark'] : null,
                // 'quantity' => (string)$prescription['quantity'],
                "medical_instruction" => implode(", ", array_filter($medication_instruction)),
                "summary" => $this->session->data['language_id'] == 1 ? $summary_en : $summary_cn,
                "total_summary_left" => "Total Weight:$total_weight",
                "total_summary_right" => "Total Amount:$total_amount",
                "weight" => $weight,
                "amount" => $amount,
                "total_weight" => "$total_weight",
                "total_amount" => "$total_amount",
                "products" => $products
            );
        }
        return $result;
    }

    private function convertPresName($name)
    {
        if ($this->session->data['language_id'] == 1) {
            $name = str_replace('处方', 'Prescription', $name);
        } else {
            $name = str_replace('Prescription', '处方', $name);
        }
        return $name;
    }

    private function getServiceItems()
    {
        $this->load->library('medical_record_cart'); //
        $this->cart = new medical_record_cart($this->registry);
        $result = array();
        foreach ($this->cart->getService() as $key => $service) {
            $sub_tax = $this->tax->calculateTax($service['total'], $service['tax_class_id'], $this->config->get('config_tax'));
            $total = $this->currency->format($sub_tax['total'], $this->config->get('config_currency'));
            $tax = $this->currency->format($sub_tax['tax'], $this->config->get('config_currency'));
            $subtotal = $this->currency->format($sub_tax['net_amount'], $this->config->get('config_currency'));
            $result[] = array(
                'service_id' => (string)$key,
                'doctor_id' => (string)$service['staff_id'],
                'staff_name' => $service['staff_name'],
                'service_name' => $service['service_name'],
                'service_minute' => $service['service_minute'] . " Mins",
                'price' => $this->currency->format($service['price'], $this->config->get('config_currency')),
                'subtotal' => $subtotal,
                'total' => $total,
                'tax' => $tax,
                'tax_class_id' => $service['tax_class_id']
            );
        }
        return $result;
    }

    private function getInfo($clinical_sale_id)
    {
        $result = [];
        $clinical_sale = $this->model_name->getClinicalSale($clinical_sale_id);
        if (!empty($clinical_sale)) {
            // $this->cart->clear();
            //get customer info
            $customer_info = $this->model_name->getCustomer($clinical_sale['customer_id']);
            if (!empty($customer_info)) {
                $address_list = $this->model_name->getAddressesByCustomerId($clinical_sale['customer_id']);
                $address_list = !empty($address_list) ? $address_list : array();
                $addresses = array();

                foreach ($address_list as $row) {
                    $add_name = '';
                    $add_name .= !empty($row['address_1']) ? $row['address_1'] : '';
                    $add_name .= !empty($row['address_2']) ? ', ' . $row['address_2'] : '';
                    $add_name .= !empty($row['address_3']) ? ', ' . $row['address_3'] : '';
                    $add_name .= !empty($row['postcode']) ? ', ' . $row['postcode'] : '';
                    $add_name .= !empty($row['city']) ? ', ' . $row['city'] : '';
                    $add_name .= !empty($row['zone']) ? ', ' . $row['zone'] : '';

                    $addresses[] = array(
                        "id" => $row['address_id'],
                        "label" => $add_name
                    );
                }

                $selected_address_id = $clinical_sale['shipping_address_id'];

                $selected_address_id = empty($selected_address_id) ? $customer_info['address_id'] : $selected_address_id;

                $customer = array(
                    "cn_name"            => $customer_info['firstname'],
                    "en_name"            => $customer_info['lastname'],
                    "name"               => trim($customer_info['firstname'] . " " . $customer_info['lastname']),
                    "customer_id"        => $customer_info['customer_id'],
                    "customer_ic"        => $customer_info['customer_ic'],
                    "email"              => $customer_info['email'],
                    "telephone1"         => $customer_info['telephone'],
                    "telephone2"         => $customer_info['telephone2'],
                    "gender_id"          => empty($customer_info['gender']) ? null : $customer_info['gender'],
                    "dob"                => $customer_info['dob'] == '0000-00-00' ? null : $customer_info['dob'],
                    "occupation"         => $customer_info['occupation'],
                    "nationality"        => $customer_info['nationality'],
                    "marital_status_id"  => empty($customer_info['marital_status']) ? null : $customer_info['marital_status'],
                    "religion_id"        => empty($customer_info['religion']) ? null : $customer_info['religion'],
                    "race_id"            => empty($customer_info['race']) ? null : $customer_info['race'],
                    "allergic"           => $customer_info['allergic'],
                    "diagnostic_history" => $customer_info['diagnostic_history'],
                    "default_address"    => $selected_address_id,
                    "address"            => $addresses
                );
            } else {
                $customer = new stdClass();
            }

            //get images
            $images = array();
            $images_db = $this->model_name->getImages($clinical_sale_id);
            if (!empty($images_db)) {
                foreach ($images_db as $img) {
                    $images[] = array(
                        "image_id" => $img['clinical_sale_image_id'],
                        "category_id" => $img['category_id'],
                        "category" => $img['category'],
                        "url" => HTTPS_HERBAL_IMAGE . $img['image']
                    );
                }
            }

            $herbal_prescription = $this->model_name->getHerbalPrescription($clinical_sale_id);
            foreach ($herbal_prescription as $prescription) {
                $herbal_product = $this->model_name->getHerbalProduct($prescription['clinical_sale_prescription_id']);
                $prescription['products'] = $herbal_product;
                $arr_prescriptions[] = $prescription;
            }
            $arr_prescriptions = $this->getFormattedPrescriptionInfo($arr_prescriptions);


            $allow_edit_service = $this->model_name->allowEditService($clinical_sale_id);

            $arr_services = array();

            $service_total = 0;
            if ($allow_edit_service) {
                $herbal_service = $this->model_name->getHerbalService($clinical_sale_id);
            } else {
                $herbal_service = [];
                $service_items = $this->model_name->getServiceFormItems($clinical_sale_id);
                foreach ($service_items as $item) {
                    $herbal_service[] = array(
                        'clinicalservice_id' => $item['clinicalservice_id'],
                        'staffincharge' => $item['user_id'],
                        'doctor_name' => $item['doctor_name'],
                        'servicename' => $item['servicename'],
                        'serviceminutes' => $item['serviceminutes'],
                        't_net_price' => $item['net_amount'],
                        'rowtotal' => $item['total'],
                        't_gst' => $item['gst'],
                        'tax_class_id' => $item['tax_class_id'],
                        'price' => $item['price']
                    );
                }
            }
            if ($herbal_service) {
                foreach ($herbal_service as $service) {
                    $arr_services[] = array(
                        "service_id" => $service['clinicalservice_id'],
                        "doctor_id" => $service['staffincharge'],
                        "staff_name" => $service['doctor_name'],
                        "service_name" => $service['servicename'],
                        "service_minute" => $service['serviceminutes'] . " Mins",
                        "price" => $this->currency->format($service['t_net_price']),
                        "subtotal" => $this->currency->format($service['rowtotal']),
                        "total" => $this->currency->format($service['rowtotal']),
                        "tax" => $this->currency->format($service['t_gst']),
                        "tax_class_id" => $service['tax_class_id']
                    );

                    $service_total += $service['price'];
                }
            }

            $sf_total = $this->model_name->getTotalFromServiceForm($clinical_sale_id);
            if (!empty($sf_total)) {
                $service_total = $sf_total['total_price'];
            }

            // $arr_services = $this->getServiceItems();

            $herbs_totals = $this->model_name->getTotals($clinical_sale_id, 1);
            $medical_totals = $this->model_name->getTotals($clinical_sale_id, 2);

            $herb_total = 0;
            foreach ($herbs_totals as $total) {
                if ($total['code'] == 'total') {
                    $herb_total = $total['value'];
                }
            }
            $medical_total = 0;
            foreach ($medical_totals as $total) {
                if ($total['code'] == 'total') {
                    $medical_total = $total['value'];
                }
            }

            $result = array(
                "medical_record_id" => (string)$clinical_sale_id,
                "doc_no"   => $clinical_sale['invoice_prefix'],
                'status' => $clinical_sale['status'],
                'payment_status' => $clinical_sale['payment_status'],
                "customer" => $customer,
                "allow_change_doctor" => $this->load->controller('android/common/permission/canModify', 'user/user'),
                "allow_edit" => ($clinical_sale['order_action'] != '5') ? true : false,
                "allow_complete" => true,
                "notice" => null,
                "allow_service_partner" => true,
                "allow_edit_service" => $allow_edit_service,
                "doctor_id" => (string)$clinical_sale['doctor_id'],
                "doctor_name" => (string)$clinical_sale['doctor_name'],
                "service_type" => (string)$clinical_sale['service_type'],
                "herb_service_type" => $clinical_sale['herb_service_type'],
                "currency" => $this->currency->getSymbolLeft($this->config->get('config_currency')),
                "consultation_fee" => (float)$clinical_sale['clinicalsale_concultation'],
                "herb_total" => (float)$herb_total,
                "medical_total" => (float)$medical_total,
                "service_fee" => (float)$service_total,
                "grand_total" => (float)($medical_total + $service_total),
                "grand_total_weight" => $this->getTotalPrescriptionWeight($arr_prescriptions),
                "diagnostics" => array(
                    'diagnostic' => $clinical_sale['diagnostic'],
                    'pulse' => $clinical_sale['pulse'],
                    'disease' => $clinical_sale['disease'],
                    'treatment' => $clinical_sale['treatment'],
                    'symptom' => $clinical_sale['symptom'],
                    'acupuncture' => $clinical_sale['acupuncture'],
                    'doctor_advice' => $clinical_sale['doctoradvice'],
                    'remark' => $clinical_sale['remark'],
                    'images' => $images
                ),
                "prescriptions" => array(
                    "prescription" => $arr_prescriptions,
                    "services" => $arr_services
                ),
            );
        }
        return $result;
    }

    private function getForm($clinical_sale_id)
    {
        $result = [];
        $clinical_sale = $this->model_name->getClinicalSale($clinical_sale_id);
        if (!empty($clinical_sale)) {
            $this->cart->clear();
            $this->cart->setMedicalRecordId($clinical_sale_id);
            //get customer info
            $customer_info = $this->model_name->getCustomer($clinical_sale['customer_id']);
            if (!empty($customer_info)) {
                $address_list = $this->model_name->getAddressesByCustomerId($clinical_sale['customer_id']);
                $address_list = !empty($address_list) ? $address_list : array();
                $addresses = array();

                foreach ($address_list as $row) {
                    $add_name = '';
                    $add_name .= !empty($row['address_1']) ? $row['address_1'] : '';
                    $add_name .= !empty($row['address_2']) ? ', ' . $row['address_2'] : '';
                    $add_name .= !empty($row['address_3']) ? ', ' . $row['address_3'] : '';
                    $add_name .= !empty($row['postcode']) ? ', ' . $row['postcode'] : '';
                    $add_name .= !empty($row['city']) ? ', ' . $row['city'] : '';
                    $add_name .= !empty($row['zone']) ? ', ' . $row['zone'] : '';

                    $addresses[] = array(
                        "id" => $row['address_id'],
                        "label" => $add_name
                    );
                }

                $selected_address_id = $clinical_sale['shipping_address_id'];

                $selected_address_id = empty($selected_address_id) ? $customer_info['address_id'] : $selected_address_id;

                $customer = array(
                    "cn_name"            => $customer_info['firstname'],
                    "en_name"            => $customer_info['lastname'],
                    "name"               => trim($customer_info['firstname'] . " " . $customer_info['lastname']),
                    "customer_id"        => $customer_info['customer_id'],
                    "customer_ic"        => $customer_info['customer_ic'],
                    "email"              => $customer_info['email'],
                    "telephone1"         => $customer_info['telephone'],
                    "telephone2"         => $customer_info['telephone2'],
                    "gender_id"          => empty($customer_info['gender']) ? null : $customer_info['gender'],
                    "dob"                => $customer_info['dob'] == '0000-00-00' ? null : $customer_info['dob'],
                    "occupation"         => $customer_info['occupation'],
                    "nationality"        => $customer_info['nationality'],
                    "marital_status_id"  => empty($customer_info['marital_status']) ? null : $customer_info['marital_status'],
                    "religion_id"        => empty($customer_info['religion']) ? null : $customer_info['religion'],
                    "race_id"            => empty($customer_info['race']) ? null : $customer_info['race'],
                    "allergic"           => $customer_info['allergic'],
                    "diagnostic_history" => $customer_info['diagnostic_history'],
                    "default_address"    => $selected_address_id,
                    "address"            => $addresses
                );
            } else {
                $customer = new stdClass();
            }

            //get images
            $images = array();
            $images_db = $this->model_name->getImages($clinical_sale_id);
            if (!empty($images_db)) {
                foreach ($images_db as $img) {
                    $images[] = array(
                        "image_id" => $img['clinical_sale_image_id'],
                        "category_id" => $img['category_id'],
                        "category" => $img['category'],
                        "url" => HTTPS_HERBAL_IMAGE . $img['image']
                    );
                }
            }


            $total_weight = 0;
            $grand_total_weight = 0;
            // $total_weight_format = '0.00';
            // $grand_total_weight_format = '0.00';

            $herbal_prescription = $this->model_name->getHerbalPrescription($clinical_sale_id);
            foreach ($herbal_prescription as $prescription) {
                $psp_name = !empty($prescription['name']) ? $prescription['name'] : '';
                $psp_times = !empty($prescription['times']) ? $prescription['times'] : '';
                $psp_day = !empty($prescription['day']) ? $prescription['day'] : '';
                $psp_cook = !empty($prescription['cook']) ? $prescription['cook'] : '';
                $psp_taketype = !empty($prescription['taketype']) ? $prescription['taketype'] : '';

                $psp_category_id = !empty($prescription['category_id']) ? $prescription['category_id'] : '';
                $psp_discount = !empty($prescription['discount']) ? $prescription['discount'] : '';
                $psp_dispense_code = !empty($prescription['dispense_code']) ? $prescription['dispense_code'] : '';
                $psp_daily_dosage = !empty($prescription['daily_dosage']) ? $prescription['daily_dosage'] : '';
                $psp_contraindications = !empty($prescription['contraindications']) ? $prescription['contraindications'] : '';
                $psp_usage = !empty($prescription['medication_method']) ? $prescription['medication_method'] : '';
                $psp_remark = !empty($prescription['remark']) ? $prescription['remark'] : '';


                $psp_data = array(
                    "name" => $psp_name,
                    "times" => $psp_times,
                    "day" => $psp_day,
                    "cook" => $psp_cook,
                    "taketype" => $psp_taketype,
                    "category_id" => $psp_category_id,
                    "discount" => $psp_discount,
                    "dispense_code" => $psp_dispense_code,
                    "daily_dosage" => $psp_daily_dosage,
                    "contraindications" => $psp_contraindications,
                    "usage" => $psp_usage,
                    "remark" => $psp_remark,
                );


                $herbal_product = $this->model_name->getHerbalProduct($prescription['clinical_sale_prescription_id']);

                if ($herbal_product) {
                    $key = $this->cart->addPrescription($psp_data);
                    foreach ($herbal_product as $product) {

                        $prod_data = array(
                            'key' => $key,
                            'product_id' => $product['product_id'],
                            'quantity' => $product['quantity'],
                            'times' => $product['times'],
                            'day' => $product['day'],
                            'price' => $product['price'],
                            'cook' => $product['cook'],
                            'taketype' => $product['taketype'],
                            'discount' => $product['discount'],
                            'usage' => $psp_usage,
                        );
                        $this->cart->addProduct($prod_data);

                        $quantity = $product['quantity'];
                        $times = $product['times'];

                        $weight = $quantity * $times;

                        $total_weight += $quantity;
                        $grand_total_weight += $weight;
                    }
                } //end product
            }

            //check for ngp product that exceed 120g limit
            $this->cart->checkNgpPrescription();
            $arr_prescriptions = $this->getFormattedPrescriptionItems();

            $allow_edit_service = $this->model_name->allowEditService($clinical_sale_id);
            $arr_services = array();

            $service_total = 0;
            if ($allow_edit_service) {
                $herbal_service = $this->model_name->getHerbalService($clinical_sale_id);
            } else {
                $herbal_service = [];
                $service_items = $this->model_name->getServiceFormItems($clinical_sale_id);
                foreach ($service_items as $item) {
                    $herbal_service[] = array(
                        'clinicalservice_id' => $item['clinicalservice_id'],
                        'staffincharge' => $item['user_id'],
                        'doctor_name' => $item['doctor_name'],
                        'servicename' => $item['servicename'],
                        'serviceminutes' => $item['serviceminutes'],
                        't_net_price' => $item['net_amount'],
                        'rowtotal' => $item['total'],
                        't_gst' => $item['gst'],
                        'tax_class_id' => $item['tax_class_id'],
                        'price' => $item['price']
                    );
                }
            }
            if ($herbal_service) {
                foreach ($herbal_service as $services) {
                    $this->cart->setService($services['clinicalservice_id'], $services['staffincharge'], $services['price']);
                    $service_total += $services['price'];
                } //loop services
            }

            $sf_total = $this->model_name->getTotalFromServiceForm($clinical_sale_id);
            if (!empty($sf_total)) {
                $service_total = $sf_total['total_price'];
            }

            $arr_services = $this->getServiceItems();

            $herbs_totals = $this->model_name->getTotals($clinical_sale_id, 1);
            $medical_totals = $this->model_name->getTotals($clinical_sale_id, 2);

            $herb_total = 0;
            foreach ($herbs_totals as $total) {
                if ($total['code'] == 'total') {
                    $herb_total = $total['value'];
                }
            }
            $medical_total = 0;
            foreach ($medical_totals as $total) {
                if ($total['code'] == 'total') {
                    $medical_total = $total['value'];
                }
            }

            if ($this->model_name->orderBeenPlaced($clinical_sale_id)) {
                $this->notice = $this->session->data['language_id'] == 1 ? "Reminder: The medical record has been recorded in the \"Pharmacy Alliance\" and cannot be pushed again. Please create a new medical record to connect with the Pharmacy Alliance." :
                    "提醒：此处方笺已经有记录在“药房联盟”，无法再次推送。请您开新的处方笺，以便对接“药房联盟”。";
            }

            $result = array(
                "medical_record_id" => (string)$clinical_sale_id,
                "doc_no"   => $clinical_sale['invoice_prefix'],
                'status' => $clinical_sale['status'],
                'payment_status' => $clinical_sale['payment_status'],
                "customer" => $customer,
                "allow_change_doctor" => $this->load->controller('android/common/permission/canModify', 'user/user'),
                "allow_edit" => ($clinical_sale['order_action'] != '5') ? true : false,
                "allow_complete" => $this->checkAllowComplete($arr_prescriptions),
                "notice" => !empty($this->notice) ? $this->notice : null,
                "allow_service_partner" => $this->model_name->canPlaceOrder($clinical_sale_id) && $this->checkAllowBrewing($arr_prescriptions) ? true : false,
                "allow_edit_service" => $allow_edit_service,
                "doctor_id" => (string)$clinical_sale['doctor_id'],
                "doctor_name" => (string)$clinical_sale['doctor_name'],
                "service_type" => (string)$clinical_sale['service_type'],
                "herb_service_type" => $clinical_sale['herb_service_type'],
                "currency" => $this->currency->getSymbolLeft($this->config->get('config_currency')),
                "consultation_fee" => (float)$clinical_sale['clinicalsale_concultation'],
                "herb_total" => (float)$herb_total,
                "medical_total" => (float)$medical_total,
                "service_fee" => (float)$service_total,
                "grand_total" => (float)($medical_total + $service_total),
                "grand_total_weight" => $this->getTotalPrescriptionWeight($arr_prescriptions),
                "diagnostics" => array(
                    'diagnostic' => $clinical_sale['diagnostic'],
                    'pulse' => $clinical_sale['pulse'],
                    'disease' => $clinical_sale['disease'],
                    'treatment' => $clinical_sale['treatment'],
                    'symptom' => $clinical_sale['symptom'],
                    'acupuncture' => $clinical_sale['acupuncture'],
                    'doctor_advice' => $clinical_sale['doctoradvice'],
                    'remark' => $clinical_sale['remark'],
                    'images' => $images
                ),
                "prescriptions" => array(
                    "prescription" => $arr_prescriptions,
                    "services" => $arr_services
                ),
            );
        }
        return $result;
    }

    private function getTotalPrescriptionWeight($prescriptions)
    {
        $total_weight = 0;
        $weight_class = 'g';
        if (!empty($prescriptions)) {
            foreach ($prescriptions as $p) {
                foreach ($p['products'] as $prod) {
                    $total_weight += $prod['quantity'] * $prod['times'];
                    $weight_class = $prod['weight_class'];
                }
            }
        }
        return $total_weight . $weight_class;
    }

    private function validateCustomerInfo($customer)
    {
        $required_info = ['name', 'customer_ic', 'telephone1'];
        if (!empty($customer['customer_id'])) {
            return true;
        } else {
            $result = true;
            foreach ($required_info as $info) {
                if (empty($customer[$info])) {
                    $result = false;
                    break;
                }
            }
            return $result;
        }
    }

    private function validateAddressInfo($address)
    {
        $required_info = [
            'address_1',
            'city',
            'post_code',
            'zone_id'
        ];

        $result = true;
        foreach ($required_info as $info) {
            if (empty($address[$info])) {
                $result = false;
                break;
            }
        }
        return $result;
    }

    private function updateMedicalTotal()
    {
        if (!empty($this->session->data['medical_record_id'])) {
            $medical_record_id = $this->session->data['medical_record_id'];
            $cs_info = $this->model_name->getClinicalSale($medical_record_id);
            $consultation_fee = $cs_info['clinicalsale_concultation'];
            $doctor_id = $cs_info['doctor_id'];
            $doctor_detail = $this->model_name->getUser($doctor_id);
            $tax_class_id = $doctor_detail['tax_class_id'];

            // $tax_code = $this->tax->getClassCode($tax_class_id);
            // Herbs Totals
            $this->load->model('pos/extension');
            $total_data = array();
            $totals = array();
            $total = 0;
            $taxes = $this->cart->getTaxes();
            if ($this->opencart_version == 2) {
                // Display prices
                $sort_order = array();
                $results = $this->model_pos_extension->getExtensions('total');
                foreach ($results as $key => $value) {
                    $sort_order[$key] = $this->config->get($value['code'] . '_sort_order');
                }
                array_multisort($sort_order, SORT_ASC, $results);

                foreach ($results as $result) {

                    if ($this->config->get($result['code'] . '_status')) {
                        $this->load->model('total/' . $result['code']);
                        $this->{'model_total_' . $result['code']}->getTotal($total_data, $total, $taxes);
                    }

                    $sort_order = array();
                    foreach ($total_data as $key => $value) {
                        $sort_order[$key] = $value['sort_order'];
                    }

                    array_multisort($sort_order, SORT_ASC, $totals);
                }

                $order_total = $total_data;

                //medical totals
                $total_data_total = 0;
                $total_data_tax = 0;
                $total_data_subtotal = 0;
                foreach ($order_total as $total) {
                    if ($total['code'] == 'total') {
                        $total_data_total = $total['value'];
                    }
                    if ($total['code'] == 'tax') {
                        $total_data_tax = $total['value'];
                    }
                }

                // $medical_total_json  = !empty($json['medical_total']) ? $json['medical_total'] : $total_data_subtotal + $consultation_fee;
                $medical_total_json  = $total_data_total - $total_data_tax + $consultation_fee;

                $medical_total_data = array();
                $medical_total = 0;
                $medical_taxes = $this->tax->calculateTax($medical_total_json, $tax_class_id);
                $medical_taxes_rates = $this->cart->getDoctorTaxes($medical_total_json, $tax_class_id);
                $tax_format = $medical_taxes['format'];

                $medical_total_data[] = array(
                    'key'       => '',
                    'code'      => 'sub_total',
                    'title'     => 'Sub total',
                    'text'      => $this->currency->format($medical_taxes['net_amount'], $this->config->get('config_currency')),
                    'value'     => $medical_taxes['net_amount'],
                    'tax_code'  => '',
                    'sort_order' => $this->config->get('sub_total_sort_order')
                );

                $medical_total += $medical_taxes['net_amount'];

                foreach ($medical_taxes_rates as $key => $value) {
                    $medical_total_data[] = array(
                        'key'       => $key,
                        'code'      => 'tax',
                        'title'     => $this->tax->getRateName($key),
                        'tax_code'  => $this->tax->getRateCode($key),
                        'text'      => $this->currency->format($value, $this->config->get('config_currency')),
                        'value'     => $value,
                        'sort_order' => $this->config->get('tax_sort_order')
                    );

                    $medical_total += $value;
                }

                $medical_total_data[] = array(
                    'key'       => '',
                    'code'      => 'total',
                    'title'     => 'total',
                    'text'      => $this->currency->format(max(0, $medical_total), $this->config->get('config_currency')),
                    'tax_code'  => '',
                    'value'     => max(0, $medical_total),
                    'sort_order' => $this->config->get('total_sort_order')
                );
            } else {
                //for opencart version 3
                $total_data = array(
                    'totals'    => &$totals,
                    'taxes'     => &$taxes,
                    'total'     => &$total
                );

                // Display prices
                $sort_order = array();
                $results = $this->model_pos_extension->getExtensions('total');
                foreach ($results as $key => $value) {
                    $sort_order[$key] = $this->config->get('total_' . $value['code'] . '_sort_order');
                }
                array_multisort($sort_order, SORT_ASC, $results);

                foreach ($results as $result) {

                    if ($this->config->get('total_' . $result['code'] . '_status')) {
                        $this->load->model('extension/total/' . $result['code']);
                        $this->{'model_extension_total_' . $result['code']}->getTotal($total_data);
                    }

                    $sort_order = array();
                    foreach ($totals as $key => $value) {
                        $sort_order[$key] = $value['sort_order'];
                    }

                    array_multisort($sort_order, SORT_ASC, $totals);
                }

                $order_total = $totals;

                //medical totals
                $total_data_total = 0;
                $total_data_tax = 0;
                foreach ($total_data['totals'] as $total) {
                    if ($total['code'] == 'total') {
                        $total_data_total = $total['value'];
                    }
                    if ($total['code'] == 'tax') {
                        $total_data_tax = $total['value'];
                    }
                }

                // $medical_total_json  = !empty($json['medical_total']) ? $json['medical_total'] : $total_data_subtotal + $consultation_fee;
                // $medical_total_json  = $total_data_subtotal + $consultation_fee;
                $medical_total_json  = $total_data_total - $total_data_tax + $consultation_fee;

                $medical_total_data = array();
                $medical_total = 0;
                $medical_taxes = $this->tax->calculateTax($medical_total_json, $tax_class_id);
                $medical_taxes_rates = $this->cart->getDoctorTaxes($medical_total_json, $tax_class_id);
                $tax_format = $medical_taxes['format'];

                $medical_total_data[] = array(
                    'key'       => '',
                    'code'      => 'sub_total',
                    'title'     => 'Sub total',
                    'text'      => $this->currency->format($medical_taxes['net_amount'], $this->config->get('config_currency')),
                    'value'     => $medical_taxes['net_amount'],
                    'tax_code'  => '',
                    'sort_order' => $this->config->get('sub_total_sort_order')
                );

                $medical_total += $medical_taxes['net_amount'];

                foreach ($medical_taxes_rates as $key => $value) {
                    $medical_total_data[] = array(
                        'key'       => $key,
                        'code'      => 'tax',
                        'title'     => $this->tax->getRateName($key),
                        'tax_code'  => $this->tax->getRateCode($key),
                        'text'      => $this->currency->format($value, $this->config->get('config_currency')),
                        'value'     => $value,
                        'sort_order' => $this->config->get('tax_sort_order')
                    );

                    $medical_total += $value;
                }

                $medical_total_data[] = array(
                    'key'       => '',
                    'code'      => 'total',
                    'title'     => 'total',
                    'text'      => $this->currency->format(max(0, $medical_total), $this->config->get('config_currency')),
                    'tax_code'  => '',
                    'value'     => max(0, $medical_total),
                    'sort_order' => $this->config->get('total_sort_order')
                );
            }

            $data = array(
                "order_total"           => $order_total,
                "medical_total_data"    => $medical_total_data,
            );
            $this->model_name->updateTotal($medical_record_id, $data);
        }
    }

    private function reformattedTotal($totals)
    {
        $total_data = [];
        foreach ($totals as $total) {
            switch ($total['code']) {
                case 'sub_total':
                    $title_en = "Subtotal";
                    $title_cn = "商品小计";
                    break;
                case 'tax':
                    $title_en = "Tax";
                    $title_cn = "税额";
                    break;
                case 'rounding':
                    $title_en = "Rounding";
                    $title_cn = "舍入";
                    break;
                case 'shipping':
                    $title_en = "Shipping";
                    $title_cn = "运输费";
                    break;
                case 'credit':
                    $title_en = "ETCM Pay";
                    $title_cn = "ETCM 支付";
                    break;
                case 'total':
                    $title_en = "Total";
                    $title_cn = "付款总额";
                    break;
                default:
                    $title_en = $total['title'];
                    $title_cn = $total['title'];
            }

            $title = $this->session->data['language_id'] == 1 ? $title_en : $title_cn;

            $total_data[] = array(
                'code' => $total['code'],
                'title' => $title,
                'value' => $total['value'],
            );
        }
        return $total_data;
    }

    private function sendNotificationToService($info)
    {
        $this->load->model('android/common/notification');

        if (!empty($info['prescriptions']['services'])) {
            $services_info = $this->model_name->getServices($info['medical_record_id']);
            foreach ($info['prescriptions']['services'] as $service) {
                $staff_id = $service['doctor_id'];
                $service_form_id = 0;
                foreach ($services_info as $service_info) {
                    if ($service_info['staffincharge'] == $staff_id) {
                        $service_form_id = $service_info['service_form_id'];
                    }
                }
                if ($this->session->data['user_id'] != $staff_id && $service_form_id > 0) {
                    $app_url = $this->model_android_common_notification->getNotificationDataUrl('doctorapp', 'service_form');
                    $app_url = str_replace(':id', $service_form_id, $app_url);
                    $app_url = str_replace(':customer-id', $info['customer']['customer_id'], $app_url);
                    $data = array("url" => $app_url);
                    $language_id = $this->model_android_common_notification->getUserLanguageId($staff_id);
                    $notification = $this->generateNotification($service, $language_id);
                    $module = 'service';
                    $action = 'new';
                    $params = array(
                        "user_id" => $staff_id,
                        "notification" => $notification,
                        "notification_type" => 'service_form',
                        "data" => $data,
                        "module" => $module,
                        "action" => $action
                    );
                    $this->load->controller('android/common/notification/push', $params);
                }
            }
        }
    }

    private function generateNotification($info, $language_id)
    {
        if ($language_id == '1') {
            return array(
                "title" => "Service Form (" . $info['service_name'] . ") created",
                "body" => "Click to see detail"
            );
        } else {
            return array(
                "title" => "服务/项目 Form (" . $info['service_name'] . ") 已创建",
                "body" => "点击查看详情"
            );
        }
    }

    private function checkCustomerExist($data)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "customer 
        WHERE 
        customer_ic = '" . $this->db->escape(trim($data['customer_ic'])) . "' 
        AND telephone = '" . $this->db->escape(trim($data['telephone1'])) . "' 
        AND firstname = '" . $this->db->escape(trim($data['name'])) . "'";
        $query = $this->db->query($sql);
        $customer_id = !empty($query->row['customer_id']) ? $query->row['customer_id'] : 0;
        return $customer_id;
    }

    #endregion
}
