<?php

use FontLib\Table\Type\name;

class ControllerAndroidHome extends Controller
{

    private $call_function;
    private $s;
    private $json;
    private $user_info;

    private $module_enable = array(
        array(
            "cn_name" => "预约",
            "en_name" => "Appointment",
            "path" => "appointment/appointment",
            "icon" => "https://www.etcm.me/image/doctorapp/module_icon/appointment.png",
            "click_event" => "/appointment/select",
        ),
        array(
            "cn_name" => "处方笺",
            "en_name" => "Medical Record",
            "path" => "herbal/new_herbal",
            "icon" => "https://www.etcm.me/image/doctorapp/module_icon/medical_record.png",
            "click_event" => "/medical-record/select",
        ),
        array(
            "cn_name" => "诊所服务",
            "en_name" => "Service Form",
            "path" => "service/service_form",
            "icon" => "https://www.etcm.me/image/doctorapp/module_icon/service_form.png",
            "click_event" => "/service-form/select",
        ),
        array(
            "cn_name" => "客户管理",
            "en_name" => "Customer",
            "path" => "customer/customer",
            "icon" => "https://www.etcm.me/image/doctorapp/module_icon/customer.png",
            "click_event" => "/customer/select",
        ),
        array(
            "cn_name" => "产品管理",
            "en_name" => "Product",
            "path" => "catalog/product",
            "icon" => "https://www.etcm.me/image/doctorapp/module_icon/box.png",
            "click_event" => "/product/select",
        ),
        array(
            "cn_name" => "ETCM 配药",
            "en_name" => "ETCM Dispensary",
            "path" => "service_partner/purchase_order",
            "icon" => "https://www.etcm.me/image/doctorapp/module_icon/brewing.png",
            "click_event" => "/brewing-service/select",
        ),
        array(
            "cn_name" => "配药订单",
            "en_name" => "ETCM Order",
            "path" => "service_partner/sale_order",
            "icon" => "https://www.etcm.me/image/doctorapp/module_icon/sales_order.png",
            "click_event" => "/sales-order/select",
        ),
        // array(
        //     "cn_name" => "出货",
        //     "en_name" => "Stock",
        //     "path" => "catalog/stock_issue",
        //     "icon" => "https://www.etcm.me/image/doctorapp/module_icon/stock_issue.png",
        //     "click_event" => "/stock-issue/list",
        // ),
        // array(
        //     "cn_name" => "统计报表",
        //     "en_name" => "Report",
        //     "path" => "report/product_stock",
        //     "icon" => "https://www.etcm.me/image/doctorapp/module_icon/report.png",
        //     "click_event" => "/report/inventory",
        // ),
        // array(
        //     "cn_name" => '退出',
        //     "en_name" => 'Logout',
        //     "path" => "account/logout",
        //     "icon" => 'https://www.etcm.me/image/doctorapp/module_icon/logout.png',
        //     "click_event" => "/log-out"
        // ),
    );

    public function index()
    {
        //load model required

        //load core api function
        require DIR_SYSTEM . "/library/start_api.php";
    }


    protected function get_promo_banner()
    {
        $curl = curl_init();

        $API_URL = "https://www.etcm.me/rest/api/shop/doctorapp/";
        curl_setopt_array($curl, array(
            CURLOPT_URL => $API_URL . 'get_home_page_banner',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);
        curl_close($curl);

        $response = json_decode($response, true);
        if ($response['error']) {
            $output = $this->response->setCachedResponse($response['code'], array(), $response['message'], "promo_banner");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setCachedResponse($response['code'], $response['response'], $response['message'], "promo_banner");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_modules()
    {
        $dynamic_module = array();
        $this->load->model('android/user');
        $platform = !empty($this->request->get['code']) ? $this->request->get['code'] : 'android';
        $platform = strtolower($platform);
        // $user_info = $this->model_android_user->getUserInfo($this->user_info['user_id']);
        $user_info = $this->session->data['user_info'];
        $arr_module = $this->getPermissions($user_info['user_group_id']);
        if ($arr_module) {
            $dynamic_module = $this->generateDynamicModule($arr_module, $platform);
            $output = $this->response->setCachedResponse(200, array("module" => $dynamic_module), "Get modules success", "home_module");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setCachedResponse(204, $this->response->noResponse(), "You dont have permission to any module", "home_module");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_profile_summary()
    {
        $result = array();
        $this->load->model('android/user');
        $user_info = $this->model_android_user->getUserInfo($this->user_info['user_id']);

        //doctor status
        if ($user_info['position'] == 2) {
            // $doctor_stats = $this->getDoctorStats($this->user_info['user_id']);
            $doctor_stats = $this->response->noResponse();
        } else {
            $doctor_stats = $this->response->noResponse();
        }

        //store name
        $store_id = $this->session->data['store_id'];
        if ($store_id == '0') {
            $store_name = htmlspecialchars_decode($this->config->get('config_name')) . " (HQ)";
        } else {
            $this->load->model('setting/store');
            $stores = $this->model_setting_store->getStores();
            foreach ($stores as $store) {
                if ($store['store_id'] == $store_id) {
                    $store_name = $store['name'];
                }
            }
        }

        //user image
        $default_image = "https://www.etcm.me/image/catalog/default-user-july17.jpg";
        $profile_image = $user_info['image'] ? $user_info['image'] : null;
        if (!empty($user_info) && $user_info['image'] && is_file(DIR_IMAGE . $user_info['image'])) {
            $profile_image = HTTPS_IMAGE . $user_info['image'];
        } else {
            $profile_image = $default_image;
        }


        $result = array(
            "name" => $user_info['firstname'] . " " . $user_info['lastname'],
            "store_name" => $store_name,
            "phone_no" => $user_info['contactno'],
            "profile_image" => $profile_image,
            "doctor_stats" => $doctor_stats
        );

        $output = $this->response->setCachedResponse(200, $result, "Get profile summary success", "profile_summary");
        $this->api->trackResponse($output);
        return;
    }

    protected function test()
    {
        try {
            if (true) {
                $this->response->setResponse2();
            } else {
                $this->response->setResponse2(200, array(), "Get modules success");
            }
        } catch (Error $e) {
            $this->response->setResponse2(500, array(), $e->getMessage());
        }
    }

    public function testing()
    {
        $result = array(
            'title' => "TGIF!!"
        );
        $this->response->setCachedResponse(200, $result, "Success", "rnd");
    }

    //internal function
    private function getDoctorStats($user_id)
    {
        $this->load->model("android/home");
        $total_appointment = $this->model_android_home->getTodayAppointments($user_id);
        $appointment_done = $this->model_android_home->getTodayAppointments($user_id, true);
        $total_med_record = $this->model_android_home->getTodayMedicalRecords($user_id);
        $med_record_done = $this->model_android_home->getTodayMedicalRecords($user_id, true);
        $total_customer_weekly = $this->model_android_home->getTotalCustomerWeekly($user_id);
        $total_sale_monthly = $this->model_android_home->getTotalSalesMonthly($user_id);

        $appointment_text = $total_appointment ? $total_appointment - $appointment_done : 0;
        $mr_text = $total_med_record ? $total_med_record : 0;

        $language_id = $this->session->data['language_id'];

        return array(
            "appointment" => array(
                "value" => "$appointment_text",
                "label" => $language_id == 1 ? "Pending Appointment" : '未确认预约'
            ),
            "medical_record" => array(
                "value" => "$mr_text",
                "label" => $language_id == 1 ? "Today Medical Records" : '本日看诊'
            ),
            "total_customer" => array(
                "value" => "$total_customer_weekly",
                "label" => $language_id == 1 ? "Customer This Week" : '本周客户'
            ),
            "total_sales" => array(
                "value" => "$total_sale_monthly",
                "label" => $language_id == 1 ? "Sales This Month" : '本月销量'
            )
        );
    }

    private function generateDynamicModule($arr_module, $platform)
    {
        $result = array();
        $arr_module_enable = $arr_module['enable'];
        $arr_module_disable = $arr_module['disable'];
        //sort array
        array_multisort(array_column($arr_module_enable,'name'),SORT_ASC,$arr_module_enable);
        array_multisort(array_column($arr_module_disable,'name'),SORT_ASC,$arr_module_disable);
        foreach ($arr_module_enable as $module) {
            $button = array(
                "type" => "DecoratedContainer",
                "width" => 20,
                //"height" => 15.5,
                "click_event" => $module['click_event'],
                "child" => array(
                    "type" => "Stack",
                    //"clipBehavior"=> "none",
                    "fit" => "passthrough",
                    "children" => array(
                        array(
                            "type" => "DecoratedContainer",
                            "width" => 20,
                            "height" => 15
                        ),
                        array(
                            "type" => "Positioned",
                            "top" => 0.00,
                            "right" => 0.00,
                            "left" => 0.00,
                            "bottom" => 0.00,
                            "child" => array(
                                "type" => "Column",
                                "mainAxisSize" => "min",
                                "children" => array(
                                    array(
                                        "type" => "DecoratedContainer",
                                        "width" => 15,
                                        "height" => 10,
                                        "padding" => "8,8,8,8",
                                        "shape" => "Circle",
                                        "color" => "#128C7E",
                                        "child" => array(
                                            "type" => "NetworkImage",
                                            "src" => $module['icon'],
                                            "color" => "#ffffff",
                                            "width" => $platform == 'ios' ? 58 : 24,
                                            "height" => $platform == 'ios' ? 58 : 24,
                                            "fit" => "contain"
                                        )
                                    ),
                                    /*array(
                                                    "type" => "SizedBox",
                                                    "height" => 4.01
                                                ),*/
                                    array(
                                        "type" => "Expanded",
                                        "child" => array(
                                            "type" => "Text",
                                            "textAlign" => "center",
                                            "style" => array(
                                                "fontSize" => 12,
                                                "fontFamily" => "Hiragino"
                                            ),
                                            "maxLines" => 2,
                                            "overflow" => "ellipsis",
                                            "data" => $module['name'],
                                        )
                                    ),
                                    /*array(
                                                    "type" => "SizedBox",
                                                    "height" => 4.01
                                                ),*/
                                )
                            )
                        ),
                        /*
                                    array(
                                        "type"=> "Positioned",
                                        "top"=> 0,
                                        "right"=> 2,
                                        "child"=> array(
                                                "type" => "DecoratedContainer",
                                                "width" => 8,
                                                "height" => 8,
                                                "shape" => "Circle",
                                                "padding" => "2,2,2,2",
                                                "color" => "#ff0000",
                                                "child" => array(
                                                    "type"=> "Center",
                                                    "child"=>array(
                                                        "type" => "Text",
                                                        "textAlign" => "center",
                                                        "style" => array(
                                                            "fontSize" => 12,
                                                            "fontFamily" => "Hiragino",
                                                            "fontWeight" => "w800",
                                                            "color"=> "ffffff"
                                                        ),
                                                        "maxLines" => 1,
                                                        "overflow" => "ellipsis",
                                                        "data" => "100",
                                                    )
                                                )
                                            ),

                                    )
                                    */
                    )
                )



            );
            $result[] = $button;
        }
        foreach ($arr_module_disable as $module) {
            $button = array(
                "type" => "DecoratedContainer",
                "width" => 20,
                //"height" => 15.5,
                "click_event" => $module['click_event'],
                "child" => array(
                    "type" => "Stack",
                    //"clipBehavior"=> "none",
                    "fit" => "passthrough",
                    "children" => array(
                        array(
                            "type" => "DecoratedContainer",
                            "width" => 20,
                            "height" => 15
                        ),
                        array(
                            "type" => "Positioned",
                            "top" => 0.00,
                            "right" => 0.00,
                            "left" => 0.00,
                            "bottom" => 0.00,
                            "child" => array(
                                "type" => "Column",
                                "mainAxisSize" => "min",
                                "children" => array(
                                    array(
                                        "type" => "DecoratedContainer",
                                        "width" => 15,
                                        "height" => 10,
                                        "padding" => "8,8,8,8",
                                        "shape" => "Circle",
                                        "color" => "#cecece",
                                        "child" => array(
                                            "type" => "NetworkImage",
                                            "src" => $module['icon'],
                                            "color" => "#ffffff",
                                            "width" => $platform == 'ios' ? 58 : 24,
                                            "height" => $platform == 'ios' ? 58 : 24,
                                            "fit" => "contain"
                                        )
                                    ),
                                    /*array(
                                                    "type" => "SizedBox",
                                                    "height" => 4.01
                                                ),*/
                                    array(
                                        "type" => "Expanded",
                                        "child" => array(
                                            "type" => "Text",
                                            "textAlign" => "center",
                                            "style" => array(
                                                "fontSize" => 12,
                                                "fontFamily" => "Hiragino"
                                            ),
                                            "maxLines" => 2,
                                            "overflow" => "ellipsis",
                                            "data" => $module['name'],
                                        )
                                    ),
                                    /*array(
                                                    "type" => "SizedBox",
                                                    "height" => 4.01
                                                ),*/
                                )
                            )
                        ),
                        /*
                                    array(
                                        "type"=> "Positioned",
                                        "top"=> 0,
                                        "right"=> 2,
                                        "child"=> array(
                                                "type" => "DecoratedContainer",
                                                "width" => 8,
                                                "height" => 8,
                                                "shape" => "Circle",
                                                "padding" => "2,2,2,2",
                                                "color" => "#ff0000",
                                                "child" => array(
                                                    "type"=> "Center",
                                                    "child"=>array(
                                                        "type" => "Text",
                                                        "textAlign" => "center",
                                                        "style" => array(
                                                            "fontSize" => 12,
                                                            "fontFamily" => "Hiragino",
                                                            "fontWeight" => "w800",
                                                            "color"=> "ffffff"
                                                        ),
                                                        "maxLines" => 1,
                                                        "overflow" => "ellipsis",
                                                        "data" => "100",
                                                    )
                                                )
                                            ),

                                    )
                                    */
                    )
                )



            );
            $result[] = $button;
        }

        // return json_encode($result);
        return $result;
    }

    private function generateDynamicModule2($arr_module, $platform)
    {
        $result = array();
        foreach ($arr_module as $module) {
            $button = array(
                "type" => "DecoratedContainer",
                "width" => 0.2,
                "height" => 0.3,
                "click_event" => $module['click_event'],
                "child" => array(
                    "type" => "Column",
                    "children" => array(
                        array(
                            "type" => "DecoratedContainer",
                            "width" => 0.15,
                            "height" => 0.15,
                            "padding" => "8,8,8,8",
                            "shape" => "Circle",
                            "color" => "#002e75",
                            "child" => array(
                                "type" => "NetworkImage",
                                "src" => $module['icon'],
                                "color" => "#ffffff",
                                "width" => $platform == 'ios' ? 58 : 24,
                                "height" => $platform == 'ios' ? 58 : 24,
                                "fit" => "contain"
                            )
                        ),
                        array(
                            "type" => "SizedBox",
                            "height" => 4.01
                        ),
                        array(
                            "type" => "Expanded",
                            "child" => array(
                                "type" => "Text",
                                "textAlign" => "center",
                                "style" => array(
                                    "fontSize" => 14,
                                    "fontFamily" => "Hiragino"
                                ),
                                "maxLines" => 2,
                                "overflow" => "ellipsis",
                                "data" => $module['name'],
                            )
                        ),
                        array(
                            "type" => "SizedBox",
                            "height" => 4.01
                        ),
                    )
                )
            );
            $result[] = $button;
        }

        // return json_encode($result);
        return $result;
    }

    private function getPermissions($user_group_id = 0)
    {
        $result = array();
        $permission_list = array();

        $user_group_permission = $this->db->query("SELECT permission FROM " . DB_PREFIX . "user_group WHERE user_group_id = '" . (int) $user_group_id . "'");
        if ($user_group_permission->num_rows) {
            $result = json_decode($user_group_permission->row['permission'], true);

            $result = $result == null ? unserialize($user_group_permission->row['permission']) : $result;

            $result['access'][] = "account/logout";
            $menus = $this->getAppMenus();
            foreach ($menus as $menu) {
                if (in_array($menu['path'], $result['access'])) {
                    $permission_list['enable'][] = array(
                        "name" => $menu['name'],
                        "icon" => $menu['icon'],
                        "click_event" => $menu['click_event'],
                    );
                } else {
                    $permission_list['disable'][] = array(
                        "name" => $menu['name'],
                        "icon" => $menu['icon'],
                        "click_event" => '/permission-denied',
                    );
                }
                // if (in_array($menu['path'], $result['modify'])) {
                //     $permission_list[] = array(
                //         "name" => "Edit " . $menu['name'],
                //         "image" => "https://picsum.photos/100?random=$counter"
                //     );
                //     $counter++;
                // }
            }
        }
        if (empty($permission_list)) {
            return array();
        } else {
            return $permission_list;
        }
    }

    private function getMenus()
    {
        $result = array();

        $menus = $this->db->query("SELECT distinct(path) as path FROM " . DB_PREFIX . "admin_menu WHERE status = '1' ORDER BY path");

        if ($menus->num_rows) {
            $result = array_column($menus->rows, 'path');
        }

        return $result;
    }

    private function getAppMenus()
    {
        //todo db
        $menus = $this->module_enable;

        foreach ($menus as $key => $menu) {
            if ($this->session->data['language_id'] == '1') {
                $menus[$key]['name'] = $menu['en_name'];
            } else {
                $menus[$key]['name'] = $menu['cn_name'];
            }
        }
        return $menus;
    }
}
