<?php

class ControllerAndroidEwallet extends Controller {

    private $app_hash;
    private $call_back;
    private $call_function;
    private $currency;
    private $currency_code;
    private $hash;
    private $is_ver20;
    private $push_currency_code;
    private $store_id;
    private $s;
    private $opencart_version;
    private $post_data;

    const MODULE_CODE = 16;
    const MODULE_VERSION = '1.1.11';
    const DEBUG_MODE = false;
    const MOB_ASSIST_API_KEY = 'AIzaSyDIq4agB70Zv7AkB9pVuF2KxcU4WQ94CVI';

    public function index() {
        @date_default_timezone_get('UTC');
        $this->check_version();

        $this->load->model('android/setting');
        $this->load->model('android/connector');
        $this->load->model('android/brewing_quotation_api');
        $this->load->model('android/customer');

        $this->s = $this->model_android_brewing_quotation_api->getSetting('andassist');
        $this->config->set('config_language_id', $this->model_android_brewing_quotation_api->getlangugeId());

        if (!isset($this->s['andassist_status'])) {
            $data['error_code'] = [
                'error' => -1,
                'msj' => 'API disabled',
                'app_hash' => $this->app_hash
            ];
            return $this->generate_output($data);
        }

        $post = $this->request->post;
        $request = $this->request->request;

        if (isset($request['call_back']) && strlen($request['call_back']) > 0) {
            $this->call_back = $request['call_back'];
        }

        if (isset($request['call_function']) && strlen($request['call_function']) > 0) {
            $this->call_function = $request['call_function'];
        }

        if (isset($request['hash']) && strlen($request['hash']) > 0) {
            $this->hash = $request['hash'];
        }

        if (isset($request['app_hash']) && strlen($request['app_hash']) > 0) {
            $this->app_hash = $request['app_hash'];
        }

        if (empty($this->call_function)) {
            $this->run_self_test();
        }

        if (!$this->check_confing()) {
            $data['error_code'] = [
                'error' => -1,
                'msj' => 'API disable',
                'app_hash' => $this->app_hash
            ];
            return $this->generate_output($data);
        }

        if (!$this->check_auth()) {
            $data['error_code'] = [
                'error' => -2,
                'msj' => 'Password Not Match',
            ];
            return $this->generate_output($data);
        }

        if ($this->call_function == 'test_config') {
            return $this->generate_output(array('test' => 1));
        }

        $params = $this->_validate_types($request, array());

        foreach ($params as $k => $value) {
            $this->{$k} = $value;
        }

        $this->post_data = $post;

        foreach ($this->post_data as $k => $value) {
            $this->{$k} = $value;
        }

        if (empty($this->currency_code) || $this->currency_code == 'not_set') {
            $this->currency = '';
        } else if ($this->currency_code == 'base_currency') {
            $this->currency = $this->config->get('config_currency');
        } else {
            $this->currency = $this->currency_code;
        }

        print_r($this->currency_code);

        if (empty($this->push_currency_code) || $this->push_currency_code == 'not_set') {
            $this->push_currency_code = '';
        }

        if ($this->store_id == '') {
            $this->store_id = -1;
        }

        $this->store_id = intval($this->store_id);

        if (!method_exists($this, $this->call_function)) {
            return $this->generate_output('old_module');
        }

        $result = call_user_func(array($this, $this->call_function));
        return $this->generate_output($result);
    }

    private function check_version() {
        if (class_exists('MijoShop')) {
            $base = MijoShop::get('base');

            $installed_ms_version = (array) $base->getMijoshopVersion();
            $mijo_version = $installed_ms_version[0];
            if (version_compare($mijo_version, '3.0.0', '>=') && version_compare(VERSION, '2.0.0.0', '<')) {
                $this->opencart_version = '2.0.1.0';
            } else {
                $this->opencart_version = VERSION;
            }
        } else {
            $this->opencart_version = VERSION;
        }
        $this->is_ver20 = version_compare($this->opencart_version, '2.0.0', '>=');
    }

    private function check_confing() {
        $this->load->model('android/brewing_quotation_api');
        $this->s = $this->model_android_brewing_quotation_api->getSetting('andassist');

        if (isset($this->request->request['app_hash'])) {
            if (md5($this->s['andassist_login'] . $this->s['andassist_pass']) == $this->request->request['app_hash'] && $this->s['andassist_status'] == 1) {
                return true;
            }
        }
        return false; //return true or false only can be one, either one return, the other one will stop.
    }

    private function check_auth() {
        $userColData = $this->revers_base64($this->hash);
        $user_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "user WHERE username = '" . $this->db->escape($userColData['user_name']) . "' AND (password = SHA1(CONCAT(salt, SHA1(CONCAT(salt, SHA1('" . $this->db->escape($userColData['password']) . "'))))) OR password = '" . $this->db->escape(md5($userColData['password'])) . "') AND status = 1 AND position = '2'");
        if ($user_query->num_rows) {
            $store_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "user_to_store s LEFT JOIN " . DB_PREFIX . "setting l ON (s.store_id = l.store_id) WHERE s.user_id = '" . (int) $user_query->row['user_id'] . "' AND s.store_id = '" . $userColData['store_id'] . "' AND l.key = 'config_language'");
            if ($store_query->num_rows) {
                if (strtotime($user_query->row['periodto']) > strtotime(date("Y-m-d"))) {
                    return true;
                } else {
                    return false;
                }
            }
        }
        return false;
    }

    private function revers_base64($data) {
        $user_info = base64_decode($data);
        $userColData = json_decode($user_info, true);
        return $userColData;
    }

    private function _validate_types($array, $names) {
        foreach ($names as $name => $type) {
            if (isset($array["$name"])) {
                switch ($type) {
                    case 'INT':
                        $array["$name"] = intval($array["$name"]);
                        break;
                    case 'FLOAT':
                        $array["$name"] = floatval($array["$name"]);
                        break;
                    case 'STR':
                        $array["$name"] = str_replace(array("\r", "\n"), ' ', addslashes(htmlspecialchars(trim(url_encode($array["$name"])))));
                        break;
                    default:
                        $array["$name"] = '';
                }
            } else {
                $array["$name"] = '';
            }
        }
        return $array;
    }

    private function generate_output($data) {
        $add_bridge_version = false;

        if (in_array($this->call_function, array("test_config", "get_store_title", "get_store_stats", "get_data_graphs"))) {
            if (is_array($data) && $data != 'auth_error' && $data != 'connection_error' && $data != 'old_bridge') {
                $add_bridge_version = true;
            }
        }

        if (!is_array($data)) {
            $data = array($data);
        }

        if ($add_bridge_version) {
            $data['module_version'] = self::MODULE_CODE;
        }

        if (is_array($data)) {
            //array_walk_recursive($data, array($this, 'reset_null'));
        }

        $data = json_encode($data);

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput($data);
    }

    public function setOutput($output) {
        $this->output = $output;
    }

    public function setHeader($header) {
        $this->headers = array();
        if (is_array($header)) {
            foreach ($header as $h)
                $this->headers[] = $h;
        } else {
            $this->headers[] = $header;
        }
    }

    private function reset_null(&$item) {
        if (empty($item) && $item != 0) {
            $item = '';
        }

        // $item = trim($item);

        $item = $item;
    }

    /**
     * options[getTermAndConditions][get][']=get term & conditions
     * options[getTermAndConditions][get][security]=private
     * options[getTermAndConditions][get][response]=[{
      terms: link or html
      }]
     */
    private function getTermAndConditions() {
        $json = [];
        $data = [];
        $path = 'etcm/ewallet/getTermAndConditions';

        $data['filter_type'] = !empty($this->request->get['filter_type']) ? $this->request->get['filter_type'] : 'link';
        $data['filter_information_id'] = !empty($this->request->get['filter_information_id']) ? $this->request->get['filter_information_id'] : 0;

        $result = $this->curlAPI($path, $data);
        $json['terms'] = null;
        if (!empty($result)) {
            $json['terms'] = ($data['filter_type'] == 'link') ? $result[0] : $result;
            $json['error_code'] = array(
                'error' => 0,
                'msj' => 'succes',
            );
        } else {
            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'No results found !',
            );
        }

        return $json;
    }

    /**
     * options[getDateFilter][get][']=get customer transaction history date filter
     * options[getDateFilter][get][security]=private
     * options[getDateFilter][get][response]=[{
      name:
      value:
      }]
     */
    private function getDateFilter() {
        $json = [];
        $data = [];
        $path = 'etcm/ewallet/getDateFilter';

        $result = $this->curlAPI($path, $data);
        $json['filters'] = null;
        if (!empty($result)) {
            $json['filters'] = $result;
            $json['error_code'] = array(
                'error' => 0,
                'msj' => 'succes',
            );
        } else {
            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'No results found !',
            );
        }

        return $json;
    }

    /**
     * options[getCustomerTransactionHistory][get][']=get customer transaction history
     * options[getCustomerTransactionHistory][get][security]=private
     * options[getCustomerTransactionHistory][get][response]=[{
      customer_transaction_history: int
      invoice_prefix: string
      payment_address: string
      payment_method: string
      payment_method_code: string
      payment: string
      description: string
      amount: float/decimal
      total : float/decimal
      status: int
      }]
     */
    private function getCustomerTransactionHistoryDetails() {
        $json = [];
        $path = 'etcm/ewallet/getCustomerTransactionHistoryDetails';
        $user_info = $this->revers_base64($this->hash);

        if (empty($user_info['user_id']) && empty($user_info['store_id'])) {
            return $json['error_code'] = array(
                'error' => 1,
                'msj' => 'Empty User ID !',
            );
        }

        $filter_data['filter_customer_transaction_id'] = !empty($this->request->post['filter_customer_transaction_id']) ? $this->request->post['filter_customer_transaction_id'] : 0;
        if (empty($filter_data['filter_customer_transaction_id'])) {
            return $json['error_code'] = array(
                'error' => 1,
                'msj' => 'Empty Customer Transaction ID !',
            );
        }

        $customer = $this->getCustomerDetails($user_info['user_id'], $user_info['store_id']);

        $data = array_merge($filter_data, $customer);

        $result = $this->curlAPI($path, $data);
        
        $json['transactions'] = null;
        if (!empty($result)) {
            $json['transactions'] = $result[0];
            $json['error_code'] = array(
                'error' => 0,
                'msj' => 'succes',
            );
        } else {
            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'No results found !',
            );
        }

        return $json;
    }

    /**
     * options[getCustomerTransactionHistory][get][']=get customer transaction history
     * options[getCustomerTransactionHistory][get][security]=private
     * options[getCustomerTransactionHistory][get][response]=[{
      customer_transaction_history: int
      invoice_prefix: string
      payment_address: string
      payment_method: string
      payment_method_code: string
      payment: string
      description: string
      amount: float/decimal
      total : float/decimal
      status: int
      }]
     */
    private function getCustomerTransactionHistory() {
        $json = [];
        $path = 'etcm/ewallet/getCustomerTransactionHistory';
        $user_info = $this->revers_base64($this->hash);

        if (empty($user_info['user_id']) && empty($user_info['store_id'])) {
            return $json['error_code'] = array(
                'error' => 1,
                'msj' => 'Empty User ID !',
            );
        }

        $filter_data['filter_date_type'] = !empty($this->request->get['filter_date_type']) ? $this->request->get['filter_date_type'] : '';
        $filter_data['filter_date_start'] = !empty($this->request->get['filter_date_start']) ? $this->request->get['filter_date_start'] : date('Y-m-d');
        $filter_data['filter_date_end'] = !empty($this->request->get['filter_date_end']) ? $this->request->get['filter_date_end'] : date('Y-m-d');
        $filter_data['page'] = isset($this->request->get['page']) ? $this->request->get['page'] : false;
        $filter_data['show'] = isset($this->request->get['show']) ? $this->request->get['show'] : false;

        $customer = $this->getCustomerDetails($user_info['user_id'], $user_info['store_id']);

        $data = array_merge($filter_data, $customer);

        // echo"<pre>";
        // print_r($data);
        // echo"</pre>";

        $result = $this->curlAPI($path, $data);
        $json['transactions'] = null;
        if (!empty($result)) {
            $json['transactions'] = $result;
            $json['error_code'] = array(
                'error' => 0,
                'msj' => 'succes',
            );
        } else {
            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'No results found !',
            );
        }

        return $json;
    }

    /**
     * options[getCustomerEwalletDetails][get][']=get customer e-wallet details
     * options[getCustomerEwalletDetails][get][security]=private
     * options[getCustomerEwalletDetails][get][response]=[{
     * 
      customer_id: int
      customer_name : string,
      telephone : string,
      ewallet_amount : decimal/float,
      total : decimal/float,
      }]
     */
    private function getCustomerEwalletDetails() {
        $json = [];
        $path = 'etcm/ewallet/getCustomerEwalletDetails';
        $user_info = $this->revers_base64($this->hash);

        if (empty($user_info['user_id']) && empty($user_info['store_id'])) {
            return $json['error_code'] = array(
                'error' => 1,
                'msj' => 'Empty User ID !',
            );
        }

        $customer = $this->getCustomerDetails($user_info['user_id'], $user_info['store_id']);

        $result = $this->curlAPI($path, $customer);
        if (!empty($result)) {
            $json = $result;
            $json['error_code'] = array(
                'error' => 0,
                'msj' => 'succes',
            );
        } else {
            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'No results found !',
            );
        }

        return $json;
    }

    /**
     * options[getDefaultTopUpAmountList][get][']=get default pre set topup amount list
     * options[getDefaultTopUpAmountList][get][security]=private
     * options[getBrewingList][get][response]=[{
     * 
      50, 10, 200
      }]
     */
    private function getDefaultTopUpAmountList() {
        $json = [];
        $path = 'etcm/ewallet/getDefaultTopAmountList';

        $data = [];

        $result = $this->curlAPI($path, $data);
        if (!empty($result)) {
            $json['deafult_topup_amount_list'] = $result;
            $json['error_code'] = array(
                'error' => 0,
                'msj' => 'succes',
            );
        } else {
            $json['error_code'] = array(
                'error' => 1,
                'msj' => 'No results found !',
            );
        }

        return $json;
    }

    protected function getCustomerDetails($user_id, $store_id) {
        $data = [];

        $this->load->model('android/connector');
        $user_info = $this->model_android_connector->getBrewUserInfo($user_id);
        $store_info = $this->model_android_connector->getBrewSetting('config', $store_id);

        $data = [
            'user_id' => $user_info['user_id'],
            'firstname' => $user_info['firstname'],
            'lastname' => $user_info['lastname'],
            'ic' => $user_info['ic'],
            'email' => $user_info['email'],
            'store_name' => $store_info['config_name'],
            'store_url' => HTTP_SERVER,
        ];

        return $data;
    }

    protected function curlAPI($path, $data) {

        // echo '<pre>';
        // print_r($data);
        // echo '</pre>';

        $hash = $this->config->get('etcm_hash');

        $url = HTTP_API . 'index.php?route=' . $path . '&hash=' . $hash;

        $hash = $this->config->get('etcm_hash');

        $curl = curl_init();

        // Set SSL if required
        if (substr(HTTP_API, 0, 5) == 'https') {
            curl_setopt($curl, CURLOPT_PORT, 443);
        }

        curl_setopt($curl, CURLOPT_HEADER, false);
        curl_setopt($curl, CURLINFO_HEADER_OUT, true);
        curl_setopt($curl, CURLOPT_USERAGENT, $this->request->server['HTTP_USER_AGENT']);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($curl, CURLOPT_FORBID_REUSE, false);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($data));

        $response = curl_exec($curl);

        // echo '<pre>';
        // print_r($response);
        // echo '</pre>';

        $result = json_decode($response, true);

        return $result;
    }

}
