<?php

class ControllerAndroidEtcmSetting extends Controller
{
    private $error = [];
    private $selected_facility = 0;
    public function get_data()
    {
        $result = [
            'store_url'             => HTTPS_SERVER,
            'store_info'            => $this->getStoreData(),
            'openings'              => $this->getOpeningData(),
            'holidays'              => $this->getHolidayData(),
            'doctor_holidays'       => $this->getDoctorHolidayData(),
            'users'                 => $this->getUserData(),
            'services'              => $this->getServicesData(),
            'facilities'            => $this->getFacilitiesData(),
            'doctor_availabilities' => $this->getDoctorAvailabilitiesData()
        ];
        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($result));
    }

    //     _____      _            _         ______                _   _             
    //    |  __ \    (_)          | |       |  ____|              | | (_)            
    //    | |__) | __ ___   ____ _| |_ ___  | |__ _   _ _ __   ___| |_ _  ___  _ __  
    //    |  ___/ '__| \ \ / / _` | __/ _ \ |  __| | | | '_ \ / __| __| |/ _ \| '_ \ 
    //    | |   | |  | |\ V / (_| | ||  __/ | |  | |_| | | | | (__| |_| | (_) | | | |
    //    |_|   |_|  |_| \_/ \__,_|\__\___| |_|   \__,_|_| |_|\___|\__|_|\___/|_| |_|
    //

    private function getStoreData()
    {
        $db_stores = $this->db->query("SELECT * FROM " . DB_PREFIX . "store")->rows;
        $store_ids = array_column($db_stores, 'store_id');
        array_unshift($store_ids, "0");

        $stores = [];
        foreach ($store_ids as $store_id) {

            $configs = $this->db->query("SELECT * FROM " . DB_PREFIX . "setting WHERE store_id = '" . (int)$store_id . "' AND code = 'config'")->rows;

            $info = [];
            foreach ($configs as $cnf) {
                $info[$cnf['key']] = $cnf['serialized'] == '1' ? json_decode($cnf['value'], true) : $cnf['value'];
            }

            if (empty($info)) {
                continue;
            }

            if ($store_id == '0') {
                $info['config_url'] = HTTPS_SERVER;
            }

            $stores[] = [
                'store_id'                    => $store_id,
                'config_owner'                => !empty($info['config_owner']) ? $info['config_owner'] : '',
                'config_telephone'            => !empty($info['config_telephone']) ? $info['config_telephone'] : '',
                'config_name'                => !empty($info['config_name']) ? $info['config_name'] : '',
                'config_url'                => !empty($info['config_url']) ? $info['config_url'] : '',
                'config_address'            => !empty($info['config_address']) ? $info['config_address'] : '',
                'config_store_city'            => !empty($info['config_store_city']) ? $info['config_store_city'] : '',
                'config_store_postcode'        => !empty($info['config_store_postcode']) ? $info['config_store_postcode'] : '',
                'config_store_country_id'    => !empty($info['config_store_country_id']) ? $info['config_store_country_id'] : '',
                'config_store_zone_id'        => !empty($info['config_store_zone_id']) ? $info['config_store_zone_id'] : '',
                'config_store_latitude'        => !empty($info['config_store_latitude']) ? $info['config_store_latitude'] : '',
                'config_store_longitude'    => !empty($info['config_store_longitude']) ? $info['config_store_longitude'] : '',
                'config_store_description'    => !empty($info['config_store_description']) ? $info['config_store_description'] : '',
            ];
        }

        return $stores;
    }

    private function getOpeningData()
    {
        $db_openings = $this->db->query("SELECT * FROM " . DB_PREFIX . "store_opening")->rows;
        $openings = [];

        foreach ($db_openings as $opening) {
            $db_times = $this->db->query("SELECT * FROM " . DB_PREFIX . "store_opening_time WHERE store_opening_id = '" . (int)$opening['store_opening_id'] . "'")->rows;
            $openings[] = [
                "store_id"  => $opening['store_id'],
                'day'       => $opening['day'],
                'times'     => $db_times
            ];
        }
        return $openings;
    }

    private function getHolidayData()
    {
        $db_holidays = $this->db->query("SELECT * FROM " . DB_PREFIX . "store_holiday WHERE end >= '" . $this->db->escape(date('Y-m-d')) . "'")->rows;

        return $db_holidays;
    }

    private function getDoctorHolidayData()
    {
        $db_doctor_holidays = $this->db->query("SELECT * FROM " . DB_PREFIX . "user_holiday WHERE end >= '" . $this->db->escape(date('Y-m-d')) . "'")->rows;

        return $db_doctor_holidays;
    }

    private function getUserData()
    {
        $db_users = $this->db->query("SELECT * FROM " . DB_PREFIX . "user")->rows;
        $users = [];
        foreach ($db_users as $user) {
            $user_desc = $this->db->query("SELECT * FROM " . DB_PREFIX . "user_description WHERE user_id = '" . (int)$user['user_id'] . "'")->row;
            $treatments = $this->db->query("SELECT * FROM " . DB_PREFIX . "user_treatment WHERE user_id = '" . (int)$user['user_id'] . "'")->rows;

            $image = !empty($user['image']) ? HTTPS_IMAGE . $user['image'] : '';
            $users[] = [
                'user_id'               => $user['user_id'],
                'firstname'             => $user['firstname'],
                'lastname'              => $user['lastname'],
                'chinesename'           => $user['chinesename'],
                'image'                 => $image,
                'telephone'             => $user['contactno'],
                'gender'                => $user['gender'],
                'user_position'         => $user['position'],
                'position'              => !empty($user_desc['position']) ? $user_desc['position'] : '',
                'professions'           => !empty($user_desc['professions']) ? $user_desc['professions'] : '',
                'description'           => !empty($user_desc['description']) ? $user_desc['description'] : '',
                'sort_order'            => $user['doctor_sort_order'],
                'enable_appointment'    => $user['enable_appointment'],
                'show_for_appointment'  => $user['show_for_appointment'],
                'status'                => $user['status'],
                'treatments'            => $treatments
            ];
        }

        return $users;
    }

    private function getServicesData()
    {
        $db_services = $this->db->query("SELECT cs.*, en.name AS en_name, cn.name AS cn_name FROM " . DB_PREFIX . "clinical_service cs 
        LEFT JOIN " . DB_PREFIX . "clinical_service_description en ON(en.clinicalservice_id = cs.clinicalservice_id AND en.language_id = '1') 
        LEFT JOIN " . DB_PREFIX . "clinical_service_description cn ON(cn.clinicalservice_id = cs.clinicalservice_id AND cn.language_id = '2')")->rows;
        $services = [];
        foreach ($db_services as $service) {

            $service_id = $service['clinicalservice_id'];

            $db_stores = $this->db->query("SELECT * FROM " . DB_PREFIX . "service_to_store WHERE service_id = '" . (int)$service_id . "'")->rows;
            $stores = [];
            if (!empty($db_stores)) {
                foreach ($db_stores as $store) {
                    $stores[] = [
                        'service_id'    => $service_id,
                        'store_id'   => $store['store_id']
                    ];
                }
            } else {
                foreach (unserialize($service['store_id']) as $id) {
                    $stores[] = [
                        'service_id'   => $service_id,
                        'store_id'     => $id
                    ];
                }
            }

            $db_doctors = $this->db->query("SELECT * FROM " . DB_PREFIX . "service_to_doctor WHERE service_id = '" . (int)$service_id . "'")->rows;
            $doctors = [];
            if (!empty($db_doctors)) {
                foreach ($db_doctors as $doctor) {
                    $doctors[] = [
                        'service_id'    => $service_id,
                        'doctor_id'   => $doctor['doctor_id']
                    ];
                }
            } else {
                foreach (unserialize($service['doctor_id']) as $id) {
                    $doctors[] = [
                        'service_id'    => $service_id,
                        'doctor_id'     => $id
                    ];
                }
            }

            $db_facilities = $this->db->query("SELECT * FROM " . DB_PREFIX . "service_to_facility WHERE service_id = '" . (int)$service_id . "'")->rows;
            $facilities = [];
            foreach ($db_facilities as $facility) {
                $facilities[] = [
                    'service_id'    => $service_id,
                    'facility_id'   => $facility['facility_id']
                ];
            }

            $services[] = [
                'service_id'    => $service_id,
                'en_name'       => $service['en_name'],
                'cn_name'       => $service['cn_name'],
                'minute'        => $service['cs_minute'],
                'type'          => $service['type'],
                'stores'        => $stores,
                'doctors'       => $doctors,
                'facilities'    => $facilities,
            ];
        }

        return $services;
    }

    private function getFacilitiesData()
    {
        $db_facilities = $this->db->query("SELECT * FROM " . DB_PREFIX . "facility")->rows;
        $facilities = [];
        foreach ($db_facilities as $facility) {
            $db_availabilities = $this->db->query("SELECT * FROM " . DB_PREFIX . "facility_availability WHERE facility_id = '" . (int)$facility['facility_id'] . "'")->rows;
            $facilities[] = [
                'facility_id'       => $facility['facility_id'],
                'store_id'          => $facility['store_id'],
                'name'              => $facility['name'],
                'available'         => $facility['available'],
                'status'            => $facility['status'],
                'availabilities'    => $db_availabilities,
            ];
        }

        return $facilities;
    }

    private function getDoctorAvailabilitiesData()
    {
        $db_availabilities = $this->db->query("SELECT * FROM " . DB_PREFIX . "appointment_availability")->rows;
        $doctor_availabilities = [];
        foreach ($db_availabilities as $availability) {
            $db_times = $this->db->query("SELECT * FROM " . DB_PREFIX . "appointment_availability_time WHERE availability_id = '" . (int)$availability['availability_id'] . "'")->rows;
            $db_services = $this->db->query("SELECT * FROM " . DB_PREFIX . "availability_to_service WHERE availability_id = '" . (int)$availability['availability_id'] . "'")->rows;
            $doctor_availabilities[] = [
                'availability_id'   => $availability['availability_id'],
                'doctor_id'         => $availability['doctor_id'],
                'store_id'          => $availability['store_id'],
                'minutes'           => $availability['minutes'],
                'day'               => $availability['day'],
                'times'             => $db_times,
                'services'          => $db_services,
            ];
        }

        return $doctor_availabilities;
    }
}
