<?php

class ControllerAndroidEtcmServicePartner extends Controller
{
    public function check_purchase_orders()
    {
        date_default_timezone_set("Asia/Kuala_Lumpur");
        $this->load->model('android/etcm/service_partner');
        $this->load->library('api');
        $json = $this->get_php_input_json();
        $id_exist = [];

        foreach ($json as $data) {
            $this->model_android_etcm_service_partner->checkPO($data);
            $etcm_purchase_order_id = $data['etcm_purchase_order_id'];
            $po_exist = $this->model_android_etcm_service_partner->getPOByEtcmId($etcm_purchase_order_id);
            if (!empty($po_exist)) {
                $id_exist[] = $etcm_purchase_order_id;
            }
        }

        $result = [
            "error"     => false,
            "code"      => "200",
            "message"   => "success",
            "response"  => [
                "id" => $id_exist
            ]
        ];

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($result));
        return;
    }

    public function check_sale_orders()
    {
        date_default_timezone_set("Asia/Kuala_Lumpur");
        $this->load->model('android/etcm/service_partner');
        $this->load->library('api');
        $json = $this->get_php_input_json();
        $id_exist = [];

        foreach ($json as $data) {
            $this->model_android_etcm_service_partner->checkSO($data);
            $etcm_purchase_order_id = $data['etcm_purchase_order_id'];
            $so_exist = $this->model_android_etcm_service_partner->getSOByEtcmId($etcm_purchase_order_id);
            if (!empty($so_exist)) {
                $id_exist[] = $etcm_purchase_order_id;
            }
        }

        $result = [
            "error"     => false,
            "code"      => "200",
            "message"   => "success",
            "response"  => [
                "id" => $id_exist
            ]
        ];

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($result));
        return;
    }

    public function get_php_input_json()
    {
        $jsonString = file_get_contents('php://input');
        $json = json_decode($jsonString, true);
        $result = is_array($json) ? $json : array();

        return $this->clean($result);
    }

    private function clean($data)
    {
        if (is_array($data)) {
            foreach ($data as $key => $value) {
                unset($data[$key]);

                $data[$this->clean($key)] = $this->clean($value);
            }
        } else {
            $data = htmlspecialchars($data, ENT_COMPAT, 'UTF-8');
        }

        return $data;
    }
}
