<?php

class ControllerAndroidEtcmAppointment extends Controller
{
    private $error = [];
    private $selected_facility = 0;

    public function check_availability()
    {
        date_default_timezone_set("Asia/Kuala_Lumpur");
        $this->update_table();
        $this->load->library('api');
        $json = $this->api->get_php_input_json();
        $doctor_id  = !empty($json['doctor_id']) ? $json['doctor_id'] : 0;
        $store_id   = !empty($json['store_id']) ? $json['store_id'] : 0;
        $service_id = !empty($json['service_id']) ? $json['service_id'] : 0;

        $start_date = !empty($json['start_date']) ? $json['start_date'] : '';
        $end_date   = !empty($json['end_date']) ? $json['end_date'] : '';

        if (empty($start_date) && empty($end_date)) {
            $start_date = date('Y-m-01');
            $end_date = date('Y-m-t');
        }
        $this->load->model('android/etcm/appointment');

        $filters = [
            'store_id'      => $store_id,
            'doctor_id'     => $doctor_id,
            'service_id'    => $service_id,
            'start_date'    => $start_date,
            'end_date'      => $end_date,
        ];
        $appointments = $this->model_android_etcm_appointment->getAppointments($filters);

        $results = [];

        foreach ($appointments as $key => $appt) {

            $appt['start_time'] = date("H:i", strtotime($appt['appointment_time']));
            $appt['end_time'] = date("H:i", strtotime($appt['appointment_time']) + (60 * $appt['service_minute']));

            $results[] = $appt;
        }
        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($results));
    }

    public function add_appointment()
    {
        date_default_timezone_set("Asia/Kuala_Lumpur");
        $this->update_table();
        $this->load->model('android/etcm/appointment');
        $this->load->library('api');
        $json = $this->api->get_php_input_json();

        // $result = [
        //     "error"     => true,
        //     "code"      => "500",
        //     "message"   => "Something went wrong",
        //     "response"  => $json
        // ];
        // $this->response->addHeader('Content-Type: application/json');
        // $this->response->setOutput(json_encode($result));
        // return;

        if (empty($json)) {
            $result = [
                "error"     => true,
                "code"      => "400",
                "message"   => "Empty Json",
                "response"  => []
            ];
        } elseif ($this->validateAdd($json)) {
            $proceed = true;


            $slot_booked = $this->slotBooked($json);

            if ($slot_booked) {
                $proceed = false;
            }

            if ($proceed) {
                $data = [
                    "store_id"          => !empty($json['store_id']) ? $json['store_id'] : 0,
                    "customer_id"       => !empty($json['customer_id']) ? $json['customer_id'] : 0,
                    "customer_name"     => $json['customer_name'],
                    "customer_ic"       => !empty($json['customer_ic']) ? $json['customer_ic'] : '',
                    "email"             => $json['email'],
                    "telephone"         => $json['telephone'],
                    "service_id"        => $json['service_id'],
                    "facility_id"       => $this->selected_facility,
                    "etcm_app_id"       => $json['etcm_app_id'],
                    "appointment_date"  => $json['appointment_date'],
                    "appointment_time"  => $json['appointment_time'],
                    "doctor_id"         => $json['doctor_id'],
                    "remark"            => !empty($json['remark']) ? trim($json['remark']) : null,
                ];
                $appointment_id = $this->model_android_etcm_appointment->addAppointment($data);

                if ($appointment_id) {
                    $app_info = $this->model_android_etcm_appointment->getAppointment($appointment_id);
                    $this->sendNotificationToDoctor($app_info);

                    $result = [
                        "error"     => false,
                        "code"      => "200",
                        "message"   => "Appointment booked !",
                        "response"  => ["appointment_id" => $appointment_id]
                    ];
                } else {
                    $result = [
                        "error"     => true,
                        "code"      => "500",
                        "message"   => "Something went wrong",
                        "response"  => []
                    ];
                }
            } else {
                $result = [
                    "error"     => true,
                    "code"      => "400",
                    "message"   => $this->error ? $this->error : "Appointment slot already taken",
                    "response"  => []
                ];
            }
        } else {
            $result = [
                "error" => true,
                "code"  => "400",
                "message"   => "Missing parameter",
                "response"  => ['error_msg' => $this->error]
            ];
        }
        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($result));
        return;
    }

    public function cancel_appointment()
    {
        date_default_timezone_set("Asia/Kuala_Lumpur");
        $this->update_table();
        $this->load->model('android/etcm/appointment');
        $this->load->library('api');
        $json = $this->api->get_php_input_json();

        if (empty($json)) {
            $result = [
                "error"     => true,
                "code"      => "400",
                "message"   => "Empty Json",
                "response"  => []
            ];
        } elseif ($this->validateCancel($json)) {
            $appointment_id = $this->model_android_etcm_appointment->cancelAppointment($json);
            if ($appointment_id) {
                $app_info = $this->model_android_etcm_appointment->getAppointment($appointment_id);
                $this->sendNotificationToDoctor($app_info);

                $result = [
                    "error"     => false,
                    "code"      => "200",
                    "message"   => "Appointment cancelled !",
                    "response"  => ["appointment_id" => $appointment_id]
                ];
            } else {
                $result = [
                    "error"     => true,
                    "code"      => "500",
                    "message"   => "Something went wrong",
                    "response"  => []
                ];
            }
        } else {
            $result = [
                "error" => true,
                "code"  => "400",
                "message"   => "Missing parameter",
                "response"  => ['error_msg' => $this->error]
            ];
        }
        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($result));
        return;
    }

    //     _____      _            _         ______                _   _             
    //    |  __ \    (_)          | |       |  ____|              | | (_)            
    //    | |__) | __ ___   ____ _| |_ ___  | |__ _   _ _ __   ___| |_ _  ___  _ __  
    //    |  ___/ '__| \ \ / / _` | __/ _ \ |  __| | | | '_ \ / __| __| |/ _ \| '_ \ 
    //    | |   | |  | |\ V / (_| | ||  __/ | |  | |_| | | | | (__| |_| | (_) | | | |
    //    |_|   |_|  |_| \_/ \__,_|\__\___| |_|   \__,_|_| |_|\___|\__|_|\___/|_| |_|
    //

    private function sendNotificationToDoctor($info)
    {
        $this->load->model('android/common/notification');
        $doctor_id = $info['doctor_id'];

        $language_id = $this->model_android_common_notification->getUserLanguageId($doctor_id);

        $notification = $this->generateNotification($info, $language_id);

        $app_url = $this->model_android_common_notification->getNotificationDataUrl('doctorapp', 'appointment');
        $data = array("url" => str_replace(':id', $info['appointment_id'], $app_url));

        $module = 'appointment';
        $action = '';

        switch ($info['status']) {
            case "0":
                $action = "new";
                break;
            case "1":
                $action = "confirm";
                break;
            case "2":
                $action = "cancel";
                break;
            case "3":
                $action = "attend";
                break;
            default:
                $action = "";
        }

        $params = array(
            "user_id"   => $doctor_id,
            "notification"  => $notification,
            "notification_type" => 'appointment',
            "data"  => $data,
            "module" => $module,
            "action" => $action
        );
        $this->load->controller('android/common/notification/push', $params);

        //send to additional user if got
        $add_user_ids = [];
        $app_setting = $this->db->query("SELECT * FROM " . DB_PREFIX . "appointment_setting WHERE setting_key = 'additional_notification'")->row;
        if (!empty($app_setting)) {
            if ($app_setting['serialized'] == '1') {
                $add_user_ids = unserialize($app_setting['value']);
            } else {
                $add_user_ids = $app_setting['value'];
            }
        }

        foreach ($add_user_ids as $user_id) {
            $language_id = $this->model_android_common_notification->getUserLanguageId($user_id);
            $notification = $this->generateNotification($info, $language_id);
            $app_url = $this->model_android_common_notification->getNotificationDataUrl('doctorapp', 'appointment');
            $data = array("url" => str_replace(':id', $info['appointment_id'], $app_url));

            $params = array(
                "user_id" => $user_id,
                "notification" => $notification,
                "notification_type" => 'appointment',
                "data" => $data
            );
            $this->load->controller('android/common/notification/push', $params);
        }
    }

    private function generateNotification($info, $language_id)
    {
        switch ($info['status']) {
            case "0":
                $title_en = 'You got new appointment !';
                $title_cn = '你有一个新的预约!';

                $body_en = 'Click to see detail';
                $body_cn = '点击查看详情';
                break;
            case "2":
                $title_en = 'Appointment Cancelled!';
                $title_cn = '预约已取消！';

                $body_en = 'Booking Slot : ' . $info['appointment_time'] . ' on ' . date("j M y", strtotime($info['appointment_date']));
                $body_cn = 'Booking Slot : ' . $info['appointment_time'] . ' on ' . date("j M y", strtotime($info['appointment_date']));
                break;
            default:
                $title_en = 'Your Appointment have been updated !';
                $title_cn = '您的预约已更新！';

                $body_en = 'Click to see detail';
                $body_cn = '点击查看详情';
        }
        return array(
            'title' => $language_id == '1' ? $title_en : $title_cn,
            'body' => $language_id == '1' ? $body_en : $body_cn,
        );
    }

    private function update_table()
    {
        $column_exist = $this->db->query("DESCRIBE " . DB_PREFIX . "appointment facility_id")->num_rows;

        if (!$column_exist) {
            $this->db->query("ALTER TABLE " . DB_PREFIX . "appointment ADD `facility_id` INT NOT NULL AFTER `clinicalservice_id`");
        }

        $column_exist2 = $this->db->query("DESCRIBE " . DB_PREFIX . "appointment customer_ic")->num_rows;

        if (!$column_exist2) {
            $this->db->query("ALTER TABLE `oc_appointment` ADD `customer_ic` VARCHAR(255) NOT NULL AFTER `customer_name`");
        }

        $column_exist3 = $this->db->query("DESCRIBE " . DB_PREFIX . "appointment hide")->num_rows;

        if (!$column_exist3) {
            $this->db->query("ALTER TABLE " . DB_PREFIX . "appointment ADD `hide` INT NOT NULL AFTER `from_etcm`");
        }
    }

    private function validateAdd($data)
    {
        if (empty($data['customer_name'])) {
            $this->error['customer_name'] = "Customer name required!";
        }
        if (empty($data['telephone'])) {
            $this->error['telephone'] = "Telephone required!";
        }
        if (empty($data['service_id'])) {
            $this->error['service_id'] = "Service id required!";
        }
        if (empty($data['etcm_app_id'])) {
            $this->error['etcm_app_id'] = "ETCM app id required!";
        }
        if (empty($data['appointment_date'])) {
            $this->error['appointment_date'] = "Appointment date required!";
        }
        if (empty($data['appointment_time'])) {
            $this->error['appointment_time'] = "Aappointment time required!";
        }
        if (empty($data['doctor_id'])) {
            $this->error['doctor_id'] = "Doctor id required!";
        }
        // if (empty($data['customer_ic'])) {
        //     $this->error['customer_ic'] = "Customer ic required!";
        // }

        return !$this->error;
    }

    private function validateCancel($data)
    {
        if (empty($data['etcm_app_id'])) {
            $this->error['etcm_app_id'] = "ETCM app id required!";
        }
        return !$this->error;
    }

    private function slotBooked($data)
    {
        $service_id = !empty($data['service_id']) ? $data['service_id'] : null;
        $store_id = !empty($data['store_id']) ? $data['store_id'] : 0;
        $doctor_id = !empty($data['doctor_id']) ? $data['doctor_id'] : null;
        $date = !empty($data['appointment_date']) ? $data['appointment_date'] : null;
        $time = !empty($data['appointment_time']) ? $data['appointment_time'] : null;
        $app_start_time = strtotime($time);

        $app_day = date('l', strtotime($date));

        //check doctor slot
        $sql = "SELECT a.*, s.cs_minute AS service_minute FROM " . DB_PREFIX . "appointment a 
            LEFT JOIN " . DB_PREFIX . "clinical_service s ON(a.clinicalservice_id = s.clinicalservice_id)
            WHERE 1 
            AND a.status <> '2'
            AND a.hide = '0'
            AND a.store_id = '" . (int)$store_id . "'
            AND a.doctor_id = '" . (int)$doctor_id . "'
            AND a.appointment_date = '" . $this->db->escape($date) . "'";
        $query = $this->db->query($sql);
        foreach ($query->rows as $row) {
            $start_time = strtotime($row['appointment_time']);
            $end_time = $start_time + ($row['service_minute'] * 60);
            $app_end_time = $app_start_time + ($row['service_minute'] * 60);

            if ($app_start_time >= $start_time && $app_start_time < $end_time) {
                $this->error = "The doctor already booked by others for the selected date & time !";
                return true;
            }

            if ($app_end_time > $start_time && $app_end_time <= $end_time) {
                $this->error = "The doctor already booked by others for the selected date & time !!";
                return true;
            }

            if ($start_time >= $app_start_time && $end_time <= $app_end_time) {
                $this->error = "The doctor already booked by others for the selected date & time !!!";
                return true;
            }
        }


        //check if service required facilities
        $facilities = $this->model_android_etcm_appointment->getServiceFacilities($service_id);
        if (!empty($facilities)) {
            $facility_booked = [];
            foreach ($facilities as $facility) {
                $facility_booked[$facility['facility_id']] = false;
                $sql = "SELECT a.*, s.cs_minute AS service_minute FROM " . DB_PREFIX . "appointment a 
                LEFT JOIN " . DB_PREFIX . "clinical_service s ON(a.clinicalservice_id = s.clinicalservice_id)
                WHERE 1 
                AND a.status <> '2'
                AND a.hide = '0'
                AND a.store_id = '" . (int)$store_id . "'
                AND a.facility_id = '" . (int)$facility['facility_id'] . "'
                AND a.appointment_date = '" . $this->db->escape($date) . "'";
                $query = $this->db->query($sql);
                foreach ($query->rows as $row) {
                    $start_time = strtotime($row['appointment_time']);
                    $end_time = $start_time + ($row['service_minute'] * 60);
                    $app_end_time = $app_start_time + ($row['service_minute'] * 60);

                    if ($app_start_time >= $start_time && $app_start_time < $end_time) {
                        //record facility not available
                        $facility_booked[$facility['facility_id']] = true;
                        break;
                    }

                    if ($app_end_time > $start_time && $app_end_time <= $end_time) {
                        //record facility not available
                        $facility_booked[$facility['facility_id']] = true;
                        break;
                    }

                    if ($start_time >= $app_start_time && $end_time <= $app_end_time) {
                        //record facility not available
                        $facility_booked[$facility['facility_id']] = true;
                        break;
                    }
                }
            }

            if (!empty($facility_booked)) {
                foreach ($facility_booked as $id => $booked) {
                    if (!$booked) {
                        //check facility availability
                        $facility_info = $this->model_android_etcm_appointment->getFacilitiesDetail($id);

                        if (!empty($facility_info)) {
                            //available 24/7
                            if ($facility_info['available'] == '1') {
                                $this->selected_facility = $id;
                                return false;
                            } else {
                                foreach ($facility_info['availabilities'] as $availability) {
                                    if ($availability['day'] == $app_day) {
                                        $start_time = strtotime($availability['start_time']);
                                        $end_time = strtotime($availability['end_time']);
                                        if ($start_time <= $app_start_time && $end_time >= $app_end_time) {
                                            $this->selected_facility = $id;
                                            return false;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                //return true if not facility left to assigned
                $this->error = "No facility available to conduct the service for the selected date & time";
                return true;
            }
        }
        return false;
    }
}
