<?php

class ControllerAndroidDiagnosticDiagnostic extends Controller
{
    private $json;
    private $user_info;
    private $model_name;

    public function index()
    {
        //load required model
        $this->load->model('android/diagnostic/diagnostic');

        $this->model_name = $this->model_android_diagnostic_diagnostic;
        require DIR_SYSTEM . "/library/start_api.php";
    }

    protected function get_list()
    {
        $filter_search = (string)trim($this->request->get['filter_search']);
        $type = (string)trim($this->request->get['type']);
        $filter_search = !empty($filter_search) ? $filter_search : null;
        $type = !empty($type) ? strtolower($type) : false;
        $page = !empty($this->request->get['page']) ? $this->request->get['page'] : 1;
        $show = !empty($this->request->get['show']) ? $this->request->get['show'] : 10;

        if ($type) {
            $filters = array(
                "filter_search" => $filter_search,
                "start"         => ($page - 1) * $show,
                "limit"         => $show
            );


            switch ($type) {
                case "diagnostic":
                    $results = $this->model_name->getDiagnosticList($filters);
                    break;
                case "pulse":
                    $results = $this->model_name->getPulseList($filters);
                    break;
                case "disease":
                    $results = $this->model_name->getDiseaseList($filters);
                    break;
                case "treatment":
                    $results = $this->model_name->getTreatmentList($filters);
                    break;
                case "symptom":
                    $results = $this->model_name->getSymptomList($filters);
                    break;
                case "acupuncture":
                    $results = $this->model_name->getAcupunctureList($filters);
                    break;
                case "doctoradvice":
                    $results = $this->model_name->getDoctorAdviceList($filters);
                    break;
                default:
                    $results = $this->model_name->getDiagnosticList($filters);
            }

            if (!empty($results)) {
                $output = $this->response->setCachedResponse(200, $results, "Get list success", "diagnostic");
                $this->api->trackResponse($output);
                return;
            } else {
                $output = $this->response->setCachedResponse(204, array(), "No result", "diagnostic");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setCachedResponse(400, array(), "Type required", "diagnostic");
            $this->api->trackResponse($output);
            return;
        }
    }
}
