<?php

class ControllerAndroidCustomerPatientHistory extends Controller
{
    private $json;
    private $user_info;
    private $model_name;

    public function index()
    {
        //load required model
        $this->load->model('android/customer/patient_history');

        $this->model_name = $this->model_android_customer_patient_history;
        require DIR_SYSTEM . "/library/start_api.php";
    }
    /*
    protected function get_list()
    {
        $customer_id = !empty($this->request->get['customer_id']) ? $this->request->get['customer_id'] : false;

        if ($customer_id) {
            $filter_search = (string)trim($this->request->get['filter_search']);
            $filter_search = !empty($filter_search) ? $filter_search : null;

            $page = !empty($this->request->get['page']) ? $this->request->get['page'] : 1;
            $show = !empty($this->request->get['show']) ? $this->request->get['show'] : 10;

            $filters = array(
                "filter_search" => $filter_search,
                "customer_id"   => $customer_id,
                "start"         => ($page - 1) * $show,
                "limit"         => $show
            );

            $histories = $this->model_name->getList($filters);

            $results = array();
            foreach ($histories as $row) {
                $prescriptions = $this->model_name->getPrescriptions($row['clinical_sale_id']);
                $services = $this->model_name->getServices($row['clinical_sale_id']);
                $images = $this->model_name->getImages($row['clinical_sale_id']);
                $results[] = array(
                    'clinical_sale_id' => $row['clinical_sale_id'],
                    'doc_no' => $row['invoice_prefix'],
                    'date' => $row['sales_date'],
                    'store' => $row['store'],
                    'doctor' => $row['doctor'],
                    'diagnostic' => $row['diagnostic'],
                    'prescriptions' => !empty($prescriptions) ? $prescriptions : array(),
                    'services' => !empty($services) ? array_column($services, 'servicename') : array(),
                    'images' => array_column($images, 'image'),
                );
            }


            if (!empty($results)) {
                $output = $this->response->setCachedResponse(200, $results, "Get list success", "patient_history");
                $this->api->trackResponse($output);
                return;
            } else {
                $output = $this->response->setCachedResponse(204, array(), "No result", "patient_history");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setCachedResponse(400, array(), "customer_id required", "patient_history");
            $this->api->trackResponse($output);
            return;
        }
    }
*/
    /*
    protected function copy()
    {
        $clinical_sale_id = !empty($this->request->get['clinical_sale_id']) ? $this->request->get['clinical_sale_id'] : false;
        $section = !empty($this->request->get['section']) ? $this->request->get['section'] : 'all';
        if ($clinical_sale_id) {
            $clinical_sale = $this->model_name->getClinicalSale($clinical_sale_id);
            if (!empty($clinical_sale)) {
                $prescription_ids = $this->model_name->getPrescriptionsIds($clinical_sale_id);
                $prescriptions = array();
                foreach ($prescription_ids as $prescription_id) {
                    $pres_info = $this->model_name->getPrescription($prescription_id);
                    if (!empty($pres_info)) {
                        $prescriptions[] = $pres_info;
                    }
                }

                // $service_ids = $this->model_name->getServices($clinical_sale_id);
                // $service_ids = !empty($service_ids) ? array_column($service_ids, 'id') : array();
                // $services = array();
                // foreach ($service_ids as $service_id) {
                //     $service_info = $this->model_name->getService($service_id);
                //     if (!empty($service_info)) {
                //         $services[] = $service_info;
                //     }
                // }

                $service_infos = $this->model_name->getServices($clinical_sale_id);
                $services = array();
                if (!empty($service_infos)) {
                    $all_doctors = $this->model_name->getDoctors();
                    $all_points = $this->model_name->getAcupuncturePoints();
                    foreach ($service_infos as $service_info) {
                        $enable_acupuncture = false;
                        $service_detail = $this->model_name->getService($service_info['clinicalservice_id']);
                        if (!empty($service_detail['enable_acupuncture']) && $service_detail['enable_acupuncture'] == '1') {
                            $enable_acupuncture = true;
                        }
                        $select_acupuncture_parts = unserialize($service_info['acupuncture_parts']);

                        $services[] = array(
                            "service_id" => $service_info['clinicalservice_id'],
                            "name" => $service_info['servicename'],
                            "service_minute" => $service_info['serviceminutes'],
                            "price" => $service_info['net_price'],
                            "selected_doctor" => $service_info['staffincharge'],
                            "selected_acupuncture_point" => $select_acupuncture_parts ? $select_acupuncture_parts : array(),
                            "doctors" => $all_doctors,
                            "acupuncture_point" => $enable_acupuncture ? $all_points : array()
                        );
                    }
                }

                //build result to send
                switch (strtolower($section)) {
                    case "prescription":
                        $results = array(
                            'consultation_fee' => $clinical_sale['collect_consultation_price'] == '1' ? $clinical_sale['clinicalsale_concultation'] : '0.00',
                            'prescriptions' => $prescriptions,

                        );
                        break;
                    case "services":
                        $results = array(
                            'consultation_fee' => $clinical_sale['collect_consultation_price'] == '1' ? $clinical_sale['clinicalsale_concultation'] : '0.00',
                            'service' => $services,

                        );
                        break;
                    case "diagnostic":
                        $results = array(
                            'consultation_fee' => $clinical_sale['collect_consultation_price'] == '1' ? $clinical_sale['clinicalsale_concultation'] : '0.00',
                            'diagnostic' => $clinical_sale['diagnostic'],
                            'pulse' => $clinical_sale['pulse'],
                            'disease' => $clinical_sale['disease'],
                            'treatment' => $clinical_sale['treatment'],
                            'symptom' => $clinical_sale['symptom'],
                            'acupuncture' => $clinical_sale['acupuncture'],
                            'doctor_advice' => $clinical_sale['doctoradvice'],
                            'remark' => $clinical_sale['remark'],
                        );
                        break;
                    default:
                        $results = array(
                            'consultation_fee' => $clinical_sale['collect_consultation_price'] == '1' ? $clinical_sale['clinicalsale_concultation'] : '0.00',
                            'diagnostic' => $clinical_sale['diagnostic'],
                            'pulse' => $clinical_sale['pulse'],
                            'disease' => $clinical_sale['disease'],
                            'treatment' => $clinical_sale['treatment'],
                            'symptom' => $clinical_sale['symptom'],
                            'acupuncture' => $clinical_sale['acupuncture'],
                            'doctor_advice' => $clinical_sale['doctoradvice'],
                            'remark' => $clinical_sale['remark'],
                            'prescriptions' => $prescriptions,
                            'service' => $services,

                        );
                }
                $output = $this->response->setCachedResponse(200, $results, "Success", "patient_history");
                $this->api->trackResponse($output);
                return;
            } else {
                $output = $this->response->setCachedResponse(200, $this->response->noResponse(), "Success", "patient_history");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setCachedResponse(400, $this->response->noResponse(), "clinical_sale_id required", "patient_history");
            $this->api->trackResponse($output);
            return;
        }
    }
    */
}
