<?php

class ControllerAndroidCustomerCustomer extends Controller
{
    private $json;
    private $user_info;
    private $model_name;

    public function index()
    {
        //load required model
        $this->load->model('android/customer/customer');

        $this->model_name = $this->model_android_customer_customer;
        require DIR_SYSTEM . "/library/start_api.php";
    }

    protected function get_customers()
    {
        $filter_search = (string)trim($this->request->get['filter_search']);
        $filter_search = !empty($filter_search) ? $filter_search : null;
        $page = !empty($this->request->get['page']) ? $this->request->get['page'] : 1;
        $show = !empty($this->request->get['show']) ? $this->request->get['show'] : 10;

        $filters = array(
            "filter_search" => $filter_search,
            "start"         => ($page - 1) * $show,
            "limit"         => $show
        );

        $results = $this->model_name->getCustomers($filters);


        if (!empty($results)) {
            $customers = array();
            foreach ($results as $row) {
                $customers[] = array(
                    "customer_id" => $row['customer_id'],
                    "name" => trim($row['firstname'] . " " . $row['lastname']),
                    "customer_ic" => $row['customer_ic'],
                    // "email" => $row['email'],
                    "telephone1" => $row['telephone'],
                    // "telephone2" => $row['telephone2'],
                    // "address" => trim($row['address_1'] . " " . $row['address_2'])
                );
            }
            $output = $this->response->setCachedResponse(200, $customers, "Get list success", "customers");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setCachedResponse(204, array(), "No result", "customers");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_customer_list()
    {
        
        $filter_search = !empty($this->request->get['keyword']) ? trim($this->request->get['keyword']):null;

        $customer_card = !empty($this->request->get['customer_card']) ? $this->request->get['customer_card'] : null;
        $customer_group_id = !empty($this->request->get['customer_group_id']) ? $this->request->get['customer_group_id'] : null;
        $gender_id = !empty($this->request->get['gender_id']) ? $this->request->get['gender_id'] : null;
        $min_age = !empty($this->request->get['min_age']) ? $this->request->get['min_age'] : null;
        $max_age = !empty($this->request->get['max_age']) ? $this->request->get['max_age'] : null;
        $zone_id = !empty($this->request->get['zone_id']) ? $this->request->get['zone_id'] : null;
        $email = !empty($this->request->get['email']) ? $this->request->get['email'] : null;
        
        $sort_by = !empty($this->request->get['sort_by']) ? strtolower($this->request->get['sort_by']) : null;
        $sort_direction = !empty($this->request->get['sort_direction']) ? strtoupper($this->request->get['sort_direction']) : null;

        $page = !empty($this->request->get['page']) ? $this->request->get['page'] : 1;
        $show = !empty($this->request->get['show']) ? $this->request->get['show'] : 10;

        $filters = array(
            "filter_search"     => $filter_search,
            "customer_card"     => $customer_card,
            "customer_group_id" => $customer_group_id,
            "gender"            => $gender_id,
            "min_age"           => $min_age,
            "max_age"           => $max_age,
            "zone_id"           => $zone_id,
            "email"             => $email,
            "sort_by"           => $sort_by,
            "sort_direction"    => $sort_direction,
            "start"             => ($page - 1) * $show,
            "limit"             => $show
        );

        $results = $this->model_name->getCustomerList($filters);

        if (!empty($results)) {
            $customers = array();
            foreach ($results as $row) {

                if ($this->session->data['language_id'] == '1') {
                    $gender = $row['gender'] == 1 ? "Male" : "Female";
                } else {
                    $gender = $row['gender'] == 1 ? "男" : "女";
                }

                $customers[] = array(
                    "customer_id"           => $row['customer_id'],
                    "registration_card_no"  => !empty($row['customer_card']) ? $row['customer_card'] : null,
                    "name"                  => trim($row['firstname'] . " " . $row['lastname']),
                    "customer_group"        => !empty($row['customer_group']) ? $row['customer_group'] : null,
                    "telephone1"            => !empty($row['telephone']) ? $row['telephone'] : "",
                    "customer_ic"           => !empty($row['customer_ic']) ? $row['customer_ic'] : "",
                    "age"                   => ($row['age_year'] > 0 && $row['age_year'] != date('Y')) ? $row['age_year'] : null,
                    "gender"                => $gender,
                    "email"                 => !empty($row['email']) ? $row['email'] : null,
                    "state_province"        => !empty($row['state_name']) ? $row['state_name'] : null
                );
            }
            $output = $this->response->setCachedResponse(200, $customers, "Get list success", "customers");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setCachedResponse(204, array(), "No result", "customers");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_customer_detail()
    {
        $customer_id = !empty($this->request->get['customer_id']) ? $this->request->get['customer_id'] : false;

        if ($customer_id) {
            $customer_info = $this->model_name->getCustomer($customer_id);
            if (!empty($customer_info)) {
                $address_list = $this->model_name->getAddressesByCustomerId($customer_id);
                $address_list = !empty($address_list) ? $address_list : array();
                $addresses = array();

                foreach ($address_list as $row) {
                    $add_name = '';
                    $add_name .= !empty($row['address_1']) ? $row['address_1'] : '';
                    $add_name .= !empty($row['address_2']) ? ', ' . $row['address_2'] : '';
                    $add_name .= !empty($row['address_3']) ? ', ' . $row['address_3'] : '';
                    $add_name .= !empty($row['postcode']) ? ', ' . $row['postcode'] : '';
                    $add_name .= !empty($row['city']) ? ', ' . $row['city'] : '';
                    $add_name .= !empty($row['zone']) ? ', ' . $row['zone'] : '';

                    $default = $customer_info['address_id'] == $row['address_id'] ? true : false;
                    $addresses[] = array(
                        "address_id" => $row['address_id'],
                        "address_1"  => $row['address_1'],
                        "address_2"  => $row['address_2'],
                        "address_3"  => $row['address_3'],
                        "city"       => $row['city'],
                        "post_code"  => $row['postcode'],
                        "zone_id"    => $row['zone_id'],
                        "zone"       => $row['zone'],
                        "country"    => $row['country'],
                        "default"    => $default,
                        // "label" => $add_name
                    );
                }

                $customer_name =  trim($customer_info['firstname'] . " " . $customer_info['lastname']);
                $customer_dob = $customer_info['dob'] == '0000-00-00' ? null : $customer_info['dob'];
                $default_address = !empty($customer_info['address_id']) ? $customer_info['address_id'] : (!empty($addresses[0]['id']) ? $addresses[0]['id'] : null);
                $customer = array(
                    "customer_id"        => $customer_info['customer_id'],
                    "customer_group_id"  => $customer_info['customer_group_id'],
                    "registration_card_no"=> $customer_info['customer_card'],
                    "customer_ic"        => $customer_info['customer_ic'],
                    "firstname"          => $customer_info['firstname'],
                    "lastname"           => $customer_info['lastname'],
                    "name"               => $customer_name,
                    "gender_id"          => $customer_info['gender'],
                    "dob"                => $customer_dob,
                    "email"              => $customer_info['email'],
                    "telephone1"         => $customer_info['telephone'],
                    "telephone2"         => $customer_info['telephone2'],
                    "home"               => $customer_info['home'],
                    "occupation"         => $customer_info['occupation'],
                    "nationality"        => $customer_info['nationality'],
                    "marital_status_id"  => $customer_info['marital_status'],
                    "religion_id"        => $customer_info['religion'],
                    "race_id"            => $customer_info['race'],
                    "allergic"           => $customer_info['allergic'],
                    "diagnostic_history" => $customer_info['diagnostic_history'],
                    "default_address"    => $default_address,
                    "address"            => $addresses
                );

                $output = $this->response->setCachedResponse(200, $customer, "Success", "customers");
                $this->api->trackResponse($output);
                return;
            } else {
                $output = $this->response->setCachedResponse(204, $this->response->noResponse(), "No result", "customers");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setCachedResponse(400, $this->response->noResponse(), "customer id is required", "customers");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_customer_address()
    {
        $customer_id = !empty($this->request->get['customer_id']) ? $this->request->get['customer_id'] : false;
        if ($customer_id) {
            $address_list = $this->model_name->getAddressesByCustomerId($customer_id);
            $address_list = !empty($address_list) ? $address_list : array();
            $addresses = array();

            foreach ($address_list as $row) {
                $add_name = '';
                $add_name .= !empty($row['address_1']) ? $row['address_1'] : '';
                $add_name .= !empty($row['address_2']) ? ', ' . $row['address_2'] : '';
                $add_name .= !empty($row['address_3']) ? ', ' . $row['address_3'] : '';
                $add_name .= !empty($row['postcode']) ? ', ' . $row['postcode'] : '';
                $add_name .= !empty($row['city']) ? ', ' . $row['city'] : '';
                $add_name .= !empty($row['zone']) ? ', ' . $row['zone'] : '';

                $addresses[] = array(
                    "id" => $row['address_id'],
                    "label" => $add_name
                );
            }

            $output = $this->response->setCachedResponse(200, $addresses, 'Success', "address");
            $this->api->trackResponse($output);
            return;
        } else {
            $output = $this->response->setCachedResponse(400, array(), 'customer id is required', "address");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_address()
    {
        $address_id = !empty($this->request->get['address_id']) ? $this->request->get['address_id'] : false;
        if ($address_id) {
            $address_info = $this->model_name->getAddress($address_id);
            if (!empty($address_info)) {
                $result = array(
                    "address_id" => $address_info["address_id"],
                    "customer_id" => $address_info["customer_id"],
                    "firstname" => $address_info["firstname"],
                    "lastname" => $address_info["lastname"],
                    "company" => $address_info["company"],
                    "address_1" => $address_info["address_1"],
                    "address_2" => $address_info["address_2"],
                    "address_3" => $address_info["address_3"],
                    "city" => $address_info["city"],
                    "post_code" => $address_info["postcode"],
                    "country_id" => $address_info["country_id"],
                    "zone_id" => $address_info["zone_id"],
                    "custom_field" => $address_info["custom_field"],
                    "zone" => $address_info["zone"],
                    "country" => $address_info["country"]
                );
                $output = $this->response->setCachedResponse(200, $result, 'Success', "address");
                $this->api->trackResponse($output);
                return;
            } else {
                $output = $this->response->setCachedResponse(204, $this->response->noResponse(), 'Not found', "address");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setCachedResponse(400, $this->response->noResponse(), 'address id is required', "address");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function update_address()
    {
        $json = $this->json;
        if (empty($json)) {
            $output = $this->response->setResponse2(400, $this->response->noResponse(), "missing json body", "address");
            $this->api->trackResponse($output);
            return;
        } else {
            if ($this->validateAddressInfo($json)) {
                $address_id = !empty($json['address_id']) ? $json['address_id'] : '0';
                $customer_id = !empty($json['customer_id']) ? $json['customer_id'] : '0';
                $firstname = !empty($json['firstname']) ? $json['firstname'] : '';
                $lastname = !empty($json['lastname']) ? $json['lastname'] : '';
                $company = !empty($json['company']) ? $json['company'] : '';
                $address_1 = !empty($json['address_1']) ? $json['address_1'] : '';
                $address_2 = !empty($json['address_2']) ? $json['address_2'] : '';
                $address_3 = !empty($json['address_3']) ? $json['address_3'] : '';
                $city = !empty($json['city']) ? $json['city'] : '';
                $postcode = !empty($json['post_code']) ? $json['post_code'] : '';
                $country_id = !empty($json['country_id']) ? $json['country_id'] : '129';
                $zone_id = !empty($json['zone_id']) ? $json['zone_id'] : '0';
                $default = !empty($json['default']) ? $json['default'] : false;

                if (empty($firstname)) {
                    $customer_info = $this->model_name->getCustomer($customer_id);
                    $firstname = $customer_info['firstname'];
                    if (empty($lastname)) {
                        $lastname = $customer_info['lastname'];
                    }
                }
                $data = array(
                    "address_id" => $address_id,
                    "customer_id" => $customer_id,
                    "firstname" => $firstname,
                    "lastname" => $lastname,
                    "company" => $company,
                    "address_1" => $address_1,
                    "address_2" => $address_2,
                    "address_3" => $address_3,
                    "city" => $city,
                    "postcode" => $postcode,
                    "country_id" => $country_id,
                    "zone_id" => $zone_id,
                    "default" => $default,
                );
                $address_id = $this->model_name->updateAddress($data);
                $output = $this->response->setResponse2(200, array("address_id" => $address_id), "success", "address");
                $this->api->trackResponse($output);
                return;
            } else {
                $output = $this->response->setResponse2(400, $this->response->noResponse(), "address info not completed", "address");
                $this->api->trackResponse($output);
                return;
            }
        }
    }

    protected function update_customer()
    {
        $json = $this->json;
        if (empty($json)) {
            $output = $this->response->setResponse2(400, $this->response->noResponse(), "missing json body", "customer");
            $this->api->trackResponse($output);
            return;
        } else {
            if ($this->validateCustomerInfo($json)) {
                $customer_id = !empty($json['customer_id']) ? trim($json['customer_id']) : '0';
                $customer_group_id = !empty($json['customer_group_id']) ? trim($json['customer_group_id']) : '';
                $customer_card = !empty($json['registration_card_no']) ? trim($json['registration_card_no']) : '';
                $customer_ic = !empty($json['customer_ic']) ? trim($json['customer_ic']) : '';
                $firstname = !empty($json['firstname']) ? trim($json['firstname']) : '';
                $lastname = !empty($json['lastname']) ? trim($json['lastname']) : '';
                $gender_id = !empty($json['gender_id']) ? trim($json['gender_id']) : '';
                $dob = !empty($json['dob']) ? trim($json['dob']) : '';
                $email = !empty($json['email']) ? trim($json['email']) : '';
                $telephone1 = !empty($json['telephone1']) ? trim($json['telephone1']) : '';
                $telephone2 = !empty($json['telephone2']) ? trim($json['telephone2']) : '';
                $home = !empty($json['home']) ? trim($json['home']) : '';
                $occupation = !empty($json['occupation']) ? trim($json['occupation']) : '';
                $nationality = !empty($json['nationality']) ? trim($json['nationality']) : '';
                $marital_status_id = !empty($json['marital_status_id']) ? trim($json['marital_status_id']) : '';
                $religion_id = !empty($json['religion_id']) ? trim($json['religion_id']) : '';
                $race_id = !empty($json['race_id']) ? trim($json['race_id']) : '';
                $allergic = !empty($json['allergic']) ? trim($json['allergic']) : '';
                $diagnostic_history = !empty($json['diagnostic_history']) ? trim($json['diagnostic_history']) : '';
                $addresses = !empty($json['address']) ? $json['address'] : array();
                $data = array(
                    "customer_id" => $customer_id,
                    "customer_group_id" => $customer_group_id,
                    "customer_card" => $customer_card,
                    "customer_ic" => $customer_ic,
                    "firstname" => $firstname,
                    "lastname" => $lastname,
                    "gender_id" => $gender_id,
                    "dob" => $dob,
                    "email" => $email,
                    "telephone1" => $telephone1,
                    "telephone2" => $telephone2,
                    "home" => $home,
                    "occupation" => $occupation,
                    "nationality" => $nationality,
                    "marital_status_id" => $marital_status_id,
                    "religion_id" => $religion_id,
                    "race_id" => $race_id,
                    "allergic" => $allergic,
                    "diagnostic_history" => $diagnostic_history,
                    // "addresses" => $addresses
                );
                $customer_id = $this->model_name->updateCustomer($data);

                //get_existing_address
                $customer_addresses = $this->model_name->getAddressesByCustomerId($customer_id);
                if (!empty($addresses)) {

                    //delete unrelated addresses
                    $updated_address_ids = array_column($addresses, 'address_id');
                    foreach ($customer_addresses as $existing_address) {
                        if (!in_array($existing_address['address_id'], $updated_address_ids)) {
                            $this->model_name->deleteAddress($existing_address['address_id']);
                        }
                    }

                    foreach ($addresses as $address) {
                        $address_id = !empty($address['address_id']) ? $address['address_id'] : '0';
                        $address_1 = !empty($address['address_1']) ? $address['address_1'] : '';
                        $address_2 = !empty($address['address_2']) ? $address['address_2'] : '';
                        $address_3 = !empty($address['address_3']) ? $address['address_3'] : '';
                        $city = !empty($address['city']) ? $address['city'] : '';
                        $postcode = !empty($address['post_code']) ? $address['post_code'] : '';
                        $zone_id = !empty($address['zone_id']) ? $address['zone_id'] : '';
                        $country_id = !empty($address['country_id']) ? $address['country_id'] : '129';
                        $default = !empty($address['default']) ? $address['default'] : false;
                        $company = !empty($address['company']) ? $address['company'] : '';
                        $data = array(
                            "address_id" => $address_id,
                            "customer_id" => $customer_id,
                            "firstname" => $firstname,
                            "lastname" => $lastname,
                            "company" => $company,
                            "address_1" => $address_1,
                            "address_2" => $address_2,
                            "address_3" => $address_3,
                            "city" => $city,
                            "postcode" => $postcode,
                            "country_id" => $country_id,
                            "zone_id" => $zone_id,
                            "default" => $default,
                        );
                        $this->model_name->updateAddress($data);
                    }
                }
                $output = $this->response->setResponse2(200, array("customer_id" => "$customer_id"), "success", "customer");
                $this->api->trackResponse($output);
                return;
            } else {
                $output = $this->response->setResponse2(400, $this->response->noResponse(), "customer info not completed", "customer");
                $this->api->trackResponse($output);
                return;
            }
        }
    }

    private function validateAddressInfo($address)
    {
        $required_info = [
            'customer_id',
            'address_1',
            'city',
            'post_code',
            'zone_id'
        ];

        $result = true;
        foreach ($required_info as $info) {
            if (empty($address[$info])) {
                $result = false;
                break;
            }
        }
        return $result;
    }

    protected function get_zones()
    {
        $country_id = 129;
        $zones = $this->model_name->getZones($country_id);
        $output = $this->response->setCachedResponse(200, $zones, "Get list success", "address");
        $this->api->trackResponse($output);
        return;
    }

    protected function get_customer_group()
    {
        $result['customer_groups'] = $this->model_name->getCustomerGroups();
        $result['default_customer_group_id'] = $this->config->get('config_customer_group_id');
        $output = $this->response->setCachedResponse(200, $result, "Get list success", "customer_group");
        $this->api->trackResponse($output);
        return;
    }

    protected function get_religions()
    {
        $religions = $this->model_name->getReligions();
        $output = $this->response->setCachedResponse(200, $religions, "Get list success", "religions");
        $this->api->trackResponse($output);
        return;
    }

    protected function get_races()
    {
        $races = $this->model_name->getRaces();
        $output = $this->response->setCachedResponse(200, $races, "Get list success", "races");
        $this->api->trackResponse($output);
        return;
    }

    protected function get_marital_statuses()
    {
        $marital_statuses = $this->model_name->getMaritalStatuses();
        $output = $this->response->setCachedResponse(200, $marital_statuses, "Get list success", "marital_statuses");
        $this->api->trackResponse($output);
        return;
    }

    private function validateCustomerInfo($customer)
    {
        $required_info = ['firstname', 'customer_ic', 'telephone1'];
        $result = true;
        foreach ($required_info as $info) {
            if (empty($customer[$info])) {
                $result = false;
                break;
            }
        }
        return $result;
    }
}
