<?php

class ControllerAndroidCreditCredit extends Controller
{
    private $json;
    private $error;
    private $model_name;

    public function index()
    {
        //Load Model
        $this->load->model('android/credit/credit');
        $this->model_name = $this->model_android_credit_credit;

        //Load Required file
        require DIR_SYSTEM . "/library/start_api.php";
    }

    protected function get_balance()
    {
        $hosting = HTTPS_SERVER;
        $path = 'etcm/credit/credit/get_balance';
        $phone_no = $this->session->data['user_info']['contactno'];
        $data = [
            "hosting" => $hosting,
            "phone_no" => $phone_no
        ];
        $result = $this->connectCurl($path, $data);
        if (!empty($result)) {
            if (!empty($result['error'])) {
                $output = $this->response->setCachedResponse(400, new stdClass(), $result['message'], "credit");
                $this->api->trackResponse($output);
                return;
            } else {
                $return_result = [
                    "report_title" => $this->session->data['language_id'] == 1 ? "Credit Transactions" : "交易记录",
                    "report_app_link" => "report/credit",
                    "report_key" => "report/credit",
                    "report_icon" => "https://www.etcm.me/image/doctorapp/report_icon/report-transaction.png"
                ];
                $return_result = array_merge($result['response'], $return_result);
                $output = $this->response->setCachedResponse(200, $return_result, $result['message'], "credit");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setCachedResponse(204, new stdClass(), "API Connection Errors : Please check the internet connection or API connection!", "credit");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_default_topup_list()
    {
        $hosting = HTTPS_SERVER;
        $path = 'etcm/credit/credit/get_default_topup_list';

        $result = $this->connectCurl($path, array("hosting" => $hosting));
        if (!empty($result)) {
            if (!empty($result['error'])) {
                $output = $this->response->setCachedResponse(400, new stdClass(), $result['message'], "credit");
                $this->api->trackResponse($output);
                return;
            } else {
                $output = $this->response->setCachedResponse(200, $result['response'], $result['message'], "credit");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setCachedResponse(204, new stdClass(), "API Connection Errors : Please check the internet connection or API connection!", "credit");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function top_up()
    {
        $hosting = HTTPS_SERVER;
        $path = 'etcm/credit/credit/top_up';
        $topup_amount = !empty($this->request->get['topup_amount']) ? $this->request->get['topup_amount'] : 0;

        $data = array(
            "hosting" => $hosting,
            "topup_amount" => $topup_amount,
        );
        $result = $this->connectCurl($path, $data);
        if (!empty($result)) {
            if (!empty($result['error'])) {
                $output = $this->response->setCachedResponse(400, new stdClass(), $result['message'], "credit");
                $this->api->trackResponse($output);
                return;
            } else {
                $output = $this->response->setCachedResponse(200, $result['response'], $result['message'], "credit");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setCachedResponse(204, new stdClass(), "API Connection Errors : Please check the internet connection or API connection!", "credit");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function get_info()
    {
        $hosting = HTTPS_SERVER;
        $path = 'etcm/credit/credit/get_info';
        $phone_no = $this->session->data['user_info']['contactno'];
        $data = [
            "hosting" => $hosting,
            "phone_no" => $phone_no
        ];
        $result = $this->connectCurl($path, $data);
        if (!empty($result)) {
            if (!empty($result['error'])) {
                $output = $this->response->setCachedResponse(400, new stdClass(), $result['message'], "credit");
                $this->api->trackResponse($output);
                return;
            } else {
                $return_result = [
                    "required_pin" => $this->config->get('config_required_pin') != '0' ? true : false
                ];
                $return_result = array_merge($result['response'], $return_result);
                $output = $this->response->setCachedResponse(200, $return_result, $result['message'], "credit");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setCachedResponse(204, new stdClass(), "API Connection Errors : Please check the internet connection or API connection!", "credit");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function connectCurl($path, $data)
    {
        $language = !empty($_SERVER['HTTP_ACCEPT_LANGUAGE']) ? $_SERVER['HTTP_ACCEPT_LANGUAGE'] : 'cn';
        $device_id = !empty($_SERVER['HTTP_DEVICE_ID']) ? $_SERVER['HTTP_DEVICE_ID'] : '';

        $url = HTTP_API . 'index.php?route=' . $path;
        $curl = curl_init();

        curl_setopt($curl, CURLOPT_HEADER, false);
        curl_setopt($curl, CURLINFO_HEADER_OUT, true);
        curl_setopt($curl, CURLOPT_USERAGENT, $this->request->server['HTTP_USER_AGENT']);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_POST, 1);
        curl_setopt($curl, CURLOPT_POSTFIELDS, htmlspecialchars_decode(json_encode($data)));
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array('Accept-Language: ' . $language, 'Device-Id: ' . $device_id, 'Content-Type: application/json'));
        curl_setopt($curl, CURLOPT_TIMEOUT, 15);

        $response = curl_exec($curl);

        $result = json_decode(htmlspecialchars_decode($response), true);

        curl_close($curl);

        return $result;
    }
}
