<?php

class ControllerAndroidCommonPayment extends Controller{
    private $json;
    private $error;
    private $model_name;

    public function index()
    {
        //load model
        // $this->load->model('android/common/payment');
        // $this->model_name = $this->model_android_common_payment;

        //load required file
        require DIR_SYSTEM . "/library/start_api.php";
    }

    protected function get_payment_code(){
        $hosting = HTTPS_SERVER;
        $path = 'etcm/doctorapp/payment/get_payment_code';

        $result = $this->connectCurl($path, array("hosting" => $hosting));
        if (!empty($result)) {
            if (!empty($result['error'])) {
                $output = $this->response->setCachedResponse(204, new stdClass(), $result['message'], "payment");
                $this->api->trackResponse($output);
                return;
            } else {
                $output = $this->response->setCachedResponse(200, $result['response'], $result['message'], "payment");
                $this->api->trackResponse($output);
                return;
            }
        } else {
            $output = $this->response->setCachedResponse(204, new stdClass(), "API Connection Errors : Please check the internet connection or API connection!", "payment");
            $this->api->trackResponse($output);
            return;
        }
    }

    protected function connectCurl($path, $data)
    {
        $language = !empty($_SERVER['HTTP_ACCEPT_LANGUAGE']) ? $_SERVER['HTTP_ACCEPT_LANGUAGE'] : 'cn';
        $device_id = !empty($_SERVER['HTTP_DEVICE_ID']) ? $_SERVER['HTTP_DEVICE_ID'] : '';

        $url = HTTP_API . 'index.php?route=' . $path;
        $curl = curl_init();

        curl_setopt($curl, CURLOPT_HEADER, false);
        curl_setopt($curl, CURLINFO_HEADER_OUT, true);
        curl_setopt($curl, CURLOPT_USERAGENT, $this->request->server['HTTP_USER_AGENT']);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_POST, 1);
        curl_setopt($curl, CURLOPT_POSTFIELDS, htmlspecialchars_decode(json_encode($data)));
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array('Accept-Language: ' . $language, 'Device-Id: ' . $device_id, 'Content-Type: application/json'));
        curl_setopt($curl, CURLOPT_TIMEOUT, 15);

        $response = curl_exec($curl);

        $result = json_decode(htmlspecialchars_decode($response), true);

        curl_close($curl);

        return $result;
    }
}